/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.graph;

import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeons2.graph.Waypoint;
import com.someguyssoftware.gottschcore.enums.Alignment;

public class Wayline {
    public static final int START_POINT_INDEX = 0;
    public static final int END_POINT_INDEX = 1;
    private Waypoint point1;
    private Waypoint point2;
    private Alignment alignment;
    private Wayline wayline;

    public Wayline() {
    }

    public Wayline(Waypoint point1, Waypoint point2) {
        this();
        this.point1 = point1;
        this.point2 = point2;
        if (point1.getZ() == point2.getZ()) {
            this.setAlignment(Alignment.HORIZONTAL);
        } else {
            this.setAlignment(Alignment.VERTICAL);
        }
    }

    public Wayline(Waypoint point1, Waypoint point2, Alignment alignment) {
        this(point1, point2);
        this.setAlignment(alignment);
    }

    public Wayline(Waypoint point1, Waypoint point2, Alignment alignment, Wayline line) {
        this(point1, point2, alignment);
        this.setWayline(line);
    }

    public Waypoint getPoint1() {
        return this.point1;
    }

    public void setPoint1(Waypoint point1) {
        this.point1 = point1;
    }

    public Waypoint getPoint2() {
        return this.point2;
    }

    public void setPoint2(Waypoint point2) {
        this.point2 = point2;
    }

    public String toString() {
        return "Wayline [point1=" + this.point1 + ", point2=" + this.point2 + ", alignment=" + this.alignment + "]";
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public Wayline getWayline() {
        return this.wayline;
    }

    public void setWayline(Wayline wayline) {
        this.wayline = wayline;
    }

    public Waypoint[] getAlignedPoints() {
        Waypoint[] points = new Waypoint[2];
        Dungeons2.log.debug("wayline -> {}", (Object)this);
        if (this.getAlignment() == Alignment.HORIZONTAL) {
            if (this.getPoint1().getX() < this.getPoint2().getX()) {
                points[0] = this.getPoint1();
                points[1] = this.getPoint2();
            } else {
                points[0] = this.getPoint2();
                points[1] = this.getPoint1();
            }
        } else if (this.getPoint1().getZ() < this.getPoint2().getZ()) {
            points[0] = this.getPoint1();
            points[1] = this.getPoint2();
        } else {
            points[0] = this.getPoint2();
            points[1] = this.getPoint1();
        }
        return points;
    }

    public boolean isSegment() {
        return !this.getPoint1().isTerminated() || !this.getPoint2().isTerminated();
    }
}

