/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.generator.strategy;

import com.google.common.collect.Multimap;
import com.someguyssoftware.dungeons2.generator.AbstractRoomGenerationStrategy;
import com.someguyssoftware.dungeons2.generator.Arrangement;
import com.someguyssoftware.dungeons2.generator.ISupportedBlock;
import com.someguyssoftware.dungeons2.generator.SupportedBlock;
import com.someguyssoftware.dungeons2.generator.SupportedBlockProcessor;
import com.someguyssoftware.dungeons2.generator.blockprovider.IDungeonsBlockProvider;
import com.someguyssoftware.dungeons2.model.LevelConfig;
import com.someguyssoftware.dungeons2.model.Room;
import com.someguyssoftware.dungeons2.style.DesignElement;
import com.someguyssoftware.dungeons2.style.StyleSheet;
import com.someguyssoftware.dungeons2.style.Theme;
import com.someguyssoftware.dungeonsengine.config.ILevelConfig;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class SupportedRoomGenerationStrategy
extends AbstractRoomGenerationStrategy {
    public SupportedRoomGenerationStrategy(IDungeonsBlockProvider provider) {
        super(provider);
    }

    @Override
    public void generate(World world, Random random, Room room, Theme theme, StyleSheet styleSheet, ILevelConfig config) {
        IBlockState blockState = null;
        SupportedBlockProcessor supportProcessor = new SupportedBlockProcessor(this.getBlockProvider(), room);
        ISupportedBlock supportedBlock = null;
        HashMap<ICoords, Arrangement> postProcessMap = new HashMap<ICoords, Arrangement>();
        Multimap<DesignElement, ICoords> blueprint = room.getFloorMap();
        for (int y = 0; y < room.getHeight(); ++y) {
            int amount;
            Arrangement arrangement;
            ICoords worldCoords;
            Coords indexCoords;
            int x;
            int z;
            for (z = 0; z < room.getDepth(); ++z) {
                for (x = 0; x < room.getWidth(); ++x) {
                    indexCoords = new Coords(x, y, z);
                    worldCoords = room.getCoords().add((ICoords)indexCoords);
                    arrangement = this.getBlockProvider().getArrangement(worldCoords, room, room.getLayout());
                    if (this.isPostProcessed(arrangement, worldCoords, postProcessMap)) continue;
                    blockState = this.getBlockProvider().getBlockState(random, worldCoords, room, arrangement, theme, styleSheet, config);
                    if (blockState == null || blockState == Blocks.field_150350_a || blockState == IDungeonsBlockProvider.NULL_BLOCK) {
                        supportedBlock = new SupportedBlock(blockState, 100);
                        if (blockState != null && blockState != IDungeonsBlockProvider.NULL_BLOCK) {
                            world.func_180501_a(worldCoords.toPos(), blockState, 3);
                            if (worldCoords.getY() == room.getMinY() + 1 || arrangement.getElement().getFamily() == DesignElement.SURFACE_AIR) {
                                blueprint.put((Object)arrangement.getElement(), (Object)worldCoords);
                            }
                        }
                    } else {
                        amount = supportProcessor.applySupportRulesPass1(world, (ICoords)indexCoords, worldCoords, arrangement.getElement());
                        if (amount >= 100) {
                            supportedBlock = new SupportedBlock(blockState, 100);
                            world.func_180501_a(worldCoords.toPos(), blockState, 3);
                            if (worldCoords.getY() == room.getMinY() + 1 || arrangement.getElement().getFamily() == DesignElement.SURFACE_AIR) {
                                blueprint.put((Object)arrangement.getElement(), (Object)worldCoords);
                            }
                        } else {
                            supportedBlock = new SupportedBlock(blockState, amount);
                        }
                    }
                    supportProcessor.getSupportMatrix()[y][z][x] = supportedBlock;
                }
            }
            for (z = room.getDepth() - 1; z >= 0; --z) {
                for (x = room.getWidth() - 1; x >= 0; --x) {
                    supportedBlock = supportProcessor.getSupportMatrix()[y][z][x];
                    if (supportedBlock != null && supportedBlock.getAmount() >= 100) continue;
                    indexCoords = new Coords(x, y, z);
                    worldCoords = room.getCoords().add((ICoords)indexCoords);
                    arrangement = this.getBlockProvider().getArrangement(worldCoords, room, room.getLayout());
                    blockState = arrangement.getElement() != DesignElement.AIR ? this.getBlockProvider().getBlockState(random, worldCoords, room, arrangement, theme, styleSheet, config) : Blocks.field_150350_a.func_176223_P();
                    if (blockState == Blocks.field_150350_a) {
                        world.func_180501_a(worldCoords.toPos(), blockState, 3);
                        continue;
                    }
                    supportedBlock = new SupportedBlock(blockState, 0);
                    amount = supportProcessor.applySupportRulesPass2(world, (ICoords)indexCoords, worldCoords, arrangement.getElement());
                    supportedBlock.setAmount(supportedBlock.getAmount() + amount);
                    if (supportedBlock.getAmount() >= 100) {
                        world.func_180501_a(worldCoords.toPos(), blockState, 3);
                        if (worldCoords.getY() != room.getMinY() + 1) continue;
                        blueprint.put((Object)arrangement.getElement(), (Object)worldCoords);
                        continue;
                    }
                    world.func_180501_a(worldCoords.toPos(), Blocks.field_150350_a.func_176223_P(), 3);
                }
            }
        }
        this.postProcess(world, random, postProcessMap, room.getLayout(), theme, styleSheet, config);
    }

    @Override
    @Deprecated
    public void generate(World world, Random random, Room room, Theme theme, StyleSheet styleSheet, LevelConfig config) {
        IBlockState blockState = null;
        SupportedBlockProcessor supportProcessor = new SupportedBlockProcessor(this.getBlockProvider(), room);
        ISupportedBlock supportedBlock = null;
        HashMap<ICoords, Arrangement> postProcessMap = new HashMap<ICoords, Arrangement>();
        Multimap<DesignElement, ICoords> blueprint = room.getFloorMap();
        for (int y = 0; y < room.getHeight(); ++y) {
            int amount;
            Arrangement arrangement;
            ICoords worldCoords;
            Coords indexCoords;
            int x;
            int z;
            for (z = 0; z < room.getDepth(); ++z) {
                for (x = 0; x < room.getWidth(); ++x) {
                    indexCoords = new Coords(x, y, z);
                    worldCoords = room.getCoords().add((ICoords)indexCoords);
                    arrangement = this.getBlockProvider().getArrangement(worldCoords, room, room.getLayout());
                    if (this.isPostProcessed(arrangement, worldCoords, postProcessMap)) continue;
                    blockState = this.getBlockProvider().getBlockState(random, worldCoords, room, arrangement, theme, styleSheet, config);
                    if (blockState == null || blockState == Blocks.field_150350_a || blockState == IDungeonsBlockProvider.NULL_BLOCK) {
                        supportedBlock = new SupportedBlock(blockState, 100);
                        if (blockState != null && blockState != IDungeonsBlockProvider.NULL_BLOCK) {
                            world.func_180501_a(worldCoords.toPos(), blockState, 3);
                            if (worldCoords.getY() == room.getMinY() + 1 || arrangement.getElement().getFamily() == DesignElement.SURFACE_AIR) {
                                blueprint.put((Object)arrangement.getElement(), (Object)worldCoords);
                            }
                        }
                    } else {
                        amount = supportProcessor.applySupportRulesPass1(world, (ICoords)indexCoords, worldCoords, arrangement.getElement());
                        if (amount >= 100) {
                            supportedBlock = new SupportedBlock(blockState, 100);
                            world.func_180501_a(worldCoords.toPos(), blockState, 3);
                            if (worldCoords.getY() == room.getMinY() + 1 || arrangement.getElement().getFamily() == DesignElement.SURFACE_AIR) {
                                blueprint.put((Object)arrangement.getElement(), (Object)worldCoords);
                            }
                        } else {
                            supportedBlock = new SupportedBlock(blockState, amount);
                        }
                    }
                    supportProcessor.getSupportMatrix()[y][z][x] = supportedBlock;
                }
            }
            for (z = room.getDepth() - 1; z >= 0; --z) {
                for (x = room.getWidth() - 1; x >= 0; --x) {
                    supportedBlock = supportProcessor.getSupportMatrix()[y][z][x];
                    if (supportedBlock != null && supportedBlock.getAmount() >= 100) continue;
                    indexCoords = new Coords(x, y, z);
                    worldCoords = room.getCoords().add((ICoords)indexCoords);
                    arrangement = this.getBlockProvider().getArrangement(worldCoords, room, room.getLayout());
                    blockState = arrangement.getElement() != DesignElement.AIR ? this.getBlockProvider().getBlockState(random, worldCoords, room, arrangement, theme, styleSheet, config) : Blocks.field_150350_a.func_176223_P();
                    if (blockState == Blocks.field_150350_a) {
                        world.func_180501_a(worldCoords.toPos(), blockState, 3);
                        continue;
                    }
                    supportedBlock = new SupportedBlock(blockState, 0);
                    amount = supportProcessor.applySupportRulesPass2(world, (ICoords)indexCoords, worldCoords, arrangement.getElement());
                    supportedBlock.setAmount(supportedBlock.getAmount() + amount);
                    if (supportedBlock.getAmount() >= 100) {
                        world.func_180501_a(worldCoords.toPos(), blockState, 3);
                        if (worldCoords.getY() != room.getMinY() + 1) continue;
                        blueprint.put((Object)arrangement.getElement(), (Object)worldCoords);
                        continue;
                    }
                    world.func_180501_a(worldCoords.toPos(), Blocks.field_150350_a.func_176223_P(), 3);
                }
            }
        }
        this.postProcess(world, random, postProcessMap, room.getLayout(), theme, styleSheet, config);
    }
}

