/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.generator.strategy;

import com.google.common.collect.Multimap;
import com.someguyssoftware.dungeons2.generator.AbstractRoomGenerationStrategy;
import com.someguyssoftware.dungeons2.generator.Arrangement;
import com.someguyssoftware.dungeons2.generator.ISupportedBlock;
import com.someguyssoftware.dungeons2.generator.SupportedBlock;
import com.someguyssoftware.dungeons2.generator.SupportedBlockProcessor;
import com.someguyssoftware.dungeons2.generator.blockprovider.IDungeonsBlockProvider;
import com.someguyssoftware.dungeons2.model.Hallway;
import com.someguyssoftware.dungeons2.model.LevelConfig;
import com.someguyssoftware.dungeons2.model.Room;
import com.someguyssoftware.dungeons2.style.DesignElement;
import com.someguyssoftware.dungeons2.style.StyleSheet;
import com.someguyssoftware.dungeons2.style.Theme;
import com.someguyssoftware.dungeonsengine.config.ILevelConfig;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class SupportedHallwayGenerationStrategy
extends AbstractRoomGenerationStrategy {
    private List<Room> rooms;
    private List<Hallway> hallways;

    public SupportedHallwayGenerationStrategy(IDungeonsBlockProvider blockProvider, List<Room> rooms, List<Hallway> hallways) {
        super(blockProvider);
        this.setRooms(rooms);
        this.setHallways(hallways);
    }

    @Override
    public void generate(World world, Random random, Room room, Theme theme, StyleSheet styleSheet, ILevelConfig config) {
        Hallway hallway = (Hallway)room;
        IBlockState blockState = null;
        HashMap<ICoords, Arrangement> postProcessMap = new HashMap<ICoords, Arrangement>();
        Multimap<DesignElement, ICoords> blueprint = room.getFloorMap();
        SupportedBlockProcessor supportProcessor = new SupportedBlockProcessor(this.getBlockProvider(), room);
        ISupportedBlock supportedBlock = null;
        ArrayList<Room> intersectRooms = new ArrayList<Room>();
        for (Room otherRoom : this.getRooms()) {
            if (!hallway.getBoundingBox().func_72326_a(otherRoom.getBoundingBox())) continue;
            intersectRooms.add(otherRoom);
        }
        for (int y = 0; y < room.getHeight(); ++y) {
            int amount;
            boolean buildBlock;
            Arrangement arrangement;
            ICoords worldCoords;
            Coords indexCoords;
            int x;
            int z;
            for (z = 0; z < room.getDepth(); ++z) {
                for (x = 0; x < room.getWidth(); ++x) {
                    indexCoords = new Coords(x, y, z);
                    worldCoords = room.getCoords().add((ICoords)indexCoords);
                    arrangement = this.getBlockProvider().getArrangement(worldCoords, room, room.getLayout());
                    if (this.isPostProcessed(arrangement, worldCoords, postProcessMap)) continue;
                    blockState = this.getBlockProvider().getBlockState(random, worldCoords, room, arrangement, theme, styleSheet, config);
                    if (blockState == null || arrangement.getElement() == DesignElement.AIR || blockState == Blocks.field_150350_a.func_176223_P() || blockState == IDungeonsBlockProvider.NULL_BLOCK) {
                        supportedBlock = new SupportedBlock(blockState, 100);
                        if (blockState == Blocks.field_150350_a.func_176223_P()) {
                            world.func_180501_a(worldCoords.toPos(), blockState, 3);
                            if (worldCoords.getY() == room.getMinY() + 1) {
                                blueprint.put((Object)arrangement.getElement(), (Object)worldCoords);
                            }
                        }
                    } else {
                        buildBlock = this.isBlockBuildable(worldCoords, hallway, intersectRooms);
                        if (blockState != null && buildBlock && blockState != IDungeonsBlockProvider.NULL_BLOCK) {
                            amount = supportProcessor.applySupportRulesPass1(world, (ICoords)indexCoords, worldCoords, arrangement.getElement());
                            if (amount >= 100) {
                                supportedBlock = new SupportedBlock(blockState, 100);
                                world.func_180501_a(worldCoords.toPos(), blockState, 3);
                            } else {
                                supportedBlock = new SupportedBlock(blockState, amount);
                            }
                        } else {
                            supportedBlock = new SupportedBlock(IDungeonsBlockProvider.NULL_BLOCK, 100);
                        }
                    }
                    supportProcessor.getSupportMatrix()[y][z][x] = supportedBlock;
                }
            }
            for (z = room.getDepth() - 1; z >= 0; --z) {
                for (x = room.getWidth() - 1; x >= 0; --x) {
                    supportedBlock = supportProcessor.getSupportMatrix()[y][z][x];
                    if (supportedBlock != null && supportedBlock.getAmount() >= 100) continue;
                    indexCoords = new Coords(x, y, z);
                    worldCoords = room.getCoords().add((ICoords)indexCoords);
                    arrangement = this.getBlockProvider().getArrangement(worldCoords, room, room.getLayout());
                    blockState = arrangement.getElement() != DesignElement.AIR ? this.getBlockProvider().getBlockState(random, worldCoords, room, arrangement, theme, styleSheet, config) : Blocks.field_150350_a.func_176223_P();
                    if (blockState == Blocks.field_150350_a) {
                        world.func_180501_a(worldCoords.toPos(), blockState, 3);
                        continue;
                    }
                    supportedBlock = new SupportedBlock(blockState, 0);
                    buildBlock = this.isBlockBuildable(worldCoords, hallway, intersectRooms);
                    if (blockState == null || !buildBlock || blockState == IDungeonsBlockProvider.NULL_BLOCK) continue;
                    amount = supportProcessor.applySupportRulesPass2(world, (ICoords)indexCoords, worldCoords, arrangement.getElement());
                    supportedBlock.setAmount(supportedBlock.getAmount() + amount);
                    if (supportedBlock.getAmount() < 100) continue;
                    world.func_180501_a(worldCoords.toPos(), blockState, 3);
                    if (worldCoords.getY() != room.getMinY() + 1) continue;
                    blueprint.put((Object)arrangement.getElement(), (Object)worldCoords);
                }
            }
            this.postProcess(world, random, postProcessMap, room.getLayout(), theme, styleSheet, config);
        }
    }

    @Override
    @Deprecated
    public void generate(World world, Random random, Room room, Theme theme, StyleSheet styleSheet, LevelConfig config) {
        Hallway hallway = (Hallway)room;
        IBlockState blockState = null;
        HashMap<ICoords, Arrangement> postProcessMap = new HashMap<ICoords, Arrangement>();
        Multimap<DesignElement, ICoords> blueprint = room.getFloorMap();
        SupportedBlockProcessor supportProcessor = new SupportedBlockProcessor(this.getBlockProvider(), room);
        ISupportedBlock supportedBlock = null;
        ArrayList<Room> intersectRooms = new ArrayList<Room>();
        for (Room otherRoom : this.getRooms()) {
            if (!hallway.getBoundingBox().func_72326_a(otherRoom.getBoundingBox())) continue;
            intersectRooms.add(otherRoom);
        }
        for (int y = 0; y < room.getHeight(); ++y) {
            int amount;
            boolean buildBlock;
            Arrangement arrangement;
            ICoords worldCoords;
            Coords indexCoords;
            int x;
            int z;
            for (z = 0; z < room.getDepth(); ++z) {
                for (x = 0; x < room.getWidth(); ++x) {
                    indexCoords = new Coords(x, y, z);
                    worldCoords = room.getCoords().add((ICoords)indexCoords);
                    arrangement = this.getBlockProvider().getArrangement(worldCoords, room, room.getLayout());
                    if (this.isPostProcessed(arrangement, worldCoords, postProcessMap)) continue;
                    blockState = this.getBlockProvider().getBlockState(random, worldCoords, room, arrangement, theme, styleSheet, config);
                    if (blockState == null || arrangement.getElement() == DesignElement.AIR || blockState == Blocks.field_150350_a.func_176223_P() || blockState == IDungeonsBlockProvider.NULL_BLOCK) {
                        supportedBlock = new SupportedBlock(blockState, 100);
                        if (blockState == Blocks.field_150350_a.func_176223_P()) {
                            world.func_180501_a(worldCoords.toPos(), blockState, 3);
                            if (worldCoords.getY() == room.getMinY() + 1) {
                                blueprint.put((Object)arrangement.getElement(), (Object)worldCoords);
                            }
                        }
                    } else {
                        buildBlock = this.isBlockBuildable(worldCoords, hallway, intersectRooms);
                        if (blockState != null && buildBlock && blockState != IDungeonsBlockProvider.NULL_BLOCK) {
                            amount = supportProcessor.applySupportRulesPass1(world, (ICoords)indexCoords, worldCoords, arrangement.getElement());
                            if (amount >= 100) {
                                supportedBlock = new SupportedBlock(blockState, 100);
                                world.func_180501_a(worldCoords.toPos(), blockState, 3);
                            } else {
                                supportedBlock = new SupportedBlock(blockState, amount);
                            }
                        } else {
                            supportedBlock = new SupportedBlock(IDungeonsBlockProvider.NULL_BLOCK, 100);
                        }
                    }
                    supportProcessor.getSupportMatrix()[y][z][x] = supportedBlock;
                }
            }
            for (z = room.getDepth() - 1; z >= 0; --z) {
                for (x = room.getWidth() - 1; x >= 0; --x) {
                    supportedBlock = supportProcessor.getSupportMatrix()[y][z][x];
                    if (supportedBlock != null && supportedBlock.getAmount() >= 100) continue;
                    indexCoords = new Coords(x, y, z);
                    worldCoords = room.getCoords().add((ICoords)indexCoords);
                    arrangement = this.getBlockProvider().getArrangement(worldCoords, room, room.getLayout());
                    blockState = arrangement.getElement() != DesignElement.AIR ? this.getBlockProvider().getBlockState(random, worldCoords, room, arrangement, theme, styleSheet, config) : Blocks.field_150350_a.func_176223_P();
                    if (blockState == Blocks.field_150350_a) {
                        world.func_180501_a(worldCoords.toPos(), blockState, 3);
                        continue;
                    }
                    supportedBlock = new SupportedBlock(blockState, 0);
                    buildBlock = this.isBlockBuildable(worldCoords, hallway, intersectRooms);
                    if (blockState == null || !buildBlock || blockState == IDungeonsBlockProvider.NULL_BLOCK) continue;
                    amount = supportProcessor.applySupportRulesPass2(world, (ICoords)indexCoords, worldCoords, arrangement.getElement());
                    supportedBlock.setAmount(supportedBlock.getAmount() + amount);
                    if (supportedBlock.getAmount() < 100) continue;
                    world.func_180501_a(worldCoords.toPos(), blockState, 3);
                    if (worldCoords.getY() != room.getMinY() + 1) continue;
                    blueprint.put((Object)arrangement.getElement(), (Object)worldCoords);
                }
            }
            this.postProcess(world, random, postProcessMap, room.getLayout(), theme, styleSheet, config);
        }
    }

    public boolean isBlockBuildable(ICoords worldCoords, Hallway hallway, List<Room> intersectRooms) {
        AxisAlignedBB bb;
        AxisAlignedBB bb2;
        AxisAlignedBB box = new AxisAlignedBB(worldCoords.toPos());
        boolean buildBlock = true;
        AxisAlignedBB bb1 = hallway.getDoors().size() > 0 && hallway.getDoors().get(0) != null ? hallway.getDoors().get(0).getRoom().getBoundingBox() : null;
        AxisAlignedBB axisAlignedBB = bb2 = hallway.getDoors().size() > 1 && hallway.getDoors().get(1) != null ? hallway.getDoors().get(1).getRoom().getBoundingBox() : null;
        if (bb1 != null && box.func_72326_a(bb1) || bb2 != null && box.func_72326_a(bb2)) {
            buildBlock = false;
        }
        if (buildBlock) {
            for (Room room : intersectRooms) {
                bb = room.getBoundingBox();
                if (!box.func_72326_a(bb)) continue;
                buildBlock = false;
                break;
            }
        }
        if (buildBlock) {
            for (Room room : this.getHallways()) {
                bb = room.getBoundingBox();
                if (!box.func_72326_a(bb)) continue;
                buildBlock = false;
                break;
            }
        }
        return buildBlock;
    }

    public List<Room> getRooms() {
        return this.rooms;
    }

    public void setRooms(List<Room> rooms) {
        this.rooms = rooms;
    }

    public List<Hallway> getHallways() {
        return this.hallways;
    }

    public void setHallways(List<Hallway> hallways) {
        this.hallways = hallways;
    }
}

