/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.generator.blockprovider;

import com.someguyssoftware.dungeons2.generator.blockprovider.IDungeonsBlockProvider;
import com.someguyssoftware.dungeons2.model.Room;
import com.someguyssoftware.dungeons2.style.DesignElement;
import com.someguyssoftware.dungeons2.style.Layout;
import com.someguyssoftware.gottschcore.positional.ICoords;

public interface IExteriorDungeonsBlockProvider
extends IDungeonsBlockProvider {
    @Override
    default public boolean isCeilingElement(ICoords coords, Room room, Layout layout) {
        if (room.hasCrenellation()) {
            return coords.getY() == room.getMaxY() - 2;
        }
        if (room.hasParapet() || room.hasMerlon()) {
            return coords.getY() == room.getMaxY() - 1;
        }
        return IDungeonsBlockProvider.super.isCeilingElement(coords, room, layout);
    }

    @Override
    default public boolean isCrownElement(ICoords coords, Room room, Layout layout) {
        if (!room.hasCrown() || room.getHeight() <= 4) {
            return false;
        }
        int yOffset = -1;
        if (room.hasCrenellation()) {
            yOffset = -3;
        } else if (room.hasParapet() || room.hasMerlon()) {
            yOffset = -2;
        }
        int xzOffset = 1;
        if (room.hasPlinth() || room.hasColumn()) {
            xzOffset = 2;
        }
        return coords.getY() == room.getMaxY() + yOffset && ((coords.getX() == room.getMinX() + xzOffset || coords.getX() == room.getMaxX() - xzOffset) && coords.getZ() >= room.getMinZ() + xzOffset && coords.getZ() <= room.getMaxZ() - xzOffset || (coords.getZ() == room.getMinZ() + xzOffset || coords.getZ() == room.getMaxZ() - xzOffset) && coords.getX() >= room.getMinX() + xzOffset && coords.getX() <= room.getMaxX() - xzOffset);
    }

    @Override
    default public boolean isTrimElement(ICoords coords, Room room, Layout layout) {
        int x = coords.getX();
        int y = coords.getY();
        int z = coords.getZ();
        if (room.hasPlinth() || room.hasColumn()) {
            if (layout.getFrames().get(DesignElement.TRIM.name()) != null && room.getWidth() >= 9 && room.getDepth() >= 9 && room.getHeight() > 4 && y == room.getMinY() + 1 && ((x == room.getMinX() + 2 || x == room.getMaxX() - 2) && z > room.getMinZ() && z < room.getMaxZ() || (z == room.getMinZ() + 2 || z == room.getMaxZ() - 2) && x > room.getMinX() && x < room.getMaxX())) {
                return true;
            }
        } else {
            IDungeonsBlockProvider.super.isTrimElement(coords, room, layout);
        }
        return false;
    }

    default public boolean isPlinthElement(ICoords coords, Room room, Layout layout) {
        if (!room.hasPlinth() || room.getWidth() < 7 || room.getDepth() < 7) {
            return false;
        }
        return coords.getY() == room.getMinY() && (coords.getX() == room.getMinX() || coords.getX() == room.getMaxX() || coords.getZ() == room.getMinZ() || coords.getZ() == room.getMaxZ());
    }

    default public boolean isCorniceElement(ICoords coords, Room room, Layout layout) {
        int x = coords.getX();
        int y = coords.getY();
        int z = coords.getZ();
        if (!room.hasCornice()) {
            return false;
        }
        if (room.hasCrenellation() && y != room.getMaxY() - 3) {
            return false;
        }
        if ((room.hasParapet() || room.hasMerlon()) && y != room.getMaxY() - 2) {
            return false;
        }
        if (!(room.hasCrenellation() || room.hasParapet() || room.hasMerlon() || y == room.getMaxY() - 1)) {
            return false;
        }
        return x == room.getMinX() || x == room.getMaxX() || z == room.getMinZ() || z == room.getMaxZ();
    }

    default public boolean isCrenellationElement(ICoords coords, Room room, Layout layout) {
        return coords.getY() >= room.getMaxY() - 2 && (coords.getX() == room.getMinX() || coords.getX() == room.getMaxX() || coords.getZ() == room.getMinZ() || coords.getZ() == room.getMaxZ());
    }

    default public boolean isParapetElement(ICoords coords, Room room, Layout layout) {
        return (room.hasCrenellation() && coords.getY() == room.getMaxY() - 1 || !room.hasCrenellation() && room.hasParapet() && coords.getY() == room.getMaxY()) && (coords.getX() == room.getMinX() || coords.getX() == room.getMaxX() || coords.getZ() == room.getMinZ() || coords.getZ() == room.getMaxZ());
    }

    default public boolean isMerlonElement(ICoords coords, Room room, Layout layout) {
        int x = coords.getX();
        int y = coords.getY();
        int z = coords.getZ();
        if ((room.hasCrenellation() || room.hasMerlon()) && y == room.getMaxY()) {
            int xIndex = x - room.getCoords().getX();
            int zIndex = z - room.getCoords().getZ();
            if (!(x != room.getMinX() && x != room.getMaxX() || z != room.getMinZ() && z != room.getMaxZ())) {
                return true;
            }
            if (room.getWidth() > 5) {
                if (!(x != room.getMinX() + 1 && x != room.getMaxX() - 1 || z != room.getMinZ() && z != room.getMaxZ())) {
                    return true;
                }
                if (!(z != room.getMinZ() + 1 && z != room.getMaxZ() - 1 || x != room.getMinX() && x != room.getMaxX())) {
                    return true;
                }
                if ((x == room.getMinX() || x == room.getMaxX()) && Math.abs(zIndex % 2) == 1 && zIndex > 0 && zIndex < room.getDepth() - 1 || (z == room.getMinZ() || z == room.getMaxZ()) && Math.abs(xIndex % 2) == 1 && xIndex > 0 && xIndex < room.getWidth() - 1) {
                    return true;
                }
            }
        }
        return false;
    }

    default public boolean isInsetWallElement(ICoords coords, Room room, Layout layout) {
        int x = coords.getX();
        int y = coords.getY();
        int z = coords.getZ();
        if (room.hasCrenellation() && y >= room.getMaxY() - 3) {
            return false;
        }
        if ((room.hasMerlon() || room.hasParapet()) && y >= room.getMaxY() - 2) {
            return false;
        }
        return (x == room.getMinX() + 1 || x == room.getMaxX() - 1) && z > room.getMinZ() && z < room.getMaxZ() || (z == room.getMinZ() + 1 || z == room.getMaxZ() - 1) && x > room.getMinX() && x < room.getMaxX();
    }

    default public boolean isWindowElement(ICoords coords, Room room, Layout layout) {
        int xIndex = coords.getX() - room.getCoords().getX();
        int zIndex = coords.getZ() - room.getCoords().getZ();
        int yIndex = coords.getY() - room.getCoords().getY();
        return room.getWidth() == 5 ? (xIndex == 1 || xIndex == 3 || zIndex == 1 || zIndex == 3) && yIndex > 2 && yIndex < 5 : room.getWidth() == 7 && (xIndex == 2 || xIndex == 4 || zIndex == 2 || zIndex == 4) && yIndex > 2 && yIndex < 5;
    }

    default public boolean isColumnElement(ICoords coords, Room room, Layout layout) {
        int x = coords.getX();
        int y = coords.getY();
        int z = coords.getZ();
        if (!room.hasColumn() || room.getWidth() < 7) {
            return false;
        }
        if (room.hasCrenellation() && y > room.getMaxY() - 3) {
            return false;
        }
        if (!room.hasCrenellation() && (room.hasMerlon() || room.hasParapet() && y > room.getMaxY() - 2)) {
            return false;
        }
        int xIndex = x - room.getCoords().getX();
        int zIndex = z - room.getCoords().getZ();
        return (x == room.getMinX() || x == room.getMaxX()) && Math.abs(zIndex % 2) == 0 && zIndex > 0 && zIndex < room.getDepth() - 1 || (z == room.getMinZ() || z == room.getMaxZ()) && Math.abs(xIndex % 2) == 0 && xIndex > 0 && xIndex < room.getWidth() - 1;
    }

    @Override
    default public boolean isBaseElement(ICoords coords, Room room, Layout layout) {
        return coords.getY() == room.getMinY();
    }

    @Override
    default public boolean isCapitalElement(ICoords coords, Room room, Layout layout) {
        int x = coords.getX();
        int y = coords.getY();
        int z = coords.getZ();
        return room.hasCrenellation() ? y == room.getMaxY() - 3 : (room.hasParapet() || room.hasMerlon() ? y == room.getMaxY() - 2 : y == room.getMaxY() - 1);
    }

    default public int getCorniceHeight(Room room, Layout layout) {
        if (!room.hasCornice()) {
            return 0;
        }
        if (room.hasCrenellation()) {
            return room.getMaxY() - 3;
        }
        if (room.hasParapet() || room.hasMerlon()) {
            return room.getMaxY() - 2;
        }
        if (!(room.hasCrenellation() || room.hasParapet() || room.hasMerlon())) {
            return room.getMaxY() - 1;
        }
        return 0;
    }

    default public int getCeilingHeight(Room room, Layout layout) {
        int h = room.getMaxY();
        if (room.hasCrenellation()) {
            h = room.getMaxY() - 2;
        }
        if (room.hasParapet() || room.hasMerlon()) {
            h = room.getMaxY() - 1;
        }
        return h;
    }
}

