/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.generator.blockprovider;

import com.someguyssoftware.dungeons2.Dungeons2;
import com.someguyssoftware.dungeons2.block.NullBlock;
import com.someguyssoftware.dungeons2.generator.Arrangement;
import com.someguyssoftware.dungeons2.generator.DungeonGenerator;
import com.someguyssoftware.dungeons2.generator.Location;
import com.someguyssoftware.dungeons2.model.LevelConfig;
import com.someguyssoftware.dungeons2.model.Room;
import com.someguyssoftware.dungeons2.rotate.RotatorHelper;
import com.someguyssoftware.dungeons2.style.DesignElement;
import com.someguyssoftware.dungeons2.style.Frame;
import com.someguyssoftware.dungeons2.style.Layout;
import com.someguyssoftware.dungeons2.style.Style;
import com.someguyssoftware.dungeons2.style.StyleSheet;
import com.someguyssoftware.dungeons2.style.Theme;
import com.someguyssoftware.dungeonsengine.config.ILevelConfig;
import com.someguyssoftware.gottschcore.block.CardinalDirectionFacadeBlock;
import com.someguyssoftware.gottschcore.enums.Direction;
import com.someguyssoftware.gottschcore.enums.Rotate;
import com.someguyssoftware.gottschcore.positional.ICoords;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;

public interface IDungeonsBlockProvider {
    public static final String NULL_BLOCK_NAME = "null";
    public static final IBlockState NULL_BLOCK = new NullBlock().func_176223_P();

    default public IBlockState getBlockState(Random random, ICoords worldCoords, Room room, Arrangement arrangement, Theme theme, StyleSheet styleSheet, ILevelConfig config) {
        IBlockState blockState = null;
        DesignElement elem = arrangement.getElement();
        int decayIndex = -1;
        if (elem != DesignElement.AIR && elem.getFamily() != DesignElement.SURFACE_AIR) {
            Style style = this.getStyle(elem, room.getLayout(), theme, styleSheet);
            decayIndex = this.getDecayIndex(random, config.getDecayMultiplier(), style);
            blockState = this.getBlockState(arrangement, style, decayIndex);
        } else {
            blockState = Blocks.field_150350_a.func_176223_P();
        }
        return blockState;
    }

    @Deprecated
    default public IBlockState getBlockState(Random random, ICoords worldCoords, Room room, Arrangement arrangement, Theme theme, StyleSheet styleSheet, LevelConfig config) {
        IBlockState blockState = null;
        DesignElement elem = arrangement.getElement();
        int decayIndex = -1;
        if (elem != DesignElement.AIR && elem.getFamily() != DesignElement.SURFACE_AIR) {
            Style style = this.getStyle(elem, room.getLayout(), theme, styleSheet);
            decayIndex = this.getDecayIndex(random, config.getDecayMultiplier(), style);
            blockState = this.getBlockState(arrangement, style, decayIndex);
        } else {
            blockState = Blocks.field_150350_a.func_176223_P();
        }
        return blockState;
    }

    default public IBlockState getBlockState(Arrangement arrangement, Style style, int decayIndex) {
        String block = "";
        IBlockState blockState = Blocks.field_150350_a.func_176223_P();
        if (style == Style.NO_STYLE) {
            return blockState;
        }
        decayIndex = decayIndex < style.getDecayBlocks().size() ? decayIndex : style.getDecayBlocks().size() - 1;
        String string = block = decayIndex > -1 ? style.getDecayBlocks().get(decayIndex) : style.getBlock();
        if (block == null || block == "") {
            return blockState;
        }
        if (block.equals(NULL_BLOCK_NAME)) {
            return NULL_BLOCK;
        }
        String[] blockAndMeta = block.split("@");
        int meta = 0;
        if (blockAndMeta.length > 1) {
            meta = Integer.valueOf(blockAndMeta[1]);
        }
        try {
            blockState = Block.func_149684_b((String)blockAndMeta[0]).func_176203_a(meta);
        }
        catch (Exception e) {
            blockState = null;
        }
        if (blockState == null) {
            Dungeons2.log.warn(String.format("Unable to retrieve blockState; returning NULL_BLOCK:\nArrangement: %s\nStyle: %s\nBlock: %s\nblockAndMeta[0]: %s\nMeta: %d", arrangement, style.getName(), block, blockAndMeta[0], meta));
            return NULL_BLOCK;
        }
        DesignElement elem = arrangement.getElement();
        if (elem == DesignElement.CROWN || elem == DesignElement.TRIM || elem == DesignElement.CORNICE || elem == DesignElement.PLINTH || elem == DesignElement.COLUMN || elem == DesignElement.CAPITAL || elem == DesignElement.BASE || elem == DesignElement.PILASTER || elem == DesignElement.LADDER || elem == DesignElement.GUTTER) {
            Direction d = null;
            d = blockState.func_177230_c() instanceof CardinalDirectionFacadeBlock ? arrangement.getDirection().rotate(Rotate.ROTATE_180) : arrangement.getDirection();
            blockState = RotatorHelper.rotateBlock(blockState, d);
        }
        return blockState;
    }

    default public Arrangement getArrangement(ICoords coords, Room room, Layout layout) {
        DesignElement element = this.getDesignElement(coords, room, layout);
        Location location = this.getLocation(coords, room, layout);
        Direction direction = this.getDirection(coords, room, element, location);
        return new Arrangement(element, location, direction);
    }

    default public Direction getDirection(ICoords coords, Room room, DesignElement element, Location location) {
        Direction direction = Direction.NORTH;
        if (element == DesignElement.LADDER) {
            switch (room.getDirection()) {
                case NORTH: {
                    direction = Direction.SOUTH;
                    break;
                }
                case EAST: {
                    direction = Direction.WEST;
                    break;
                }
                case SOUTH: {
                    direction = Direction.NORTH;
                    break;
                }
                case WEST: {
                    direction = Direction.EAST;
                    break;
                }
                default: {
                    direction = room.getDirection();
                    break;
                }
            }
        } else if (element == DesignElement.PLINTH || element == DesignElement.COLUMN || element == DesignElement.CORNICE || element == DesignElement.COLUMN || element == DesignElement.CAPITAL || element == DesignElement.BASE) {
            direction = coords.getX() == room.getMinX() ? Direction.EAST : (coords.getX() == room.getMaxX() ? Direction.WEST : (coords.getZ() == room.getMinZ() ? Direction.SOUTH : Direction.NORTH));
        } else if (location == Location.SOUTH_SIDE) {
            direction = Direction.SOUTH;
        } else if (location == Location.WEST_SIDE) {
            direction = Direction.WEST;
        } else if (location == Location.EAST_SIDE) {
            direction = Direction.EAST;
        }
        return direction;
    }

    default public DesignElement getDesignElement(ICoords coords, Room room, Layout layout) {
        if (this.isFloorElement(coords, room, layout)) {
            if (room.hasGutter() && this.isGutterElement(coords, room, layout)) {
                return DesignElement.GUTTER;
            }
            if (room.hasGrate() && this.isGrateElement(coords, room, layout)) {
                return DesignElement.GRATE;
            }
            return DesignElement.FLOOR;
        }
        if (this.isWallElement(coords, room, layout)) {
            if (this.isFacadeSupport(coords, room, layout)) {
                return DesignElement.FACADE_SUPPORT;
            }
            if (room.hasWallBase() && this.isWallBase(coords, room, layout)) {
                return DesignElement.WALL_BASE;
            }
            if (room.hasWallCapital() && this.isWallCapital(coords, room, layout)) {
                return DesignElement.WALL_CAPITAL;
            }
            return DesignElement.WALL;
        }
        if (room.hasPilaster() && this.isPilasterElement(coords, room, layout)) {
            if (this.isBaseElement(coords, room, layout)) {
                return DesignElement.PILASTER_BASE;
            }
            if (this.isCapitalElement(coords, room, layout)) {
                return DesignElement.PILASTER_CAPITAL;
            }
            return DesignElement.PILASTER;
        }
        if (room.hasPillar() && this.isPillarElement(coords, room, layout)) {
            if (this.isBaseElement(coords, room, layout)) {
                return DesignElement.PILLAR_BASE;
            }
            if (this.isCapitalElement(coords, room, layout)) {
                return DesignElement.PILLAR_CAPITAL;
            }
            return DesignElement.PILLAR;
        }
        if (room.hasCrown() && this.isCrownElement(coords, room, layout)) {
            return DesignElement.CROWN;
        }
        if (room.hasTrim() && this.isTrimElement(coords, room, layout)) {
            return DesignElement.TRIM;
        }
        if (room.hasCoffer() && this.isCofferedCrossbeamElement(coords, room, layout)) {
            return DesignElement.COFFERED_CROSSBEAM;
        }
        if (room.hasCoffer() && this.isCofferedMidbeamElement(coords, room, layout)) {
            return DesignElement.COFFERED_MIDBEAM;
        }
        if (this.isCeilingElement(coords, room, layout)) {
            return DesignElement.CEILING;
        }
        if (this.isSurfaceAirElement(coords, room, layout)) {
            int x = coords.getX();
            int z = coords.getZ();
            if (coords.getY() == room.getMinY() + 1) {
                return DesignElement.FLOOR_AIR;
            }
            if ((x == room.getMinX() + 1 || x == room.getMaxX() - 1) && z > room.getMinZ() && z < room.getMaxZ() || (z == room.getMinZ() + 1 || z == room.getMaxZ() - 1) && x > room.getMinX() && x < room.getMaxX()) {
                return DesignElement.WALL_AIR;
            }
            if (coords.getY() == room.getMaxY() - 1) {
                return DesignElement.CEILING_AIR;
            }
        }
        return DesignElement.AIR;
    }

    default public boolean isCofferedMidbeamElement(ICoords coords, Room room, Layout layout) {
        return this.isCofferedCrossbeamElement(coords, room, layout);
    }

    default public boolean isCofferedCrossbeamElement(ICoords coords, Room room, Layout layout) {
        return coords.getY() == room.getMaxY() - 1;
    }

    default public boolean isSurfaceAirElement(ICoords coords, Room room, Layout layout) {
        return coords.getY() <= room.getMinY() + 1 || coords.getY() >= room.getMaxY() - 1 || coords.getX() <= room.getMinX() + 1 || coords.getX() >= room.getMaxX() - 1 || coords.getZ() <= room.getMinZ() + 1 || coords.getZ() >= room.getMaxZ() - 1;
    }

    default public Location getLocation(ICoords coords, Room room, Layout layout) {
        ICoords center = room.getCenter();
        int zDiff = 0;
        int xDiff = 0;
        int x = coords.getX();
        int y = coords.getY();
        int z = coords.getZ();
        if (z < center.getZ()) {
            zDiff = z - room.getMinZ();
            if (x >= room.getMinX() + zDiff && x <= room.getMaxX() - zDiff) {
                return Location.NORTH_SIDE;
            }
        }
        if (z > center.getZ()) {
            zDiff = room.getMaxZ() - z;
            if (x >= room.getMinX() + zDiff && x <= room.getMaxX() - zDiff) {
                return Location.SOUTH_SIDE;
            }
        }
        if (x < center.getX()) {
            xDiff = x - room.getMinX();
            if (z >= room.getMinZ() + xDiff && z <= room.getMaxZ() - xDiff) {
                return Location.WEST_SIDE;
            }
        }
        if (x > center.getX()) {
            xDiff = room.getMaxX() - x;
            if (z >= room.getMinZ() + xDiff && z <= room.getMaxZ() - xDiff) {
                return Location.EAST_SIDE;
            }
        }
        return Location.MIDDLE;
    }

    default public Style getStyle(DesignElement elem, Layout layout, Theme theme, StyleSheet styleSheet) {
        Style style = Style.NO_STYLE;
        if (layout == null) {
            layout = DungeonGenerator.getDefaultStyleSheet().getLayouts().get("default");
        }
        if (elem == null || elem == DesignElement.NONE || elem == DesignElement.AIR || elem.getFamily() == DesignElement.SURFACE_AIR || elem == DesignElement.FACADE) {
            return Style.NO_STYLE;
        }
        Frame frame = layout.getFrames().get(elem.name());
        if (frame == null) {
            ArrayList<String> layoutRefs = new ArrayList<String>(5);
            while (frame == null && layout != null && layout.getRef() != null && layout.getRef().length() > 0) {
                if (layoutRefs.contains(layout.getRef())) {
                    Dungeons2.log.warn(String.format("Stylesheet layout circular dependency: %s. Using defaults.", layout.getRef()));
                    break;
                }
                if (layoutRefs.size() == 5) {
                    Dungeons2.log.warn("Too many Stylesheet layout references (5 max allowed. Using defaults.");
                    break;
                }
                layoutRefs.add(layout.getRef());
                layout = styleSheet.getLayouts().get(layout.getRef());
                if (layout == null) continue;
                frame = layout.getFrames().get(elem.name());
            }
        }
        if (frame == null) {
            frame = DungeonGenerator.getDefaultStyleSheet().getLayouts().get("default").getFrames().get(elem.name());
        }
        if (frame == null) {
            return Style.NO_STYLE;
        }
        if (theme != null && frame.getAlias() != null && frame.getAlias().length() > 0) {
            style = styleSheet.getStyles().get(theme.getAliases().get(frame.getAlias()).getStyle());
            if (style == null) {
                Dungeons2.log.warn(String.format("Unable to locate style based on theme [%s] and frame [%s]'s alias [%s]", theme.getName(), elem.name(), frame.getAlias()));
            }
        } else if (frame.getStyle() != null && frame.getStyle().length() > 0 && (style = styleSheet.getStyles().get(frame.getStyle())) == null) {
            style = DungeonGenerator.getDefaultStyleSheet().getStyles().get(frame.getStyle());
        }
        if (style == null) {
            return Style.NO_STYLE;
        }
        return style;
    }

    default public int getDecayIndex(Random random, int decayMultiplier, Style style) {
        if (decayMultiplier <= 0) {
            return -1;
        }
        int decayIndex = -1;
        for (int i = 0; i < decayMultiplier; ++i) {
            if (!(random.nextDouble() * 100.0 < style.getDecay())) continue;
            ++decayIndex;
        }
        return decayIndex;
    }

    default public boolean isFloorElement(ICoords coords, Room room, Layout layout) {
        return coords.getY() == room.getMinY();
    }

    default public boolean isWallElement(ICoords coords, Room room, Layout layout) {
        return coords.getX() == room.getMinX() || coords.getZ() == room.getMinZ() || coords.getX() == room.getMaxX() || coords.getZ() == room.getMaxZ();
    }

    default public boolean isWallCapital(ICoords coords, Room room, Layout layout) {
        return coords.getY() == room.getMaxY() - 1;
    }

    default public boolean isWallBase(ICoords coords, Room room, Layout layout) {
        return coords.getY() == room.getMinY() + 1;
    }

    default public boolean isCeilingElement(ICoords coords, Room room, Layout layout) {
        return coords.getY() == room.getMaxY();
    }

    default public boolean isCrownElement(ICoords coords, Room room, Layout layout) {
        return coords.getY() == room.getMaxY() - 1 && room.getHeight() > 4 && (coords.getX() == room.getMinX() + 1 || coords.getX() == room.getMaxX() - 1 || coords.getZ() == room.getMinZ() + 1 || coords.getZ() == room.getMaxZ() - 1);
    }

    default public boolean isFacadeSupport(ICoords coords, Room room, Layout layout) {
        return coords.getY() == room.getMaxY() - 1;
    }

    default public boolean isTrimElement(ICoords coords, Room room, Layout layout) {
        return room.getWidth() >= 7 && room.getDepth() >= 7 && room.getHeight() > 4 && coords.getY() == room.getMinY() + 1 && (coords.getX() == room.getMinX() + 1 || coords.getX() == room.getMaxX() - 1 || coords.getZ() == room.getMinZ() + 1 || coords.getZ() == room.getMaxZ() - 1);
    }

    default public boolean isLadderElement(ICoords coords, Room room, Layout layout) {
        int x = coords.getX();
        int y = coords.getY();
        int z = coords.getZ();
        ICoords center = room.getCenter();
        Direction direction = room.getDirection();
        if (y > room.getMinY()) {
            return false;
        }
        switch (direction) {
            case NORTH: {
                if (x != center.getX() || z != center.getZ() + 1) break;
                return true;
            }
            case EAST: {
                if (x != center.getX() - 1 || z != center.getZ()) break;
                return true;
            }
            case SOUTH: {
                if (x != center.getX() || z != center.getZ() - 1) break;
                return true;
            }
            case WEST: {
                if (x != center.getX() + 1 || z != center.getZ()) break;
                return true;
            }
        }
        return false;
    }

    default public boolean isPillarElement(ICoords coords, Room room, Layout layout) {
        int x = coords.getX();
        int y = coords.getY();
        int z = coords.getZ();
        if (!room.hasPillar() || Math.min(room.getWidth(), room.getDepth()) < 7 || y == room.getMaxY()) {
            return false;
        }
        int xIndex = x - room.getCoords().getX();
        int zIndex = z - room.getCoords().getZ();
        int offset = 1;
        int remainder = 0;
        if (room.hasPilaster()) {
            offset += 2;
            remainder = 1;
        }
        return xIndex > offset && xIndex < room.getWidth() - offset && Math.abs(xIndex % 3) == remainder && zIndex > offset && zIndex < room.getDepth() - offset && Math.abs(zIndex % 3) == remainder;
    }

    default public boolean isPilasterElement(ICoords coords, Room room, Layout layout) {
        int x = coords.getX();
        int z = coords.getZ();
        if (room.getWidth() <= 5 || room.getDepth() <= 5 || coords.getY() == room.getMinY() || coords.getY() == room.getMaxY()) {
            return false;
        }
        int xIndex = x - room.getCoords().getX();
        int zIndex = z - room.getCoords().getZ();
        if (room.getWidth() % 2 == 0 || room.getDepth() % 2 == 0) {
            return !(x != room.getMinX() + 1 && x != room.getMaxX() - 1 || z != room.getMinZ() + 1 && z != room.getMaxZ() - 1);
        }
        return (x == room.getMinX() + 1 || x == room.getMaxX() - 1) && Math.abs(zIndex % 2) == 1 && zIndex > 0 && zIndex < room.getDepth() - 1 || (z == room.getMinZ() + 1 || z == room.getMaxZ() - 1) && Math.abs(xIndex % 2) == 1 && xIndex > 0 && xIndex < room.getWidth() - 1;
    }

    default public boolean isGutterElement(ICoords coords, Room room, Layout layout) {
        int x = coords.getX();
        int z = coords.getZ();
        return coords.getY() == room.getMinY() && ((x == room.getMinX() + 1 || x == room.getMaxX() - 1) && z > room.getMinZ() + 1 && z < room.getMaxZ() - 1 || (z == room.getMinZ() + 1 || z == room.getMaxZ() - 1) && x > room.getMinX() + 1 && x < room.getMaxX() - 1);
    }

    default public boolean isGrateElement(ICoords coords, Room room, Layout layout) {
        int x = coords.getX();
        int z = coords.getZ();
        if (coords.getY() != room.getMinY()) {
            return false;
        }
        if (room.hasGutter()) {
            if (!(x != room.getMinX() + 1 && x != room.getMaxX() - 1 || z != room.getMinZ() + 1 && z != room.getMaxZ() - 1)) {
                return true;
            }
        } else {
            ICoords center = room.getCenter();
            if (coords.getX() == center.getX() && coords.getZ() == center.getZ()) {
                return true;
            }
        }
        return false;
    }

    default public boolean isBaseElement(ICoords coords, Room room, Layout layout) {
        return coords.getY() == room.getMinY() + 1;
    }

    default public boolean isCapitalElement(ICoords coords, Room room, Layout layout) {
        return coords.getY() == room.getMaxY() - 1;
    }
}

