/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.generator.blockprovider;

import com.someguyssoftware.dungeons2.generator.blockprovider.IDungeonsBlockProvider;
import com.someguyssoftware.dungeons2.model.Room;
import com.someguyssoftware.dungeons2.style.DesignElement;
import com.someguyssoftware.dungeons2.style.Layout;
import com.someguyssoftware.gottschcore.enums.Direction;
import com.someguyssoftware.gottschcore.positional.ICoords;

public class EndRoomBlockProvider
implements IDungeonsBlockProvider {
    @Override
    public DesignElement getDesignElement(ICoords coords, Room room, Layout layout) {
        if (this.isLadderPillarElement(coords, room, layout)) {
            return DesignElement.LADDER_PILLAR;
        }
        if (this.isLadderElement(coords, room, layout)) {
            return DesignElement.LADDER;
        }
        if (this.isFloorElement(coords, room, layout)) {
            return DesignElement.FLOOR;
        }
        if (this.isWallElement(coords, room, layout)) {
            if (this.isFacadeSupport(coords, room, layout)) {
                return DesignElement.FACADE_SUPPORT;
            }
            return DesignElement.WALL;
        }
        if (this.isCrownElement(coords, room, layout)) {
            return DesignElement.CROWN;
        }
        if (this.isTrimElement(coords, room, layout)) {
            return DesignElement.TRIM;
        }
        if (this.isCeilingElement(coords, room, layout)) {
            return DesignElement.CEILING;
        }
        return DesignElement.AIR;
    }

    public boolean isLadderPillarElement(ICoords coords, Room room, Layout layout) {
        ICoords center = room.getCenter();
        return coords.getX() == center.getX() && coords.getZ() == center.getZ() && coords.getY() < room.getMaxY();
    }

    @Override
    public boolean isLadderElement(ICoords coords, Room room, Layout layout) {
        ICoords center = room.getCenter();
        Direction direction = room.getDirection();
        if (coords.getY() == room.getMaxY()) {
            return false;
        }
        switch (direction) {
            case NORTH: {
                if (coords.getX() != center.getX() || coords.getZ() != center.getZ() + 1) break;
                return true;
            }
            case EAST: {
                if (coords.getX() != center.getX() - 1 || coords.getZ() != center.getZ()) break;
                return true;
            }
            case SOUTH: {
                if (coords.getX() != center.getX() || coords.getZ() != center.getZ() - 1) break;
                return true;
            }
            case WEST: {
                if (coords.getX() != center.getX() + 1 || coords.getZ() != center.getZ()) break;
                return true;
            }
        }
        return false;
    }
}

