/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.generator;

import com.someguyssoftware.dungeons2.generator.ISupportedBlock;
import com.someguyssoftware.dungeons2.generator.SupportedBlock;
import com.someguyssoftware.dungeons2.generator.blockprovider.IDungeonsBlockProvider;
import com.someguyssoftware.dungeons2.model.Room;
import com.someguyssoftware.dungeons2.style.DesignElement;
import com.someguyssoftware.gottschcore.positional.ICoords;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SupportedBlockProcessor {
    private ISupportedBlock[][][] supportMatrix;
    private IDungeonsBlockProvider blockProvider;
    private Room room;

    public SupportedBlockProcessor(IDungeonsBlockProvider blockProvider, Room room) {
        this.blockProvider = blockProvider;
        this.room = room;
        this.supportMatrix = new SupportedBlock[room.getHeight()][room.getDepth()][room.getWidth()];
    }

    public int applySupportRulesPass1(World world, ICoords indexCoords, ICoords worldCoords, DesignElement elem) {
        int amount = 0;
        if (elem == DesignElement.AIR || elem == DesignElement.SURFACE_AIR || elem == DesignElement.NONE || elem.getFamily() == DesignElement.SURFACE_AIR) {
            return 100;
        }
        if ((amount += this.getYNegSupportAmount(world, indexCoords, worldCoords, elem)) >= 100) {
            return 100;
        }
        if ((amount += this.getXNegSupportAmount(world, indexCoords, worldCoords, elem)) >= 100) {
            return 100;
        }
        if ((amount += this.getZNegSupportAmount(world, indexCoords, worldCoords, elem)) >= 100) {
            return 100;
        }
        return amount;
    }

    public int applySupportRulesPass2(World world, ICoords indexCoords, ICoords worldCoords, DesignElement elem) {
        int amount = 0;
        if (elem == DesignElement.AIR) {
            return 100;
        }
        if ((amount += this.getXPosSupportAmount(world, indexCoords, worldCoords, elem)) >= 100) {
            return 100;
        }
        if ((amount += this.getZPosSupportAmount(world, indexCoords, worldCoords, elem)) >= 100) {
            return 100;
        }
        return amount;
    }

    public int getYNegSupportAmount(World world, ICoords indexCoords, ICoords worldCoords, DesignElement elem) {
        int amount = 0;
        BlockPos supportPos = new BlockPos(worldCoords.getX(), worldCoords.getY() - 1, worldCoords.getZ());
        IBlockState worldBlockState = world.func_180495_p(supportPos);
        if (worldBlockState != null && this.isSupportingBlock(world, supportPos)) {
            if (indexCoords.getY() == 0) {
                return 100;
            }
            ISupportedBlock supportBlock = this.supportMatrix[indexCoords.getY() - 1][indexCoords.getZ()][indexCoords.getX()];
            if (supportBlock == null) {
                return 100;
            }
            DesignElement supportElement = this.blockProvider.getDesignElement(worldCoords.add(0, -1, 0), this.room, this.room.getLayout());
            amount += supportElement.getVerticalSupport().intValue();
        }
        return amount;
    }

    public int getXNegSupportAmount(World world, ICoords indexCoords, ICoords worldCoords, DesignElement elem) {
        int amount = 0;
        BlockPos supportPos = new BlockPos(worldCoords.getX() - 1, worldCoords.getY(), worldCoords.getZ());
        IBlockState worldBlockState = world.func_180495_p(supportPos);
        if (worldBlockState != null && this.isSupportingBlock(world, supportPos)) {
            if (indexCoords.getX() == 0) {
                return 100;
            }
            ISupportedBlock supportBlock = this.supportMatrix[indexCoords.getY()][indexCoords.getZ()][indexCoords.getX() - 1];
            if (supportBlock == null) {
                return 100;
            }
            DesignElement supportElement = this.blockProvider.getDesignElement(worldCoords.add(-1, 0, 0), this.room, this.room.getLayout());
            amount = supportElement == DesignElement.FACADE_SUPPORT ? (elem.getFamily() == DesignElement.FACADE ? (amount += supportElement.getHorizontalSupport().intValue()) : (amount += supportElement.getFamily().getHorizontalSupport().intValue())) : (amount += supportElement.getHorizontalSupport().intValue());
        }
        return amount;
    }

    public int getZNegSupportAmount(World world, ICoords indexCoords, ICoords worldCoords, DesignElement elem) {
        int amount = 0;
        BlockPos supportPos = new BlockPos(worldCoords.getX(), worldCoords.getY(), worldCoords.getZ() - 1);
        IBlockState worldBlockState = world.func_180495_p(supportPos);
        if (worldBlockState != null && this.isSupportingBlock(world, supportPos)) {
            if (indexCoords.getZ() == 0) {
                return 100;
            }
            ISupportedBlock supportBlock = this.supportMatrix[indexCoords.getY()][indexCoords.getZ() - 1][indexCoords.getX()];
            if (supportBlock == null) {
                return 100;
            }
            DesignElement supportElement = this.blockProvider.getDesignElement(worldCoords.add(0, 0, -1), this.room, this.room.getLayout());
            amount = supportElement == DesignElement.FACADE_SUPPORT && elem.getFamily() != DesignElement.FACADE ? (amount += supportElement.getFamily().getHorizontalSupport().intValue()) : (amount += supportElement.getHorizontalSupport().intValue());
        }
        return amount;
    }

    public int getXPosSupportAmount(World world, ICoords indexCoords, ICoords worldCoords, DesignElement elem) {
        int amount = 0;
        BlockPos supportPos = new BlockPos(worldCoords.getX() + 1, worldCoords.getY(), worldCoords.getZ());
        IBlockState worldBlockState = world.func_180495_p(supportPos);
        if (worldBlockState != null && this.isSupportingBlock(world, supportPos)) {
            if (indexCoords.getX() == this.getSupportMatrix()[0][0].length - 1) {
                return 100;
            }
            ISupportedBlock supportBlock = this.getSupportMatrix()[indexCoords.getY()][indexCoords.getZ()][indexCoords.getX() + 1];
            if (supportBlock == null) {
                return 100;
            }
            DesignElement supportElement = this.blockProvider.getDesignElement(worldCoords.add(1, 0, 0), this.room, this.room.getLayout());
            amount = supportElement == DesignElement.FACADE_SUPPORT && elem.getFamily() != DesignElement.FACADE ? (amount += supportElement.getFamily().getHorizontalSupport().intValue()) : (amount += supportElement.getHorizontalSupport().intValue());
        }
        return amount;
    }

    public int getZPosSupportAmount(World world, ICoords indexCoords, ICoords worldCoords, DesignElement elem) {
        int amount = 0;
        BlockPos supportPos = new BlockPos(worldCoords.getX(), worldCoords.getY(), worldCoords.getZ() + 1);
        IBlockState worldBlockState = world.func_180495_p(supportPos);
        if (worldBlockState != null && this.isSupportingBlock(world, supportPos)) {
            if (indexCoords.getZ() == this.getSupportMatrix()[0].length - 1) {
                return 100;
            }
            ISupportedBlock supportBlock = this.getSupportMatrix()[indexCoords.getY()][indexCoords.getZ() + 1][indexCoords.getX()];
            if (supportBlock == null) {
                return 100;
            }
            DesignElement supportElement = this.blockProvider.getDesignElement(worldCoords.add(0, 0, 1), this.room, this.room.getLayout());
            amount = supportElement == DesignElement.FACADE_SUPPORT && elem.getFamily() != DesignElement.FACADE ? (amount += supportElement.getFamily().getHorizontalSupport().intValue()) : (amount += supportElement.getHorizontalSupport().intValue());
        }
        return amount;
    }

    public boolean isSupportingBlock(World world, int x, int y, int z) {
        return this.isSupportingBlock(world, new BlockPos(x, y, z));
    }

    public boolean isSupportingBlock(World world, ICoords coords) {
        return this.isSupportingBlock(world, new BlockPos(coords.getX(), coords.getY(), coords.getZ()));
    }

    public boolean isSupportingBlock(World world, BlockPos blockPos) {
        IBlockState blockState = world.func_180495_p(blockPos);
        Block block = blockState.func_177230_c();
        return block != Blocks.field_150350_a && block != Blocks.field_150355_j && block != Blocks.field_150353_l && !block.isFoliage((IBlockAccess)world, blockPos) && !blockState.func_185904_a().func_76222_j() && !block.isLeaves(blockState, (IBlockAccess)world, blockPos);
    }

    public ISupportedBlock[][][] getSupportMatrix() {
        return this.supportMatrix;
    }

    public void setSupportMatrix(ISupportedBlock[][][] supportMatrix) {
        this.supportMatrix = supportMatrix;
    }

    public Room getRoom() {
        return this.room;
    }

    public void setRoom(Room room) {
        this.room = room;
    }

    public IDungeonsBlockProvider getBlockProvider() {
        return this.blockProvider;
    }

    public void setBlockProvider(IDungeonsBlockProvider blockProvider) {
        this.blockProvider = blockProvider;
    }
}

