/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.generator;

import com.someguyssoftware.dungeons2.generator.Arrangement;
import com.someguyssoftware.dungeons2.generator.blockprovider.IDungeonsBlockProvider;
import com.someguyssoftware.dungeons2.generator.strategy.IRoomGenerationStrategy;
import com.someguyssoftware.dungeons2.model.LevelConfig;
import com.someguyssoftware.dungeons2.style.DesignElement;
import com.someguyssoftware.dungeons2.style.Layout;
import com.someguyssoftware.dungeons2.style.Style;
import com.someguyssoftware.dungeons2.style.StyleSheet;
import com.someguyssoftware.dungeons2.style.Theme;
import com.someguyssoftware.dungeonsengine.config.ILevelConfig;
import com.someguyssoftware.gottschcore.positional.ICoords;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class AbstractRoomGenerationStrategy
implements IRoomGenerationStrategy {
    private IDungeonsBlockProvider blockProvider;

    public AbstractRoomGenerationStrategy(IDungeonsBlockProvider provider) {
        this.blockProvider = provider;
    }

    protected boolean isPostProcessed(Arrangement arrangement, ICoords coords, Map<ICoords, Arrangement> postProcess) {
        if (arrangement.getElement() == DesignElement.LADDER) {
            postProcess.put(coords, arrangement);
            return true;
        }
        return false;
    }

    protected void postProcess(World world, Random random, Map<ICoords, Arrangement> post, Layout layout, Theme theme, StyleSheet styleSheet, ILevelConfig config) {
        IBlockState blockState = null;
        for (Map.Entry<ICoords, Arrangement> e : post.entrySet()) {
            ICoords keyCoords = e.getKey();
            Arrangement a = e.getValue();
            DesignElement elem = a.getElement();
            BlockPos pos = keyCoords.toPos();
            IBlockState state1 = world.func_180495_p(pos.func_177974_f());
            IBlockState state2 = world.func_180495_p(pos.func_177976_e());
            IBlockState state3 = world.func_180495_p(pos.func_177978_c());
            IBlockState state4 = world.func_180495_p(pos.func_177968_d());
            boolean flag = false;
            if (state1 != null && state1.func_177230_c().isNormalCube(state1, (IBlockAccess)world, null) || state2 != null && state2.func_177230_c().isNormalCube(state2, (IBlockAccess)world, null) || state3 != null && state3.func_177230_c().isNormalCube(state3, (IBlockAccess)world, null) || state4 != null && state4.func_177230_c().isNormalCube(state4, (IBlockAccess)world, null)) {
                flag = true;
            }
            if (!flag) {
                return;
            }
            Style style = this.getBlockProvider().getStyle(elem, layout, theme, styleSheet);
            int decayIndex = this.getBlockProvider().getDecayIndex(random, config.getDecayMultiplier(), style);
            blockState = this.getBlockProvider().getBlockState(a, style, decayIndex);
            if (blockState == null || blockState == IDungeonsBlockProvider.NULL_BLOCK) continue;
            world.func_180501_a(keyCoords.toPos(), blockState, 3);
        }
    }

    @Deprecated
    protected void postProcess(World world, Random random, Map<ICoords, Arrangement> post, Layout layout, Theme theme, StyleSheet styleSheet, LevelConfig config) {
        IBlockState blockState = null;
        for (Map.Entry<ICoords, Arrangement> e : post.entrySet()) {
            ICoords keyCoords = e.getKey();
            Arrangement a = e.getValue();
            DesignElement elem = a.getElement();
            BlockPos pos = keyCoords.toPos();
            IBlockState state1 = world.func_180495_p(pos.func_177974_f());
            IBlockState state2 = world.func_180495_p(pos.func_177976_e());
            IBlockState state3 = world.func_180495_p(pos.func_177978_c());
            IBlockState state4 = world.func_180495_p(pos.func_177968_d());
            boolean flag = false;
            if (state1 != null && state1.func_177230_c().isNormalCube(state1, (IBlockAccess)world, null) || state2 != null && state2.func_177230_c().isNormalCube(state2, (IBlockAccess)world, null) || state3 != null && state3.func_177230_c().isNormalCube(state3, (IBlockAccess)world, null) || state4 != null && state4.func_177230_c().isNormalCube(state4, (IBlockAccess)world, null)) {
                flag = true;
            }
            if (!flag) {
                return;
            }
            Style style = this.getBlockProvider().getStyle(elem, layout, theme, styleSheet);
            int decayIndex = this.getBlockProvider().getDecayIndex(random, config.getDecayMultiplier(), style);
            blockState = this.getBlockProvider().getBlockState(a, style, decayIndex);
            if (blockState == null || blockState == IDungeonsBlockProvider.NULL_BLOCK) continue;
            world.func_180501_a(keyCoords.toPos(), blockState, 3);
        }
    }

    @Override
    public IDungeonsBlockProvider getBlockProvider() {
        return this.blockProvider;
    }
}

