/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2.config;

import com.someguyssoftware.dungeons2.config.BuildDirection;
import com.someguyssoftware.dungeons2.config.BuildPattern;
import com.someguyssoftware.dungeons2.config.BuildSize;
import com.someguyssoftware.dungeons2.config.ModConfig;
import com.someguyssoftware.dungeons2.model.LevelConfig;
import com.someguyssoftware.gottschcore.Quantity;

public final class PRESET_LEVEL_CONFIGS {
    private static double DIRECTIONAL_LOW_OFFSET = 0.4;
    private static double DIRECTIONAL_HIGH_OFFSET = 1.6;

    public static LevelConfig getConfig(BuildPattern pattern, BuildSize size, BuildDirection direction) {
        int xdist = 0;
        int zdist = 0;
        Quantity xDistQuantity = null;
        Quantity zDistQuantity = null;
        Quantity numRooms = null;
        LevelConfig config = new LevelConfig();
        config.setDecayMultiplier(ModConfig.decayMultiplier);
        switch (size) {
            case SMALL: {
                numRooms = new Quantity(10.0, 20.0);
                break;
            }
            case MEDIUM: {
                numRooms = new Quantity(15.0, 30.0);
                break;
            }
            case LARGE: {
                numRooms = new Quantity(20.0, 40.0);
                break;
            }
            case VAST: {
                numRooms = new Quantity(25.0, 50.0);
            }
        }
        block6 : switch (pattern) {
            case SQUARE: {
                switch (size) {
                    case SMALL: {
                        zdist = 25;
                        xdist = 25;
                        break;
                    }
                    case MEDIUM: {
                        zdist = 35;
                        xdist = 35;
                        break;
                    }
                    case LARGE: {
                        zdist = 45;
                        xdist = 45;
                        break;
                    }
                    case VAST: {
                        zdist = 55;
                        xdist = 55;
                    }
                }
                break;
            }
            case HORZ: {
                switch (size) {
                    case SMALL: {
                        xdist = 30;
                        zdist = 5;
                        break;
                    }
                    case MEDIUM: {
                        xdist = 40;
                        zdist = 5;
                        break;
                    }
                    case LARGE: {
                        xdist = 50;
                        zdist = 5;
                        break;
                    }
                    case VAST: {
                        xdist = 60;
                        zdist = 5;
                    }
                }
                break;
            }
            case VERT: {
                switch (size) {
                    case SMALL: {
                        xdist = 5;
                        zdist = 30;
                        break block6;
                    }
                    case MEDIUM: {
                        xdist = 5;
                        zdist = 40;
                        break block6;
                    }
                    case LARGE: {
                        xdist = 5;
                        zdist = 50;
                        break block6;
                    }
                    case VAST: {
                        xdist = 5;
                        zdist = 60;
                    }
                }
            }
        }
        switch (direction) {
            case CENTER: {
                xDistQuantity = new Quantity((double)(-xdist), (double)xdist);
                zDistQuantity = new Quantity((double)(-zdist), (double)zdist);
                break;
            }
            case NORTH: {
                xDistQuantity = new Quantity((double)(-xdist), (double)xdist);
                zDistQuantity = new Quantity(-(DIRECTIONAL_LOW_OFFSET * (double)zdist), DIRECTIONAL_HIGH_OFFSET * (double)zdist);
                break;
            }
            case SOUTH: {
                xDistQuantity = new Quantity((double)(-xdist), (double)xdist);
                zDistQuantity = new Quantity(-(DIRECTIONAL_HIGH_OFFSET * (double)zdist), DIRECTIONAL_LOW_OFFSET * (double)zdist);
                break;
            }
            case EAST: {
                xDistQuantity = new Quantity(-(DIRECTIONAL_HIGH_OFFSET * (double)xdist), DIRECTIONAL_LOW_OFFSET * (double)xdist);
                zDistQuantity = new Quantity((double)(-zdist), (double)zdist);
                break;
            }
            case WEST: {
                xDistQuantity = new Quantity(-(DIRECTIONAL_LOW_OFFSET * (double)xdist), DIRECTIONAL_HIGH_OFFSET * (double)xdist);
                zDistQuantity = new Quantity((double)(-zdist), (double)zdist);
            }
        }
        config.setNumberOfRooms(numRooms);
        config.setXDistance(xDistQuantity);
        config.setZDistance(zDistQuantity);
        return config;
    }
}

