/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.dungeons2;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.someguyssoftware.dungeons2.chest.ChestContainer;
import com.someguyssoftware.dungeons2.chest.ChestItem;
import com.someguyssoftware.dungeons2.chest.ChestItemEnchantment;
import com.someguyssoftware.dungeons2.chest.ChestItemGroup;
import com.someguyssoftware.dungeons2.chest.ChestSheet;
import com.someguyssoftware.dungeons2.chest.Enchants;
import com.someguyssoftware.dungeons2.chest.RandomGroup;
import com.someguyssoftware.dungeons2.chest.RandomItem;
import com.someguyssoftware.gottschcore.Quantity;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ChestSheetBuilder {
    Map<String, ChestItem> itemMap = new LinkedHashMap<String, ChestItem>();
    Map<String, RandomItem> randomItemMap = new LinkedHashMap<String, RandomItem>();
    Map<String, RandomGroup> randomGroupMap = new LinkedHashMap<String, RandomGroup>();
    Map<String, ChestItemEnchantment> enchantmentsMap = new HashMap<String, ChestItemEnchantment>();
    ChestSheet chestSheet = new ChestSheet();

    public static void main(String[] args) {
        ChestSheetBuilder chestBuilder = new ChestSheetBuilder();
        GsonBuilder builder = new GsonBuilder();
        JsonSerializer<ChestItem> serializer = new JsonSerializer<ChestItem>(){

            public JsonElement serialize(ChestItem src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject jsonObj = new JsonObject();
                jsonObj.addProperty("NAME", src.getName());
                jsonObj.addProperty("damage", (Number)src.getDamage());
                return jsonObj;
            }
        };
        builder.registerTypeAdapter(ChestItem.class, (Object)serializer);
        builder.setPrettyPrinting();
        Gson gson = builder.create();
        chestBuilder.buildEnchantments();
        chestBuilder.buildItems();
        chestBuilder.buildRandomItems();
        chestBuilder.buildItemGroups();
        chestBuilder.buildRandomGroups();
        chestBuilder.buildContainers();
        String json = gson.toJson((Object)chestBuilder.chestSheet);
        System.out.println(json);
    }

    private void buildEnchantments() {
        this.e("bane_of_anthropods_x1", "bane_of_anthropods", 1);
        this.e("bane_of_anthropods_x2", "bane_of_anthropods", 2);
    }

    private void e(String id, String name, int level) {
        ChestItemEnchantment enchantment = new ChestItemEnchantment();
        enchantment.setName(name);
        enchantment.setLevel(level);
        this.enchantmentsMap.put(id, enchantment);
    }

    private void buildItems() {
        this.m("bread", "bread");
        this.m("wool", "wool");
        this.m("torch", "torch");
        this.m("leather", "leather");
        this.m("rabbit_hide", "rabbit_hide");
        this.m("gold_nugget", "gold_nugget");
        this.m("arrow", "arrow");
        this.m("dye0", "dye", 0);
        this.m("bone", "bone");
        this.m("spider_eye", "spider_eye");
        this.m("rotten_flesh", "rotten_flesh");
        this.m("string", "string");
        this.m("wheat", "wheat");
        this.m("wheat_seeds", "wheat_seeds");
        this.m("sugar", "sugar");
        this.m("brown_mushroom", "brown_mushroom");
        this.m("red_mushroom", "red_mushroom");
        this.m("apple", "apple");
        this.m("carrot", "carrot");
        this.m("porkchop", "porkchop");
        this.m("rabbit", "rabbit");
        this.m("egg", "egg");
        this.m("chicken", "chicken");
        this.m("fish0", "fish", 0);
        this.m("fish1", "fish", 1);
        this.m("beef", "beef");
        this.m("cookie", "cookie");
        this.m("pumpkin", "pumpkin");
        this.m("pumpkin_seeds", "pumpkin_seeds");
        this.m("melon", "melon");
        this.m("melon_seeds", "melon_seeds");
        this.m("mutton", "mutton");
        this.m("cocoa", "cocoa");
        this.m("spectral_arrow", "spectral_arrow");
        this.m("paper", "paper");
        this.m("reeds", "reeds");
        this.m("book", "book");
        this.m("bowl", "bowl");
        this.m("redstone", "redstone");
        this.m("redstone_torch", "redstone_torch");
        this.m("coal", "coal");
        this.m("shield", "shield");
        this.m("bow", "bow");
        this.m("clay", "clay");
        this.m("bucket", "bucket");
        this.m("slime_ball", "slime_ball");
        this.m("lead", "lead");
        this.m("fermented_spider_eye", "fermented_spider_eye");
        this.m("leather_chestplate", "leather_chestplate");
        this.m("leather_leggings", "leather_leggings");
        this.m("leather_arms", "leather_arms");
        this.m("leather_helmet", "leather_helmet");
        this.m("leather_boots", "leather_boots");
        this.m("stone_pickaxe", "stone_pickaxe");
        this.m("stone_axe", "stone_axe");
        this.m("stone_sword", "stone_sword");
        this.m("gold_sword", "gold_sword");
        this.m("iron_pickaxe", "iron_pickaxe");
        this.m("iron_axe", "iron_axe");
        this.m("iron_chestplate", "iron_chestplate");
        this.m("iron_leggings", "iron_leggings");
        this.m("iron_arms", "iron_arms");
        this.m("iron_helmet", "iron_helmet");
        this.m("iron_boots", "iron_boots");
        this.m("iron_sword", "iron_sword");
        this.m("iron_ingot", "iron_ingot");
        this.m("iron_block", "iron_block");
        this.m("tnt", "tnt");
        this.m("blaze_powder", "blaze_powder");
        this.m("magma_cream", "magma_cream");
        this.m("clock", "clock");
        this.m("compass", "compass");
        this.m("glowstone", "glowstone");
        this.m("ender_pearl", "ender_pearl");
        this.m("ender_eye", "ender_pearl");
        this.m("blaze_rod", "blaze_rod");
        this.m("ghast_tear", "ghast_tear");
        this.m("diamond", "diamond");
        this.m("prismarine_crystals", "prismarine_crystals");
        this.m("prismarine_shard", "prismarine_shard");
        this.m("sea_lantern", "sea_lantern");
        this.m("nether_star", "nether_star");
        this.m("firework_charge", "firework_charge");
        this.m("rabbit_foot", "rabbit_foot");
        this.m("potato", "potato");
        this.m("cake", "cake");
        this.m("pumpkin_pie", "pumpkin_pie");
        this.m("speckled_melon", "speckled_melon");
        this.m("beetroot", "beetroot");
        this.m("beetroot_seeds", "beetroot_seeds");
        this.m("diamond_chestplate", "diamond_chestplate");
        this.m("diamond_leggings", "diamond_leggings");
        this.m("diamond_arms", "diamond_arms");
        this.m("diamond_helmet", "diamond_helmet");
        this.m("diamond_boots", "diamond_boots");
        this.m("diamond_block", "diamond_block");
        this.m("iron_horse_armor", "iron_horse_armor");
        this.m("gold_horse_armor", "gold_horse_armor");
        this.m("end_crystal", "end_crystal");
        this.m("chorus_fruit_popped", "chorus_fruit_popped");
        this.m("diamond_pickaxe", "diamond_pickaxe");
        this.m("diamond_sword", "diamond_sword");
        this.m("shulker_box", "shulker_box");
        this.m("shulker_shell", "shulker_shell");
        this.m("dragon_breath", "dragon_breath");
        this.m("elytra", "elytra");
        this.m("saddle", "saddle");
        this.m("emerald", "emerald");
        this.m("golden_apple", "golden_apple");
        this.m("golden_carrot", "golden_carrot");
        this.m("diamond_horse_armor", "diamond_horse_armor");
        this.m("totem_of_undying", "totem_of_undying");
        this.m("experience_bottle", "experience_bottle");
        this.m("record_13", "record_13");
        this.m("record_cat", "record_cat");
        this.m("record_blocks", "record_blocks");
        this.m("record_chirp", "record_chirp");
        this.m("record_far", "record_far");
        this.m("record_mall", "record_mall");
        this.m("record_mellohi", "record_mellohi");
        this.m("record_stal", "record_stal");
        this.m("record_strad", "record_strad");
        this.m("record_ward", "record_ward");
        this.m("record_11", "record_11");
        this.m("record_wait", "record_wait");
        this.m("lapis_ore", "lapis_ore");
        this.m("dye4", "dye4", 4);
        for (ChestItem item : this.itemMap.values()) {
            this.chestSheet.getItems().put(item.getId(), item);
        }
    }

    private void m(String id, String name) {
        this.itemMap.put(id, new ChestItem(id, ChestSheetBuilder.pf(name)));
    }

    private void m(String id, String name, int damage) {
        this.itemMap.put(id, new ChestItem(id, ChestSheetBuilder.pf(name), damage));
    }

    private void m(String id, String name, String modid) {
        int size = this.itemMap.size();
        String newId = String.valueOf(size);
        this.itemMap.put(id, new ChestItem(id, ChestSheetBuilder.pf(name, modid)));
    }

    private void m(String id, String name, int damage, String modid) {
        ChestItem ci = new ChestItem(id, ChestSheetBuilder.pf(name, modid));
        ci.setDamage(damage);
        this.itemMap.put(id, ci);
    }

    private static String pf(String name) {
        return "minecraft:" + name;
    }

    private static String pf(String name, String modid) {
        return modid + ":" + name;
    }

    private void buildRandomItems() {
        this.rm("torch", "torch", 50.0, 1.0, 5.0, 50.0, 52.0);
        this.rm("bone", "bone", 35.0, 1.0, 3.0, 50.0, 57.0);
        this.rm("rotten_flesh", "rotten_flesh", 50.0, 1.0, 1.0, 50.0, 59.0);
        this.rm("arrow", "arrow", 35.0, 5.0, 10.0, 50.0, 56.0);
        this.rm("string", "string", 35.0, 1.0, 3.0, 50.0, 60.0);
        this.rm("wool", "wool", 25.0, 1.0, 3.0, 25.0, 51.0);
        this.rm("leather", "leather", 20.0, 1.0, 3.0, 20.0, 53.0);
        this.rm("dye0", "dye0", 20.0, 1.0, 3.0, 20.0, 54.0);
        this.rm("gold_nugget", "gold_nugget", 20.0, 1.0, 3.0, 20.0, 55.0);
        this.rm("spider_eye", "spider_eye", 35.0, 1.0, 3.0, 35.0, 58.0);
        this.rm("rabbit_hide", "rabbit_hide", 22.0, 1.0, 3.0, 22.0, 61.0);
        this.rm("iron_ingot", "iron_ingot", 30.0, 1.0, 5.0, 10.0, 62.0);
        this.rm("leather_chestplate", "leather_chestplate", 15.0, 1.0, 1.0, 20.0, 300.0);
        this.rm("leather_leggings", "leather_leggings", 20.0, 1.0, 1.0, 20.0, 300.0);
        this.rm("leather_arms", "leather_arms", 20.0, 1.0, 1.0, 20.0, 300.0);
        this.rm("leather_helmet", "leather_helmet", 20.0, 1.0, 1.0, 20.0, 300.0);
        this.rm("leather_boots", "leather_boots", 20.0, 1.0, 1.0, 20.0, 300.0);
        this.rm("stone_pickaxe", "stone_pickaxe", 25.0, 1.0, 1.0, 25.0, 100.0);
        this.rm("stone_axe", "stone_axe", 25.0, 1.0, 1.0, 25.0, 101.0);
        this.rm("stone_sword", "stone_sword", 25.0, 1.0, 1.0, 25.0, 102.0);
        this.rm("bread", "bread", 80.0, 2.0, 5.0, 80.0, 50.0);
        this.rm("wheat", "wheat", 80.0, 2.0, 5.0, 80.0, 50.0);
        this.rm("wheat_seeds", "wheat_seeds", 80.0, 3.0, 5.0, 80.0, 50.0);
        this.rm("sugar", "sugar", 20.0, 1.0, 3.0, 20.0, 50.0);
        this.rm("brown_mushroom", "brown_mushroom", 80.0, 1.0, 5.0, 80.0, 50.0);
        this.rm("red_mushroom", "red_mushroom", 80.0, 1.0, 5.0, 80.0, 50.0);
        this.rm("apple", "apple", 80.0, 1.0, 5.0, 80.0, 50.0);
        this.rm("carrot", "carrot", 35.0, 1.0, 5.0, 35.0, 50.0);
        this.rm("porkchop", "porkchop", 25.0, 1.0, 2.0, 25.0, 50.0);
        this.rm("rabbit", "rabbit", 25.0, 1.0, 2.0, 25.0, 50.0);
        this.rm("egg", "egg", 80.0, 1.0, 3.0, 80.0, 50.0);
        this.rm("chicken", "chicken", 25.0, 1.0, 2.0, 25.0, 50.0);
        this.rm("fish0", "fish0", 35.0, 1.0, 5.0, 35.0, 50.0);
        this.rm("fish1", "fish1", 35.0, 1.0, 3.0, 30.0, 50.0);
        this.rm("beef", "beef", 25.0, 1.0, 3.0, 25.0, 50.0);
        this.rm("cookie", "cookie", 15.0, 1.0, 2.0, 15.0, 50.0);
        this.rm("pumpkin", "pumpkin", 15.0, 1.0, 1.0, 15.0, 50.0);
        this.rm("pumpkin_seeds", "pumpkin_seeds", 50.0, 1.0, 2.0, 50.0, 50.0);
        this.rm("melon", "melon", 10.0, 1.0, 1.0, 10.0, 50.0);
        this.rm("melon_seeds", "melon_seeds", 10.0, 1.0, 5.0, 10.0, 50.0);
        this.rm("mutton", "mutton", 25.0, 1.0, 5.0, 25.0, 50.0);
        this.rm("cocoa", "cocoa", 10.0, 1.0, 2.0, 10.0, 50.0);
        this.rm("spectral_arrow", "spectral_arrow", 15.0, 2.0, 6.0, 15.0, 120.0);
        this.rm("paper", "paper", 25.0, 1.0, 2.0, 25.0, 120.0);
        this.rm("reeds", "reeds", 50.0, 1.0, 2.0, 50.0, 120.0);
        this.rm("book", "book", 25.0, 1.0, 2.0, 25.0, 120.0);
        this.rm("bowl", "bowl", 30.0, 1.0, 1.0, 30.0, 120.0);
        this.rm("redstone", "redstone", 30.0, 1.0, 2.0, 30.0, 120.0);
        this.rm("redstone_torch", "redstone_torch", 40.0, 1.0, 2.0, 40.0, 120.0);
        this.rm("coal", "coal", 50.0, 1.0, 5.0, 50.0, 120.0);
        this.rm("iron_ingot2", "iron_ingot", 20.0, 2.0, 7.0, 20.0, 120.0);
        this.rm("bow", "bow", 25.0, 1.0, 1.0, 25.0, 120.0);
        this.rm("clay", "clay", 15.0, 1.0, 3.0, 15.0, 120.0);
        this.rm("bucket", "bucket", 50.0, 1.0, 1.0, 50.0, 120.0);
        this.rm("slime_ball", "slime_ball", 35.0, 1.0, 3.0, 35.0, 120.0);
        this.rm("lead", "lead", 35.0, 1.0, 3.0, 35.0, 120.0);
        this.rm("fermented_spider_eye", "fermented_spider_eye", 25.0, 1.0, 3.0, 25.0, 120.0);
        this.rm("iron_chestplate", "iron_chestplate", 12.5, 1.0, 1.0, 12.5, 122.0);
        this.rm("iron_leggings", "iron_leggings", 20.0, 1.0, 1.0, 20.0, 123.0);
        this.rm("iron_boots", "iron_boots", 20.0, 1.0, 1.0, 20.0, 124.0);
        this.rm("iron_helmet", "iron_helmet", 20.0, 1.0, 1.0, 20.0, 125.0);
        this.rm("shield", "shield", 20.0, 1.0, 1.0, 20.0, 122.0);
        this.rm("iron_sword", "iron_sword", 35.0, 1.0, 1.0, 35.0, 121.0);
        this.rm("iron_pickaxe", "iron_pickaxe", 25.0, 1.0, 1.0, 25.0, 121.0);
        this.rm("iron_axe", "iron_axe", 25.0, 1.0, 1.0, 25.0, 121.0);
        this.rm("gold_sword", "gold_sword", 25.0, 1.0, 1.0, 25.0, 121.0);
        this.rm("tnt", "tnt", 35.0, 1.0, 2.0, 35.0, 25.0);
        this.rm("blaze_powder", "blaze_powder", 25.0, 2.0, 5.0, 25.0, 25.0);
        this.rm("magma_cream", "magma_cream", 25.0, 2.0, 5.0, 25.0, 25.0);
        this.rm("clock", "clock", 25.0, 1.0, 1.0, 25.0, 25.0);
        this.rm("compass", "compass", 25.0, 1.0, 1.0, 25.0, 25.0);
        this.rm("diamond_block", "diamond_block", 10.0, 1.0, 1.0, 10.0, 25.0);
        this.rm("glowstone", "glowstone", 25.0, 1.0, 5.0, 25.0, 25.0);
        this.rm("ender_pearl", "ender_pearl", 35.0, 1.0, 3.0, 35.0, 25.0);
        this.rm("ender_eye", "ender_eye", 25.0, 1.0, 2.0, 25.0, 25.0);
        this.rm("blaze_rod", "blaze_rod", 25.0, 1.0, 3.0, 25.0, 25.0);
        this.rm("ghast_tear", "ghast_tear", 25.0, 1.0, 2.0, 25.0, 25.0);
        this.rm("diamond", "diamond", 25.0, 1.0, 3.0, 25.0, 25.0);
        this.rm("prismarine_crystals", "prismarine_crystals", 20.0, 1.0, 3.0, 20.0, 25.0);
        this.rm("prismarine_shard", "prismarine_shard", 20.0, 1.0, 3.0, 20.0, 25.0);
        this.rm("sea_lantern", "sea_lantern", 20.0, 1.0, 1.0, 20.0, 25.0);
        this.rm("nether_star", "nether_star", 15.0, 1.0, 1.0, 15.0, 25.0);
        this.rm("firework_charge", "firework_charge", 35.0, 1.0, 5.0, 35.0, 25.0);
        this.rm("rabbit_foot", "rabbit_foot", 25.0, 1.0, 1.0, 25.0, 50.0);
        this.rm("potato", "potato", 35.0, 1.0, 5.0, 35.0, 50.0);
        this.rm("cake", "cake", 35.0, 1.0, 1.0, 35.0, 50.0);
        this.rm("pumpkin_pie", "pumpkin_pie", 45.0, 1.0, 1.0, 45.0, 50.0);
        this.rm("speckled_melon", "speckled_melon", 15.0, 1.0, 1.0, 15.0, 50.0);
        this.rm("beetroot", "beetroot", 50.0, 1.0, 5.0, 50.0, 50.0);
        this.rm("beetroot_seeds", "beetroot_seeds", 50.0, 1.0, 3.0, 50.0, 50.0);
        this.rm("diamond_chestplate", "diamond_chestplate", 18.0, 1.0, 1.0, 18.0, 35.0);
        this.rm("diamond_leggings", "diamond_leggings", 22.0, 1.0, 1.0, 22.0, 35.0);
        this.rm("diamond_helmet", "diamond_helmet", 22.0, 1.0, 1.0, 22.0, 35.0);
        this.rm("diamond_boots", "diamond_boots", 22.0, 1.0, 1.0, 22.0, 35.0);
        this.rm("iron_horse_armor", "iron_horse_armor", 18.0, 1.0, 1.0, 18.0, 35.0);
        this.rm("gold_horse_armor", "gold_horse_armor", 20.0, 1.0, 1.0, 18.0, 35.0);
        this.rm("iron_chestplate_e1", "iron_chestplate", 18.0, 1.0, 1.0, 18.0, 35.0, 1.0, 2.0);
        this.rm("iron_leggings_e1", "iron_leggings", 22.0, 1.0, 1.0, 22.0, 35.0, 1.0, 2.0);
        this.rm("iron_helmet_e1", "iron_helmet", 22.0, 1.0, 1.0, 22.0, 35.0, 1.0, 2.0);
        this.rm("iron_boots_e1", "iron_boots", 22.0, 1.0, 1.0, 22.0, 35.0, 1.0, 2.0);
        this.rm("diamond_pickaxe", "diamond_pickaxe", 25.0, 1.0, 1.0, 25.0, 45.0);
        this.rm("diamond_sword", "diamond_sword", 25.0, 1.0, 1.0, 25.0, 45.0);
        this.rm("shulker_box", "shulker_box", 30.0, 1.0, 1.0, 15.0, 0.0);
        this.rm("shulker_shell", "shulker_shell", 35.0, 1.0, 1.0, 20.0, 0.0);
        this.rm("dragon_breath", "dragon_breath", 30.0, 1.0, 1.0, 15.0, 0.0);
        this.rm("elytra", "elytra", 15.0, 1.0, 1.0, 10.0, 0.0);
        this.rm("totem_of_undying", "totem_of_undying", 15.0, 1.0, 1.0, 10.0, 0.0);
        this.rm("experience_bottle", "experience_bottle", 75.0, 1.0, 3.0, 75.0, 0.0);
        this.rm("emerald", "emerald", 45.0, 1.0, 3.0, 50.0, 0.0);
        this.rm("end_crystal", "end_crystal", 25.0, 1.0, 2.0, 25.0, 0.0);
        this.rm("chorus_fruit_popped", "chorus_fruit_popped", 35.0, 1.0, 3.0, 25.0, 0.0);
        this.rm("golden_apple", "golden_apple", 25.0, 1.0, 2.0, 35.0, 1.0);
        this.rm("golden_carrot", "golden_carrot", 35.0, 1.0, 2.0, 35.0, 1.0);
        this.rm("diamond_chestplate_e1", "diamond_chestplate", 35.0, 1.0, 1.0, 18.0, 50.0, 1.0, 2.0);
        this.rm("diamond_leggings_e1", "diamond_leggings", 35.0, 1.0, 1.0, 22.0, 50.0, 1.0, 2.0);
        this.rm("diamond_helmet_e1", "diamond_helmet", 35.0, 1.0, 1.0, 22.0, 50.0, 1.0, 2.0);
        this.rm("diamond_boots_e1", "diamond_boots", 35.0, 1.0, 1.0, 22.0, 50.0, 1.0, 2.0);
        this.rm("iron_chestplate_e2", "iron_chestplate", 35.0, 1.0, 1.0, 35.0, 1.0, 2.0, 3.0);
        this.rm("iron_leggings_e2", "iron_leggings", 35.0, 1.0, 1.0, 35.0, 1.0, 2.0, 3.0);
        this.rm("iron_helmet_e2", "iron_helmet", 35.0, 1.0, 1.0, 35.0, 1.0, 2.0, 3.0);
        this.rm("iron_boots_e2", "iron_boots", 35.0, 1.0, 1.0, 35.0, 1.0, 2.0, 3.0);
        this.rm("diamond_horse_armor", "diamond_horse_armor", 25.0, 1.0, 1.0, 25.0, 0.0);
        this.rm("record_13", "record_13", 25.0, 1.0, 1.0, 10.0, 4.0);
        this.rm("record_cat", "record_cat", 25.0, 1.0, 1.0, 10.0, 4.0);
        this.rm("record_blocks", "record_blocks", 25.0, 1.0, 1.0, 10.0, 4.0);
        this.rm("record_chirp", "record_chirp", 25.0, 1.0, 1.0, 10.0, 4.0);
        this.rm("record_far", "record_far", 25.0, 1.0, 1.0, 10.0, 4.0);
        this.rm("record_mall", "record_mall", 25.0, 1.0, 1.0, 10.0, 4.0);
        this.rm("record_mellohi", "record_mellohi", 25.0, 1.0, 1.0, 10.0, 4.0);
        this.rm("record_stal", "record_stal", 25.0, 1.0, 1.0, 10.0, 4.0);
        this.rm("record_strad", "record_strad", 25.0, 1.0, 1.0, 10.0, 4.0);
        this.rm("record_ward", "record_ward", 25.0, 1.0, 1.0, 10.0, 4.0);
        this.rm("record_11", "record_11", 25.0, 1.0, 1.0, 10.0, 4.0);
        this.rm("record_wait", "record_wait", 25.0, 1.0, 1.0, 10.0, 4.0);
    }

    private void rm(String id, String ref, double chance, double min, double max, double weight, double order) {
        RandomItem ri = new RandomItem();
        ri.setRef(this.itemMap.get(ref));
        ri.setChance(chance);
        ri.setQuantity(new Quantity(min, max));
        ri.setWeight(weight);
        ri.setOrder(order);
        this.randomItemMap.put(id, ri);
    }

    private void rm(String id, String ref, double chance, double min, double max, double weight, double order, double eMin, double eMax) {
        RandomItem ri = new RandomItem();
        ri.setRef(this.itemMap.get(ref));
        ri.setChance(chance);
        ri.setQuantity(new Quantity(min, max));
        ri.setWeight(weight);
        ri.setOrder(order);
        Enchants e = new Enchants();
        e.setQuantity(new Quantity(eMin, eMax));
        ri.setEnchants(e);
        this.randomItemMap.put(id, ri);
    }

    private void buildItemGroups() {
        this.ig("common_items", "bread");
        this.ig("common_items", "wool");
        this.ig("common_items", "torch");
        this.ig("common_items", "leather");
        this.ig("common_items", "rabbit_hide");
        this.ig("common_items", "gold_nugget");
        this.ig("common_items", "iron_ingot");
        this.ig("common_items", "arrow");
        this.ig("common_items", "dye0");
        this.ig("common_items", "bone");
        this.ig("common_items", "spider_eye");
        this.ig("common_items", "rotten_flesh");
        this.ig("common_items", "string");
        this.ig("common_armor", "leather_chestplate");
        this.ig("common_armor", "leather_leggings");
        this.ig("common_armor", "leather_arms");
        this.ig("common_armor", "leather_helmet");
        this.ig("common_armor", "leather_boots");
        this.ig("common_tools", "stone_sword");
        this.ig("common_tools", "stone_pickaxe");
        this.ig("common_tools", "stone_axe");
        this.ig("common_food", "apple");
        this.ig("common_food", "wheat");
        this.ig("common_food", "wheat_seeds");
        this.ig("common_food", "sugar");
        this.ig("common_food", "brown_mushroom");
        this.ig("common_food", "red_mushroom");
        this.ig("common_food", "carrot");
        this.ig("common_food", "porkchop");
        this.ig("common_food", "rabbit");
        this.ig("common_food", "egg");
        this.ig("common_food", "chicken");
        this.ig("common_food", "fish0");
        this.ig("common_food", "fish1");
        this.ig("common_food", "beef");
        this.ig("common_food", "cookie");
        this.ig("common_food", "pumpkin");
        this.ig("common_food", "pumpkin_seeds");
        this.ig("common_food", "melon");
        this.ig("common_food", "melon_seeds");
        this.ig("common_food", "mutton");
        this.ig("common_food", "cocoa");
        this.ig("uncommon_items", "spectral_arrow");
        this.ig("uncommon_items", "iron_ingot2");
        this.ig("uncommon_items", "paper");
        this.ig("uncommon_items", "reeds");
        this.ig("uncommon_items", "book");
        this.ig("uncommon_items", "bowl");
        this.ig("uncommon_items", "redstone");
        this.ig("uncommon_items", "redstone_torch");
        this.ig("uncommon_items", "coal");
        this.ig("uncommon_items", "bow");
        this.ig("uncommon_items", "clay");
        this.ig("uncommon_items", "bucket");
        this.ig("uncommon_items", "slime_ball");
        this.ig("uncommon_items", "lead");
        this.ig("uncommon_items", "fermented_spider_eye");
        this.ig("uncommon_armor", "iron_chestplate");
        this.ig("uncommon_armor", "iron_leggings");
        this.ig("uncommon_armor", "iron_boots");
        this.ig("uncommon_armor", "iron_helmet");
        this.ig("uncommon_armor", "shield");
        this.ig("uncommon_tools", "iron_sword");
        this.ig("uncommon_tools", "iron_pickaxe");
        this.ig("uncommon_tools", "iron_axe");
        this.ig("uncommon_tools", "gold_sword");
        this.ig("rare_items", "tnt");
        this.ig("rare_items", "blaze_powder");
        this.ig("rare_items", "magma_cream");
        this.ig("rare_items", "clock");
        this.ig("rare_items", "compass");
        this.ig("rare_items", "diamond_block");
        this.ig("rare_items", "glowstone");
        this.ig("rare_items", "ender_pearl");
        this.ig("rare_items", "ender_pearl");
        this.ig("rare_items", "blaze_rod");
        this.ig("rare_items", "ghast_tear");
        this.ig("rare_items", "experience_bottle");
        this.ig("rare_items", "diamond");
        this.ig("rare_items", "prismarine_crystals");
        this.ig("rare_items", "prismarine_shard");
        this.ig("rare_items", "sea_lantern");
        this.ig("rare_items", "nether_star");
        this.ig("rare_items", "firework_charge");
        this.ig("rare_armor", "diamond_chestplate");
        this.ig("rare_armor", "diamond_leggings");
        this.ig("rare_armor", "diamond_helmet");
        this.ig("rare_armor", "diamond_boots");
        this.ig("rare_armor", "iron_chestplate_e1");
        this.ig("rare_armor", "iron_leggings_e1");
        this.ig("rare_armor", "iron_helmet_e1");
        this.ig("rare_armor", "iron_boots_e1");
        this.ig("rare_armor", "iron_horse_armor");
        this.ig("rare_armor", "gold_horse_armor");
        this.ig("rare_tools", "diamond_pickaxe");
        this.ig("rare_tools", "diamond_sword");
        this.ig("rare_food", "rabbit_foot");
        this.ig("rare_food", "potato");
        this.ig("rare_food", "cake");
        this.ig("rare_food", "pumpkin_pie");
        this.ig("rare_food", "speckled_melon");
        this.ig("rare_food", "beetroot");
        this.ig("rare_food", "beetroot_seeds");
        this.ig("epic_items", "shulker_box");
        this.ig("epic_items", "shulker_shell");
        this.ig("epic_items", "dragon_breath");
        this.ig("epic_items", "elytra");
        this.ig("epic_items", "totem_of_undying");
        this.ig("epic_items", "experience_bottle");
        this.ig("epic_items", "emerald");
        this.ig("epic_items", "end_crystal");
        this.ig("epic_items", "chorus_fruit_popped");
        this.ig("epic_records", "record_13");
        this.ig("epic_records", "record_cat");
        this.ig("epic_records", "record_blocks");
        this.ig("epic_records", "record_chirp");
        this.ig("epic_records", "record_far");
        this.ig("epic_records", "record_mall");
        this.ig("epic_records", "record_mellohi");
        this.ig("epic_records", "record_stal");
        this.ig("epic_records", "record_strad");
        this.ig("epic_records", "record_ward");
        this.ig("epic_records", "record_11");
        this.ig("epic_records", "record_wait");
        this.ig("epic_food", "golden_apple");
        this.ig("epic_food", "golden_carrot");
        this.ig("epic_armor", "diamond_chestplate_e1");
        this.ig("epic_armor", "diamond_leggings_e1");
        this.ig("epic_armor", "diamond_helmet_e1");
        this.ig("epic_armor", "diamond_boots_e1");
        this.ig("epic_armor", "iron_chestplate_e2");
        this.ig("epic_armor", "iron_leggings_e2");
        this.ig("epic_armor", "iron_helmet_e2");
        this.ig("epic_armor", "iron_boots_e2");
        this.ig("epic_armor", "diamond_horse_armor");
    }

    private void ig(String group, String randomItemRef) {
        ChestItemGroup g = this.chestSheet.getGroups().get(group);
        if (g == null) {
            g = new ChestItemGroup(group);
            this.chestSheet.getGroups().put(group, g);
        }
        g.getItems().add(this.randomItemMap.get(randomItemRef));
    }

    private void buildRandomGroups() {
        this.rg("rg_common", "common_items", 3.0, 5.0, 1.0, 100.0);
        this.rg("rg_common_x2", "common_items", 3.0, 5.0, 2.0, 1.2, 100.0);
        this.rg("rg_common_x3", "common_items", 3.0, 5.0, 3.0, 1.3, 100.0);
        this.rg("rg_common_armor", "common_armor", 1.0, 2.0, 1.0, 110.0);
        this.rg("rg_common_tools", "common_tools", 1.0, 2.0, 1.0, 110.0);
        this.rg("rg_common_food", "common_food", 1.0, 3.0, 1.0, 120.0);
        this.rg("rg_common_food_x2", "common_food", 1.0, 3.0, 2.0, 1.2, 120.0);
        this.rg("rg_common_food_x3", "common_food", 1.0, 3.0, 3.0, 1.3, 120.0);
        this.rg("rg_uncommon", "uncommon_items", 2.0, 4.0, 1.0, 50.0);
        this.rg("rg_uncommon_x2", "uncommon_items", 2.0, 5.0, 2.0, 1.2, 50.0);
        this.rg("rg_uncommon_x3", "uncommon_items", 3.0, 5.0, 3.0, 1.3, 50.0);
        this.rg("rg_uncommon_tools", "uncommon_tools", 1.0, 2.0, 1.0, 60.0);
        this.rg("rg_uncommon_armor", "uncommon_armor", 1.0, 2.0, 1.0, 70.0);
        this.rg("rg_rare", "rare_items", 2.0, 4.0, 1.0, 10.0);
        this.rg("rg_rare_x2", "rare_items", 2.0, 4.0, 2.0, 1.2, 10.0);
        this.rg("rg_rare_x3", "rare_items", 1.0, 3.0, 3.0, 1.3, 10.0);
        this.rg("rg_rare_armor", "rare_armor", 1.0, 1.0, 1.0, 11.0);
        this.rg("rg_rare_food", "rare_food", 2.0, 4.0, 1.0, 12.0);
        this.rg("rg_rare_tools", "rare_tools", 1.0, 1.0, 1.0, 13.0);
        this.rg("rg_epic", "epic_items", 3.0, 5.0, 1.0, 0.0);
        this.rg("rg_epic_records", "epic_records", 1.0, 1.0, 1.0, 0.0);
        this.rg("rg_epic_food", "epic_food", 2.0, 2.0, 1.0, 0.0);
        this.rg("rg_epic_armor", "epic_armor", 2.0, 3.0, 1.0, 0.0);
    }

    private void rg(String id, String groupRef, double min, double max, double itemFactor, double order) {
        RandomGroup group = new RandomGroup();
        group.setRef(groupRef);
        group.setQuantity(new Quantity(min, max));
        group.setItemsFactor(itemFactor);
        group.setOrder(order);
        this.randomGroupMap.put(id, group);
    }

    private void rg(String id, String groupRef, double min, double max, double itemFactor, double chanceFactor, double order) {
        RandomGroup group = new RandomGroup();
        group.setRef(groupRef);
        group.setQuantity(new Quantity(min, max));
        group.setItemsFactor(itemFactor);
        group.setChanceFactor(chanceFactor);
        group.setOrder(order);
        this.randomGroupMap.put(id, group);
    }

    private void buildContainers() {
        this.c("common_chest", "common", 50.0);
        this.cg("common_chest", "rg_common");
        this.cg("common_chest", "rg_common_armor");
        this.cg("common_chest", "rg_common_food");
        this.cg("common_chest", "rg_common_tools");
        this.c("common_chest2", "common", 50.0);
        this.cg("common_chest2", "rg_common_x2");
        this.cg("common_chest2", "rg_common_armor");
        this.cg("common_chest2", "rg_common_food_x2");
        this.cg("common_chest2", "rg_common_tools");
        this.c("common_chest3", "common", 50.0);
        this.cg("common_chest3", "rg_common_x3");
        this.cg("common_chest3", "rg_common_armor");
        this.cg("common_chest3", "rg_common_food_x3");
        this.cg("common_chest3", "rg_common_tools");
        this.c("uncommon_chest", "uncommon", 35.0);
        this.cg("uncommon_chest", "rg_uncommon");
        this.cg("uncommon_chest", "rg_common_armor");
        this.cg("uncommon_chest", "rg_common_tools");
        this.cg("uncommon_chest", "rg_common");
        this.cg("uncommon_chest", "rg_common_food");
        this.c("uncommon_chest2", "uncommon", 35.0);
        this.cg("uncommon_chest2", "rg_uncommon_x2");
        this.cg("uncommon_chest2", "rg_common_armor");
        this.cg("uncommon_chest2", "rg_common_tools");
        this.cg("uncommon_chest2", "rg_common");
        this.cg("uncommon_chest2", "rg_common_food");
        this.c("uncommon_chest3", "uncommon", 35.0);
        this.cg("uncommon_chest3", "rg_uncommon_x3");
        this.cg("uncommon_chest3", "rg_common_armor");
        this.cg("uncommon_chest3", "rg_common_tools");
        this.cg("uncommon_chest3", "rg_common");
        this.cg("uncommon_chest3", "rg_common_food");
        this.c("rare_chest", "rare", 50.0);
        this.cg("rare_chest", "rg_rare");
        this.cg("rare_chest", "rg_rare_armor");
        this.cg("rare_chest", "rg_rare_food");
        this.cg("rare_chest", "rg_rare_tools");
        this.cg("rare_chest", "rg_uncommon_x2");
        this.cg("rare_chest", "rg_common_x3");
        this.c("epic_chest", "epic");
        this.cg("epic_chest", "rg_epic");
        this.cg("epic_chest", "rg_epic_food");
        this.cg("epic_chest", "rg_epic_armor");
        this.cg("epic_chest", "rg_epic_records");
        this.cg("epic_chest", "rg_rare_x3");
        this.cg("epic_chest", "rg_rare_x2");
        this.cg("epic_chest", "rg_rare");
        this.cg("epic_chest", "rg_rare_armor");
        this.cg("epic_chest", "rg_rare_food");
        this.cg("epic_chest", "rg_rare_tools");
    }

    private void c(String name, String category) {
        ChestContainer container = new ChestContainer();
        container.setName(name);
        container.setCategory(category);
        container.setWeight(0.0);
        this.chestSheet.getContainers().put(name, container);
    }

    private void c(String name, String category, Double weight) {
        ChestContainer container = new ChestContainer();
        container.setName(name);
        container.setCategory(category);
        container.setWeight(weight);
        this.chestSheet.getContainers().put(name, container);
    }

    private void cg(String name, String groupRef) {
        this.chestSheet.getContainers().get(name).getRandomGroups().add(this.randomGroupMap.get(groupRef));
    }

    private void ci(String name, String itemRef) {
        this.chestSheet.getContainers().get(name).getRandomItems().add(this.randomItemMap.get(itemRef));
    }
}

