/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.builder;

import jaredbgreat.dldungeons.api.DLDEvent;
import jaredbgreat.dldungeons.builder.AbstractBlock;
import jaredbgreat.dldungeons.builder.BlockFamily;
import jaredbgreat.dldungeons.builder.DBlock;
import jaredbgreat.dldungeons.builder.IBlockPlacer;
import jaredbgreat.dldungeons.debug.Logging;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class RegisteredBlock
extends AbstractBlock {
    private final String id;
    private final IBlockPlacer block;
    public static final Block quartz = Blocks.field_150371_ca;
    public static final Block lapis = Blocks.field_150368_y;
    public static final Block water = Blocks.field_150355_j;
    public static final Block air = Blocks.field_150350_a;
    public static final ArrayList<RegisteredBlock> registry = new ArrayList();

    private static Item getItem(String in) {
        return (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(in));
    }

    private RegisteredBlock(String id) throws NoSuchElementException {
        this.id = id;
        this.block = DBlock.makeDBlock(id);
        if (this.block.toString().contains("minecraft:air") && !id.contains("minecraft:air")) {
            String error = "[DLDUNGEONS] ERROR! Block read as \"" + id + "\" parsed into an air block!";
            Logging.logError(error);
            throw new NoSuchElementException(error);
        }
    }

    private RegisteredBlock(BlockFamily family) throws NoSuchElementException {
        this.id = family.getName();
        this.block = family;
    }

    public static void place(World world, int x, int y, int z, int block) {
        if (!RegisteredBlock.isProtectedBlock(world, x, y, z)) {
            registry.get(block).place(world, x, y, z);
        }
    }

    public static int add(String id) throws NoSuchElementException {
        if (id.startsWith("$")) {
            return RegisteredBlock.add(BlockFamily.getBlockFamily(id));
        }
        RegisteredBlock block = new RegisteredBlock(id);
        if (!registry.contains(block)) {
            registry.add(block);
        }
        return registry.indexOf(block);
    }

    public static int add(BlockFamily family) throws NoSuchElementException {
        RegisteredBlock blocks = new RegisteredBlock(family);
        if (!registry.contains(blocks)) {
            registry.add(blocks);
        }
        return registry.indexOf(blocks);
    }

    public static RegisteredBlock get(int id) throws NoSuchElementException {
        return registry.get(id);
    }

    public static IBlockPlacer getPlacer(int id) throws NoSuchElementException {
        return registry.get(id);
    }

    public static boolean placeBlock(World world, int x, int y, int z, Block block) {
        if (RegisteredBlock.isProtectedBlock(world, x, y, z)) {
            return false;
        }
        BlockPos pos = new BlockPos(x, y, z);
        if (MinecraftForge.TERRAIN_GEN_BUS.post((Event)new DLDEvent.PlaceBlock(world, pos, block))) {
            return false;
        }
        world.func_175656_a(pos, block.func_176223_P());
        return true;
    }

    public static void placeBlock(World world, int x, int y, int z, Block block, int a, int b) {
        if (RegisteredBlock.isProtectedBlock(world, x, y, z)) {
            return;
        }
        world.func_175656_a(new BlockPos(x, y, z), block.func_176203_a(a));
    }

    public static void deleteBlock(World world, int x, int y, int z) {
        if (RegisteredBlock.isProtectedBlock(world, x, y, z)) {
            return;
        }
        world.func_175698_g(new BlockPos(x, y, z));
    }

    public static void deleteBlock(World world, int x, int y, int z, boolean flooded) {
        if (RegisteredBlock.isProtectedBlock(world, x, y, z)) {
            return;
        }
        if (flooded) {
            RegisteredBlock.placeBlock(world, x, y, z, water);
        } else {
            world.func_175698_g(new BlockPos(x, y, z));
        }
    }

    public static void deleteBlock(World world, int x, int y, int z, int block) {
        if (RegisteredBlock.isProtectedBlock(world, x, y, z)) {
            return;
        }
        if (block > 0) {
            registry.get(block).place(world, x, y, z);
        } else {
            world.func_175698_g(new BlockPos(x, y, z));
        }
    }

    public static void placeChest(World world, int x, int y, int z) {
        RegisteredBlock.placeBlock(world, x, y, z, chest);
    }

    public static void placeSpawner(World world, int x, int y, int z, String mob) {
        BlockPos pos = new BlockPos(x, y, z);
        if (MinecraftForge.TERRAIN_GEN_BUS.post((Event)new DLDEvent.BeforePlaceSpawner(world, pos, mob))) {
            return;
        }
        if (RegisteredBlock.isProtectedBlock(world, x, y, z)) {
            return;
        }
        if (!RegisteredBlock.placeBlock(world, x, y, z, spawner)) {
            return;
        }
        TileEntityMobSpawner theSpawner = (TileEntityMobSpawner)world.func_175625_s(pos);
        MobSpawnerBaseLogic logic = theSpawner.func_145881_a();
        NBTTagCompound spawnData = new NBTTagCompound();
        spawnData.func_74778_a("id", mob);
        logic.func_184993_a(new WeightedSpawnerEntity(1, spawnData));
    }

    public static boolean isGroundBlock(World world, int x, int y, int z) {
        IBlockState bs = world.func_180495_p(new BlockPos(x, y, z));
        Material mat = bs.func_185904_a();
        return mat == Material.field_151577_b || mat == Material.field_151573_f || mat == Material.field_151578_c || mat == Material.field_151595_p || mat == Material.field_151576_e || mat == Material.field_151571_B || y < 0;
    }

    public boolean equals(Object other) {
        if (!(other instanceof RegisteredBlock)) {
            return false;
        }
        return this.block.equals(((RegisteredBlock)other).block);
    }

    public int hashCode() {
        return this.block.hashCode();
    }

    @Override
    public void placeNoMeta(World world, int x, int y, int z) {
        this.block.placeNoMeta(world, x, y, z);
    }

    @Override
    public void place(World world, int x, int y, int z) {
        this.block.place(world, x, y, z);
    }

    @Override
    public Object getContents() {
        return this.block;
    }
}

