/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import jaredbgreat.dldungeons.builder.IBlockPlacer;
import jaredbgreat.dldungeons.builder.RegisteredBlock;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.world.World;

public class BlockFamily
implements IBlockPlacer {
    private static final Map<String, BlockFamily> FAMILIES = new HashMap<String, BlockFamily>();
    private final String name;
    private final IBlockPlacer[] blocks;
    private static Random random;

    private BlockFamily(String name, List<IBlockPlacer> theBlocks) {
        this.name = name;
        this.blocks = theBlocks.toArray(new IBlockPlacer[theBlocks.size()]);
        random = new Random();
    }

    public static void setRadnom(Random r) {
        random = r;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void placeNoMeta(World world, int x, int y, int z) {
        this.blocks[random.nextInt(this.blocks.length)].placeNoMeta(world, x, y, z);
    }

    @Override
    public void place(World world, int x, int y, int z) {
        this.blocks[random.nextInt(this.blocks.length)].place(world, x, y, z);
    }

    public boolean equals(Object other) {
        if (!(other instanceof BlockFamily)) {
            return false;
        }
        return this.name.equals(((BlockFamily)other).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static BlockFamily makeBlockFamily(String json) {
        JsonParser parser = new JsonParser();
        JsonObject data = parser.parse(json).getAsJsonObject();
        final LinkedList<IBlockPlacer> blocks = new LinkedList<IBlockPlacer>();
        if (!data.has("name")) {
            throw new RuntimeException("DLDungeonsJBG tried to load BlockFamily with no Name!");
        }
        String name = "$" + data.get("name").getAsString();
        if (!data.has("blocks")) {
            throw new RuntimeException("DLDungeonsJBG tried to load BlockFamily with no blocks!");
        }
        data.get("blocks").getAsJsonArray().forEach((Consumer)new Consumer<JsonElement>(){

            @Override
            public void accept(JsonElement t) {
                int id = RegisteredBlock.add(t.getAsString());
                blocks.add(RegisteredBlock.getPlacer(id));
            }
        });
        if (blocks.isEmpty()) {
            throw new RuntimeException("DLDungeonsJBG tried to load BlockFamily empty block list!");
        }
        BlockFamily out = new BlockFamily(name, blocks);
        FAMILIES.put(name, out);
        return out;
    }

    public static BlockFamily getBlockFamily(String name) {
        return FAMILIES.get(name);
    }

    @Override
    public Object getContents() {
        return this.blocks;
    }
}

