/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.network.client;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.inferface.Talent;
import doggytalents.entity.EntityDog;
import doggytalents.network.AbstractMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;

public class DogTalentMessage
extends AbstractMessage.AbstractServerMessage {
    public int entityId;
    public ResourceLocation talentId;

    public DogTalentMessage() {
    }

    public DogTalentMessage(int entityId, ResourceLocation talentId) {
        this.entityId = entityId;
        this.talentId = talentId;
    }

    @Override
    public void read(PacketBuffer buf) {
        this.entityId = buf.readInt();
        this.talentId = buf.func_192575_l();
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.writeInt(this.entityId);
        buf.func_192572_a(this.talentId);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        Entity target = player.field_70170_p.func_73045_a(this.entityId);
        if (!(target instanceof EntityDog)) {
            return;
        }
        EntityDog dog = (EntityDog)target;
        if (!dog.canInteract((EntityLivingBase)player)) {
            return;
        }
        Talent talent = (Talent)DoggyTalentsAPI.TALENTS.getValue(this.talentId);
        int level = dog.TALENTS.getLevel(talent);
        if (level < talent.getHighestLevel(dog) && dog.spendablePoints() >= talent.getCost(dog, level + 1)) {
            dog.TALENTS.setLevel(talent, level + 1);
        }
    }
}

