/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import doggytalents.DoggyTalents;
import doggytalents.ModBlocks;
import doggytalents.ModItems;
import doggytalents.ModSerializers;
import doggytalents.ModTalents;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.feature.EnumGender;
import doggytalents.api.feature.EnumMode;
import doggytalents.api.feature.ICoordFeature;
import doggytalents.api.feature.IGenderFeature;
import doggytalents.api.feature.IHungerFeature;
import doggytalents.api.feature.ILevelFeature;
import doggytalents.api.feature.IModeFeature;
import doggytalents.api.feature.IStatsFeature;
import doggytalents.api.feature.ITalentFeature;
import doggytalents.api.inferface.IDogEntity;
import doggytalents.api.inferface.IDogItem;
import doggytalents.api.inferface.IThrowableItem;
import doggytalents.api.inferface.Talent;
import doggytalents.entity.ai.DogLocationManager;
import doggytalents.entity.ai.EntityAIBegDog;
import doggytalents.entity.ai.EntityAIBerserkerMode;
import doggytalents.entity.ai.EntityAIDogFeed;
import doggytalents.entity.ai.EntityAIDogWander;
import doggytalents.entity.ai.EntityAIExtinguishFire;
import doggytalents.entity.ai.EntityAIFetch;
import doggytalents.entity.ai.EntityAIFetchReturn;
import doggytalents.entity.ai.EntityAIFollowOwnerDog;
import doggytalents.entity.ai.EntityAIHurtByTargetDog;
import doggytalents.entity.ai.EntityAIIncapacitatedTargetDog;
import doggytalents.entity.ai.EntityAIOwnerHurtByTargetDog;
import doggytalents.entity.ai.EntityAIOwnerHurtTargetDog;
import doggytalents.entity.ai.EntityAIShepherdDog;
import doggytalents.entity.features.CoordFeature;
import doggytalents.entity.features.DogFeature;
import doggytalents.entity.features.DogStats;
import doggytalents.entity.features.GenderFeature;
import doggytalents.entity.features.HungerFeature;
import doggytalents.entity.features.LevelFeature;
import doggytalents.entity.features.ModeFeature;
import doggytalents.entity.features.TalentFeature;
import doggytalents.helper.DogUtil;
import doggytalents.helper.TalentHelper;
import doggytalents.inventory.InventoryTreatBag;
import doggytalents.item.ItemChewStick;
import doggytalents.item.ItemFancyCollar;
import doggytalents.lib.ConfigValues;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityDog
extends IDogEntity {
    private static final DataParameter<Float> DATA_HEALTH_ID = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Byte> DOG_TEXTURE = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> COLLAR_COLOUR = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> LEVEL = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> LEVEL_DIRE = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> DOG_FLAGS = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Map<Talent, Integer>> TALENTS_PARAM = EntityDataManager.func_187226_a(EntityDog.class, ModSerializers.TALENT_LEVEL_SERIALIZER);
    private static final DataParameter<Integer> HUNGER_PARAM = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<ItemStack> BONE_VARIANT = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Integer> CAPE = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<BlockPos>> BOWL_POS = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Optional<BlockPos>> BED_POS = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Byte> SIZE = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> GENDER_PARAM = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> MODE_PARAM = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Optional<ITextComponent>> LAST_KNOWN_NAME = EntityDataManager.func_187226_a(EntityDog.class, ModSerializers.OPTIONAL_TEXT_COMPONENT_SERIALIZER);
    public DogLocationManager locationManager;
    public TalentFeature TALENTS = new TalentFeature(this);
    public LevelFeature LEVELS = new LevelFeature(this);
    public ModeFeature MODE = new ModeFeature(this);
    public CoordFeature COORDS = new CoordFeature(this);
    public GenderFeature GENDER = new GenderFeature(this);
    public DogStats STATS = new DogStats(this);
    public HungerFeature HUNGER = new HungerFeature(this);
    private List<DogFeature> FEATURES = Arrays.asList(this.TALENTS, this.LEVELS, this.MODE, this.COORDS, this.GENDER, this.STATS, this.HUNGER);
    public Map<String, Object> objects;
    private float headRotationCourse;
    private float headRotationCourseOld;
    public boolean isWet;
    public boolean gotWetInWater;
    private boolean isShaking;
    private float timeDogIsShaking;
    private float prevTimeDogIsShaking;
    private float timeWolfIsHappy;
    private float prevTimeWolfIsHappy;
    private boolean isWolfHappy;
    public boolean hiyaMaster;
    private int reversionTime;
    private int hungerTick;
    private int prevHungerTick;
    private int healingTick;
    private int prevHealingTick;
    private int regenerationTick;
    private int prevRegenerationTick;
    public static final ResourceLocation DOG_LOOT_TABLE = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("doggytalents", "entities/dog"));
    protected boolean dogJumping;
    protected float jumpPower;

    public EntityDog(World world) {
        super(world);
        if (!this.field_70170_p.field_72995_K) {
            this.locationManager = DogLocationManager.getHandler(this.func_130014_f_());
        }
        this.objects = new HashMap<String, Object>();
        this.func_70105_a(0.6f, 0.85f);
        this.func_70903_f(false);
        this.setGender(this.func_70681_au().nextBoolean() ? EnumGender.MALE : EnumGender.FEMALE);
        TalentHelper.onClassCreation(this);
    }

    protected void func_184651_r() {
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIExtinguishFire((EntityCreature)this, 1.15, 16));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFetchReturn(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIDogWander(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIShepherdDog(this, 1.0, 8.0f, (Predicate<EntityAnimal>)((Predicate)entity -> !(entity instanceof EntityDog))));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIFetch(this, 1.0, 32.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIFollowOwnerDog(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(13, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(14, (EntityAIBase)new EntityAIBegDog(this, 8.0f));
        this.field_70714_bg.func_75776_a(15, (EntityAIBase)new EntityAIDogFeed(this, 1.0, 20.0f));
        this.field_70714_bg.func_75776_a(25, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(25, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIIncapacitatedTargetDog(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTargetDog(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTargetDog(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTargetDog(this, true));
        this.field_70715_bh.func_75776_a(4, new EntityAIBerserkerMode<EntityMob>(this, EntityMob.class, false));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
        this.field_70180_af.func_187214_a(DOG_FLAGS, (Object)0);
        this.field_70180_af.func_187214_a(DOG_TEXTURE, (Object)0);
        this.field_70180_af.func_187214_a(COLLAR_COLOUR, (Object)-2);
        this.field_70180_af.func_187214_a(TALENTS_PARAM, Collections.emptyMap());
        this.field_70180_af.func_187214_a(HUNGER_PARAM, (Object)60);
        this.field_70180_af.func_187214_a(BONE_VARIANT, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(MODE_PARAM, (Object)((byte)EnumMode.DOCILE.getIndex()));
        this.field_70180_af.func_187214_a(LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(LEVEL_DIRE, (Object)0);
        this.field_70180_af.func_187214_a(BOWL_POS, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(BED_POS, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(CAPE, (Object)-2);
        this.field_70180_af.func_187214_a(SIZE, (Object)3);
        this.field_70180_af.func_187214_a(GENDER_PARAM, (Object)((byte)EnumGender.UNISEX.getIndex()));
        this.field_70180_af.func_187214_a(LAST_KNOWN_NAME, (Object)Optional.absent());
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (SIZE.equals(key)) {
            this.func_98055_j((float)this.getDogSize() * 0.3f + 0.1f);
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.field_70180_af.func_187227_b(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.func_70909_n() ? 20.0 : 8.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    protected SoundEvent func_184639_G() {
        if (this.getDogHunger() <= ConfigValues.LOW_HUNGER && ConfigValues.DOG_WHINE_WHEN_HUNGER_LOW) {
            return SoundEvents.field_187871_gL;
        }
        if (this.field_70146_Z.nextInt(3) == 0) {
            return this.func_70909_n() && ((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue() < this.func_110138_aP() / 2.0f ? SoundEvents.field_187871_gL : SoundEvents.field_187865_gI;
        }
        return SoundEvents.field_187857_gE;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187863_gH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    @Override
    public float func_70599_aP() {
        return 0.4f;
    }

    protected ResourceLocation func_184647_J() {
        return DOG_LOOT_TABLE;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        this.FEATURES.forEach(f -> f.writeAdditional(compound));
        compound.func_74768_a("doggyTex", this.getTameSkin());
        compound.func_74768_a("collarColour", this.getCollarData());
        compound.func_74768_a("dogHunger", this.getDogHunger());
        compound.func_74757_a("willObey", this.willObeyOthers());
        compound.func_74757_a("friendlyFire", this.canPlayersAttack());
        compound.func_74757_a("radioCollar", this.hasRadarCollar());
        compound.func_74757_a("sunglasses", this.hasSunglasses());
        compound.func_74768_a("capeData", this.getCapeData());
        compound.func_74768_a("dogSize", this.getDogSize());
        compound.func_74757_a("hasBone", this.hasBone());
        if (this.hasBone()) {
            compound.func_74782_a("fetchItem", (NBTBase)this.getBoneVariant().func_77955_b(new NBTTagCompound()));
        }
        if (((Optional)this.field_70180_af.func_187225_a(LAST_KNOWN_NAME)).isPresent()) {
            compound.func_74778_a("lastKnownOwnerName", ITextComponent.Serializer.func_150696_a((ITextComponent)((ITextComponent)((Optional)this.field_70180_af.func_187225_a(LAST_KNOWN_NAME)).get())));
        }
        TalentHelper.writeAdditional(this, compound);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.FEATURES.forEach(f -> f.readAdditional(compound));
        this.setTameSkin(compound.func_74762_e("doggyTex"));
        if (compound.func_150297_b("collarColour", 99)) {
            this.setCollarData(compound.func_74762_e("collarColour"));
        }
        this.setDogHunger(compound.func_74762_e("dogHunger"));
        this.setWillObeyOthers(compound.func_74767_n("willObey"));
        this.setCanPlayersAttack(compound.func_74767_n("friendlyFire"));
        this.hasRadarCollar(compound.func_74767_n("radioCollar"));
        this.setHasSunglasses(compound.func_74767_n("sunglasses"));
        if (compound.func_150297_b("capeData", 99)) {
            this.setCapeData(compound.func_74762_e("capeData"));
        }
        if (compound.func_150297_b("dogSize", 99)) {
            this.setDogSize(compound.func_74762_e("dogSize"));
        }
        if (compound.func_150297_b("fetchItem", 10)) {
            this.setBoneVariant(new ItemStack(compound.func_74775_l("fetchItem")));
        }
        if (compound.func_150297_b("lastKnownOwnerName", 8)) {
            this.field_70180_af.func_187227_b(LAST_KNOWN_NAME, (Object)Optional.of((Object)ITextComponent.Serializer.func_150699_a((String)compound.func_74779_i("lastKnownOwnerName"))));
        }
        TalentHelper.readAdditional(this, compound);
        if (compound.func_74764_b("dogName")) {
            this.func_96094_a(compound.func_74779_i("dogName"));
        }
        if (compound.func_74767_n("hasBone")) {
            int variant = compound.func_74762_e("boneVariant");
            if (variant == 0) {
                this.setBoneVariant(new ItemStack(ModItems.THROW_BONE));
            } else if (variant == 1) {
                this.setBoneVariant(new ItemStack(ModItems.THROW_STICK));
            }
        }
    }

    public EntityAISit getSitAI() {
        return this.field_70911_d;
    }

    public void func_70636_d() {
        Entity entityRidden;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.isWet && !this.isShaking && !this.func_70781_l() && this.field_70122_E) {
            this.isShaking = true;
            this.timeDogIsShaking = 0.0f;
            this.prevTimeDogIsShaking = 0.0f;
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        }
        if (ConfigValues.IS_HUNGER_ON) {
            this.prevHungerTick = this.hungerTick++;
            if (this.func_184207_aI() || !this.func_70906_o()) {
                // empty if block
            }
            this.hungerTick += TalentHelper.hungerTick(this, this.hungerTick - this.prevHungerTick);
            if (this.hungerTick > 400) {
                this.setDogHunger(this.getDogHunger() - 1);
                this.hungerTick -= 400;
            }
        }
        if (ConfigValues.DOGS_IMMORTAL) {
            this.prevRegenerationTick = this.regenerationTick++;
            if (this.func_70906_o()) {
                this.regenerationTick += TalentHelper.regenerationTick(this, this.regenerationTick - this.prevRegenerationTick);
            } else if (!this.func_70906_o()) {
                this.regenerationTick = 0;
            }
            if (this.regenerationTick >= 2400 && this.isIncapacicated()) {
                this.func_70606_j(2.0f);
                this.setDogHunger(1);
            } else if (this.regenerationTick >= 2400 && !this.isIncapacicated() && this.regenerationTick >= 4400 && this.getDogHunger() < 60) {
                this.setDogHunger(this.getDogHunger() + 1);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                this.regenerationTick = 2400;
            }
        }
        if (this.func_110143_aJ() != (float)ConfigValues.LOW_HEATH_LEVEL) {
            this.prevHealingTick = this.healingTick;
            this.healingTick += this.nourishment();
            if (this.healingTick >= 6000) {
                if (this.func_110143_aJ() < this.func_110138_aP()) {
                    this.func_70606_j(this.func_110143_aJ() + 1.0f);
                }
                this.healingTick = 0;
            }
        }
        if (this.func_110143_aJ() <= 0.0f && this.isImmortal()) {
            this.field_70725_aQ = 0;
            this.func_70606_j(1.0f);
        }
        if (this.LEVELS.isDireDog() && ConfigValues.DIRE_PARTICLES) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
            }
        }
        if (this.reversionTime > 0) {
            --this.reversionTime;
        }
        if ((entityRidden = this.func_184187_bx()) instanceof EntityPlayer && entityRidden.func_70093_af()) {
            this.func_184210_p();
        }
        if (this.field_70173_aa % 50 == 0 && this.COORDS.hasBowlPos() && this.field_70170_p.func_175667_e(this.COORDS.getBowlPos()) && this.field_70170_p.func_180495_p(this.COORDS.getBowlPos()).func_177230_c() != ModBlocks.FOOD_BOWL) {
            this.COORDS.resetBowlPosition();
        }
        TalentHelper.livingTick(this);
    }

    public void func_70071_h_() {
        float distanceToOwner;
        EntityPlayer player;
        super.func_70071_h_();
        this.headRotationCourseOld = this.headRotationCourse;
        this.headRotationCourse = this.isBegging() ? (this.headRotationCourse += (1.0f - this.headRotationCourse) * 0.4f) : (this.headRotationCourse += (0.0f - this.headRotationCourse) * 0.4f);
        if (this.func_70026_G()) {
            this.isWet = true;
            this.isShaking = false;
            this.timeDogIsShaking = 0.0f;
            this.prevTimeDogIsShaking = 0.0f;
            this.gotWetInWater = this.func_70090_H();
        } else if ((this.isWet || this.isShaking) && this.isShaking) {
            if (this.timeDogIsShaking == 0.0f) {
                this.func_184185_a(SoundEvents.field_187867_gJ, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeDogIsShaking = this.timeDogIsShaking;
            this.timeDogIsShaking += 0.05f;
            if (this.prevTimeDogIsShaking >= 2.0f) {
                this.isWet = false;
                this.isShaking = false;
                this.prevTimeDogIsShaking = 0.0f;
                this.timeDogIsShaking = 0.0f;
                TalentHelper.onFinishShaking(this, this.gotWetInWater);
            }
            if (this.timeDogIsShaking > 0.4f) {
                float f = (float)this.func_174813_aQ().field_72338_b;
                int i = (int)(MathHelper.func_76126_a((float)((this.timeDogIsShaking - 0.4f) * (float)Math.PI)) * 7.0f);
                for (int j = 0; j < i; ++j) {
                    float f1 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    float f2 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, this.field_70165_t + (double)f1, (double)(f + 0.8f), this.field_70161_v + (double)f2, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
            }
        }
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.hiyaMaster = true;
        }
        if ((this.isBegging() || this.hiyaMaster) && !this.isWolfHappy) {
            this.isWolfHappy = true;
            this.timeWolfIsHappy = 0.0f;
            this.prevTimeWolfIsHappy = 0.0f;
        } else {
            this.hiyaMaster = false;
        }
        if (this.isWolfHappy) {
            if (this.timeWolfIsHappy % 1.0f == 0.0f) {
                this.func_184185_a(SoundEvents.field_187865_gI, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeWolfIsHappy = this.timeWolfIsHappy;
            this.timeWolfIsHappy += 0.05f;
            if (this.prevTimeWolfIsHappy >= 8.0f) {
                this.isWolfHappy = false;
                this.prevTimeWolfIsHappy = 0.0f;
                this.timeWolfIsHappy = 0.0f;
            }
        }
        if (this.func_70909_n() && (player = (EntityPlayer)this.func_70902_q()) != null && (distanceToOwner = player.func_70032_d((Entity)this)) <= 2.0f && this.hasBone() && !this.field_70170_p.field_72995_K) {
            IThrowableItem throwableItem = this.getThrowableItem();
            ItemStack fetchItem = throwableItem != null ? throwableItem.getReturnStack(this.getBoneVariant()) : this.getBoneVariant();
            this.func_70099_a(fetchItem, 0.0f);
            this.setBoneVariant(ItemStack.field_190927_a);
        }
        if (this.field_70173_aa % 40 == 0 && !this.field_70170_p.field_72995_K) {
            if (this.func_70089_S()) {
                this.locationManager.update(this);
            } else {
                this.locationManager.remove(this);
            }
            if (this.func_70902_q() != null) {
                this.field_70180_af.func_187227_b(LAST_KNOWN_NAME, (Object)Optional.fromNullable((Object)this.func_70902_q().func_145748_c_()));
            }
        }
        this.FEATURES.forEach(DogFeature::tick);
        TalentHelper.tick(this);
    }

    public boolean isControllingPassengerPlayer() {
        return this.func_184179_bs() instanceof EntityPlayer;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (!TalentHelper.isImmuneToFalls(this)) {
            super.func_180430_e(distance - (float)TalentHelper.fallProtection(this), damageMultiplier);
        }
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        Entity entity = damageSource.func_76346_g();
        if (!this.canPlayersAttack() && entity instanceof EntityPlayer) {
            return false;
        }
        if (!TalentHelper.attackEntityFrom(this, damageSource, damage)) {
            return false;
        }
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            damage = (damage + 1.0f) / 2.0f;
        }
        return super.func_70097_a(damageSource, damage);
    }

    public boolean func_70652_k(Entity entity) {
        boolean flag;
        if (!TalentHelper.shouldDamageMob(this, entity)) {
            return false;
        }
        int damage = 4 + (MathHelper.func_76128_c((double)this.effectiveLevel()) + 1) / 2;
        damage = TalentHelper.attackEntityAsMob(this, entity, damage);
        if (entity instanceof EntityZombie) {
            ((EntityZombie)entity).func_70624_b((EntityLivingBase)this);
        }
        if (flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)damage)) {
            this.STATS.increaseDamageDealt(damage);
            this.func_174815_a((EntityLivingBase)this, entity);
        }
        return flag;
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(tamed ? 20.0 : 8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 8) {
            this.isShaking = true;
            this.timeDogIsShaking = 0.0f;
            this.prevTimeDogIsShaking = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        EnumActionResult result = TalentHelper.interactWithPlayer(this, player, hand);
        switch (result) {
            case SUCCESS: {
                return true;
            }
            case FAIL: {
                return false;
            }
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == ModItems.OWNER_CHANGE && player.field_71075_bZ.field_75098_d && !this.func_152114_e((EntityLivingBase)player)) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70903_f(true);
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                this.field_70911_d.func_75270_a(true);
                this.func_184754_b(player.func_110124_au());
                this.func_70908_e(true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            }
            return true;
        }
        if (this.func_70909_n()) {
            if (!stack.func_190926_b()) {
                int foodValue = this.foodValue(stack);
                if (foodValue != 0 && this.getDogHunger() < ConfigValues.HUNGER_POINTS && this.canInteract((EntityLivingBase)player)) {
                    if (this.isIncapacicated()) {
                        if (!this.field_70170_p.field_72995_K) {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("dog.mode.incapacitated.help", new Object[]{this.func_145748_c_(), this.GENDER.getGenderPronoun()}));
                        }
                    } else {
                        this.func_175505_a(player, stack);
                        if (!this.field_70170_p.field_72995_K) {
                            this.setDogHunger(this.getDogHunger() + foodValue);
                            if (stack.func_77973_b() == ModItems.CHEW_STICK) {
                                ((ItemChewStick)ModItems.CHEW_STICK).addChewStickEffects(this);
                            }
                        }
                        this.func_70908_e(true);
                    }
                    return true;
                }
                if (stack.func_77973_b() == ModItems.DOGGY_CHARM && player.field_71075_bZ.field_75098_d) {
                    EntityDog babySpawn;
                    if (!this.field_70170_p.field_72995_K && (babySpawn = this.createChild((EntityAgeable)this)) != null) {
                        babySpawn.func_70873_a(-ConfigValues.TIME_TO_MATURE);
                        babySpawn.func_70903_f(true);
                        if (ConfigValues.PUPS_GET_PARENT_LEVELS) {
                            babySpawn.LEVELS.setLevel(Math.min(this.LEVELS.getLevel(), 20));
                        }
                        babySpawn.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
                        this.field_70170_p.func_72838_d((Entity)babySpawn);
                        this.func_175505_a(player, stack);
                    }
                    return true;
                }
                if (stack.func_77973_b() == Items.field_151055_y && this.canInteract((EntityLivingBase)player)) {
                    if (this.isIncapacicated()) {
                        if (!this.field_70170_p.field_72995_K) {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("dog.mode.incapacitated.help", new Object[]{this.func_145748_c_(), this.GENDER.getGenderPronoun()}));
                        }
                    } else {
                        player.openGui((Object)DoggyTalents.INSTANCE, 1, this.field_70170_p, this.func_145782_y(), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
                    }
                    return true;
                }
                if (stack.func_77973_b() == ModItems.RADIO_COLLAR && this.canInteract((EntityLivingBase)player) && !this.hasRadarCollar() && !this.isIncapacicated()) {
                    this.hasRadarCollar(true);
                    this.func_175505_a(player, stack);
                    return true;
                }
                if (stack.func_77973_b() == ModItems.WOOL_COLLAR && this.canInteract((EntityLivingBase)player) && !this.hasCollar() && !this.isIncapacicated()) {
                    int colour = -1;
                    if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("collar_colour", 99)) {
                        colour = stack.func_77978_p().func_74762_e("collar_colour");
                    }
                    this.setCollarData(colour);
                    this.func_175505_a(player, stack);
                    return true;
                }
                if (stack.func_77973_b() instanceof ItemFancyCollar && this.canInteract((EntityLivingBase)player) && !this.hasCollar() && !this.isIncapacicated()) {
                    this.setCollarData(-3 - ((ItemFancyCollar)stack.func_77973_b()).type.ordinal());
                    this.func_175505_a(player, stack);
                    return true;
                }
                if (stack.func_77973_b() == ModItems.CAPE && this.canInteract((EntityLivingBase)player) && !this.hasCape() && !this.isIncapacicated()) {
                    this.setFancyCape();
                    this.func_175505_a(player, stack);
                    return true;
                }
                if (stack.func_77973_b() == ModItems.LEATHER_JACKET && this.canInteract((EntityLivingBase)player) && !this.hasCape() && !this.isIncapacicated()) {
                    this.setLeatherJacket();
                    this.func_175505_a(player, stack);
                    return true;
                }
                if (stack.func_77973_b() == ModItems.CAPE_COLOURED && this.canInteract((EntityLivingBase)player) && !this.hasCape() && !this.isIncapacicated()) {
                    int colour = -1;
                    if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("cape_colour", 99)) {
                        colour = stack.func_77978_p().func_74762_e("cape_colour");
                    }
                    this.setCapeData(colour);
                    this.func_175505_a(player, stack);
                    return true;
                }
                if (stack.func_77973_b() == ModItems.SUNGLASSES && this.canInteract((EntityLivingBase)player) && !this.hasSunglasses() && !this.isIncapacicated()) {
                    this.setHasSunglasses(true);
                    this.func_175505_a(player, stack);
                    return true;
                }
                if (stack.func_77973_b() instanceof IDogItem && this.canInteract((EntityLivingBase)player) && !this.isIncapacicated()) {
                    IDogItem treat = (IDogItem)stack.func_77973_b();
                    EnumActionResult treatResult = treat.onInteractWithDog(this, this.field_70170_p, player, hand);
                    switch (treatResult) {
                        case SUCCESS: {
                            return true;
                        }
                        case FAIL: {
                            return false;
                        }
                    }
                } else {
                    if (stack.func_77973_b() == ModItems.COLLAR_SHEARS && this.canInteract((EntityLivingBase)player)) {
                        if (!this.field_70170_p.field_72995_K) {
                            if (this.hasCollar() || this.hasSunglasses() || this.hasCape()) {
                                this.reversionTime = 40;
                                if (this.hasCollarColoured()) {
                                    ItemStack collarDrop = new ItemStack(ModItems.WOOL_COLLAR, 1);
                                    if (this.isCollarColoured()) {
                                        collarDrop.func_77982_d(new NBTTagCompound());
                                        collarDrop.func_77978_p().func_74768_a("collar_colour", this.getCollarData());
                                    }
                                    this.func_70099_a(collarDrop, 1.0f);
                                    this.setNoCollar();
                                }
                                if (this.hasFancyCollar()) {
                                    Item drop = ModItems.MULTICOLOURED_COLLAR;
                                    if (this.getCollarData() == -3) {
                                        drop = ModItems.CREATIVE_COLLAR;
                                    } else if (this.getCollarData() == -4) {
                                        drop = ModItems.SPOTTED_COLLAR;
                                    }
                                    this.func_145779_a(drop, 1);
                                    this.setNoCollar();
                                }
                                if (this.hasFancyCape()) {
                                    this.func_70099_a(new ItemStack(ModItems.CAPE, 1), 1.0f);
                                    this.setNoCape();
                                }
                                if (this.hasCapeColoured()) {
                                    ItemStack capeDrop = new ItemStack(ModItems.CAPE_COLOURED, 1);
                                    if (this.isCapeColoured()) {
                                        capeDrop.func_77982_d(new NBTTagCompound());
                                        capeDrop.func_77978_p().func_74768_a("cape_colour", this.getCapeData());
                                    }
                                    this.func_70099_a(capeDrop, 1.0f);
                                    this.setNoCape();
                                }
                                if (this.hasLeatherJacket()) {
                                    this.func_70099_a(new ItemStack(ModItems.LEATHER_JACKET, 1), 1.0f);
                                    this.setNoCape();
                                }
                                if (this.hasSunglasses()) {
                                    this.func_70099_a(new ItemStack(ModItems.SUNGLASSES, 1), 1.0f);
                                    this.setHasSunglasses(false);
                                }
                            } else if (this.reversionTime < 1) {
                                this.func_70903_f(false);
                                this.field_70699_by.func_75499_g();
                                this.field_70911_d.func_75270_a(false);
                                this.func_70606_j(8.0f);
                                this.TALENTS.resetTalents();
                                this.func_184754_b(null);
                                this.field_70180_af.func_187227_b(LAST_KNOWN_NAME, (Object)Optional.absent());
                                this.setWillObeyOthers(false);
                                this.MODE.setMode(EnumMode.DOCILE);
                                if (this.hasRadarCollar()) {
                                    this.func_145779_a(ModItems.RADIO_COLLAR, 1);
                                }
                                this.hasRadarCollar(false);
                                this.reversionTime = 40;
                            }
                        }
                        return true;
                    }
                    if (stack.func_77973_b() == Items.field_151105_aU && this.canInteract((EntityLivingBase)player) && this.isIncapacicated()) {
                        this.func_175505_a(player, stack);
                        if (!this.field_70170_p.field_72995_K) {
                            this.field_70911_d.func_75270_a(true);
                            this.func_70606_j(this.func_110138_aP());
                            this.setDogHunger(ConfigValues.HUNGER_POINTS);
                            this.regenerationTick = 0;
                            this.func_70624_b(null);
                            this.func_70908_e(true);
                            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                        }
                        return true;
                    }
                    if (stack.func_77973_b() == Items.field_151100_aR && this.canInteract((EntityLivingBase)player) && this.hasCollarColoured()) {
                        if (!this.field_70170_p.field_72995_K) {
                            int[] aint = new int[3];
                            int maxCompSum = 0;
                            int count = 1;
                            EnumDyeColor colour = EnumDyeColor.func_176766_a((int)stack.func_77960_j());
                            if (colour == null) {
                                return false;
                            }
                            float[] afloat = colour.func_193349_f();
                            int l1 = (int)(afloat[0] * 255.0f);
                            int i2 = (int)(afloat[1] * 255.0f);
                            int j2 = (int)(afloat[2] * 255.0f);
                            maxCompSum += Math.max(l1, Math.max(i2, j2));
                            aint[0] = aint[0] + l1;
                            aint[1] = aint[1] + i2;
                            aint[2] = aint[2] + j2;
                            if (this.isCollarColoured()) {
                                int l = this.getCollarData();
                                float f = (float)(l >> 16 & 0xFF) / 255.0f;
                                float f1 = (float)(l >> 8 & 0xFF) / 255.0f;
                                float f2 = (float)(l & 0xFF) / 255.0f;
                                maxCompSum = (int)((float)maxCompSum + Math.max(f, Math.max(f1, f2)) * 255.0f);
                                aint[0] = (int)((float)aint[0] + f * 255.0f);
                                aint[1] = (int)((float)aint[1] + f1 * 255.0f);
                                aint[2] = (int)((float)aint[2] + f2 * 255.0f);
                                ++count;
                            }
                            int i1 = aint[0] / count;
                            int j1 = aint[1] / count;
                            int k1 = aint[2] / count;
                            float f3 = (float)maxCompSum / (float)count;
                            float f4 = Math.max(i1, Math.max(j1, k1));
                            i1 = (int)((float)i1 * f3 / f4);
                            j1 = (int)((float)j1 * f3 / f4);
                            k1 = (int)((float)k1 * f3 / f4);
                            int k2 = (i1 << 8) + j1;
                            k2 = (k2 << 8) + k1;
                            this.setCollarData(k2);
                        }
                        return true;
                    }
                    if (stack.func_77973_b() == ModItems.TREAT_BAG && this.getDogHunger() < ConfigValues.HUNGER_POINTS && this.canInteract((EntityLivingBase)player) && !this.isIncapacicated()) {
                        InventoryTreatBag treatBag = new InventoryTreatBag(player.field_71071_by.field_70461_c, stack);
                        treatBag.func_174889_b(player);
                        int slotIndex = DogUtil.getFirstSlotWithFood(this, (IInventory)treatBag);
                        if (slotIndex >= 0) {
                            DogUtil.feedDog(this, (IInventory)treatBag, slotIndex);
                        }
                        treatBag.func_174886_c(player);
                        return true;
                    }
                }
            }
            if (!this.func_70877_b(stack) && this.canInteract((EntityLivingBase)player)) {
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70911_d.func_75270_a(!this.func_70906_o());
                    this.field_70703_bu = false;
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                }
                return true;
            }
        } else {
            if (stack.func_77973_b() == ModItems.COLLAR_SHEARS && this.reversionTime < 1) {
                if (!this.field_70170_p.field_72995_K) {
                    this.locationManager.remove(this);
                    this.func_70106_y();
                    EntityWolf wolf = new EntityWolf(this.field_70170_p);
                    wolf.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                    wolf.func_70606_j(this.func_110143_aJ());
                    wolf.func_70873_a(this.func_70874_b());
                    this.field_70170_p.func_72838_d((Entity)wolf);
                }
                return true;
            }
            if (stack.func_77973_b() == Items.field_151103_aS || stack.func_77973_b() == ModItems.TRAINING_TREAT) {
                this.func_175505_a(player, stack);
                if (!this.field_70170_p.field_72995_K) {
                    if (stack.func_77973_b() == ModItems.TRAINING_TREAT || this.field_70146_Z.nextInt(3) == 0) {
                        this.func_70903_f(true);
                        this.field_70699_by.func_75499_g();
                        this.func_70624_b(null);
                        this.field_70911_d.func_75270_a(true);
                        this.func_70606_j(20.0f);
                        this.func_184754_b(player.func_110124_au());
                        this.func_70908_e(true);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    } else {
                        this.func_70908_e(false);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                    }
                }
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    public EntityDog createChild(EntityAgeable entityAgeable) {
        EntityDog entitydog = new EntityDog(this.field_70170_p);
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            entitydog.func_184754_b(uuid);
            entitydog.func_70903_f(true);
        }
        entitydog.func_70873_a(-ConfigValues.TIME_TO_MATURE);
        if (ConfigValues.PUPS_GET_PARENT_LEVELS && entityAgeable instanceof EntityDog) {
            int combinedLevel = this.LEVELS.getLevel() + ((EntityDog)entityAgeable).LEVELS.getLevel();
            combinedLevel /= 2;
            combinedLevel = Math.min(combinedLevel, 20);
            entitydog.LEVELS.setLevel(combinedLevel);
        }
        return entitydog;
    }

    public boolean func_70877_b(ItemStack stack) {
        return DoggyTalentsAPI.BREED_WHITELIST.containsItem(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_94059_bO() {
        return this.func_145818_k_();
    }

    protected boolean func_70610_aX() {
        return this.func_70608_bn() || super.func_70610_aX();
    }

    public boolean func_70687_e(PotionEffect potionEffect) {
        switch (TalentHelper.isPostionApplicable(this, potionEffect)) {
            case SUCCESS: {
                return true;
            }
            case FAIL: {
                return false;
            }
        }
        return !this.isIncapacicated();
    }

    public void func_70015_d(int amount) {
        if (TalentHelper.setFire(this, amount)) {
            super.func_70015_d(amount);
        }
    }

    public boolean func_70608_bn() {
        return false;
    }

    protected int func_70682_h(int air) {
        return TalentHelper.shouldDecreaseAir(this, air) ? super.func_70682_h(air) : air;
    }

    public boolean func_70648_aU() {
        return TalentHelper.canBreatheUnderwater(this);
    }

    protected boolean func_70041_e_() {
        return TalentHelper.canTriggerWalking(this);
    }

    public boolean func_142018_a(EntityLivingBase target, EntityLivingBase owner) {
        if (TalentHelper.canAttackEntity(this, (Entity)target)) {
            return true;
        }
        if (!(target instanceof EntityCreeper) && !(target instanceof EntityGhast)) {
            EntityWolf entitywolf;
            EntityDog entitydog;
            if (target instanceof EntityDog ? (entitydog = (EntityDog)target).func_70909_n() && entitydog.func_70902_q() == owner : target instanceof EntityWolf && (entitywolf = (EntityWolf)target).func_70909_n() && entitywolf.func_70902_q() == owner) {
                return false;
            }
            if (target instanceof EntityPlayer && owner instanceof EntityPlayer && !((EntityPlayer)owner).func_96122_a((EntityPlayer)target)) {
                return false;
            }
            if (target == owner) {
                return false;
            }
            return !(target instanceof AbstractHorse) || !((AbstractHorse)target).func_110248_bS();
        }
        return false;
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        if (TalentHelper.canAttackClass(this, cls)) {
            return true;
        }
        return super.func_70686_a(cls);
    }

    public Entity changeDimension(int dimId, ITeleporter teleporter) {
        Entity entity = super.changeDimension(dimId, teleporter);
        if (entity instanceof EntityDog) {
            EntityDog dog = (EntityDog)entity;
            if (!this.field_70170_p.field_72995_K) {
                dog.locationManager.update(dog);
                this.locationManager.remove(this);
            }
        } else if (entity != null) {
            DoggyTalents.LOGGER.warn("Dog tried to change dimension but now isn't a dog?");
        }
        return entity;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.field_70170_p.field_72995_K) {
            this.locationManager.update(this);
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (!this.field_70170_p.field_72995_K && !this.func_70089_S()) {
            this.locationManager.remove(this);
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (!this.field_70170_p.field_72995_K) {
            this.locationManager.remove(this);
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.isImmortal()) {
            this.isWet = false;
            this.isShaking = false;
            this.prevTimeDogIsShaking = 0.0f;
            this.timeDogIsShaking = 0.0f;
            if (!this.field_70170_p.field_72995_K) {
                this.locationManager.remove(this);
                if (this.field_70170_p.func_82736_K().func_82766_b("showDeathMessages") && this.func_70902_q() instanceof EntityPlayerMP) {
                    this.func_70902_q().func_145747_a(this.func_110142_aN().func_151521_b());
                }
            }
        }
    }

    protected float func_175134_bD() {
        return 0.42f;
    }

    public boolean func_70692_ba() {
        return false;
    }

    protected float func_189749_co() {
        return 0.8f;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(otherAnimal instanceof EntityDog)) {
            return false;
        }
        EntityDog entitydog = (EntityDog)otherAnimal;
        if (!entitydog.func_70909_n()) {
            return false;
        }
        if (entitydog.func_70906_o()) {
            return false;
        }
        if (!this.GENDER.canMateWith(entitydog)) {
            return false;
        }
        return this.func_70880_s() && entitydog.func_70880_s();
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(ModItems.DOGGY_CHARM);
    }

    public void func_70074_a(EntityLivingBase entityLivingIn) {
        super.func_70074_a(entityLivingIn);
        this.STATS.incrementKillCount((Entity)entityLivingIn);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isDogWet() {
        return this.isWet;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadingWhileWet(float partialTick) {
        return 0.75f + (this.prevTimeDogIsShaking + (this.timeDogIsShaking - this.prevTimeDogIsShaking) * partialTick) / 2.0f * 0.25f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShakeAngle(float partialTick, float offset) {
        float f = (this.prevTimeDogIsShaking + (this.timeDogIsShaking - this.prevTimeDogIsShaking) * partialTick + offset) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return MathHelper.func_76126_a((float)(f * (float)Math.PI)) * MathHelper.func_76126_a((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    @SideOnly(value=Side.CLIENT)
    public float getInterestedAngle(float partialTick) {
        return (this.headRotationCourseOld + (this.headRotationCourse - this.headRotationCourseOld) * partialTick) * 0.15f * (float)Math.PI;
    }

    public float getWagAngle(float partialTick, float offset) {
        float f = (this.prevTimeWolfIsHappy + (this.timeWolfIsHappy - this.prevTimeWolfIsHappy) * partialTick + offset) / 2.0f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 2.0f) {
            f %= 2.0f;
        }
        return MathHelper.func_76126_a((float)(f * (float)Math.PI * 11.0f)) * 0.3f * (float)Math.PI;
    }

    @SideOnly(value=Side.CLIENT)
    public float getTailRotation() {
        return this.func_70909_n() ? (0.55f - (this.func_110138_aP() - ((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue()) / this.func_110138_aP() * 20.0f * 0.02f) * (float)Math.PI : 0.62831855f;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    public boolean isImmortal() {
        return this.func_70909_n() && ConfigValues.DOGS_IMMORTAL || this.LEVELS.isDireDog();
    }

    public boolean isIncapacicated() {
        return this.isImmortal() && this.func_110143_aJ() <= (float)ConfigValues.LOW_HEATH_LEVEL;
    }

    public double effectiveLevel() {
        return (double)(this.LEVELS.getLevel() + this.LEVELS.getDireLevel()) / 10.0;
    }

    public double getHealthRelative() {
        return (double)this.func_110143_aJ() / (double)this.func_110138_aP();
    }

    public boolean canWander() {
        return this.func_70909_n() && this.MODE.isMode(EnumMode.WANDERING) && this.COORDS.hasBowlPos() && this.func_174818_b(this.COORDS.getBowlPos()) < 400.0;
    }

    @Override
    public boolean canInteract(EntityLivingBase player) {
        return this.func_152114_e(player) || this.willObeyOthers();
    }

    public int foodValue(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        int foodValue = 0;
        Item item = stack.func_77973_b();
        if (stack.func_77973_b() != Items.field_151078_bh && item instanceof ItemFood) {
            ItemFood itemfood = (ItemFood)item;
            if (itemfood.func_77845_h()) {
                foodValue = 40;
            }
        } else if (stack.func_77973_b() == ModItems.CHEW_STICK) {
            return 10;
        }
        foodValue = TalentHelper.changeFoodValue(this, stack, foodValue);
        return foodValue;
    }

    public int nourishment() {
        int amount = 0;
        if (this.getDogHunger() > 0) {
            amount = 40 + 4 * (MathHelper.func_76128_c((double)this.effectiveLevel()) + 1);
            if (this.func_70906_o() && this.TALENTS.getLevel(ModTalents.QUICK_HEALER) == 5) {
                amount += 20 + 2 * (MathHelper.func_76128_c((double)this.effectiveLevel()) + 1);
            }
            if (!this.func_70906_o()) {
                amount *= 5 + this.TALENTS.getLevel(ModTalents.QUICK_HEALER);
                amount /= 10;
            }
        }
        return amount;
    }

    public void mountTo(EntityLivingBase entityLiving) {
        entityLiving.field_70177_z = this.field_70177_z;
        entityLiving.field_70125_A = this.field_70125_A;
        if (!this.field_70170_p.field_72995_K) {
            entityLiving.func_184220_m((Entity)this);
        }
    }

    public int points() {
        return this.isCreativeCollar() ? 1000 : this.LEVELS.getLevel() + this.LEVELS.getDireLevel() + (this.LEVELS.isDireDog() ? 15 : 0) + (this.func_70874_b() < 0 ? 0 : 15);
    }

    public int spendablePoints() {
        return this.points() - this.usedPoints();
    }

    public int usedPoints() {
        return TalentHelper.getUsedPoints(this);
    }

    public int deductive(int id) {
        if (id >= 1 && id <= 5) {
            return (new int[]{1, 3, 6, 10, 15})[id - 1];
        }
        return 0;
    }

    public ITextComponent getOwnersName() {
        if (this.func_70902_q() != null) {
            return this.func_70902_q().func_145748_c_();
        }
        if (((Optional)this.field_70180_af.func_187225_a(LAST_KNOWN_NAME)).isPresent()) {
            return (ITextComponent)((Optional)this.field_70180_af.func_187225_a(LAST_KNOWN_NAME)).get();
        }
        if (this.func_184753_b() != null) {
            return new TextComponentTranslation("entity.doggytalents.dog.unknown_owner", new Object[0]);
        }
        return new TextComponentTranslation("entity.doggytalents.dog.untamed", new Object[0]);
    }

    private boolean getDogFlag(int bit) {
        return ((Byte)this.field_70180_af.func_187225_a(DOG_FLAGS) & bit) != 0;
    }

    private void setDogFlag(int bit, boolean flag) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DOG_FLAGS);
        if (flag) {
            this.field_70180_af.func_187227_b(DOG_FLAGS, (Object)((byte)(b0 | bit)));
        } else {
            this.field_70180_af.func_187227_b(DOG_FLAGS, (Object)((byte)(b0 & ~bit)));
        }
    }

    public void setBegging(boolean flag) {
        this.setDogFlag(1, flag);
    }

    public boolean isBegging() {
        return this.getDogFlag(1);
    }

    public void setWillObeyOthers(boolean flag) {
        this.setDogFlag(2, flag);
    }

    public boolean willObeyOthers() {
        return this.getDogFlag(2);
    }

    public void setCanPlayersAttack(boolean flag) {
        this.setDogFlag(4, flag);
    }

    public boolean canPlayersAttack() {
        return this.getDogFlag(4);
    }

    public void hasRadarCollar(boolean flag) {
        this.setDogFlag(8, flag);
    }

    public boolean hasRadarCollar() {
        return this.getDogFlag(8);
    }

    public void setHasSunglasses(boolean hasSunglasses) {
        this.setDogFlag(16, hasSunglasses);
    }

    public boolean hasSunglasses() {
        return this.getDogFlag(16);
    }

    public void setLyingDown(boolean lying) {
        this.setDogFlag(32, lying);
    }

    public boolean isLyingDown() {
        return this.getDogFlag(32);
    }

    public int getTameSkin() {
        return ((Byte)this.field_70180_af.func_187225_a(DOG_TEXTURE)).byteValue();
    }

    public void setTameSkin(int index) {
        this.field_70180_af.func_187227_b(DOG_TEXTURE, (Object)((byte)index));
    }

    public int getDogHunger() {
        return (Integer)this.field_70180_af.func_187225_a(HUNGER_PARAM);
    }

    public void setDogHunger(int par1) {
        this.field_70180_af.func_187227_b(HUNGER_PARAM, (Object)Math.min(ConfigValues.HUNGER_POINTS, Math.max(0, par1)));
    }

    public void setBoneVariant(ItemStack stack) {
        this.field_70180_af.func_187227_b(BONE_VARIANT, (Object)stack);
    }

    public ItemStack getBoneVariant() {
        return (ItemStack)this.field_70180_af.func_187225_a(BONE_VARIANT);
    }

    @Nullable
    public IThrowableItem getThrowableItem() {
        Item item = ((ItemStack)this.field_70180_af.func_187225_a(BONE_VARIANT)).func_77973_b();
        if (item instanceof IThrowableItem) {
            return (IThrowableItem)item;
        }
        return null;
    }

    public boolean hasBone() {
        return !this.getBoneVariant().func_190926_b();
    }

    public int getCollarData() {
        return (Integer)this.field_70180_af.func_187225_a(COLLAR_COLOUR);
    }

    public void setCollarData(int value) {
        this.field_70180_af.func_187227_b(COLLAR_COLOUR, (Object)value);
    }

    public int getCapeData() {
        return (Integer)this.field_70180_af.func_187225_a(CAPE);
    }

    public void setCapeData(int value) {
        this.field_70180_af.func_187227_b(CAPE, (Object)value);
    }

    @Override
    public void setDogSize(int value) {
        this.field_70180_af.func_187227_b(SIZE, (Object)((byte)Math.min(5, Math.max(1, value))));
    }

    @Override
    public int getDogSize() {
        return ((Byte)this.field_70180_af.func_187225_a(SIZE)).byteValue();
    }

    public void setGender(EnumGender gender) {
        this.field_70180_af.func_187227_b(GENDER_PARAM, (Object)((byte)gender.getIndex()));
    }

    public EnumGender getGender() {
        return EnumGender.byIndex(((Byte)this.field_70180_af.func_187225_a(GENDER_PARAM)).byteValue());
    }

    public void setLevel(int level) {
        this.field_70180_af.func_187227_b(LEVEL, (Object)((byte)level));
    }

    public int getLevel() {
        return ((Byte)this.field_70180_af.func_187225_a(LEVEL)).byteValue();
    }

    public void setDireLevel(int level) {
        this.field_70180_af.func_187227_b(LEVEL_DIRE, (Object)((byte)level));
    }

    public int getDireLevel() {
        return ((Byte)this.field_70180_af.func_187225_a(LEVEL_DIRE)).byteValue();
    }

    public void setMode(EnumMode mode) {
        EnumMode prevMode = this.getMode();
        this.field_70180_af.func_187227_b(MODE_PARAM, (Object)((byte)mode.getIndex()));
        mode.onModeSet(this, prevMode);
    }

    public EnumMode getMode() {
        return EnumMode.byIndex(((Byte)this.field_70180_af.func_187225_a(MODE_PARAM)).byteValue());
    }

    public void setTalentMap(Map<Talent, Integer> data) {
        this.field_70180_af.func_187227_b(TALENTS_PARAM, data);
    }

    public Map<Talent, Integer> getTalentMap() {
        return (Map)this.field_70180_af.func_187225_a(TALENTS_PARAM);
    }

    public boolean hasBedPos() {
        return ((Optional)this.field_70180_af.func_187225_a(BED_POS)).isPresent();
    }

    public boolean hasBowlPos() {
        return ((Optional)this.field_70180_af.func_187225_a(BOWL_POS)).isPresent();
    }

    public BlockPos getBedPos() {
        return (BlockPos)((Optional)this.field_70180_af.func_187225_a(BED_POS)).or((Object)this.field_70170_p.func_175694_M());
    }

    public BlockPos getBowlPos() {
        return (BlockPos)((Optional)this.field_70180_af.func_187225_a(BOWL_POS)).or((Object)this.func_180425_c());
    }

    public void resetBedPosition() {
        this.field_70180_af.func_187227_b(BED_POS, (Object)Optional.absent());
    }

    public void resetBowlPosition() {
        this.field_70180_af.func_187227_b(BOWL_POS, (Object)Optional.absent());
    }

    public void setBedPos(BlockPos pos) {
        this.field_70180_af.func_187227_b(BED_POS, (Object)Optional.of((Object)pos));
    }

    public void setBowlPos(BlockPos pos) {
        this.field_70180_af.func_187227_b(BOWL_POS, (Object)Optional.of((Object)pos));
    }

    public void setNoCollar() {
        this.setCollarData(-2);
    }

    public boolean hasCollar() {
        return this.getCollarData() != -2;
    }

    public boolean hasCollarColoured() {
        return this.getCollarData() >= -1;
    }

    public boolean isCollarColoured() {
        return this.getCollarData() > -1;
    }

    public void setHasCollar() {
        this.setCollarData(-1);
    }

    public boolean hasFancyCollar() {
        return this.getCollarData() < -2;
    }

    public int getFancyCollarIndex() {
        return -3 - this.getCollarData();
    }

    public boolean isCreativeCollar() {
        return this.getCollarData() == -3;
    }

    public float[] getCollar() {
        return DogUtil.rgbIntToFloatArray(this.getCollarData());
    }

    public boolean hasCape() {
        return this.getCapeData() != -2;
    }

    public boolean hasCapeColoured() {
        return this.getCapeData() >= -1;
    }

    public boolean hasFancyCape() {
        return this.getCapeData() == -3;
    }

    public boolean hasLeatherJacket() {
        return this.getCapeData() == -4;
    }

    public boolean isCapeColoured() {
        return this.getCapeData() > -1;
    }

    public void setFancyCape() {
        this.setCapeData(-3);
    }

    public void setLeatherJacket() {
        this.setCapeData(-4);
    }

    public void setCapeColoured() {
        this.setCapeData(-1);
    }

    public void setNoCape() {
        this.setCapeData(-2);
    }

    public float[] getCapeColour() {
        return DogUtil.rgbIntToFloatArray(this.getCapeData());
    }

    public boolean isDogJumping() {
        return this.dogJumping;
    }

    public void setDogJumping(boolean jumping) {
        this.dogJumping = jumping;
    }

    public double getDogJumpStrength() {
        float verticalVelocity = 0.42f + 0.06f * (float)this.TALENTS.getLevel(ModTalents.WOLF_MOUNT);
        if (this.TALENTS.getLevel(ModTalents.WOLF_MOUNT) == 5) {
            verticalVelocity += 0.04f;
        }
        return verticalVelocity;
    }

    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof EntityLivingBase;
    }

    public boolean func_70104_M() {
        return !this.func_184207_aI();
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (passenger instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)passenger;
            this.field_70761_aq = entityliving.field_70761_aq;
        }
    }

    public double func_70033_W() {
        return this.func_184187_bx() instanceof EntityPlayer ? 0.5 : 0.0;
    }

    public boolean shouldDismountInWater(Entity rider) {
        switch (TalentHelper.canBeRiddenInWater(this, rider)) {
            case SUCCESS: {
                return false;
            }
            case FAIL: {
                return true;
            }
        }
        return true;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public void setJumpPower(int jumpPowerIn) {
        if (this.TALENTS.getLevel(ModTalents.WOLF_MOUNT) > 0) {
            this.jumpPower = 1.0f;
        }
    }

    public boolean canJump() {
        return this.TALENTS.getLevel(ModTalents.WOLF_MOUNT) > 0;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_184207_aI() && this.func_82171_bF() && this.TALENTS.getLevel(ModTalents.WOLF_MOUNT) > 0) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br * 0.7f;
            forward = entitylivingbase.field_191988_bg;
            if (forward <= 0.0f) {
                forward *= 0.5f;
            }
            this.field_70138_W = 1.0f;
            if (this.jumpPower > 0.0f && !this.isDogJumping() && this.field_70122_E) {
                this.field_70181_x = this.getDogJumpStrength() * (double)this.jumpPower;
                if (this.func_70644_a(MobEffects.field_76430_j)) {
                    this.field_70181_x += (double)((float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
                }
                this.setDogJumping(true);
                this.field_70160_al = true;
                if (forward > 0.0f) {
                    float f = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    float f1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    this.field_70159_w += (double)(-0.4f * f * this.jumpPower);
                    this.field_70179_y += (double)(0.4f * f1 * this.jumpPower);
                }
                this.jumpPower = 0.0f;
            } else if (this.jumpPower > 0.0f && this.func_70090_H() && !this.isDogJumping()) {
                this.field_70181_x = this.getDogJumpStrength() * (double)0.4f;
                this.setDogJumping(true);
                this.jumpPower = 0.0f;
            }
            this.field_70747_aH = this.func_70689_ay() * 0.3f;
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 0.5f);
                super.func_191986_a(strafe, vertical, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            if (this.field_70122_E || this.func_70090_H()) {
                this.jumpPower = 0.0f;
                this.setDogJumping(false);
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70138_W = 0.6f;
            this.field_70747_aH = 0.02f;
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    @Override
    public ICoordFeature getCoordFeature() {
        return this.COORDS;
    }

    @Override
    public IGenderFeature getGenderFeature() {
        return this.GENDER;
    }

    @Override
    public ILevelFeature getLevelFeature() {
        return this.LEVELS;
    }

    @Override
    public IModeFeature getModeFeature() {
        return this.MODE;
    }

    @Override
    public IStatsFeature getStatsFeature() {
        return this.STATS;
    }

    @Override
    public ITalentFeature getTalentFeature() {
        return this.TALENTS;
    }

    @Override
    public IHungerFeature getHungerFeature() {
        return this.HUNGER;
    }

    @Override
    public <T> void putObject(String key, T i) {
        this.objects.put(key, i);
    }

    @Override
    public <T> T getObject(String key, Class<T> type) {
        return (T)this.objects.get(key);
    }
}

