/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.command.delete;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import pregenerator.impl.command.CompleterHelper;
import pregenerator.impl.command.base.BasePregenCommand;
import pregenerator.impl.command.base.CommandContainer;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.processor.ChunkCalculator;
import pregenerator.impl.processor.deleter.DeleteProcess;
import pregenerator.impl.processor.deleter.IDeletionTask;

public class DeleteRadiusSubCommand
extends BasePregenCommand {
    public DeleteRadiusSubCommand() {
        super(6);
        this.addDescription(0, "Deletion Type: Which shape the Generation should have");
        this.addDescription(1, "X Center: Which Chunk the center should be in. (if 'b' infront of the number or after ~ means block position)");
        this.addDescription(2, "Z Center: Which Chunk the center should be in. (if 'b' infront of the number or after ~ means block position)");
        this.addDescription(3, "Radius: How big the Radius in Chunks should be. (if 'b' infront of the number or after ~ means block distance)");
        this.addDescription(4, "(Optional) Dimension: The Dimension the Deletion should be happening in");
        this.addDescription(5, "(Optional) Delay: How long the Deleter should wait until it should start (in ticks)");
        this.addSuggestion("deleteRadius square 0 0 100 -1 200", "Deletes a 100 Chunk Area around the World Center in the nether and it waits 10 seconds before starting");
    }

    @Override
    public String getName() {
        return "deleteRadius";
    }

    @Override
    public String getDescription() {
        return "Deletes a Radius of Unloaded Chunks";
    }

    @Override
    public int getRequiredParameterCount() {
        return 4;
    }

    @Override
    public void execute(CommandContainer container, String[] args) {
        if (container.processorRunning()) {
            container.sendChatMessage("While the Pregenerator or Deleter is running you are not allowed to start Deletion Task!");
            return;
        }
        if (args.length >= 4) {
            int type = DeleteRadiusSubCommand.getGenType(args[0]);
            FilePos center = DeleteRadiusSubCommand.getChunkPos(args[1], args[2], container.getPlayerPos());
            int radius = DeleteRadiusSubCommand.getNumber(DeleteRadiusSubCommand.getArg(args, 3), 0);
            int dimension = DeleteRadiusSubCommand.getDimension(container, DeleteRadiusSubCommand.getArg(args, 4));
            int delay = DeleteRadiusSubCommand.parseNumber(DeleteRadiusSubCommand.getArg(args, 5), 0);
            if (!DeleteRadiusSubCommand.isDimensionValid(dimension)) {
                container.sendChatMessage("Dimension " + dimension + " is not Registered!");
                return;
            }
            if (radius > 1000) {
                container.sendChatMessage("A Radius over 1000 is to big to Delete at once. If you want to delete more use the dimension delete command");
                return;
            }
            container.onProcessStarted();
            container.getDeleter().startTask(new RadiusTask(type, dimension, center, radius, delay));
        } else {
            this.throwErrors(container, args.length);
        }
    }

    @Override
    public List<String> getAutoCompleteOption(String[] args, int argLayer, int commandIndex) {
        if (commandIndex == 0) {
            return DeleteRadiusSubCommand.getBestMatch(args, CompleterHelper.GEN_TYPE);
        }
        if (commandIndex == 1 || commandIndex == 2) {
            return DeleteRadiusSubCommand.getBestMatch(args, "0", "~");
        }
        if (commandIndex == 3) {
            if (args[argLayer].startsWith("b")) {
                return DeleteRadiusSubCommand.getBestMatch(args, CompleterHelper.GEN_RADIUS_BLOCK);
            }
            return DeleteRadiusSubCommand.getBestMatch(args, CompleterHelper.GEN_RADIUS_CHUNK);
        }
        if (commandIndex == 4) {
            return DeleteRadiusSubCommand.getBestMatch(args, CompleterHelper.DIMENSION);
        }
        if (commandIndex == 5) {
            return DeleteRadiusSubCommand.getBestMatch(args, CompleterHelper.GEN_DELAY);
        }
        return new ArrayList<String>();
    }

    public static class RadiusTask
    extends IDeletionTask {
        int type;
        int dim;
        FilePos center;
        int radius;

        public RadiusTask(int type, int dim, FilePos center, int radius, int delay) {
            super(delay);
            this.type = type;
            this.dim = dim;
            this.center = center;
            this.radius = radius;
        }

        @Override
        public DeleteProcess createTask() {
            boolean loaded = DimensionManager.getWorld((int)this.dim) != null;
            WorldServer world = this.getWorld(this.dim);
            DeleteProcess process = new DeleteProcess(world.getChunkSaveLocation(), this.type == 1 ? ChunkCalculator.createcircle(this.center.x, this.center.z, this.radius) : ChunkCalculator.createSquare(this.center.x, this.center.z, this.radius));
            if (loaded) {
                process.setChunkHost(world);
            } else {
                DimensionManager.unloadWorld((int)this.dim);
            }
            return process;
        }
    }
}

