/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview.texture;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;
import pregenerator.impl.client.preview.texture.DisplayTexture;

public class RenderShader {
    public static final String VERTEX_FILE = "/pregenerator/base/impl/gui/shader/vertex.txt";
    public static final String FRAGMENT_FILE = "/pregenerator/base/impl/gui/shader/fragment.txt";
    public static RenderShader SHADER = RenderShader.createShader();
    int shaderID;
    Map<String, Integer> uniforms = new HashMap<String, Integer>();
    FloatBuffer buffer = BufferUtils.createFloatBuffer((int)16);

    public RenderShader(String vertex, String fragment, String ... attributes) {
        int vertexID = this.loadShader(vertex, 35633);
        int fragmentID = this.loadShader(fragment, 35632);
        if (vertexID == -1 || fragmentID == -1) {
            this.shaderID = -1;
            System.out.println("Couldnt create Shader");
            return;
        }
        this.shaderID = GL20.glCreateProgram();
        GL20.glAttachShader((int)this.shaderID, (int)vertexID);
        GL20.glAttachShader((int)this.shaderID, (int)fragmentID);
        for (int i = 0; i < attributes.length; ++i) {
            GL20.glBindAttribLocation((int)this.shaderID, (int)i, (CharSequence)attributes[i]);
        }
        GL20.glLinkProgram((int)this.shaderID);
        GL20.glDetachShader((int)this.shaderID, (int)vertexID);
        GL20.glDetachShader((int)this.shaderID, (int)fragmentID);
        GL20.glDeleteShader((int)vertexID);
        GL20.glDeleteShader((int)fragmentID);
    }

    public RenderShader addUniforms(String ... values) {
        for (String s : values) {
            this.uniforms.put(s, GL20.glGetUniformLocation((int)this.shaderID, (CharSequence)s));
        }
        return this;
    }

    public RenderShader addArrayUniform(String name, int size) {
        for (int i = 0; i < size; ++i) {
            String indexName = name + "[" + i + "]";
            this.uniforms.put(indexName, GL20.glGetUniformLocation((int)this.shaderID, (CharSequence)indexName));
        }
        return this;
    }

    public RenderShader finish() {
        GL20.glValidateProgram((int)this.shaderID);
        for (Map.Entry<String, Integer> entry : this.uniforms.entrySet()) {
            if (entry.getValue() != -1) continue;
            System.out.println("Uniform[" + entry.getKey() + "] was not found");
        }
        return this;
    }

    public boolean isShaderValid() {
        return this.shaderID != -1;
    }

    public void startShader() {
        GL20.glUseProgram((int)this.shaderID);
    }

    public void stopShader() {
        GL20.glUseProgram((int)0);
    }

    public void removeShader() {
        if (this.shaderID == -1) {
            return;
        }
        this.stopShader();
        GL20.glDeleteProgram((int)this.shaderID);
        this.shaderID = -1;
    }

    public void loadVec3Array(String uniformName, int index, float x, float y, float z) {
        GL20.glUniform3f((int)this.uniforms.get(uniformName + "[" + index + "]"), (float)x, (float)y, (float)z);
    }

    public void loadVec3(String uniformName, float x, float y, float z) {
        GL20.glUniform3f((int)this.uniforms.get(uniformName), (float)x, (float)y, (float)z);
    }

    public void loadFloat(String uniformName, float value) {
        GL20.glUniform1f((int)this.uniforms.get(uniformName), (float)value);
    }

    public void loadInt(String uniformName, int value) {
        GL20.glUniform1i((int)this.uniforms.get(uniformName), (int)value);
    }

    public void loadMat(String uniformName, Matrix4f mat) {
        this.buffer.clear();
        mat.store(this.buffer);
        this.buffer.flip();
        GL20.glUniformMatrix4((int)this.uniforms.get(uniformName), (boolean)false, (FloatBuffer)this.buffer);
    }

    private int loadShader(String file, int type) {
        StringBuilder shaderSource = new StringBuilder();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(RenderShader.class.getResourceAsStream(file)));
            String line = reader.readLine();
            while (line != null) {
                if (!line.startsWith("//")) {
                    shaderSource.append(line).append("//\n");
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        int shaderID = GL20.glCreateShader((int)type);
        GL20.glShaderSource((int)shaderID, (CharSequence)shaderSource);
        GL20.glCompileShader((int)shaderID);
        if (GL20.glGetShaderi((int)shaderID, (int)35713) == 0) {
            System.out.println("Could not compile shader " + file);
            System.err.println(GL20.glGetShaderInfoLog((int)shaderID, (int)500));
            return -1;
        }
        return shaderID;
    }

    private static RenderShader createShader() {
        RenderShader shader = new RenderShader(VERTEX_FILE, FRAGMENT_FILE, "in_position", "in_texture");
        shader.addUniforms("proViewMatrix", "transform");
        shader.addUniforms("dataMap");
        shader.addArrayUniform("blockColors", 256);
        shader.finish();
        if (shader.isShaderValid()) {
            shader.startShader();
            float[] data = DisplayTexture.defaultData;
            shader.loadMat("transform", RenderShader.createMatrix(0.0f, 0.0f, 2000.0f, 1.0f));
            shader.stopShader();
        }
        return shader;
    }

    public static Matrix4f createMatrix(float x, float y, float z, float scale) {
        Matrix4f mat = new Matrix4f();
        mat.translate(new Vector3f(x, y, z));
        mat.scale(new Vector3f(scale, scale, 1.0f));
        return mat;
    }

    public static Matrix4f orthoLH(float left, float right, float bottom, float top, float zNear, float zFar, boolean zZeroToOne) {
        Matrix4f mat = new Matrix4f();
        float rm00 = 2.0f / (right - left);
        float rm11 = 2.0f / (top - bottom);
        float rm22 = (zZeroToOne ? 1.0f : 2.0f) / (zFar - zNear);
        float rm30 = (left + right) / (left - right);
        float rm31 = (top + bottom) / (bottom - top);
        float rm32 = (zZeroToOne ? zNear : zFar + zNear) / (zNear - zFar);
        mat.m30 = mat.m00 * rm30 + mat.m10 * rm31 + mat.m20 * rm32 + mat.m30;
        mat.m31 = mat.m01 * rm30 + mat.m11 * rm31 + mat.m21 * rm32 + mat.m31;
        mat.m32 = mat.m02 * rm30 + mat.m12 * rm31 + mat.m22 * rm32 + mat.m32;
        mat.m33 = mat.m03 * rm30 + mat.m13 * rm31 + mat.m23 * rm32 + mat.m33;
        mat.m00 *= rm00;
        mat.m01 *= rm00;
        mat.m02 *= rm00;
        mat.m03 *= rm00;
        mat.m10 *= rm11;
        mat.m11 *= rm11;
        mat.m12 *= rm11;
        mat.m13 *= rm11;
        mat.m20 *= rm22;
        mat.m21 *= rm22;
        mat.m22 *= rm22;
        mat.m23 *= rm22;
        return mat;
    }
}

