/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tools;

import com.direwolf20.buildinggadgets.common.building.IBuildingMode;
import com.direwolf20.buildinggadgets.common.building.modes.BuildToMeMode;
import com.direwolf20.buildinggadgets.common.building.modes.BuildingHorizontalColumnMode;
import com.direwolf20.buildinggadgets.common.building.modes.BuildingSurfaceMode;
import com.direwolf20.buildinggadgets.common.building.modes.BuildingVerticalColumnMode;
import com.direwolf20.buildinggadgets.common.building.modes.GridMode;
import com.direwolf20.buildinggadgets.common.building.modes.HorizontalWallMode;
import com.direwolf20.buildinggadgets.common.building.modes.StairMode;
import com.direwolf20.buildinggadgets.common.building.modes.VerticalWallMode;
import com.direwolf20.buildinggadgets.common.config.SyncedConfig;
import com.direwolf20.buildinggadgets.common.tools.BlockMap;
import com.direwolf20.buildinggadgets.common.tools.GadgetUtils;
import com.direwolf20.buildinggadgets.common.tools.NBTTool;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.doubles.Double2ObjectArrayMap;
import it.unimi.dsi.fastutil.doubles.DoubleBidirectionalIterator;
import it.unimi.dsi.fastutil.doubles.DoubleRBTreeSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Spliterators;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public enum BuildingModes {
    BuildToMe("build_to_me.png", new BuildToMeMode(BuildingModes::combineTester)),
    VerticalColumn("vertical_column.png", new BuildingVerticalColumnMode(BuildingModes::combineTester)),
    HorizontalColumn("horizontal_column.png", new BuildingHorizontalColumnMode(BuildingModes::combineTester)),
    VerticalWall("vertical_wall.png", new VerticalWallMode(BuildingModes::combineTester)),
    HorizontalWall("horizontal_wall.png", new HorizontalWallMode(BuildingModes::combineTester)),
    Stair("stairs.png", new StairMode(BuildingModes::combineTester)),
    Grid("grid.png", new GridMode(BuildingModes::combineTester)),
    Surface("surface.png", new BuildingSurfaceMode(BuildingModes::combineTester));

    private static final BuildingModes[] VALUES;
    private final ResourceLocation icon;
    private final IBuildingMode modeImpl;
    private static final ImmutableList<ResourceLocation> ICONS;

    private BuildingModes(String iconFile, IBuildingMode modeImpl) {
        this.icon = new ResourceLocation("buildinggadgets", "textures/gui/mode/" + iconFile);
        this.modeImpl = modeImpl;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public IBuildingMode getModeImplementation() {
        return this.modeImpl;
    }

    public String getRegistryName() {
        return this.getModeImplementation().getRegistryName().toString() + "/BuildingGadget";
    }

    public String toString() {
        return this.getModeImplementation().getLocalized();
    }

    public BuildingModes next() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    public static List<BlockPos> collectPlacementPos(World world, EntityPlayer player, BlockPos hit, EnumFacing sideHit, ItemStack tool, BlockPos initial) {
        IBuildingMode mode = BuildingModes.byName(NBTTool.getOrNewTag(tool).func_74779_i("mode")).getModeImplementation();
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(mode.createExecutionContext(player, hit, sideHit, tool).getFilteredSequence(world, tool, player, initial), 16), false).sorted(Comparator.comparingDouble(e -> e.func_177957_d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v))).collect(Collectors.toList());
    }

    public static BuildingModes byName(String name) {
        return Arrays.stream(BuildingModes.values()).filter(mode -> mode.getRegistryName().equals(name)).findFirst().orElse(BuildToMe);
    }

    public static ImmutableList<ResourceLocation> getIcons() {
        return ICONS;
    }

    public static BiPredicate<BlockPos, IBlockState> combineTester(World world, ItemStack tool, EntityPlayer player, BlockPos initial) {
        IBlockState target = GadgetUtils.getToolBlock(tool);
        return (pos, state) -> {
            IBlockState current = world.func_180495_p(pos);
            if (!target.func_177230_c().func_176196_c(world, pos)) {
                return false;
            }
            if (pos.func_177956_o() < 0) {
                return false;
            }
            if (SyncedConfig.canOverwriteBlocks) {
                return current.func_177230_c().func_176200_f((IBlockAccess)world, pos);
            }
            return current.func_177230_c().isAir(current, (IBlockAccess)world, pos);
        };
    }

    public static List<BlockMap> sortMapByDistance(List<BlockMap> unSortedMap, EntityPlayer player) {
        ArrayList<BlockPos> unSortedList = new ArrayList<BlockPos>();
        HashMap<BlockPos, IBlockState> PosToStateMap = new HashMap<BlockPos, IBlockState>();
        HashMap<BlockPos, Integer> PosToX = new HashMap<BlockPos, Integer>();
        HashMap<BlockPos, Integer> PosToY = new HashMap<BlockPos, Integer>();
        HashMap<BlockPos, Integer> PosToZ = new HashMap<BlockPos, Integer>();
        for (BlockMap blockMap : unSortedMap) {
            PosToStateMap.put(blockMap.pos, blockMap.state);
            PosToX.put(blockMap.pos, blockMap.xOffset);
            PosToY.put(blockMap.pos, blockMap.yOffset);
            PosToZ.put(blockMap.pos, blockMap.zOffset);
            unSortedList.add(blockMap.pos);
        }
        ArrayList<BlockMap> sortedMap = new ArrayList<BlockMap>();
        Double2ObjectArrayMap rangeMap = new Double2ObjectArrayMap(unSortedList.size());
        DoubleRBTreeSet distances = new DoubleRBTreeSet();
        double x = player.field_70165_t;
        double y = player.field_70163_u + (double)player.func_70047_e();
        double z = player.field_70161_v;
        for (BlockPos pos : unSortedList) {
            double distance = pos.func_177957_d(x, y, z);
            rangeMap.put(distance, (Object)pos);
            distances.add(distance);
        }
        DoubleBidirectionalIterator doubleBidirectionalIterator = distances.iterator();
        while (doubleBidirectionalIterator.hasNext()) {
            double dist = (Double)doubleBidirectionalIterator.next();
            BlockPos pos = new BlockPos((Vec3i)rangeMap.get(dist));
            sortedMap.add(new BlockMap(pos, (IBlockState)PosToStateMap.get(pos), (Integer)PosToX.get(pos), (Integer)PosToY.get(pos), (Integer)PosToZ.get(pos)));
        }
        return sortedMap;
    }

    static {
        VALUES = BuildingModes.values();
        ICONS = (ImmutableList)Arrays.stream(BuildingModes.values()).map(BuildingModes::getIcon).collect(ImmutableList.toImmutableList());
    }
}

