/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.integration.mods;

import com.direwolf20.buildinggadgets.common.integration.IntegrationHandler;
import com.direwolf20.buildinggadgets.common.integration.NetworkProvider;
import com.direwolf20.buildinggadgets.common.integration.mods.SimpleStorageNetworkAPI;
import com.direwolf20.buildinggadgets.common.tools.NetworkIO;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mrriegel.storagenetwork.api.network.INetworkMaster;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;

@IntegrationHandler.IntegratedMod(value="storagenetwork")
public class SimpleStorageNetwork
extends NetworkProvider {
    @Override
    @Nullable
    protected IItemHandler getWrappedNetworkInternal(TileEntity te, EntityPlayer player, NetworkIO.Operation operation) {
        if (te instanceof INetworkMaster) {
            return new NetworkSimpleStorageNetworkIO(player, (INetworkMaster)te, operation);
        }
        return null;
    }

    public static class NetworkSimpleStorageNetworkIO
    extends NetworkIO<NetworkIO.StackProviderVanilla> {
        private INetworkMaster network;

        public NetworkSimpleStorageNetworkIO(EntityPlayer player, INetworkMaster network, NetworkIO.Operation operation) {
            super(player, operation == NetworkIO.Operation.INSERT ? null : (Collection)network.getStacks().stream().map(stack -> new NetworkIO.StackProviderVanilla(stack.func_77946_l())).collect(Collectors.toList()));
            this.network = network;
        }

        @Override
        @Nullable
        public ItemStack insertItemInternal(ItemStack stack, boolean simulate) {
            ItemStack copy = stack.func_77946_l();
            int remainder = this.network.insertStack(stack, simulate);
            if (remainder == 0) {
                return null;
            }
            copy.func_190920_e(remainder);
            return copy;
        }

        @Override
        @Nonnull
        protected NetworkIO.IStackProvider extractItemInternal(NetworkIO.StackProviderVanilla stackProvider, int amount, boolean simulate) {
            return new NetworkIO.StackProviderVanilla(this.network.request(SimpleStorageNetworkAPI.createItemStackMatcher(stackProvider.getStack()), amount, simulate));
        }
    }
}

