/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.ambientsounds;

import com.creativemd.ambientsounds.AmbientDimension;
import com.creativemd.ambientsounds.AmbientEngine;
import com.creativemd.ambientsounds.AmbientEnviroment;
import com.creativemd.ambientsounds.AmbientRegion;
import com.creativemd.ambientsounds.AmbientSound;
import com.creativemd.ambientsounds.AmbientSoundEngine;
import com.creativemd.ambientsounds.AmbientSounds;
import com.creativemd.ambientsounds.utils.Pair;
import com.creativemd.ambientsounds.utils.PairList;
import com.creativemd.creativecore.CreativeCore;
import com.creativemd.creativecore.common.config.holder.ConfigHolderDynamic;
import com.creativemd.creativecore.common.config.holder.CreativeConfigRegistry;
import com.creativemd.creativecore.common.config.sync.ConfigSynchronization;
import com.google.common.base.Strings;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.client.event.sound.SoundSetupEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import paulscode.sound.SoundSystemConfig;

public class AmbientTickHandler {
    private static Minecraft mc = Minecraft.func_71410_x();
    public AmbientSoundEngine soundEngine;
    public AmbientEnviroment enviroment = null;
    public AmbientEngine engine;
    public int timer = 0;
    public boolean showDebugInfo = false;
    private static DecimalFormat df = new DecimalFormat("0.##");

    public void setEngine(AmbientEngine engine) {
        this.engine = engine;
        this.initConfiguration();
    }

    public void initConfiguration() {
        CreativeConfigRegistry.ROOT.removeField("ambientsounds");
        ConfigHolderDynamic holder = CreativeConfigRegistry.ROOT.registerFolder("ambientsounds", ConfigSynchronization.CLIENT);
        ConfigHolderDynamic sounds = holder.registerFolder("sounds");
        Field soundField = ReflectionHelper.findField(AmbientSound.class, (String[])new String[]{"volumeSetting"});
        for (Pair pair : this.engine.allRegions) {
            if (((AmbientRegion)pair.value).sounds == null) continue;
            for (AmbientSound sound : ((AmbientRegion)pair.value).sounds) {
                sounds.registerField((String)pair.key + "." + sound.name, soundField, (Object)sound);
            }
        }
        ConfigHolderDynamic dimensions = holder.registerFolder("dimensions");
        Field field = ReflectionHelper.findField(AmbientDimension.class, (String[])new String[]{"volumeSetting"});
        for (AmbientDimension dimension : this.engine.dimensions) {
            dimensions.registerField(dimension.name, field, (Object)dimension);
        }
        holder.registerField("silent-dimensions", ReflectionHelper.findField(AmbientEngine.class, (String[])new String[]{"silentDimensions"}), (Object)this.engine);
        CreativeCore.configHandler.load("ambientsounds", Side.CLIENT);
        CreativeCore.configHandler.save("ambientsounds", Side.CLIENT);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            return;
        }
        if (this.engine != null) {
            this.engine.stopEngine();
        }
        this.enviroment = null;
        this.timer = 0;
    }

    @SubscribeEvent
    public void onSoundLoadEvent(SoundLoadEvent event) {
        this.soundEngine = new AmbientSoundEngine(event.getManager(), AmbientTickHandler.mc.field_71474_y);
        if (this.engine != null) {
            this.engine.soundEngine = this.soundEngine;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onSoundSetup(SoundSetupEvent event) {
        SoundSystemConfig.setNumberStreamingChannels((int)AmbientSounds.streamingChannels);
        SoundSystemConfig.setNumberNormalChannels((int)AmbientSounds.normalChannels);
    }

    private String format(Object value) {
        if (value instanceof Double || value instanceof Float) {
            return df.format(value);
        }
        return value.toString();
    }

    private String format(PairList<String, Object> details) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Pair pair : details) {
            if (!first) {
                builder.append(",");
            } else {
                first = false;
            }
            builder.append(ChatFormatting.YELLOW + (String)pair.key + ChatFormatting.RESET + ":" + this.format(pair.value));
        }
        return builder.toString();
    }

    @SubscribeEvent
    public void onRender(TickEvent.RenderTickEvent event) {
        if (this.showDebugInfo && event.phase == TickEvent.Phase.END && this.engine != null && AmbientTickHandler.mc.field_71415_G && this.enviroment != null) {
            GlStateManager.func_179094_E();
            ArrayList<String> list = new ArrayList<String>();
            AmbientDimension dimension = this.engine.getDimension((World)AmbientTickHandler.mc.field_71441_e);
            PairList<String, Object> details = new PairList<String, Object>();
            details.add("night", Boolean.valueOf(this.enviroment.night));
            details.add("rain", Boolean.valueOf(this.enviroment.raining));
            details.add("storm", Boolean.valueOf(this.enviroment.thundering));
            details.add("b-volume", Double.valueOf(this.enviroment.biomeVolume));
            details.add("underwater", Double.valueOf(this.enviroment.underwater));
            details.add("dim-name", AmbientTickHandler.mc.field_71441_e.field_73011_w.func_186058_p().func_186065_b());
            list.add(this.format(details));
            details.clear();
            for (Pair pair : this.enviroment.biomes) {
                details.add(((AmbientEnviroment.BiomeArea)pair.key).biome.func_185359_l(), pair.value);
            }
            list.add(this.format(details));
            details.clear();
            details.add("dimension", (Object)dimension);
            details.add("playing", (Object)this.engine.soundEngine.playingCount());
            details.add("light", (Object)this.enviroment.blocks.averageLight);
            details.add("outside", (Object)this.enviroment.blocks.outsideVolume);
            details.add("height", (Object)(df.format(this.enviroment.relativeHeight) + "," + df.format(this.enviroment.averageHeight) + "," + df.format(this.enviroment.player.field_70163_u - (double)this.enviroment.minHeight) + "," + df.format(this.enviroment.player.field_70163_u - (double)this.enviroment.maxHeight)));
            list.add(this.format(details));
            details.clear();
            for (AmbientRegion ambientRegion : this.engine.activeRegions) {
                details.add("region", (Object)(ChatFormatting.DARK_GREEN + ambientRegion.name + ChatFormatting.RESET));
                details.add("playing", (Object)ambientRegion.playing.size());
                list.add(this.format(details));
                details.clear();
                for (AmbientSound sound : ambientRegion.playing) {
                    if (!sound.isPlaying()) continue;
                    String text = "";
                    if (sound.stream1 != null) {
                        details.add("n", (Object)sound.stream1.location);
                        details.add("v", (Object)sound.stream1.volume);
                        details.add("i", (Object)sound.stream1.index);
                        details.add("p", (Object)sound.stream1.pitch);
                        details.add("t", (Object)sound.stream1.ticksPlayed);
                        details.add("d", (Object)sound.stream1.duration);
                        text = "[" + this.format(details) + "]";
                        details.clear();
                    }
                    if (sound.stream2 != null) {
                        details.add("n", (Object)sound.stream2.location);
                        details.add("v", (Object)sound.stream2.volume);
                        details.add("i", (Object)sound.stream2.index);
                        details.add("p", (Object)sound.stream2.pitch);
                        details.add("t", (Object)sound.stream2.ticksPlayed);
                        details.add("d", (Object)sound.stream2.duration);
                        text = text + "[" + this.format(details) + "]";
                        details.clear();
                    }
                    list.add(text);
                }
            }
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                if (Strings.isNullOrEmpty((String)string)) continue;
                int j = AmbientTickHandler.mc.field_71466_p.field_78288_b;
                int k = AmbientTickHandler.mc.field_71466_p.func_78256_a(string);
                int l = 2;
                int i1 = 2 + j * i;
                Gui.func_73734_a((int)1, (int)(i1 - 1), (int)(2 + k + 1), (int)(i1 + j - 1), (int)-1873784752);
                AmbientTickHandler.mc.field_71466_p.func_78276_b(string, 2, i1, 0xE0E0E0);
            }
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && this.engine != null) {
            WorldClient world = AmbientTickHandler.mc.field_71441_e;
            EntityPlayerSP player = AmbientTickHandler.mc.field_71439_g;
            if (world != null && player != null && AmbientTickHandler.mc.field_71474_y.func_186711_a(SoundCategory.AMBIENT) > 0.0f) {
                if (this.enviroment == null) {
                    this.enviroment = new AmbientEnviroment((EntityPlayer)player);
                }
                this.enviroment.dimension = this.engine.getDimension((World)world);
                if (this.timer % this.engine.enviromentTickTime == 0) {
                    this.enviroment.world = world;
                    this.enviroment.player = player;
                    this.enviroment.biomeVolume = 1.0;
                    this.enviroment.setHeight(this.engine.calculateAverageHeight((World)world, (EntityPlayer)player));
                    this.enviroment.biomeVolume = 1.0;
                    if (this.enviroment.dimension != null) {
                        this.enviroment.dimension.manipulateEnviroment(this.enviroment);
                    }
                    if (this.enviroment.biomeVolume > 0.0) {
                        this.enviroment.biomes = this.engine.calculateBiomes((World)world, (EntityPlayer)player, this.enviroment.biomeVolume);
                    } else if (this.enviroment.biomes != null) {
                        this.enviroment.biomes.clear();
                    } else {
                        this.enviroment.biomes = new PairList();
                    }
                    this.enviroment.blocks.updateAllDirections(this.engine);
                }
                if (this.timer % this.engine.soundTickTime == 0) {
                    this.enviroment.setSunAngle(world.func_72826_c(mc.func_184121_ak()));
                    this.enviroment.updateWorld();
                    int depth = 0;
                    if (player.func_70055_a(Material.field_151586_h)) {
                        AxisAlignedBB bb = player.func_174813_aQ().func_72314_b((double)-0.1f, (double)-0.4f, (double)-0.1f);
                        while (world.func_72875_a(bb, Material.field_151586_h)) {
                            ++depth;
                            bb = bb.func_72317_d(0.0, 1.0, 0.0);
                        }
                        --depth;
                    }
                    this.enviroment.setUnderwater(depth);
                    this.engine.tick(this.enviroment);
                }
                this.engine.fastTick(this.enviroment);
                ++this.timer;
            } else if (!this.engine.activeRegions.isEmpty()) {
                this.engine.stopEngine();
            }
        }
    }
}

