/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.ambientsounds;

import com.creativemd.ambientsounds.AmbientEngine;
import com.creativemd.ambientsounds.AmbientTickHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
@Mod(modid="ambientsounds", version="3.0", name="Ambient Sounds", acceptedMinecraftVersions="", clientSideOnly=true, dependencies="required-before:creativecore", guiFactory="com.creativemd.ambientsounds.AmbientSettings")
public class AmbientSounds {
    public static final String modid = "ambientsounds";
    public static final String version = "3.0";
    public static final Logger logger = LogManager.getLogger((String)"ambientsounds");
    public static Configuration config;
    public static boolean debugging;
    public static int streamingChannels;
    public static int normalChannels;
    public static AmbientTickHandler tickHandler;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        debugging = config.getBoolean("debugging", "Custom", false, "Useful if you want to modify the engine");
        streamingChannels = config.getInt("streamingChannels", "engine", streamingChannels, 1, 32, "Streaming + Normal channels may have to be 32 in total.");
        normalChannels = config.getInt("normalChannels", "engine", normalChannels, 1, 32, "Streaming + Normal channels may have to be 32 in total.");
        config.save();
        tickHandler = new AmbientTickHandler();
        MinecraftForge.EVENT_BUS.register((Object)tickHandler);
    }

    @Mod.EventHandler
    public void loadComplete(FMLInitializationEvent event) {
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandBase(){

            public String func_71518_a(ICommandSender sender) {
                return "reload ambient sound engine";
            }

            public String func_71517_b() {
                return "ambient-reload";
            }

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                if (AmbientSounds.tickHandler.engine != null) {
                    AmbientSounds.tickHandler.engine.stopEngine();
                }
                tickHandler.setEngine(AmbientEngine.loadAmbientEngine(AmbientSounds.tickHandler.soundEngine));
            }
        });
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandBase(){

            public String func_71518_a(ICommandSender sender) {
                return "show ambient engine debug info";
            }

            public String func_71517_b() {
                return "ambient-debug";
            }

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                AmbientSounds.tickHandler.showDebugInfo = !AmbientSounds.tickHandler.showDebugInfo;
            }
        });
        Minecraft minecraft = Minecraft.func_71410_x();
        IReloadableResourceManager reloadableResourceManager = (IReloadableResourceManager)minecraft.func_110442_L();
        reloadableResourceManager.func_110542_a(new IResourceManagerReloadListener(){

            public void func_110549_a(IResourceManager resourceManager) {
                if (AmbientSounds.tickHandler.engine != null) {
                    AmbientSounds.tickHandler.engine.stopEngine();
                }
                tickHandler.setEngine(AmbientEngine.loadAmbientEngine(AmbientSounds.tickHandler.soundEngine));
            }
        });
    }

    static {
        streamingChannels = 11;
        normalChannels = 21;
    }
}

