/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.DispenseFluidContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;

public class UniversalBucket
extends ain {
    private final int capacity;
    @Nonnull
    private final aip empty;
    private final boolean nbtSensitive;

    public UniversalBucket() {
        this(1000, new aip(air.az), false);
    }

    public UniversalBucket(int capacity, @Nonnull aip empty, boolean nbtSensitive) {
        this.capacity = capacity;
        this.empty = empty;
        this.nbtSensitive = nbtSensitive;
        this.d(1);
        this.b(ahp.f);
        apz.c.a((Object)this, (Object)DispenseFluidContainer.getInstance());
    }

    public boolean hasContainerItem(@Nonnull aip stack) {
        return !this.getEmpty().b();
    }

    @Nonnull
    public aip getContainerItem(@Nonnull aip itemStack) {
        if (!this.getEmpty().b()) {
            return this.getEmpty().l();
        }
        return super.getContainerItem(itemStack);
    }

    public void a(@Nullable ahp tab, @Nonnull fi<aip> subItems) {
        if (!this.a(tab)) {
            return;
        }
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            FluidStack fs;
            aip stack;
            FluidBucketWrapper fluidHandler;
            if (fluid == FluidRegistry.WATER || fluid == FluidRegistry.LAVA || fluid.getName().equals("milk") || (fluidHandler = new FluidBucketWrapper(stack = new aip((ain)this))).fill(fs = new FluidStack(fluid, this.getCapacity()), true) != fs.amount) continue;
            aip filled = fluidHandler.getContainer();
            subItems.add((Object)filled);
        }
    }

    @Nonnull
    public String b(@Nonnull aip stack) {
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack == null) {
            if (!this.getEmpty().b()) {
                return this.getEmpty().r();
            }
            return super.b(stack);
        }
        String unloc = this.j(stack);
        if (ft.c((String)(unloc + "." + fluidStack.getFluid().getName()))) {
            return ft.a((String)(unloc + "." + fluidStack.getFluid().getName()));
        }
        return ft.a((String)(unloc + ".name"), (Object[])new Object[]{fluidStack.getLocalizedName()});
    }

    @Nonnull
    public ue<aip> a(@Nonnull amu world, @Nonnull aed player, @Nonnull ub hand) {
        FluidActionResult result;
        et targetPos;
        aip itemstack = player.b(hand);
        FluidStack fluidStack = this.getFluid(itemstack);
        if (fluidStack == null) {
            return ue.newResult((ud)ud.b, (Object)itemstack);
        }
        bhc mop = this.a(world, player, false);
        ue<aip> ret = ForgeEventFactory.onBucketUse(player, world, itemstack, mop);
        if (ret != null) {
            return ret;
        }
        if (mop == null || mop.a != bhc.a.b) {
            return ue.newResult((ud)ud.b, (Object)itemstack);
        }
        et clickPos = mop.a();
        if (world.a(player, clickPos) && player.a(targetPos = clickPos.a(mop.b), mop.b, itemstack) && (result = FluidUtil.tryPlaceFluid(player, world, targetPos, itemstack, fluidStack)).isSuccess() && !player.bO.d) {
            aip emptyStack;
            player.b(qs.b((ain)this));
            itemstack.g(1);
            aip drained = result.getResult();
            aip aip2 = emptyStack = !drained.b() ? drained.l() : new aip((ain)this);
            if (itemstack.b()) {
                return ue.newResult((ud)ud.a, (Object)emptyStack);
            }
            ItemHandlerHelper.giveItemToPlayer(player, emptyStack);
            return ue.newResult((ud)ud.a, (Object)itemstack);
        }
        return ue.newResult((ud)ud.c, (Object)itemstack);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onFillBucket(FillBucketEvent event) {
        if (event.getResult() != Event.Result.DEFAULT) {
            return;
        }
        aip emptyBucket = event.getEmptyBucket();
        if (emptyBucket.b() || !emptyBucket.a(this.getEmpty()) || this.isNbtSensitive() && aip.a((aip)emptyBucket, (aip)this.getEmpty())) {
            return;
        }
        bhc target = event.getTarget();
        if (target == null || target.a != bhc.a.b) {
            return;
        }
        amu world = event.getWorld();
        et pos = target.a();
        aip singleBucket = emptyBucket.l();
        singleBucket.e(1);
        FluidActionResult filledResult = FluidUtil.tryPickUpFluid(singleBucket, event.getEntityPlayer(), world, pos, target.b);
        if (filledResult.isSuccess()) {
            event.setResult(Event.Result.ALLOW);
            event.setFilledBucket(filledResult.getResult());
        } else {
            event.setCanceled(true);
        }
    }

    @Deprecated
    @Nonnull
    public static aip getFilledBucket(@Nonnull UniversalBucket item, Fluid fluid) {
        return FluidUtil.getFilledBucket(new FluidStack(fluid, 1000));
    }

    @Nullable
    public FluidStack getFluid(@Nonnull aip container) {
        return FluidStack.loadFluidStackFromNBT(container.p());
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Nonnull
    public aip getEmpty() {
        return this.empty;
    }

    public boolean isNbtSensitive() {
        return this.nbtSensitive;
    }

    @Nullable
    public String getCreatorModId(@Nonnull aip itemStack) {
        FluidStack fluidStack = this.getFluid(itemStack);
        String modId = FluidRegistry.getModId(fluidStack);
        return modId != null ? modId : super.getCreatorModId(itemStack);
    }

    public ICapabilityProvider initCapabilities(@Nonnull aip stack, fy nbt) {
        return new FluidBucketWrapper(stack);
    }
}

