/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.view.impl.server;

import com.mojang.authlib.GameProfile;
import de.johni0702.minecraft.betterportals.common.ExtensionsKt;
import de.johni0702.minecraft.view.impl.net.CreateWorld;
import de.johni0702.minecraft.view.impl.net.DestroyWorld;
import de.johni0702.minecraft.view.impl.net.NetKt;
import de.johni0702.minecraft.view.impl.net.Transaction;
import de.johni0702.minecraft.view.impl.net.WorldData;
import de.johni0702.minecraft.view.impl.server.NettyExceptionHandler;
import de.johni0702.minecraft.view.impl.server.ServerWorldManager;
import de.johni0702.minecraft.view.impl.server.ServerWorldsManagerImpl;
import de.johni0702.minecraft.view.impl.server.VanillaView;
import de.johni0702.minecraft.view.impl.server.ViewEntity;
import de.johni0702.minecraft.view.server.CubeSelector;
import de.johni0702.minecraft.view.server.ServerWorldsManager;
import de.johni0702.minecraft.view.server.View;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.embedded.EmbeddedChannel;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.EnumPacketDirection;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NettyPacketEncoder;
import net.minecraft.network.NettyVarint21FrameEncoder;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001CB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u001fJ\b\u0010.\u001a\u00020,H\u0016J)\u0010/\u001a\u00020,2\u0006\u00100\u001a\u00020\u001f2\u0017\u00101\u001a\u0013\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020,02\u00a2\u0006\u0002\b3H\u0016J\u0010\u00104\u001a\u00020\f2\u0006\u00105\u001a\u00020\u001fH\u0002J\b\u00106\u001a\u00020,H\u0002J\u0010\u00107\u001a\u00020,2\u0006\u00108\u001a\u00020\fH\u0002J\b\u00109\u001a\u00020,H\u0016J\b\u0010:\u001a\u00020,H\u0016J\u0010\u0010;\u001a\u00020\f2\u0006\u00105\u001a\u00020\u001fH\u0002J\u0010\u0010<\u001a\u00020,2\u0006\u0010=\u001a\u00020!H\u0016J\u001c\u0010>\u001a\u00020,2\u0006\u00105\u001a\u00020\u001f2\n\u0010?\u001a\u0006\u0012\u0002\b\u00030@H\u0016J\b\u0010A\u001a\u00020,H\u0002J\u0006\u0010B\u001a\u00020,R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR&\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u001d\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\f0%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010#R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001f0(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006D"}, d2={"Lde/johni0702/minecraft/view/impl/server/ServerWorldsManagerImpl;", "Lde/johni0702/minecraft/view/server/ServerWorldsManager;", "server", "Lnet/minecraft/server/MinecraftServer;", "connection", "Lnet/minecraft/network/NetHandlerPlayServer;", "(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/network/NetHandlerPlayServer;)V", "getConnection", "()Lnet/minecraft/network/NetHandlerPlayServer;", "eventHandler", "Lde/johni0702/minecraft/view/impl/server/ServerWorldsManagerImpl$EventHandler;", "mainWorldManager", "Lde/johni0702/minecraft/view/impl/server/ServerWorldManager;", "getMainWorldManager", "()Lde/johni0702/minecraft/view/impl/server/ServerWorldManager;", "needsUpdate", "", "getNeedsUpdate", "()Z", "setNeedsUpdate", "(Z)V", "player", "Lnet/minecraft/entity/player/EntityPlayerMP;", "getPlayer", "()Lnet/minecraft/entity/player/EntityPlayerMP;", "setPlayer", "(Lnet/minecraft/entity/player/EntityPlayerMP;)V", "getServer", "()Lnet/minecraft/server/MinecraftServer;", "views", "", "Lnet/minecraft/world/WorldServer;", "", "Lde/johni0702/minecraft/view/server/View;", "getViews", "()Ljava/util/Map;", "worldManagers", "", "getWorldManagers", "worlds", "", "getWorlds", "()Ljava/util/List;", "beforeTransferToDimension", "", "destination", "beginTransaction", "changeDimension", "newWorld", "updatePosition", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "createWorldManager", "world", "destroy", "destroyWorldManager", "manager", "endTransaction", "flushPackets", "getOrCreateWorldManager", "registerView", "view", "sendPacket", "packet", "Lnet/minecraft/network/Packet;", "tick", "updateActiveViews", "EventHandler", "bp-master_view"})
public final class ServerWorldsManagerImpl
implements ServerWorldsManager {
    @NotNull
    private final Map<WorldServer, ServerWorldManager> worldManagers;
    private boolean needsUpdate;
    @NotNull
    private EntityPlayerMP player;
    private final EventHandler eventHandler;
    @NotNull
    private final MinecraftServer server;
    @NotNull
    private final NetHandlerPlayServer connection;

    @NotNull
    public final Map<WorldServer, ServerWorldManager> getWorldManagers() {
        return this.worldManagers;
    }

    @NotNull
    public final ServerWorldManager getMainWorldManager() {
        Map<WorldServer, ServerWorldManager> map = this.worldManagers;
        World world2 = this.connection.field_147369_b.field_70170_p;
        boolean bl = false;
        ServerWorldManager serverWorldManager = map.get(world2);
        if (serverWorldManager == null) {
            throw (Throwable)new IllegalStateException("Missing world manager for " + this.connection.field_147369_b.field_70170_p);
        }
        return serverWorldManager;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<WorldServer, List<View>> getViews() {
        void $this$mapValuesTo$iv$iv;
        Map<WorldServer, ServerWorldManager> $this$mapValues$iv = this.worldManagers;
        boolean $i$f$mapValues = false;
        Map<WorldServer, ServerWorldManager> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            boolean bl2 = false;
            List<View> list = ((ServerWorldManager)it.getValue()).getViews();
            map3.put(k2, list);
        }
        return destination$iv$iv;
    }

    public final boolean getNeedsUpdate() {
        return this.needsUpdate;
    }

    public final void setNeedsUpdate(boolean bl) {
        this.needsUpdate = bl;
    }

    @Override
    public void registerView(@NotNull View view2) {
        Intrinsics.checkParameterIsNotNull((Object)view2, (String)"view");
        this.getOrCreateWorldManager(view2.getWorld()).getViews().add(view2);
        this.needsUpdate = true;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateActiveViews() {
        Object object;
        Iterator $this$mapValuesTo$iv$iv;
        VanillaView vanillaView;
        Object object2;
        boolean bl;
        this.server.field_71304_b.func_76320_a("updateActiveViews");
        boolean bl2 = false;
        Map anchorDistances = new LinkedHashMap();
        PriorityQueue queuedViews2 = new PriorityQueue(Comparator.comparing(new Function<T, U>(anchorDistances){
            final /* synthetic */ Map $anchorDistances;

            public final int apply(View it) {
                V v = this.$anchorDistances.get(it);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                return ((Number)v).intValue();
            }
            {
                this.$anchorDistances = map;
            }
        }));
        if (!this.getPlayer().func_193105_t()) {
            Map<WorldServer, ServerWorldManager> map = this.worldManagers;
            WorldServer worldServer = this.getPlayer().func_71121_q();
            boolean bl3 = false;
            Map<WorldServer, ServerWorldManager> map2 = map;
            boolean bl4 = false;
            boolean bl5 = map2.containsKey(worldServer);
            bl = false;
            bl3 = false;
            if (!bl5) {
                boolean bl6 = false;
                String string = "Player changed world without us noticing. Did some third-party mod do something weird?";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            VanillaView vanillaView2 = new VanillaView(this, this.getPlayer());
            object2 = queuedViews2;
            bl = false;
            bl3 = false;
            VanillaView it = vanillaView2;
            boolean bl7 = false;
            anchorDistances.put(it, 0);
            vanillaView = vanillaView2;
            ((PriorityQueue)object2).add(vanillaView);
        }
        bl = false;
        Map anchoredViews = new LinkedHashMap();
        Map<WorldServer, ServerWorldManager> $this$mapValues$iv = this.worldManagers;
        boolean $i$f$mapValues = false;
        Map<WorldServer, ServerWorldManager> bl7 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl8 = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            vanillaView = k;
            object2 = map;
            boolean bl9 = false;
            boolean bl10 = false;
            Map map3 = new LinkedHashMap();
            bl10 = false;
            object = new LinkedHashSet();
            Set set = object;
            Map map4 = map3;
            Pair pair = new Pair((Object)map4, (Object)set);
            object2.put(vanillaView, pair);
        }
        Map trackedViews = destination$iv$iv;
        Object $this$forEach$iv = this.worldManagers.values();
        boolean $i$f$forEach = false;
        $this$mapValuesTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$mapValuesTo$iv$iv.hasNext()) {
            Object element$iv = $this$mapValuesTo$iv$iv.next();
            ServerWorldManager worldManager = (ServerWorldManager)element$iv;
            boolean bl11 = false;
            Iterable $this$forEach$iv2 = worldManager.getViews();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object3;
                void $this$getOrPut$iv;
                Object it;
                View it2 = (View)element$iv2;
                boolean bl12 = false;
                Pair<WorldServer, Vec3i> anchor = it2.getAnchor();
                if (anchor == null) {
                    it = it2;
                    PriorityQueue bl9 = queuedViews2;
                    boolean bl13 = false;
                    boolean bl14 = false;
                    Object it3 = it;
                    boolean bl15 = false;
                    anchorDistances.put(it3, 0);
                    object = it;
                    bl9.add(object);
                    continue;
                }
                it = anchoredViews;
                Object key$iv = anchor.getFirst();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl16 = false;
                    boolean bl17 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object3 = answer$iv;
                } else {
                    object3 = value$iv;
                }
                ((List)object3).add(it2);
            }
        }
        block3: while ((View)queuedViews2.poll() != null) {
            View view2;
            WorldServer world2 = view2.getWorld();
            Object v = anchorDistances.get(view2);
            if (v == null) {
                Intrinsics.throwNpe();
            }
            int anchorDistance = ((Number)v).intValue();
            CubeSelector selector = view2.getCubeSelector().withAnchorDistance(anchorDistance);
            Object worldManager = MapsKt.getValue((Map)trackedViews, (Object)world2);
            boolean bl11 = false;
            boolean $this$forEach$iv2 = false;
            Pair $dstr$activeViews$activeSelectors = (Pair)worldManager;
            boolean bl18 = false;
            Object activeViews2 = (Map)$dstr$activeViews$activeSelectors.component1();
            Set activeSelectors = (Set)$dstr$activeViews$activeSelectors.component2();
            activeViews2.put(view2, anchorDistance);
            activeSelectors.add(selector);
            int portalDistance = view2.getAnchor() != null ? view2.getPortalDistance() : 0;
            int centerDistance = anchorDistance + portalDistance;
            Vec3i centerCube = ExtensionsKt.toCubePos((Vec3i)ExtensionsKt.toBlockPos(view2.getCenter()));
            List list = (List)anchoredViews.get(view2.getWorld());
            if (list == null) continue;
            Iterable $this$forEach$iv3 = list;
            boolean $i$f$forEach3 = false;
            activeViews2 = $this$forEach$iv3.iterator();
            while (true) {
                int oldOtherAnchorDist;
                boolean otherAnchorNearViewCenter;
                if (!activeViews2.hasNext()) continue block3;
                Object element$iv = activeViews2.next();
                View other = (View)element$iv;
                boolean bl19 = false;
                Pair<WorldServer, Vec3i> pair = other.getAnchor();
                if (pair == null) {
                    Intrinsics.throwNpe();
                }
                Vec3i otherAnchorPos = (Vec3i)pair.getSecond();
                boolean bl20 = otherAnchorNearViewCenter = ExtensionsKt.isCubicWorld((World)world2) ? selector.isCubeIncluded(otherAnchorPos) : selector.isColumnIncluded(new ChunkPos(otherAnchorPos.func_177958_n(), otherAnchorPos.func_177952_p()));
                if (!otherAnchorNearViewCenter) continue;
                double d = centerCube.func_177951_i(otherAnchorPos);
                boolean bl21 = false;
                d = Math.sqrt(d);
                bl21 = false;
                int distCenterToOtherAnchor = (int)Math.ceil(d);
                int newOtherAnchorDist = centerDistance + distCenterToOtherAnchor;
                Integer n = (Integer)anchorDistances.get(other);
                int n2 = oldOtherAnchorDist = n != null ? n : Integer.MAX_VALUE;
                if (oldOtherAnchorDist <= newOtherAnchorDist) continue;
                queuedViews2.remove(other);
                anchorDistances.put(other, newOtherAnchorDist);
                queuedViews2.offer(other);
            }
        }
        $this$forEach$iv = trackedViews;
        $i$f$forEach = false;
        Object object4 = $this$forEach$iv;
        boolean bl22 = false;
        Iterator iterator = object4.entrySet().iterator();
        while (iterator.hasNext()) {
            void activeViews;
            Pair value;
            Map.Entry element$iv;
            Map.Entry $dstr$world$value = element$iv = iterator.next();
            boolean bl23 = false;
            Object $i$f$forEach3 = $dstr$world$value;
            boolean activeViews2 = false;
            WorldServer world3 = (WorldServer)$i$f$forEach3.getKey();
            $i$f$forEach3 = $dstr$world$value;
            activeViews2 = false;
            Pair bl19 = value = (Pair)$i$f$forEach3.getValue();
            $i$f$forEach3 = (Map)bl19.component1();
            Set activeSelectors = (Set)bl19.component2();
            ServerWorldManager manager = (ServerWorldManager)MapsKt.getValue(this.worldManagers, (Object)world3);
            manager.setActiveViews((Map<View, Integer>)activeViews);
            manager.setActiveSelectors(activeSelectors);
        }
        this.needsUpdate = false;
        this.server.field_71304_b.func_76319_b();
    }

    @Override
    @NotNull
    public List<WorldServer> getWorlds() {
        return CollectionsKt.toList((Iterable)this.worldManagers.keySet());
    }

    @Override
    public void changeDimension(@NotNull WorldServer newWorld, @NotNull Function1<? super EntityPlayerMP, Unit> updatePosition) {
        Intrinsics.checkParameterIsNotNull((Object)newWorld, (String)"newWorld");
        Intrinsics.checkParameterIsNotNull(updatePosition, (String)"updatePosition");
        this.getOrCreateWorldManager(newWorld).makeMainWorld$bp_master_view(updatePosition);
        this.needsUpdate = true;
    }

    public final void beforeTransferToDimension(@NotNull WorldServer destination) {
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.worldManagers.values());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerWorldManager it = (ServerWorldManager)element$iv;
            boolean bl = false;
            if (!(it.getPlayer() instanceof ViewEntity)) continue;
            this.destroyWorldManager(it);
        }
        boolean bl = this.worldManagers.size() == 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "More than one non-view world?!";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        WorldServer worldServer = this.getPlayer().func_71121_q();
        Intrinsics.checkExpressionValueIsNotNull((Object)worldServer, (String)"player.serverWorld");
        worldServer.func_184164_w().func_72695_c(this.getPlayer());
        this.worldManagers.clear();
        EntityPlayerMP entityPlayerMP = this.connection.field_147369_b;
        Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayerMP, (String)"connection.player");
        this.worldManagers.put(destination, new ServerWorldManager(this, destination, entityPlayerMP));
    }

    @Override
    @NotNull
    public EntityPlayerMP getPlayer() {
        return this.player;
    }

    public void setPlayer(@NotNull EntityPlayerMP entityPlayerMP) {
        Intrinsics.checkParameterIsNotNull((Object)entityPlayerMP, (String)"<set-?>");
        this.player = entityPlayerMP;
    }

    private final ServerWorldManager getOrCreateWorldManager(WorldServer world2) {
        ServerWorldManager serverWorldManager = this.worldManagers.get(world2);
        if (serverWorldManager == null) {
            serverWorldManager = this.createWorldManager(world2);
        }
        return serverWorldManager;
    }

    private final ServerWorldManager createWorldManager(WorldServer world2) {
        Field stateField;
        EmbeddedChannel channel = new EmbeddedChannel();
        UUID uUID = UUID.randomUUID();
        StringBuilder stringBuilder = new StringBuilder();
        EntityPlayerMP entityPlayerMP = this.connection.field_147369_b;
        Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayerMP, (String)"connection.player");
        GameProfile gameProfile = new GameProfile(uUID, stringBuilder.append(entityPlayerMP.func_70005_c_()).append("[view]").toString());
        ViewEntity camera2 = new ViewEntity(world2, gameProfile, this.connection, channel);
        ChannelPipeline channelPipeline = channel.pipeline().addLast("prepender", (ChannelHandler)new NettyVarint21FrameEncoder()).addLast("encoder", (ChannelHandler)new NettyPacketEncoder(EnumPacketDirection.CLIENTBOUND)).addLast("exception_handler", (ChannelHandler)new NettyExceptionHandler(this.connection));
        NetHandlerPlayServer netHandlerPlayServer = camera2.field_71135_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)netHandlerPlayServer, (String)"camera.connection");
        channelPipeline.addLast("packet_handler", (ChannelHandler)netHandlerPlayServer.func_147362_b()).fireChannelActive();
        NetHandlerPlayServer netHandlerPlayServer2 = camera2.field_71135_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)netHandlerPlayServer2, (String)"camera.connection");
        netHandlerPlayServer2.func_147362_b().func_150723_a(EnumConnectionState.PLAY);
        NetHandlerPlayServer netHandlerPlayServer3 = camera2.field_71135_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)netHandlerPlayServer3, (String)"camera.connection");
        NetworkDispatcher networkDispatcher = NetworkDispatcher.allocAndSet((NetworkManager)netHandlerPlayServer3.func_147362_b(), (PlayerList)this.server.func_184103_al());
        channel.pipeline().addBefore("packet_handler", "fml:packet_handler", (ChannelHandler)networkDispatcher);
        channel.attr(NetworkRegistry.FML_MARKER).set((Object)true);
        Field field = stateField = NetworkDispatcher.class.getDeclaredField("state");
        Intrinsics.checkExpressionValueIsNotNull((Object)field, (String)"stateField");
        Class<Enum> clazz = field.getType().asSubclass(Enum.class);
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"stateField.type.asSubclass(Enum::class.java)");
        Object[] objectArray = clazz.getEnumConstants();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"stateField.type.asSubcla\u2026class.java).enumConstants");
        Enum connectedState = (Enum)ArraysKt.last((Object[])objectArray);
        stateField.setAccessible(true);
        stateField.set(networkDispatcher, connectedState);
        ServerWorldManager worldManager = new ServerWorldManager(this, world2, camera2);
        this.worldManagers.put(world2, worldManager);
        int n = camera2.field_71093_bK;
        WorldProvider worldProvider = world2.field_73011_w;
        Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"world.provider");
        String string = worldProvider.func_186058_p().name();
        EnumDifficulty enumDifficulty = world2.func_175659_aa();
        WorldInfo worldInfo = world2.func_72912_H();
        Intrinsics.checkExpressionValueIsNotNull((Object)worldInfo, (String)"world.worldInfo");
        IMessage iMessage = new CreateWorld(n, string, enumDifficulty, worldInfo.func_76077_q(), world2.func_175624_G());
        EntityPlayerMP[] entityPlayerMPArray = new EntityPlayerMP[1];
        EntityPlayerMP entityPlayerMP2 = this.connection.field_147369_b;
        Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayerMP2, (String)"connection.player");
        entityPlayerMPArray[0] = entityPlayerMP2;
        NetKt.sendTo(iMessage, entityPlayerMPArray);
        world2.func_72838_d((Entity)camera2);
        this.server.func_184103_al().func_72375_a((EntityPlayerMP)camera2, null);
        this.server.func_184103_al().func_72354_b((EntityPlayerMP)camera2, world2);
        camera2.field_71135_a.func_147364_a(camera2.field_70165_t, camera2.field_70163_u, camera2.field_70161_v, camera2.field_70177_z, camera2.field_70125_A);
        this.flushPackets();
        return worldManager;
    }

    private final void destroyWorldManager(ServerWorldManager manager) {
        NetworkManager networkManager = this.connection.field_147371_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)networkManager, (String)"connection.netManager");
        if (!networkManager.func_150724_d()) {
            return;
        }
        this.flushPackets();
        WorldProvider worldProvider = manager.getWorld().field_73011_w;
        Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"manager.world.provider");
        IMessage iMessage = new DestroyWorld(worldProvider.getDimension());
        EntityPlayerMP[] entityPlayerMPArray = new EntityPlayerMP[1];
        EntityPlayerMP entityPlayerMP = this.connection.field_147369_b;
        Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayerMP, (String)"connection.player");
        entityPlayerMPArray[0] = entityPlayerMP;
        NetKt.sendTo(iMessage, entityPlayerMPArray);
        EntityPlayerMP player = manager.getPlayer();
        WorldServer world2 = manager.getWorld();
        world2.func_72900_e((Entity)player);
        world2.func_184164_w().func_72695_c(player);
        boolean bl = this.worldManagers.remove(manager.getWorld(), manager);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "unknown manager " + manager;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    private final void destroy() {
        this.eventHandler.setRegistered(false);
        Iterable $this$forEach$iv = MapsKt.toList(this.worldManagers);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ViewEntity player;
            Pair $dstr$world$manager = (Pair)element$iv;
            boolean bl = false;
            WorldServer world2 = (WorldServer)$dstr$world$manager.component1();
            ServerWorldManager manager = (ServerWorldManager)$dstr$world$manager.component2();
            EntityPlayerMP entityPlayerMP = manager.getPlayer();
            if (!(entityPlayerMP instanceof ViewEntity)) {
                entityPlayerMP = null;
            }
            if ((ViewEntity)entityPlayerMP == null) {
                continue;
            }
            world2.func_72900_e((Entity)player);
            world2.func_184164_w().func_72695_c((EntityPlayerMP)player);
            this.worldManagers.remove(world2);
        }
    }

    private final void tick() {
        if (this.needsUpdate) {
            this.updateActiveViews();
        }
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.worldManagers.values());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerWorldManager manager = (ServerWorldManager)element$iv;
            boolean bl = false;
            manager.getViews().removeIf(tick.1.1.INSTANCE);
            if (manager.getActiveViews().keySet().removeIf(tick.1.2.INSTANCE)) {
                manager.setNeedsUpdate(true);
            }
            if (manager.getNeedsUpdate()) {
                manager.getWorld().func_184164_w().func_72685_d(manager.getPlayer());
                manager.getWorld().func_73039_n().func_180245_a(manager.getPlayer());
            }
            if (!manager.getViews().isEmpty() || !(manager.getPlayer() instanceof ViewEntity)) continue;
            this.destroyWorldManager(manager);
        }
        this.flushPackets();
    }

    @Override
    public void sendPacket(@NotNull WorldServer world2, @NotNull Packet<?> packet) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)world2, (String)"world");
            Intrinsics.checkParameterIsNotNull(packet, (String)"packet");
            ServerWorldManager serverWorldManager = this.worldManagers.get(world2);
            if (serverWorldManager == null || (serverWorldManager = serverWorldManager.getPlayer()) == null || (serverWorldManager = ((EntityPlayerMP)serverWorldManager).field_71135_a) == null) break block0;
            serverWorldManager.func_147359_a(packet);
        }
    }

    @Override
    public void flushPackets() {
        Function1 flushEntityPackets2 = flushPackets.flushEntityPackets.1.INSTANCE;
        EntityPlayerMP entityPlayerMP = this.connection.field_147369_b;
        Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayerMP, (String)"connection.player");
        flushEntityPackets2.invoke((Object)entityPlayerMP);
        Iterable $this$forEach$iv = this.worldManagers.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerWorldManager it = (ServerWorldManager)element$iv;
            boolean bl = false;
            flushEntityPackets2.invoke((Object)it.getPlayer());
        }
        $this$forEach$iv = this.worldManagers.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            ServerWorldManager manager = (ServerWorldManager)element$iv;
            boolean bl = false;
            EntityPlayerMP entityPlayerMP2 = manager.getPlayer();
            if (!(entityPlayerMP2 instanceof ViewEntity)) {
                entityPlayerMP2 = null;
            }
            if ((object = (ViewEntity)entityPlayerMP2) == null || (object = ((ViewEntity)((Object)object)).getChannel()) == null || (object = object.outboundMessages()) == null) continue;
            Iterable $this$onEach$iv = (Iterable)object;
            boolean $i$f$onEach = false;
            Iterable iterable = $this$onEach$iv;
            boolean bl2 = false;
            boolean bl3 = false;
            Iterable $this$apply$iv = iterable;
            boolean bl4 = false;
            Iterator iterator = $this$apply$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv2;
                Object it = element$iv2 = iterator.next();
                boolean bl5 = false;
                WorldProvider worldProvider = manager.getWorld().field_73011_w;
                Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"manager.world.provider");
                Object t = it;
                if (t == null) {
                    throw new TypeCastException("null cannot be cast to non-null type io.netty.buffer.ByteBuf");
                }
                IMessage iMessage = new WorldData(worldProvider.getDimension(), (ByteBuf)t);
                EntityPlayerMP[] entityPlayerMPArray = new EntityPlayerMP[1];
                EntityPlayerMP entityPlayerMP3 = this.connection.field_147369_b;
                Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayerMP3, (String)"connection.player");
                entityPlayerMPArray[0] = entityPlayerMP3;
                NetKt.sendTo(iMessage, entityPlayerMPArray);
            }
            object = (Queue)iterable;
            if (object == null) continue;
            object.clear();
        }
    }

    @Override
    public void beginTransaction() {
        this.flushPackets();
        this.connection.func_147359_a((Packet)new SPacketCustomPayload("BP/view|TS", new PacketBuffer(Unpooled.EMPTY_BUFFER)));
        NetKt.sendTo((IMessage)new Transaction(Transaction.Phase.START), this.getPlayer());
    }

    @Override
    public void endTransaction() {
        this.flushPackets();
        NetKt.sendTo((IMessage)new Transaction(Transaction.Phase.END), this.getPlayer());
        this.connection.func_147359_a((Packet)new SPacketCustomPayload("BP/view|TE", new PacketBuffer(Unpooled.EMPTY_BUFFER)));
    }

    @NotNull
    public final MinecraftServer getServer() {
        return this.server;
    }

    @NotNull
    public final NetHandlerPlayServer getConnection() {
        return this.connection;
    }

    public ServerWorldsManagerImpl(@NotNull MinecraftServer server2, @NotNull NetHandlerPlayServer connection) {
        WorldServer world2;
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)server2, (String)"server");
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        this.server = server2;
        this.connection = connection;
        ServerWorldsManagerImpl serverWorldsManagerImpl = this;
        boolean bl = false;
        serverWorldsManagerImpl.worldManagers = map = (Map)new LinkedHashMap();
        EntityPlayerMP entityPlayerMP = this.connection.field_147369_b;
        Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayerMP, (String)"connection.player");
        WorldServer worldServer = world2 = entityPlayerMP.func_71121_q();
        Intrinsics.checkExpressionValueIsNotNull((Object)worldServer, (String)"world");
        EntityPlayerMP entityPlayerMP2 = this.connection.field_147369_b;
        Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayerMP2, (String)"connection.player");
        this.worldManagers.put(worldServer, new ServerWorldManager(this, world2, entityPlayerMP2));
        EntityPlayerMP entityPlayerMP3 = this.connection.field_147369_b;
        Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayerMP3, (String)"connection.player");
        this.player = entityPlayerMP3;
        this.eventHandler = new EventHandler();
        this.eventHandler.setRegistered(true);
    }

    @Override
    @NotNull
    public View createView(@NotNull WorldServer world2, @NotNull Vec3d pos, @Nullable Pair<? extends WorldServer, ? extends Vec3i> anchor) {
        Intrinsics.checkParameterIsNotNull((Object)world2, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return ServerWorldsManager.DefaultImpls.createView(this, world2, pos, anchor);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0015H\u0007R+\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lde/johni0702/minecraft/view/impl/server/ServerWorldsManagerImpl$EventHandler;", "", "(Lde/johni0702/minecraft/view/impl/server/ServerWorldsManagerImpl;)V", "<set-?>", "", "registered", "getRegistered", "()Z", "setRegistered", "(Z)V", "registered$delegate", "Lkotlin/properties/ReadWriteProperty;", "onPlayerLeft", "", "event", "Lnet/minecraftforge/fml/common/gameevent/PlayerEvent$PlayerLoggedOutEvent;", "onPlayerRespawn", "Lnet/minecraftforge/event/entity/player/PlayerEvent$Clone;", "onWorldUnload", "Lnet/minecraftforge/event/world/WorldEvent$Unload;", "postTick", "Lnet/minecraftforge/fml/common/gameevent/TickEvent$ServerTickEvent;", "bp-master_view"})
    private final class EventHandler {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty registered$delegate = ExtensionsKt.provideDelegate(MinecraftForge.EVENT_BUS, this, $$delegatedProperties[0]);

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(EventHandler.class), "registered", "getRegistered()Z"))};
        }

        public final boolean getRegistered() {
            return (Boolean)this.registered$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setRegistered(boolean bl) {
            this.registered$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
        }

        @SubscribeEvent
        public final void onPlayerLeft(@NotNull PlayerEvent.PlayerLoggedOutEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            EntityPlayer entityPlayer = event.player;
            if (!(entityPlayer instanceof EntityPlayerMP)) {
                entityPlayer = null;
            }
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)entityPlayer;
            if ((entityPlayerMP != null ? entityPlayerMP.field_71135_a : null) == ServerWorldsManagerImpl.this.getConnection()) {
                ServerWorldsManagerImpl.this.destroy();
            }
        }

        @SubscribeEvent
        public final void postTick(@NotNull TickEvent.ServerTickEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            ServerWorldsManagerImpl.this.tick();
        }

        @SubscribeEvent
        public final void onWorldUnload(@NotNull WorldEvent.Unload event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            Map<WorldServer, ServerWorldManager> map = ServerWorldsManagerImpl.this.getWorldManagers();
            World world2 = event.getWorld();
            boolean bl = false;
            ServerWorldManager serverWorldManager = map.get(world2);
            if (serverWorldManager == null) {
                return;
            }
            ServerWorldManager manager = serverWorldManager;
            if (manager.getPlayer() instanceof ViewEntity) {
                ServerWorldsManagerImpl.this.destroyWorldManager(manager);
            }
        }

        @SubscribeEvent
        public final void onPlayerRespawn(@NotNull PlayerEvent.Clone event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            EntityPlayer player = event.getEntityPlayer();
            if (player instanceof EntityPlayerMP && ((EntityPlayerMP)player).field_71135_a == ServerWorldsManagerImpl.this.getConnection()) {
                WorldServer newWorld = ((EntityPlayerMP)player).func_71121_q();
                Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)ServerWorldsManagerImpl.this.getWorldManagers().values());
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ServerWorldManager it = (ServerWorldManager)element$iv;
                    boolean bl = false;
                    if (it.getPlayer() instanceof ViewEntity) {
                        ServerWorldsManagerImpl.this.destroyWorldManager(it);
                        continue;
                    }
                    ServerWorldsManagerImpl.this.getWorldManagers().remove(it.getWorld());
                }
                Map<WorldServer, ServerWorldManager> map = ServerWorldsManagerImpl.this.getWorldManagers();
                WorldServer worldServer = newWorld;
                Intrinsics.checkExpressionValueIsNotNull((Object)worldServer, (String)"newWorld");
                map.put(worldServer, new ServerWorldManager(ServerWorldsManagerImpl.this, newWorld, (EntityPlayerMP)player));
                ServerWorldsManagerImpl.this.setPlayer((EntityPlayerMP)player);
            }
        }
    }
}

