/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.view.impl.mixin;

import de.johni0702.minecraft.view.impl.ClientViewAPIImpl;
import de.johni0702.minecraft.view.impl.client.ClientState;
import de.johni0702.minecraft.view.impl.client.ClientWorldsManagerImpl;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.profiler.Profiler;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@SideOnly(value=Side.CLIENT)
@Mixin(value={WorldClient.class})
public abstract class MixinWorldClient
extends World {
    @Shadow
    @Final
    private Minecraft field_73037_M;
    @Shadow
    @Final
    private Set<Entity> field_73036_L;

    protected MixinWorldClient(ISaveHandler saveHandlerIn, WorldInfo info, WorldProvider providerIn, Profiler profilerIn, boolean client2) {
        super(saveHandlerIn, info, providerIn, profilerIn, client2);
    }

    @Inject(method={"getEntityByID"}, at={@At(value="HEAD")}, cancellable=true)
    private void getPlayerEntityByID(int entityId, CallbackInfoReturnable<Entity> ci) {
        ClientWorldsManagerImpl viewManager = ClientViewAPIImpl.INSTANCE.getViewManagerImpl();
        for (ClientState view2 : viewManager.getViews()) {
            WorldClient world2 = view2.getWorld();
            if (world2 != this) continue;
            if (viewManager.getActiveView() == view2) {
                if (this.field_73037_M.field_71439_g == null) {
                    ci.setReturnValue(super.func_73045_a(entityId));
                }
            } else {
                EntityPlayerSP player = view2.getThePlayer();
                if (player != null && player.func_145782_y() == entityId) {
                    ci.setReturnValue((Entity)player);
                } else {
                    ci.setReturnValue(super.func_73045_a(entityId));
                }
            }
            return;
        }
    }

    @Inject(method={"removeEntity"}, at={@At(value="HEAD")})
    private void removeEntityFromSpawnQueue(Entity entity, CallbackInfo ci) {
        this.field_73036_L.remove(entity);
    }
}

