/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.view.impl.mixin;

import de.johni0702.minecraft.view.impl.compat.OFVertexBuffer;
import de.johni0702.minecraft.view.impl.compat.OFViewFrustum;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import kotlin.Pair;
import net.minecraft.client.renderer.ViewFrustum;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.optifine.render.VboRegion;
import org.apache.commons.lang3.mutable.MutableInt;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@SideOnly(value=Side.CLIENT)
@Mixin(value={ViewFrustum.class})
public abstract class MixinViewFrustum_OF
implements OFViewFrustum {
    private boolean vboRegionsEnabled = MixinViewFrustum_OF.queryVboRegionsEnabled();
    private Deque<VboRegion[]> freeVboRegions = new ArrayDeque<VboRegion[]>();
    private Map<BlockPos, Pair<VboRegion[], MutableInt>> vboRegions = new HashMap<BlockPos, Pair<VboRegion[], MutableInt>>();

    private BlockPos getRegionPos(RenderChunk chunk) {
        BlockPos p = chunk.func_178568_j();
        return new BlockPos(p.func_177958_n() & 0xFFFFFF00, p.func_177956_o() & 0xFFFFFF00, p.func_177952_p() & 0xFFFFFF00);
    }

    @Override
    public void refVboRegion(RenderChunk chunk) {
        if (!this.vboRegionsEnabled) {
            return;
        }
        Pair pair = this.vboRegions.computeIfAbsent(this.getRegionPos(chunk), pos_ -> new Pair((Object)this.allocVboRegion(), (Object)new MutableInt()));
        ((MutableInt)pair.getSecond()).increment();
        VboRegion[] array = (VboRegion[])pair.getFirst();
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            ((OFVertexBuffer)chunk.func_178565_b(layer.ordinal())).setVboRegion(array[layer.ordinal()]);
        }
    }

    @Override
    public void unrefVboRegion(RenderChunk chunk) {
        if (!this.vboRegionsEnabled) {
            return;
        }
        BlockPos pos = this.getRegionPos(chunk);
        Pair<VboRegion[], MutableInt> pair = this.vboRegions.get(pos);
        assert (pair != null);
        if (((MutableInt)pair.getSecond()).decrementAndGet() > 0) {
            return;
        }
        this.vboRegions.remove(pos);
        this.freeVboRegion((VboRegion[])pair.getFirst());
    }

    private VboRegion[] allocVboRegion() {
        VboRegion[] region = this.freeVboRegions.pollFirst();
        if (region == null) {
            region = new VboRegion[BlockRenderLayer.values().length];
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                region[layer.ordinal()] = new VboRegion(layer);
            }
        }
        return region;
    }

    private void freeVboRegion(VboRegion[] region) {
        this.freeVboRegions.offerFirst(region);
    }

    @Inject(method={"deleteGlResources"}, at={@At(value="HEAD")})
    private void deleteGlResources(CallbackInfo ci) {
        for (VboRegion[] vboRegionArray : this.freeVboRegions) {
            for (VboRegion region : vboRegionArray) {
                region.deleteGlBuffers();
            }
        }
        this.freeVboRegions.clear();
        for (Pair pair : this.vboRegions.values()) {
            for (VboRegion region : (VboRegion[])pair.getFirst()) {
                region.deleteGlBuffers();
            }
        }
        this.vboRegions.clear();
    }

    private static boolean queryVboRegionsEnabled() {
        try {
            Class<?> config = Class.forName("Config");
            boolean isVbo = (Boolean)config.getDeclaredMethod("isVbo", new Class[0]).invoke(null, new Object[0]);
            boolean isRenderRegions = (Boolean)config.getDeclaredMethod("isRenderRegions", new Class[0]).invoke(null, new Object[0]);
            return isVbo && isRenderRegions;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

