/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.view.impl.mixin;

import de.johni0702.minecraft.betterportals.common.ExtensionsKt;
import de.johni0702.minecraft.view.client.ClientViewAPI;
import de.johni0702.minecraft.view.client.render.RenderPass;
import de.johni0702.minecraft.view.impl.compat.OFRenderChunk;
import de.johni0702.minecraft.view.impl.compat.OFViewFrustum;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.ViewFrustum;
import net.minecraft.client.renderer.chunk.IRenderChunkFactory;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableInt;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@SideOnly(value=Side.CLIENT)
@Mixin(value={ViewFrustum.class}, priority=900)
public abstract class MixinViewFrustum {
    @Shadow
    protected int field_178165_d;
    @Shadow
    protected int field_178168_c;
    @Shadow
    protected int field_178166_e;
    @Shadow
    @Final
    protected World field_178167_b;
    @Shadow
    public RenderChunk[] field_178164_f;
    @Shadow
    @Final
    protected RenderGlobal field_178169_a;
    private RenderPass prevRootPass;
    private IRenderChunkFactory chunkFactory;
    private Deque<RenderChunk> freeChunks = new ArrayDeque<RenderChunk>();
    private Map<BlockPos, Pair<RenderChunk, MutableInt>> chunkMap = new HashMap<BlockPos, Pair<RenderChunk, MutableInt>>();
    private Set<BlockPos> unusedChunkArrays = new HashSet<BlockPos>();
    private Map<BlockPos, RenderChunk[]> chunkArrayCache = new HashMap<BlockPos, RenderChunk[]>();

    @Shadow
    protected abstract int func_178157_a(int var1, int var2, int var3);

    @Inject(method={"createRenderChunks"}, at={@At(value="HEAD")}, cancellable=true)
    private void createDefaultArray(IRenderChunkFactory renderChunkFactory, CallbackInfo ci) {
        this.chunkFactory = renderChunkFactory;
        this.field_178164_f = this.getOrCreateChunkArray(Vec3d.field_186680_a);
        ci.cancel();
    }

    private void gcUnusedChunkArrays() {
        for (BlockPos pos : this.unusedChunkArrays) {
            RenderChunk[] array = this.chunkArrayCache.remove(pos);
            assert (array != null);
            for (RenderChunk chunk : array) {
                this.unrefChunk(chunk.func_178568_j());
            }
        }
        this.unusedChunkArrays.clear();
        this.unusedChunkArrays.addAll(this.chunkArrayCache.keySet());
    }

    private void touchChunkArrays(RenderPass renderPass) {
        if (renderPass.getWorld() == this.field_178167_b) {
            Vec3d pos = renderPass.getCamera().getFeetPosition();
            if (!ExtensionsKt.isCubicWorld(this.field_178167_b)) {
                pos = new Vec3d(pos.field_72450_a, 8.0, pos.field_72449_c);
            }
            this.getOrCreateChunkArray(pos);
        }
        for (RenderPass child : renderPass.getChildren()) {
            this.touchChunkArrays(child);
        }
    }

    @Inject(method={"updateChunkPositions"}, at={@At(value="HEAD")}, cancellable=true)
    private void loadChunkArray(double x, double z, CallbackInfo ci) {
        ci.cancel();
        Minecraft mc = Minecraft.func_71410_x();
        RenderPass currRootPass = ClientViewAPI.getInstance().getRenderPassManager(mc).getRoot();
        if (this.prevRootPass != currRootPass) {
            this.prevRootPass = currRootPass;
            this.gcUnusedChunkArrays();
            this.touchChunkArrays(currRootPass);
        }
        if (ExtensionsKt.isCubicWorld(this.field_178167_b)) {
            Entity view2 = mc.func_175606_aa();
            this.field_178164_f = this.getOrCreateChunkArray(ExtensionsKt.getPos(view2));
        } else {
            this.field_178164_f = this.getOrCreateChunkArray(new Vec3d(x, 8.0, z));
        }
    }

    private RenderChunk[] getOrCreateChunkArray(Vec3d viewPos) {
        int viewX = MathHelper.func_76128_c((double)viewPos.field_72450_a) - 8;
        int viewY = MathHelper.func_76128_c((double)viewPos.field_72448_b) - 8;
        int viewZ = MathHelper.func_76128_c((double)viewPos.field_72449_c) - 8;
        BlockPos pos = new BlockPos(viewX & 0xFFFFFFF0, viewY & 0xFFFFFFF0, viewZ & 0xFFFFFFF0);
        return this.getOrCreateChunkArray(pos);
    }

    private RenderChunk[] getOrCreateChunkArray(BlockPos center) {
        this.unusedChunkArrays.remove(center);
        return this.chunkArrayCache.computeIfAbsent(center, this::createChunkArray);
    }

    private RenderChunk[] createChunkArray(BlockPos center) {
        int xSizeInChunks = this.field_178165_d;
        int ySizeInChunks = this.field_178168_c;
        int zSizeInChunks = this.field_178166_e;
        RenderChunk[] array = new RenderChunk[xSizeInChunks * ySizeInChunks * zSizeInChunks];
        int xSizeInBlocks = xSizeInChunks * 16;
        int ySizeInBlocks = ySizeInChunks * 16;
        int zSizeInBlocks = zSizeInChunks * 16;
        boolean isCubic = ExtensionsKt.isCubicWorld(this.field_178167_b);
        for (int xIndex = 0; xIndex < xSizeInChunks; ++xIndex) {
            int blockX = this.func_178157_a(center.func_177958_n(), xSizeInBlocks, xIndex);
            for (int yIndex = 0; yIndex < ySizeInChunks; ++yIndex) {
                int blockY = isCubic ? this.func_178157_a(center.func_177956_o(), ySizeInBlocks, yIndex) : yIndex * 16;
                for (int zIndex = 0; zIndex < zSizeInChunks; ++zIndex) {
                    RenderChunk chunk;
                    int blockZ = this.func_178157_a(center.func_177952_p(), zSizeInBlocks, zIndex);
                    array[(zIndex * ySizeInChunks + yIndex) * xSizeInChunks + xIndex] = chunk = this.refChunk(new BlockPos(blockX, blockY, blockZ));
                }
            }
        }
        return array;
    }

    private RenderChunk refChunk(BlockPos pos) {
        Pair pair = this.chunkMap.computeIfAbsent(pos, pos_ -> new Pair((Object)this.allocChunk((BlockPos)pos_), (Object)new MutableInt()));
        ((MutableInt)pair.getSecond()).increment();
        return (RenderChunk)pair.getFirst();
    }

    private void unrefChunk(BlockPos pos) {
        Pair<RenderChunk, MutableInt> pair = this.chunkMap.get(pos);
        assert (pair != null);
        if (((MutableInt)pair.getSecond()).decrementAndGet() > 0) {
            return;
        }
        this.chunkMap.remove(pos);
        this.freeChunk((RenderChunk)pair.getFirst());
    }

    private RenderChunk allocChunk(BlockPos pos) {
        RenderChunk chunk = this.freeChunks.pollFirst();
        if (chunk == null) {
            chunk = this.chunkFactory.func_189565_a(this.field_178167_b, this.field_178169_a, 0);
        }
        chunk.func_189562_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        chunk.func_178575_a(false);
        if (chunk instanceof OFRenderChunk) {
            OFRenderChunk ofChunk = (OFRenderChunk)chunk;
            RenderChunk[] neighbours = ofChunk.getRenderChunkNeighbours();
            for (EnumFacing facing : EnumFacing.values()) {
                RenderChunk neighbour;
                Pair<RenderChunk, MutableInt> neighbourPair = this.chunkMap.get(pos.func_177967_a(facing, 16));
                if (neighbourPair == null) continue;
                neighbours[facing.ordinal()] = neighbour = (RenderChunk)neighbourPair.getFirst();
                ((OFRenderChunk)neighbour).getRenderChunkNeighbours()[facing.func_176734_d().ordinal()] = chunk;
            }
            ofChunk.setRenderChunkNeighboursUpdated(true);
        }
        if (this instanceof OFViewFrustum) {
            ((OFViewFrustum)((Object)this)).refVboRegion(chunk);
        }
        return chunk;
    }

    private void freeChunk(RenderChunk chunk) {
        chunk.func_178585_h();
        this.freeChunks.offerFirst(chunk);
        if (chunk instanceof OFRenderChunk) {
            OFRenderChunk ofChunk = (OFRenderChunk)chunk;
            RenderChunk[] neighbours = ofChunk.getRenderChunkNeighbours();
            for (EnumFacing facing : EnumFacing.values()) {
                RenderChunk neighbour = neighbours[facing.ordinal()];
                if (neighbour == null) continue;
                neighbours[facing.ordinal()] = null;
                ((OFRenderChunk)neighbour).getRenderChunkNeighbours()[facing.func_176734_d().ordinal()] = null;
            }
            ofChunk.setRenderChunkNeighboursUpdated(true);
        }
        if (this instanceof OFViewFrustum) {
            ((OFViewFrustum)((Object)this)).unrefVboRegion(chunk);
        }
    }

    @Inject(method={"deleteGlResources"}, at={@At(value="HEAD")})
    private void deleteGlResources(CallbackInfo ci) {
        for (RenderChunk renderChunk : this.freeChunks) {
            renderChunk.func_178566_a();
        }
        this.freeChunks.clear();
        for (Pair pair : this.chunkMap.values()) {
            ((RenderChunk)pair.getFirst()).func_178566_a();
        }
        this.chunkMap.clear();
        this.chunkArrayCache.clear();
        this.unusedChunkArrays.clear();
    }

    @Inject(method={"markBlocksForUpdate"}, at={@At(value="HEAD")}, cancellable=true)
    private void markBlocksForUpdate(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean updateImmediately, CallbackInfo ci) {
        minX &= 0xFFFFFFF0;
        minY &= 0xFFFFFFF0;
        minZ &= 0xFFFFFFF0;
        maxX &= 0xFFFFFFF0;
        maxY &= 0xFFFFFFF0;
        maxZ &= 0xFFFFFFF0;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = minX; x <= maxX; x += 16) {
            for (int y = minY; y <= maxY; y += 16) {
                for (int z = minZ; z <= maxZ; z += 16) {
                    pos.func_181079_c(x, y, z);
                    Pair<RenderChunk, MutableInt> pair = this.chunkMap.get(pos);
                    if (pair == null) continue;
                    ((RenderChunk)pair.getFirst()).func_178575_a(updateImmediately);
                }
            }
        }
        ci.cancel();
    }
}

