/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.view.impl.mixin;

import de.johni0702.minecraft.betterportals.common.ExtensionsKt;
import de.johni0702.minecraft.view.client.render.ChunkVisibilityDetail;
import de.johni0702.minecraft.view.client.render.RenderPass;
import de.johni0702.minecraft.view.impl.client.render.ViewChunkRenderDispatcher;
import de.johni0702.minecraft.view.impl.client.render.ViewRenderManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@SideOnly(value=Side.CLIENT)
@Mixin(value={RenderGlobal.class})
public abstract class MixinRenderGlobal {
    @Shadow
    @Final
    private Minecraft field_72777_q;
    private static int globalRefreshCount = 0;
    private int refreshCount = globalRefreshCount;
    private boolean ignoreRefresh = false;
    @Shadow
    private double field_147596_f;
    @Shadow
    private double field_147597_g;
    @Shadow
    private double field_147602_h;

    @Shadow
    public abstract void func_72712_a();

    @Redirect(method={"loadRenderers"}, at=@At(value="NEW", target="net/minecraft/client/renderer/chunk/ChunkRenderDispatcher"))
    private ChunkRenderDispatcher createChunkRenderDispatcher() {
        return new ViewChunkRenderDispatcher();
    }

    @Redirect(method={"setupTerrain"}, at=@At(value="NEW", target="net/minecraft/util/math/BlockPos", ordinal=0))
    private BlockPos getChunkVisibilityFloodFillOrigin(double orgX, double orgY, double orgZ) {
        BlockPos origin;
        RenderPass current = ViewRenderManager.Companion.getINSTANCE().getCurrent();
        if (current != null && (origin = current.get(ChunkVisibilityDetail.class).getOrigin()) != null) {
            return origin;
        }
        return new BlockPos(orgX, orgY, orgZ);
    }

    @Inject(method={"loadRenderers"}, at={@At(value="HEAD")})
    private void refreshOtherViews(CallbackInfo ci) {
        if (!this.ignoreRefresh) {
            this.refreshCount = ++globalRefreshCount;
        }
    }

    @Inject(method={"setWorldAndLoadRenderers"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderGlobal;loadRenderers()V")})
    private void beforeLoadRenderers(WorldClient world2, CallbackInfo ci) {
        this.ignoreRefresh = true;
    }

    @Inject(method={"setWorldAndLoadRenderers"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderGlobal;loadRenderers()V", shift=At.Shift.AFTER)})
    private void afterLoadRenderers(WorldClient world2, CallbackInfo ci) {
        this.ignoreRefresh = false;
    }

    @Inject(method={"setupTerrain"}, at={@At(value="HEAD")})
    private void refreshIfOtherViewRefreshed(Entity viewEntity, double partialTicks, ICamera camera2, int frameCount, boolean playerSpectator, CallbackInfo ci) {
        if (this.refreshCount != globalRefreshCount) {
            this.refreshCount = globalRefreshCount;
            this.ignoreRefresh = true;
            this.func_72712_a();
            this.ignoreRefresh = false;
        }
    }

    @Redirect(method={"loadRenderers"}, at=@At(value="FIELD", target="Lnet/minecraft/client/settings/GameSettings;renderDistanceChunks:I", opcode=180))
    private int getRealRenderDistance$0(GameSettings gameSettings) {
        return ViewRenderManager.Companion.getINSTANCE().getRealRenderDistanceChunks();
    }

    @Redirect(method={"setupTerrain"}, slice=@Slice(to=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderGlobal;loadRenderers()V")), at=@At(value="FIELD", target="Lnet/minecraft/client/settings/GameSettings;renderDistanceChunks:I", opcode=180))
    private int getRealRenderDistance$1(GameSettings gameSettings) {
        return ViewRenderManager.Companion.getINSTANCE().getRealRenderDistanceChunks();
    }

    @Redirect(method={"setupTerrain"}, slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderGlobal;loadRenderers()V")), at=@At(value="FIELD", target="Lnet/minecraft/client/renderer/RenderGlobal;renderDistanceChunks:I", opcode=180))
    private int getFakeRenderDistance(RenderGlobal renderGlobal) {
        return this.field_72777_q.field_71474_y.field_151451_c;
    }

    private boolean isMainView() {
        RenderPass pass = ViewRenderManager.Companion.getINSTANCE().getCurrent();
        if (pass != null) {
            Vec3d playerEyePos = this.field_72777_q.field_71439_g.func_174824_e(this.field_72777_q.func_184121_ak());
            Vec3d cameraEyePos = pass.getCamera().getEyePosition();
            return ExtensionsKt.approxEquals(cameraEyePos, playerEyePos, 1.0E-4);
        }
        return false;
    }

    @Redirect(method={"renderBlockLayer(Lnet/minecraft/util/BlockRenderLayer;DILnet/minecraft/entity/Entity;)I"}, at=@At(value="FIELD", opcode=180, target="Lnet/minecraft/entity/Entity;posX:D"))
    private double getPlayerXForTransparencySort(Entity entity) {
        return this.isMainView() ? this.field_72777_q.field_71439_g.field_70165_t : this.field_147596_f;
    }

    @Redirect(method={"renderBlockLayer(Lnet/minecraft/util/BlockRenderLayer;DILnet/minecraft/entity/Entity;)I"}, at=@At(value="FIELD", opcode=180, target="Lnet/minecraft/entity/Entity;posY:D"))
    private double getPlayerYForTransparencySort(Entity entity) {
        return this.isMainView() ? this.field_72777_q.field_71439_g.field_70163_u : this.field_147597_g;
    }

    @Redirect(method={"renderBlockLayer(Lnet/minecraft/util/BlockRenderLayer;DILnet/minecraft/entity/Entity;)I"}, at=@At(value="FIELD", opcode=180, target="Lnet/minecraft/entity/Entity;posZ:D"))
    private double getPlayerZForTransparencySort(Entity entity) {
        return this.isMainView() ? this.field_72777_q.field_71439_g.field_70161_v : this.field_147602_h;
    }
}

