/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.view.impl.mixin;

import de.johni0702.minecraft.view.impl.server.ViewAdvancements;
import de.johni0702.minecraft.view.impl.server.ViewEntity;
import de.johni0702.minecraft.view.impl.server.ViewStatsManager;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ITeleporter;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerList.class})
public abstract class MixinPlayerList {
    @Shadow
    @Final
    private MinecraftServer field_72400_f;

    @Shadow
    public abstract void transferEntityToWorld(Entity var1, int var2, WorldServer var3, WorldServer var4, ITeleporter var5);

    @Inject(method={"sendPacketToAllPlayers"}, at={@At(value="HEAD")})
    private void sendPacketToAllViews(Packet<?> packetIn, CallbackInfo ci) {
        for (Integer dimension : DimensionManager.getIDs()) {
            this.sendPacketToAllViewsInDimension(packetIn, dimension, ci);
        }
    }

    @Inject(method={"sendPacketToAllPlayersInDimension"}, at={@At(value="HEAD")})
    private void sendPacketToAllViewsInDimension(Packet<?> packetIn, int dimension, CallbackInfo ci) {
        for (EntityPlayer entity : this.field_72400_f.func_71218_a((int)dimension).field_73010_i) {
            if (!(entity instanceof ViewEntity)) continue;
            ((ViewEntity)entity).field_71135_a.func_147359_a(packetIn);
        }
    }

    @Inject(method={"sendToAllNearExcept"}, at={@At(value="HEAD")})
    private void sendPacketToAllViewsNearExcept(EntityPlayer except, double x, double y, double z, double radius, int dimension, Packet<?> packetIn, CallbackInfo ci) {
        for (EntityPlayer entity : this.field_72400_f.func_71218_a((int)dimension).field_73010_i) {
            double dz;
            double dy;
            double dx;
            if (!(entity instanceof ViewEntity) || entity == except || !((dx = x - entity.field_70165_t) * dx + (dy = y - entity.field_70163_u) * dy + (dz = z - entity.field_70161_v) * dz < radius * radius)) continue;
            ((ViewEntity)entity).field_71135_a.func_147359_a(packetIn);
        }
    }

    @Inject(method={"getPlayerAdvancements"}, at={@At(value="HEAD")}, cancellable=true)
    private void getPlayerAdvancementsForViewEntity(EntityPlayerMP player, CallbackInfoReturnable<PlayerAdvancements> ci) {
        if (player instanceof ViewEntity) {
            ci.setReturnValue(new ViewAdvancements(this.field_72400_f, player));
        }
    }

    @Inject(method={"getPlayerStatsFile"}, at={@At(value="HEAD")}, cancellable=true)
    private void getPlayerStatsForViewEntity(EntityPlayer player, CallbackInfoReturnable<StatisticsManagerServer> ci) {
        if (player instanceof ViewEntity) {
            ci.setReturnValue(new ViewStatsManager());
        }
    }
}

