/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.view.impl.mixin;

import de.johni0702.minecraft.view.impl.ViewAPIImplKt;
import de.johni0702.minecraft.view.impl.server.PlayerCubeMapHandler;
import de.johni0702.minecraft.view.impl.server.ServerWorldManager;
import de.johni0702.minecraft.view.impl.server.ServerWorldManagerKt;
import de.johni0702.minecraft.view.impl.server.ServerWorldsManagerImpl;
import io.github.opencubicchunks.cubicchunks.api.util.CubePos;
import io.github.opencubicchunks.cubicchunks.core.CubicChunks;
import io.github.opencubicchunks.cubicchunks.core.server.ChunkGc;
import io.github.opencubicchunks.cubicchunks.core.server.CubeWatcher;
import io.github.opencubicchunks.cubicchunks.core.server.PlayerCubeMap;
import io.github.opencubicchunks.cubicchunks.core.visibility.CubeSelector;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.WorldServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerCubeMap.class})
public abstract class MixinPlayerCubeMap_CC
extends PlayerChunkMap {
    @Shadow(remap=false)
    @Final
    private ChunkGc chunkGc;
    @Shadow(remap=false)
    private int horizontalViewDistance;
    @Shadow(remap=false)
    private int verticalViewDistance;
    private Function<ChunkPos, PlayerChunkMapEntry> getOrCreateColumnWatcherFunc;
    private EntityPlayerMP player;

    @Shadow(remap=false)
    protected abstract CubeWatcher getOrCreateCubeWatcher(@Nonnull CubePos var1);

    @Shadow(remap=false)
    protected abstract void setNeedSort();

    private CubeWatcher getOrCreateCubeWatcher(Vec3i cubePos) {
        return this.getOrCreateCubeWatcher(new CubePos(cubePos.func_177958_n(), cubePos.func_177956_o(), cubePos.func_177952_p()));
    }

    private PlayerChunkMapEntry invokeGetOrCreateColumnWatcher(ChunkPos chunkPos) {
        if (this.getOrCreateColumnWatcherFunc == null) {
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                MethodHandle handle = lookup.unreflect(((Object)((Object)this)).getClass().getDeclaredMethod("getOrCreateColumnWatcher", ChunkPos.class));
                this.getOrCreateColumnWatcherFunc = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(Function.class, ((Object)((Object)this)).getClass()), MethodType.methodType(Object.class, Object.class), handle, MethodType.methodType(PlayerChunkMapEntry.class, ChunkPos.class)).getTarget().invoke(this);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return this.getOrCreateColumnWatcherFunc.apply(chunkPos);
    }

    public MixinPlayerCubeMap_CC(WorldServer serverWorld) {
        super(serverWorld);
    }

    @Redirect(method={"addPlayer"}, at=@At(value="INVOKE", target="Ljava/util/List;contains(Ljava/lang/Object;)Z", remap=false))
    private boolean forceAddDuringSwap(List list, Object o) {
        if (PlayerCubeMapHandler.INSTANCE.getSwapInProgress()) {
            return true;
        }
        return list.contains(o);
    }

    @Inject(method={"addPlayer", "removePlayer", "updateMovingPlayer"}, at={@At(value="HEAD")})
    private void recordPlayerArgument(EntityPlayerMP player, CallbackInfo ci) {
        this.player = player;
    }

    @Redirect(method={"addPlayer"}, at=@At(value="INVOKE", target="Lio/github/opencubicchunks/cubicchunks/core/visibility/CubeSelector;forAllVisibleFrom(Lio/github/opencubicchunks/cubicchunks/api/util/CubePos;IILjava/util/function/Consumer;)V", remap=false))
    private void addPlayerWithViews(CubeSelector self, CubePos playerPos, int horizontalViewDist, int verticalViewDist, Consumer<CubePos> func) {
        ServerWorldsManagerImpl worldsManager = ViewAPIImplKt.getWorldsManagerImpl(this.player);
        ServerWorldManager worldManager = worldsManager.getWorldManagers().get(this.func_72688_a());
        if (PlayerCubeMapHandler.INSTANCE.getSwapInProgress()) {
            PlayerChunkMapEntry watcher;
            for (ChunkPos columnPos : worldManager.getTrackedColumns()) {
                watcher = this.invokeGetOrCreateColumnWatcher(columnPos);
                watcher.func_187276_a(this.player);
            }
            for (Vec3i cubePos : worldManager.getTrackedCubes()) {
                watcher = this.getOrCreateCubeWatcher(cubePos);
                ServerWorldManagerKt.addPlayer((CubeWatcher)watcher, this.player);
            }
        } else {
            worldsManager.updateActiveViews();
            worldManager.updateTrackedColumnsAndCubes((Function1<? super ChunkPos, ? extends PlayerChunkMapEntry>)((Function1)this::invokeGetOrCreateColumnWatcher), (Function1<? super Vec3i, ? extends CubeWatcher>)((Function1)this::getOrCreateCubeWatcher));
        }
    }

    @Redirect(method={"removePlayer"}, at=@At(value="INVOKE", target="Lio/github/opencubicchunks/cubicchunks/core/visibility/CubeSelector;forAllVisibleFrom(Lio/github/opencubicchunks/cubicchunks/api/util/CubePos;IILjava/util/function/Consumer;)V", remap=false))
    private void removePlayerWithViews(CubeSelector self, CubePos playerPos, int horizontalViewDist, int verticalViewDist, Consumer<CubePos> func) {
        CubeWatcher watcher;
        ServerWorldsManagerImpl worldsManager = ViewAPIImplKt.getWorldsManagerImpl(this.player);
        ServerWorldManager worldManager = worldsManager.getWorldManagers().get(this.func_72688_a());
        for (Vec3i cubePos : worldManager.getTrackedCubes()) {
            watcher = this.getOrCreateCubeWatcher(cubePos);
            ServerWorldManagerKt.removePlayer(watcher, this.player);
        }
        if (!PlayerCubeMapHandler.INSTANCE.getSwapInProgress()) {
            worldManager.getTrackedCubes().clear();
        }
        for (ChunkPos columnPos : worldManager.getTrackedColumns()) {
            watcher = this.invokeGetOrCreateColumnWatcher(columnPos);
            watcher.func_187277_b(this.player);
        }
        if (!PlayerCubeMapHandler.INSTANCE.getSwapInProgress()) {
            worldManager.getTrackedColumns().clear();
        }
    }

    @Inject(method={"updatePlayer"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void updateActiveViews(@Coerce Object entry, CubePos oldPos, CubePos newPos, CallbackInfo ci) {
        ViewAPIImplKt.getWorldsManagerImpl(this.player).updateActiveViews();
        ci.cancel();
    }

    @Inject(method={"updateMovingPlayer"}, at={@At(value="RETURN")})
    private void updateTrackedColumnsAndCubes(EntityPlayerMP player, CallbackInfo ci) {
        ServerWorldManager worldManager = ViewAPIImplKt.getWorldsManagerImpl(player).getWorldManagers().get(this.func_72688_a());
        if (worldManager.getNeedsUpdate()) {
            worldManager.updateTrackedColumnsAndCubes((Function1<? super ChunkPos, ? extends PlayerChunkMapEntry>)((Function1)this::invokeGetOrCreateColumnWatcher), (Function1<? super Vec3i, ? extends CubeWatcher>)((Function1)this::getOrCreateCubeWatcher));
            worldManager.setNeedsUpdate(false);
            this.setNeedSort();
            this.chunkGc.tick();
        }
    }

    @Inject(method={"setPlayerViewDistance"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void updateTrackedOnViewDistanceIncrease(int newHorizontalViewDistance, int newVerticalViewDistance, CallbackInfo ci) {
        ci.cancel();
        newHorizontalViewDistance = MathHelper.func_76125_a((int)newHorizontalViewDistance, (int)3, (int)(CubicChunks.hasOptifine() ? 64 : 32));
        newVerticalViewDistance = MathHelper.func_76125_a((int)newVerticalViewDistance, (int)3, (int)(CubicChunks.hasOptifine() ? 64 : 32));
        if (this.horizontalViewDistance == newHorizontalViewDistance && this.verticalViewDistance == newVerticalViewDistance) {
            return;
        }
        this.horizontalViewDistance = newHorizontalViewDistance;
        this.verticalViewDistance = newVerticalViewDistance;
        for (EntityPlayer player : new ArrayList(this.func_72688_a().field_73010_i)) {
            ServerWorldsManagerImpl worldsManager;
            if (!(player instanceof EntityPlayerMP) || (worldsManager = ViewAPIImplKt.getWorldsManagerImpl((EntityPlayerMP)player)) == null) continue;
            worldsManager.updateActiveViews();
            ServerWorldManager worldManager = worldsManager.getWorldManagers().get(this.func_72688_a());
            if (worldManager == null) continue;
            worldManager.updateTrackedColumnsAndCubes((Function1<? super ChunkPos, ? extends PlayerChunkMapEntry>)((Function1)this::invokeGetOrCreateColumnWatcher), (Function1<? super Vec3i, ? extends CubeWatcher>)((Function1)this::getOrCreateCubeWatcher));
        }
    }
}

