/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.view.impl.mixin;

import de.johni0702.minecraft.view.impl.ViewAPIImplKt;
import de.johni0702.minecraft.view.impl.server.ServerWorldManager;
import de.johni0702.minecraft.view.impl.server.ServerWorldsManagerImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerChunkMap.class})
public abstract class MixinPlayerChunkMap {
    @Shadow
    private int field_72698_e;
    @Shadow
    @Final
    public List<EntityPlayerMP> field_72699_b;
    @Shadow
    @Final
    private WorldServer field_72701_a;

    @Shadow
    protected abstract PlayerChunkMapEntry func_187302_c(int var1, int var2);

    private PlayerChunkMapEntry getOrCreateEntry(ChunkPos pos) {
        return this.func_187302_c(pos.field_77276_a, pos.field_77275_b);
    }

    @Shadow
    protected abstract void func_187306_e();

    @Shadow
    @Nullable
    public abstract PlayerChunkMapEntry func_187301_b(int var1, int var2);

    @Inject(method={"addPlayer"}, at={@At(value="HEAD")}, cancellable=true)
    private void addPlayerWithViews(EntityPlayerMP player, CallbackInfo ci) {
        ci.cancel();
        player.field_71131_d = player.field_70165_t;
        player.field_71132_e = player.field_70161_v;
        ServerWorldsManagerImpl worldsManager = ViewAPIImplKt.getWorldsManagerImpl(player);
        worldsManager.updateActiveViews();
        ServerWorldManager worldManager = worldsManager.getWorldManagers().get(this.field_72701_a);
        worldManager.updateTrackedColumns((Function1<? super ChunkPos, ? extends PlayerChunkMapEntry>)((Function1)this::getOrCreateEntry));
        this.field_72699_b.add(player);
        this.func_187306_e();
    }

    @Inject(method={"removePlayer"}, at={@At(value="HEAD")}, cancellable=true)
    private void removePlayerWithViews(EntityPlayerMP player, CallbackInfo ci) {
        ci.cancel();
        if (player.field_71135_a == null) {
            return;
        }
        ServerWorldsManagerImpl worldsManager = ViewAPIImplKt.getWorldsManagerImpl(player);
        ServerWorldManager worldManager = worldsManager.getWorldManagers().get(this.field_72701_a);
        for (ChunkPos pos : worldManager.getTrackedColumns()) {
            PlayerChunkMapEntry entry = this.func_187301_b(pos.field_77276_a, pos.field_77275_b);
            if (entry == null) continue;
            entry.func_187277_b(player);
        }
        worldManager.getTrackedColumns().clear();
        this.field_72699_b.remove(player);
        this.func_187306_e();
    }

    @Inject(method={"updateMovingPlayer"}, at={@At(value="HEAD")}, cancellable=true)
    private void updateMovingPlayerWithViews(EntityPlayerMP player, CallbackInfo ci) {
        double dZ;
        double dX;
        ci.cancel();
        ServerWorldsManagerImpl worldsManager = ViewAPIImplKt.getWorldsManagerImpl(player);
        ServerWorldManager worldManager = worldsManager.getWorldManagers().get(this.field_72701_a);
        if (worldsManager.getPlayer() == player && (dX = player.field_71131_d - player.field_70165_t) * dX + (dZ = player.field_71132_e - player.field_70161_v) * dZ >= 64.0) {
            boolean changeOnZ;
            boolean changeOnX = (int)player.field_70165_t >> 4 != (int)player.field_71131_d >> 4;
            boolean bl = changeOnZ = (int)player.field_70161_v >> 4 != (int)player.field_71132_e >> 4;
            if (changeOnX || changeOnZ) {
                player.field_71131_d = player.field_70165_t;
                player.field_71132_e = player.field_70161_v;
                worldsManager.updateActiveViews();
            }
        }
        if (worldManager.getNeedsUpdate()) {
            worldManager.updateTrackedColumns((Function1<? super ChunkPos, ? extends PlayerChunkMapEntry>)((Function1)this::getOrCreateEntry));
            worldManager.setNeedsUpdate(false);
            this.func_187306_e();
        }
    }

    @Inject(method={"setPlayerViewRadius"}, at={@At(value="HEAD")}, cancellable=true)
    private void setPlayerViewRadiusWithViews(int radius, CallbackInfo ci) {
        ci.cancel();
        radius = MathHelper.func_76125_a((int)radius, (int)3, (int)32);
        if (radius == this.field_72698_e) {
            return;
        }
        this.field_72698_e = radius;
        for (EntityPlayerMP player : new ArrayList<EntityPlayerMP>(this.field_72699_b)) {
            ServerWorldsManagerImpl worldsManager = ViewAPIImplKt.getWorldsManagerImpl(player);
            worldsManager.updateActiveViews();
            ServerWorldManager worldManager = worldsManager.getWorldManagers().get(this.field_72701_a);
            worldManager.updateTrackedColumns((Function1<? super ChunkPos, ? extends PlayerChunkMapEntry>)((Function1)this::getOrCreateEntry));
        }
        this.func_187306_e();
    }
}

