/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.view.impl.mixin;

import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import de.johni0702.minecraft.view.impl.client.ClientWorldsManagerImpl;
import java.io.File;
import java.net.Proxy;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@SideOnly(value=Side.CLIENT)
@Mixin(value={IntegratedServer.class})
public abstract class MixinIntegratedServer
extends MinecraftServer
implements ClientWorldsManagerImpl.IIntegratedServer {
    private final Queue<Runnable> clientStateUpdates = new ConcurrentLinkedQueue<Runnable>();
    private int clientRenderDistanceChunks = 10;
    private WorldClient clientWorld;
    private WorldInfo clientWorldInfo;

    public MixinIntegratedServer(File anvilFileIn, Proxy proxyIn, DataFixer dataFixerIn, YggdrasilAuthenticationService authServiceIn, MinecraftSessionService sessionServiceIn, GameProfileRepository profileRepoIn, PlayerProfileCache profileCacheIn) {
        super(anvilFileIn, proxyIn, dataFixerIn, authServiceIn, sessionServiceIn, profileRepoIn, profileCacheIn);
    }

    @Override
    public void updateClientState(@NotNull Minecraft mc) {
        int clientRenderDistanceChunks = mc.field_71474_y.field_151451_c;
        WorldClient clientWorld = mc.field_71441_e;
        WorldInfo clientWorldInfo = clientWorld == null ? null : new WorldInfo(clientWorld.func_72912_H());
        this.clientStateUpdates.offer(() -> {
            this.clientRenderDistanceChunks = clientRenderDistanceChunks;
            this.clientWorld = clientWorld;
            this.clientWorldInfo = clientWorldInfo;
        });
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void pollClientState(CallbackInfo ci) {
        Runnable update;
        while ((update = this.clientStateUpdates.poll()) != null) {
            update.run();
        }
    }

    @Redirect(method={"tick"}, at=@At(value="FIELD", opcode=180, target="Lnet/minecraft/client/settings/GameSettings;renderDistanceChunks:I"))
    private int getClientRenderDistanceChunks(GameSettings gameSettings) {
        return this.clientRenderDistanceChunks;
    }

    @Redirect(method={"tick"}, at=@At(value="FIELD", opcode=180, target="Lnet/minecraft/client/Minecraft;world:Lnet/minecraft/client/multiplayer/WorldClient;"))
    private WorldClient getClientWorld(Minecraft minecraft) {
        return this.clientWorld;
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/WorldClient;getWorldInfo()Lnet/minecraft/world/storage/WorldInfo;"))
    private WorldInfo getClientWorldInfo(WorldClient client2) {
        return this.clientWorldInfo;
    }
}

