/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.view.impl.mixin;

import java.util.WeakHashMap;
import kotlin.Triple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ForgeHooksClient.class}, remap=false)
public abstract class MixinForgeHooksClient {
    @Shadow
    private static boolean skyInit;
    @Shadow
    private static int skyRGBMultiplier;
    @Shadow
    private static int skyX;
    @Shadow
    private static int skyZ;
    private static WeakHashMap<World, Triple<Integer, Integer, Integer>> skyColorCache;

    @Inject(method={"getSkyBlendColour"}, at={@At(value="HEAD")})
    private static void loadSkyColorCache(World world2, BlockPos center, CallbackInfoReturnable<Integer> ci) {
        Triple<Integer, Integer, Integer> cache = skyColorCache.get(world2);
        if (cache != null) {
            skyInit = true;
            skyX = (Integer)cache.component1();
            skyZ = (Integer)cache.component2();
            skyRGBMultiplier = (Integer)cache.component3();
        } else {
            skyInit = false;
        }
    }

    @Inject(method={"getSkyBlendColour"}, at={@At(value="RETURN", ordinal=1)})
    private static void storeSkyColorCache(World world2, BlockPos center, CallbackInfoReturnable<Integer> ci) {
        skyColorCache.put(world2, (Triple<Integer, Integer, Integer>)new Triple((Object)skyX, (Object)skyZ, (Object)skyRGBMultiplier));
    }

    static {
        skyColorCache = new WeakHashMap();
    }
}

