/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.view.impl.mixin;

import de.johni0702.minecraft.betterportals.common.ExtensionsKt;
import de.johni0702.minecraft.view.impl.ViewAPIImplKt;
import de.johni0702.minecraft.view.impl.server.ServerWorldManager;
import de.johni0702.minecraft.view.impl.server.ServerWorldsManagerImpl;
import de.johni0702.minecraft.view.server.View;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.Vec3d;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityTrackerEntry.class})
public abstract class MixinEntityTrackerEntry {
    @Shadow
    private long field_73128_d;
    @Shadow
    private long field_73129_e;
    @Shadow
    private long field_73126_f;
    @Shadow
    @Final
    private int field_73130_b;
    @Shadow
    private int field_187262_f;
    @Shadow
    @Final
    private Entity field_73132_a;

    @Redirect(method={"updatePlayerEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityTrackerEntry;isVisibleTo(Lnet/minecraft/entity/player/EntityPlayerMP;)Z"))
    private boolean isVisibleToAnyViewLegacyCC(EntityTrackerEntry entityTrackerEntry, EntityPlayerMP player) {
        CallbackInfoReturnable<Boolean> ci = new CallbackInfoReturnable<Boolean>("", true);
        this.isVisibleToAnyView(player, ci);
        return ci.getReturnValue();
    }

    @Inject(method={"isVisibleTo"}, at={@At(value="HEAD")}, cancellable=true)
    private void isVisibleToAnyView(EntityPlayerMP player, CallbackInfoReturnable<Boolean> ci) {
        ServerWorldsManagerImpl worldsManager = ViewAPIImplKt.getWorldsManagerImpl(player);
        ServerWorldManager worldManager = worldsManager.getWorldManagers().get(player.func_71121_q());
        if (worldManager == null) {
            ci.setReturnValue(false);
            return;
        }
        boolean isCubic = ExtensionsKt.isCubicWorld(player.field_70170_p);
        int baseRange = Math.min(this.field_73130_b, this.field_187262_f);
        for (Map.Entry<View, Integer> entry : worldManager.getActiveViews().entrySet()) {
            Vec3d pos = entry.getKey().getCenter();
            int range = Math.max(0, baseRange - entry.getValue() * 16);
            double dx = pos.field_72450_a - (double)this.field_73128_d / 4096.0;
            double dy = pos.field_72448_b - (double)this.field_73129_e / 4096.0;
            double dz = pos.field_72449_c - (double)this.field_73126_f / 4096.0;
            if (!(dx >= (double)(-range)) || !(dx <= (double)range) || !(dz >= (double)(-range)) || !(dz <= (double)range) || isCubic && (!(dy >= (double)(-range)) || !(dy <= (double)range))) continue;
            ci.setReturnValue(this.field_73132_a.func_174827_a(player));
            return;
        }
        ci.setReturnValue(false);
    }
}

