/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.view.impl.client;

import de.johni0702.minecraft.view.client.ClientWorldsManager;
import de.johni0702.minecraft.view.impl.ViewAPIImplKt;
import de.johni0702.minecraft.view.impl.client.ClientState;
import de.johni0702.minecraft.view.impl.client.MainViewChange;
import de.johni0702.minecraft.view.impl.common.ExtensionsKt;
import io.netty.buffer.ByteBuf;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.Entity;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0002FGB\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020!2\u0017\u0010&\u001a\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020$0'\u00a2\u0006\u0002\b(H\u0016J\u000e\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020!J\u000e\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020\u0004J\u000e\u0010-\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u0004J\u000e\u0010.\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u0004J\u0016\u0010/\u001a\u00020$2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u00020$J.\u00105\u001a\u00020$2\u0006\u00106\u001a\u00020\u00042\u0017\u0010&\u001a\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020$0'\u00a2\u0006\u0002\b(H\u0000\u00a2\u0006\u0002\b7J\u0010\u00108\u001a\u00020$2\u0006\u00106\u001a\u00020\u0004H\u0002J\u000e\u00109\u001a\u00020$2\u0006\u00100\u001a\u000201J\b\u0010:\u001a\u00020$H\u0002J\b\u0010;\u001a\u00020$H\u0002J\u0006\u0010<\u001a\u00020$J\b\u0010=\u001a\u00020$H\u0002J\b\u0010>\u001a\u00020$H\u0002J\b\u0010?\u001a\u00020$H\u0002J'\u0010@\u001a\u0002HA\"\u0004\b\u0000\u0010A2\u0006\u0010,\u001a\u00020\u00042\f\u0010B\u001a\b\u0012\u0004\u0012\u0002HA0C\u00a2\u0006\u0002\u0010DJ'\u0010E\u001a\u0002HA\"\u0004\b\u0000\u0010A2\u0006\u0010,\u001a\u00020\u00042\f\u0010B\u001a\b\u0012\u0004\u0012\u0002HA0C\u00a2\u0006\u0002\u0010DR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0006\"\u0004\b\r\u0010\bR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0006R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001e\u00a8\u0006H"}, d2={"Lde/johni0702/minecraft/view/impl/client/ClientWorldsManagerImpl;", "Lde/johni0702/minecraft/view/client/ClientWorldsManager;", "()V", "activeView", "Lde/johni0702/minecraft/view/impl/client/ClientState;", "getActiveView", "()Lde/johni0702/minecraft/view/impl/client/ClientState;", "setActiveView", "(Lde/johni0702/minecraft/view/impl/client/ClientState;)V", "inUpdate", "", "mainView", "getMainView", "setMainView", "mc", "Lnet/minecraft/client/Minecraft;", "getMc", "()Lnet/minecraft/client/Minecraft;", "player", "Lnet/minecraft/client/entity/EntityPlayerSP;", "getPlayer", "()Lnet/minecraft/client/entity/EntityPlayerSP;", "serverMainView", "getServerMainView", "unconfirmedChanges", "", "Lde/johni0702/minecraft/view/impl/client/MainViewChange;", "unusedViews", "views", "getViews", "()Ljava/util/List;", "worlds", "", "Lnet/minecraft/client/multiplayer/WorldClient;", "getWorlds", "changeDimension", "", "newWorld", "updatePosition", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "createState", "world", "destroyState", "view", "getClientPlayer", "getServerPlayer", "handleWorldData", "dimensionId", "", "data", "Lio/netty/buffer/ByteBuf;", "init", "makeClientMainView", "newMainView", "makeClientMainView$bp_master_view", "makeMainView", "makeMainViewAck", "preRender", "reset", "rewindMainView", "stopMusic", "tickView", "tickViews", "updateState", "T", "block", "Lkotlin/Function0;", "(Lde/johni0702/minecraft/view/impl/client/ClientState;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withView", "EventHandler", "IIntegratedServer", "bp-master_view"})
public final class ClientWorldsManagerImpl
implements ClientWorldsManager {
    @NotNull
    private final Minecraft mc;
    @NotNull
    private ClientState mainView;
    private final List<ClientState> unusedViews;
    @NotNull
    private final List<ClientState> views;
    @NotNull
    private ClientState activeView;
    private boolean inUpdate;
    private final List<MainViewChange> unconfirmedChanges;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<WorldClient> getWorlds() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.views;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClientState clientState = (ClientState)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            WorldClient worldClient = it.getWorld();
            collection.add(worldClient);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void changeDimension(@NotNull WorldClient newWorld, @NotNull Function1<? super EntityPlayerSP, Unit> updatePosition) {
        Object v0;
        boolean bl;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)newWorld, (String)"newWorld");
            Intrinsics.checkParameterIsNotNull(updatePosition, (String)"updatePosition");
            Iterable iterable = this.views;
            bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                ClientState it = (ClientState)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getWorld(), (Object)newWorld)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        ClientState view2 = v0;
        boolean bl4 = view2 != null;
        bl = false;
        boolean bl5 = false;
        if (!bl4) {
            boolean bl6 = false;
            String string = "Unknown world " + newWorld;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.makeClientMainView$bp_master_view(view2, updatePosition);
    }

    @NotNull
    public final Minecraft getMc() {
        return this.mc;
    }

    @Override
    @NotNull
    public EntityPlayerSP getPlayer() {
        return this.mainView.getClientPlayer();
    }

    @NotNull
    public final ClientState getMainView() {
        return this.mainView;
    }

    public final void setMainView(@NotNull ClientState clientState) {
        Intrinsics.checkParameterIsNotNull((Object)clientState, (String)"<set-?>");
        this.mainView = clientState;
    }

    @NotNull
    public final List<ClientState> getViews() {
        return this.views;
    }

    @NotNull
    public final ClientState getActiveView() {
        return this.activeView;
    }

    public final void setActiveView(@NotNull ClientState clientState) {
        Intrinsics.checkParameterIsNotNull((Object)clientState, (String)"<set-?>");
        this.activeView = clientState;
    }

    @NotNull
    public final ClientState getServerMainView() {
        Object object = (MainViewChange)CollectionsKt.firstOrNull(this.unconfirmedChanges);
        if (object == null || (object = ((MainViewChange)object).getOld()) == null) {
            object = this.mainView;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final EntityPlayerSP getServerPlayer(@NotNull ClientState view2) {
        EntityPlayerSP entityPlayerSP;
        ClientState serverView;
        ClientState clientState;
        Intrinsics.checkParameterIsNotNull((Object)view2, (String)"view");
        if (this.inUpdate) {
            clientState = view2;
        } else {
            Iterable $this$fold$iv = CollectionsKt.asReversedMutable(this.unconfirmedChanges);
            boolean $i$f$fold = false;
            ClientState accumulator$iv = view2;
            for (Object element$iv : $this$fold$iv) {
                void change;
                MainViewChange mainViewChange = (MainViewChange)element$iv;
                ClientState curr = accumulator$iv;
                boolean bl = false;
                accumulator$iv = Intrinsics.areEqual((Object)change.getNew(), (Object)curr) ? change.getOld() : curr;
            }
            clientState = serverView = accumulator$iv;
        }
        if (Intrinsics.areEqual((Object)this.activeView, (Object)serverView)) {
            EntityPlayerSP entityPlayerSP2 = this.mc.field_71439_g;
            entityPlayerSP = entityPlayerSP2;
            Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayerSP2, (String)"mc.player");
        } else {
            entityPlayerSP = serverView.getThePlayer();
            if (entityPlayerSP == null) {
                Intrinsics.throwNpe();
            }
        }
        return entityPlayerSP;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final EntityPlayerSP getClientPlayer(@NotNull ClientState view2) {
        EntityPlayerSP entityPlayerSP;
        ClientState clientView;
        ClientState clientState;
        Intrinsics.checkParameterIsNotNull((Object)view2, (String)"view");
        if (this.inUpdate) {
            Iterable $this$fold$iv = this.unconfirmedChanges;
            boolean $i$f$fold = false;
            ClientState accumulator$iv = view2;
            for (Object element$iv : $this$fold$iv) {
                void change;
                MainViewChange mainViewChange = (MainViewChange)element$iv;
                ClientState curr = accumulator$iv;
                boolean bl = false;
                accumulator$iv = Intrinsics.areEqual((Object)change.getOld(), (Object)curr) ? change.getNew() : curr;
            }
            clientState = accumulator$iv;
        } else {
            clientState = clientView = view2;
        }
        if (Intrinsics.areEqual((Object)this.activeView, (Object)clientView)) {
            EntityPlayerSP entityPlayerSP2 = this.mc.field_71439_g;
            entityPlayerSP = entityPlayerSP2;
            Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayerSP2, (String)"mc.player");
        } else {
            entityPlayerSP = clientView.getThePlayer();
            if (entityPlayerSP == null) {
                Intrinsics.throwNpe();
            }
        }
        return entityPlayerSP;
    }

    /*
     * WARNING - void declaration
     */
    private final void reset() {
        void $this$forEach$iv;
        ClientState clientState;
        this.unconfirmedChanges.clear();
        this.views.remove(this.mainView);
        Object object = new ClientState(this, null, null, null, null);
        ClientWorldsManagerImpl clientWorldsManagerImpl = this;
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        ((ClientState)it).captureState$bp_master_view(this.mc);
        clientWorldsManagerImpl.mainView = clientState = object;
        this.activeView = this.mainView;
        object = CollectionsKt.toList((Iterable)this.views);
        ClientWorldsManagerImpl clientWorldsManagerImpl2 = this;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClientState p1 = (ClientState)element$iv;
            boolean bl4 = false;
            clientWorldsManagerImpl2.destroyState(p1);
        }
        boolean bl5 = this.views.isEmpty();
        boolean bl6 = false;
        bl2 = false;
        if (!bl5) {
            boolean bl7 = false;
            String string = "Even after destroying all non-main views, there are still non-main views remaining.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.views.add(this.mainView);
    }

    public final void init() {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    @NotNull
    public final ClientState createState(@NotNull WorldClient world2) {
        Object v2;
        boolean bl;
        int dim;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)world2, (String)"world");
            WorldProvider worldProvider = world2.field_73011_w;
            Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"world.provider");
            dim = worldProvider.getDimension();
            Iterable iterable = this.views;
            bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                ClientState it = (ClientState)t;
                boolean bl3 = false;
                WorldProvider worldProvider2 = it.getWorld().field_73011_w;
                Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider2, (String)"it.world.provider");
                if (!(worldProvider2.getDimension() == dim)) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        boolean bl4 = v2 == null;
        bl = false;
        boolean bl5 = false;
        if (!bl4) {
            boolean bl6 = false;
            String string = "World with dimension " + dim + " already exists";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ClientState clientState = ClientState.Companion.reuseOrCreate(this, world2, de.johni0702.minecraft.betterportals.common.ExtensionsKt.popOrNull(this.unusedViews));
        bl = false;
        bl5 = false;
        ClientState it = clientState;
        boolean bl7 = false;
        this.views.add(it);
        return clientState;
    }

    public final void destroyState(@NotNull ClientState view2) {
        Intrinsics.checkParameterIsNotNull((Object)view2, (String)"view");
        ViewAPIImplKt.getLOGGER().debug("Removing view {}", (Object)view2);
        if (Intrinsics.areEqual((Object)this.activeView, (Object)this.mainView) ^ true) {
            throw (Throwable)new IllegalStateException("Main view must be active");
        }
        if (Intrinsics.areEqual((Object)view2, (Object)this.mainView)) {
            throw (Throwable)new IllegalArgumentException("Cannot remove main view");
        }
        this.withView(view2, (Function0)new Function0<Unit>(this){
            final /* synthetic */ ClientWorldsManagerImpl this$0;

            public final void invoke() {
                WorldClient worldClient = this.this$0.getMc().field_71441_e;
                if (worldClient != null) {
                    WorldClient worldClient2 = worldClient;
                    boolean bl = false;
                    boolean bl2 = false;
                    WorldClient it = worldClient2;
                    boolean bl3 = false;
                    WorldEvent.Unload cfr_ignored_0 = (WorldEvent.Unload)de.johni0702.minecraft.betterportals.common.ExtensionsKt.post((Event)new WorldEvent.Unload((World)it));
                }
                this.this$0.getMc().field_71438_f.func_72732_a(null);
            }
            {
                this.this$0 = clientWorldsManagerImpl;
                super(0);
            }
        });
        boolean bl = this.views.remove(view2);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Unknown view " + view2;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        view2.setValid(false);
        this.unusedViews.add(view2);
    }

    public final void handleWorldData(int dimensionId, @NotNull ByteBuf data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        try {
            Object v0;
            block6: {
                Iterable iterable = this.views;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    ClientState it = (ClientState)t;
                    boolean bl3 = false;
                    if (!(it.getDimension() == dimensionId)) continue;
                    v0 = t;
                    break block6;
                }
                v0 = null;
            }
            ClientState view2 = v0;
            if (view2 == null) {
                ViewAPIImplKt.getLOGGER().warn("Received data for unknown dimension {}", (Object)dimensionId);
                return;
            }
            EmbeddedChannel channel = view2.getChannel();
            if (channel != null) {
                this.updateState(view2, (Function0)new Function0<Boolean>(data, channel){
                    final /* synthetic */ ByteBuf $data;
                    final /* synthetic */ EmbeddedChannel $channel;

                    public final boolean invoke() {
                        this.$data.retain();
                        return this.$channel.writeInbound(new Object[]{this.$data});
                    }
                    {
                        this.$data = byteBuf;
                        this.$channel = embeddedChannel;
                        super(0);
                    }
                });
            } else {
                ViewAPIImplKt.getLOGGER().warn("Received data for main dimension {} via WorldData message", (Object)view2);
            }
        }
        catch (Throwable t) {
            ViewAPIImplKt.getLOGGER().error("Handling view data for dimension " + dimensionId + ':', t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T updateState(@NotNull ClientState view2, @NotNull Function0<? extends T> block) {
        Intrinsics.checkParameterIsNotNull((Object)view2, (String)"view");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        if (this.inUpdate) {
            throw (Throwable)new IllegalStateException("nested updateState");
        }
        if (Intrinsics.areEqual((Object)this.activeView, (Object)this.mainView) ^ true) {
            throw (Throwable)new IllegalStateException("already in withView");
        }
        this.mainView.captureState$bp_master_view(this.mc);
        Iterable $this$forEach$iv = CollectionsKt.asReversedMutable(this.unconfirmedChanges);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MainViewChange change = (MainViewChange)element$iv;
            boolean bl = false;
            change.getOld().swapThePlayer$bp_master_view(change.getNew(), false);
        }
        this.activeView = view2;
        this.activeView.restoreState$bp_master_view(this.mc);
        this.inUpdate = true;
        try {
            Object object = block.invoke();
            return (T)object;
        }
        finally {
            this.inUpdate = false;
            this.activeView.captureState$bp_master_view(this.mc);
            Iterable $this$forEach$iv2 = this.unconfirmedChanges;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                MainViewChange change = (MainViewChange)element$iv;
                boolean bl = false;
                change.getOld().swapThePlayer$bp_master_view(change.getNew(), false);
            }
            this.activeView = this.mainView;
            this.activeView.restoreState$bp_master_view(this.mc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withView(@NotNull ClientState view2, @NotNull Function0<? extends T> block) {
        Intrinsics.checkParameterIsNotNull((Object)view2, (String)"view");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        if (Intrinsics.areEqual((Object)this.activeView, (Object)this.mainView) ^ true) {
            throw (Throwable)new IllegalStateException("already in withView");
        }
        if (Intrinsics.areEqual((Object)view2, (Object)this.mainView)) {
            return (T)block.invoke();
        }
        this.activeView.captureState$bp_master_view(this.mc);
        this.activeView = view2;
        this.activeView.restoreState$bp_master_view(this.mc);
        try {
            Object object = block.invoke();
            return (T)object;
        }
        finally {
            this.activeView.captureState$bp_master_view(this.mc);
            this.activeView = this.mainView;
            this.activeView.restoreState$bp_master_view(this.mc);
        }
    }

    public final void makeClientMainView$bp_master_view(@NotNull ClientState newMainView, @NotNull Function1<? super EntityPlayerSP, Unit> updatePosition) {
        Intrinsics.checkParameterIsNotNull((Object)newMainView, (String)"newMainView");
        Intrinsics.checkParameterIsNotNull(updatePosition, (String)"updatePosition");
        if (this.inUpdate) {
            throw (Throwable)new IllegalStateException("Cannot change main view during update / packet handling");
        }
        if (Intrinsics.areEqual((Object)this.activeView, (Object)this.mainView) ^ true) {
            throw (Throwable)new IllegalStateException("Needs to be called with the current main view active");
        }
        EntityPlayerSP entityPlayerSP = this.getPlayer();
        boolean bl = false;
        boolean bl2 = false;
        EntityPlayerSP $this$with = entityPlayerSP;
        boolean bl3 = false;
        $this$with.field_71174_a.func_147297_a((Packet)new CPacketPlayer.PositionRotation($this$with.field_70165_t, $this$with.func_174813_aQ().field_72338_b, $this$with.field_70161_v, $this$with.field_70177_z, $this$with.field_70125_A, $this$with.field_70122_E));
        ViewAPIImplKt.getLOGGER().info("Swapping main view " + this.mainView + " with " + newMainView);
        this.makeMainView(newMainView);
        updatePosition.invoke((Object)this.getPlayer());
    }

    private final void makeMainView(ClientState newMainView) {
        this.unconfirmedChanges.add(new MainViewChange(this.mainView, newMainView, de.johni0702.minecraft.betterportals.common.ExtensionsKt.getPos((Entity)this.mainView.getClientPlayer())));
        this.activeView.captureState$bp_master_view(this.mc);
        newMainView.swapThePlayer$bp_master_view(this.activeView, false);
        newMainView.copyRenderState$bp_master_view(this.activeView);
        newMainView.restoreState$bp_master_view(this.mc);
        this.activeView = newMainView;
        this.mainView = newMainView;
        this.stopMusic();
    }

    public final void rewindMainView() {
        MainViewChange mainViewChange = (MainViewChange)CollectionsKt.firstOrNull(this.unconfirmedChanges);
        if (mainViewChange == null || (mainViewChange = mainViewChange.getFallbackPos()) == null) {
            return;
        }
        MainViewChange fallbackPos = mainViewChange;
        ViewAPIImplKt.getLOGGER().warn("Got teleport in old main view, rewinding main view changes to before that change..");
        if (!this.inUpdate) {
            throw (Throwable)new IllegalStateException("rewind outside update");
        }
        if (Intrinsics.areEqual((Object)this.activeView, (Object)this.getServerMainView()) ^ true) {
            throw (Throwable)new IllegalStateException("rewind outside server main view");
        }
        this.unconfirmedChanges.clear();
        this.mainView = this.activeView;
        boolean bl = false;
        boolean bl2 = false;
        MainViewChange $this$with = fallbackPos;
        boolean bl3 = false;
        this.getPlayer().func_70107_b(((Vec3d)$this$with).field_72450_a, ((Vec3d)$this$with).field_72448_b, ((Vec3d)$this$with).field_72449_c);
        this.stopMusic();
    }

    private final void stopMusic() {
        List badDims = CollectionsKt.listOf((Object[])new String[]{"aether", "necromancertower", "aetheri"});
        WorldProvider worldProvider = this.mc.field_71441_e.field_73011_w;
        Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"mc.world.provider");
        if (badDims.contains(worldProvider.func_186058_p().name())) {
            this.mc.func_147118_V().func_147690_c();
        }
    }

    public final void makeMainViewAck(int dimensionId) {
        EmbeddedChannel embeddedChannel;
        ClientState it;
        Object object;
        Integer expectedId;
        ViewAPIImplKt.getLOGGER().info("Ack for swap of {}", (Object)dimensionId);
        Object object2 = (MainViewChange)CollectionsKt.getOrNull(this.unconfirmedChanges, (int)0);
        Integer n = expectedId = object2 != null && (object2 = ((MainViewChange)object2).getNew()) != null ? Integer.valueOf(((ClientState)object2).getDimension()) : null;
        if (n == null || n != dimensionId) {
            EmbeddedChannel embeddedChannel2;
            block4: {
                this.rewindMainView();
                Iterable iterable = this.views;
                object = this;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    it = (ClientState)t;
                    boolean bl3 = false;
                    if (!(it.getDimension() == dimensionId)) continue;
                    embeddedChannel2 = (EmbeddedChannel)t;
                    break block4;
                }
                embeddedChannel2 = null;
            }
            EmbeddedChannel embeddedChannel3 = embeddedChannel = embeddedChannel2;
            if (embeddedChannel3 == null) {
                Intrinsics.throwNpe();
            }
            ((ClientWorldsManagerImpl)object).makeMainView((ClientState)embeddedChannel3);
        }
        MainViewChange mainViewChange = de.johni0702.minecraft.betterportals.common.ExtensionsKt.removeAtOrNull(this.unconfirmedChanges, 0);
        if (mainViewChange == null) {
            Intrinsics.throwNpe();
        }
        MainViewChange change = mainViewChange;
        ClientState newMainView = change.getNew();
        ClientState oldMainView = change.getOld();
        this.activeView.captureState$bp_master_view(this.mc);
        EmbeddedChannel embeddedChannel4 = newMainView.getChannel();
        object = oldMainView;
        boolean bl = false;
        boolean bl4 = false;
        it = embeddedChannel4;
        boolean bl5 = false;
        newMainView.setChannel(oldMainView.getChannel());
        embeddedChannel = embeddedChannel4;
        ((ClientState)object).setChannel(embeddedChannel);
        embeddedChannel4 = newMainView.getNetManager();
        object = oldMainView;
        bl = false;
        bl4 = false;
        it = embeddedChannel4;
        boolean bl6 = false;
        newMainView.setNetManager(oldMainView.getNetManager());
        embeddedChannel = embeddedChannel4;
        ((ClientState)object).setNetManager((NetworkManager)embeddedChannel);
        this.activeView.restoreState$bp_master_view(this.mc);
    }

    /*
     * WARNING - void declaration
     */
    private final void tickViews() {
        void $this$filterTo$iv$iv;
        if (this.mc.func_147113_T() || this.mc.field_71442_b == null) {
            return;
        }
        IntegratedServer integratedServer = this.mc.func_71401_C();
        if (!(integratedServer instanceof IIntegratedServer)) {
            integratedServer = null;
        }
        IIntegratedServer iIntegratedServer = (IIntegratedServer)integratedServer;
        if (iIntegratedServer != null) {
            iIntegratedServer.updateClientState(this.mc);
        }
        this.mc.field_71424_I.func_76320_a("tickViews");
        Iterable $this$filter$iv = this.views;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ClientState it = (ClientState)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it, (Object)this.mainView) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClientState view2 = (ClientState)element$iv;
            boolean bl = false;
            this.withView(view2, (Function0)new Function0<Unit>(this){
                final /* synthetic */ ClientWorldsManagerImpl this$0;
                {
                    this.this$0 = clientWorldsManagerImpl;
                    super(0);
                }

                public final void invoke() {
                    ClientWorldsManagerImpl.access$tickView(this.this$0);
                }
            });
        }
        this.mc.field_71424_I.func_76319_b();
    }

    private final void tickView() {
        if (this.mc.field_71460_t == null) {
            return;
        }
        this.mc.field_71424_I.func_76320_a(String.valueOf(this.activeView.getDimension()));
        this.mc.field_71460_t.func_78473_a(1.0f);
        this.mc.field_71424_I.func_76320_a("gameRenderer");
        this.mc.field_71460_t.func_78464_a();
        this.mc.field_71424_I.func_76318_c("levelRenderer");
        this.mc.field_71438_f.func_72734_e();
        this.mc.field_71424_I.func_76318_c("level");
        WorldClient worldClient = this.mc.field_71441_e;
        Intrinsics.checkExpressionValueIsNotNull((Object)worldClient, (String)"mc.world");
        if (worldClient.func_175658_ac() > 0) {
            WorldClient worldClient2 = this.mc.field_71441_e;
            Intrinsics.checkExpressionValueIsNotNull((Object)worldClient2, (String)"mc.world");
            WorldClient worldClient3 = this.mc.field_71441_e;
            Intrinsics.checkExpressionValueIsNotNull((Object)worldClient3, (String)"mc.world");
            worldClient2.func_175702_c(worldClient3.func_175658_ac() - 1);
        }
        this.mc.field_71441_e.func_72939_s();
        WorldClient worldClient4 = this.mc.field_71441_e;
        WorldClient worldClient5 = this.mc.field_71441_e;
        Intrinsics.checkExpressionValueIsNotNull((Object)worldClient5, (String)"mc.world");
        worldClient4.func_72891_a(worldClient5.func_175659_aa() != EnumDifficulty.PEACEFUL, true);
        try {
            this.mc.field_71441_e.func_72835_b();
        }
        catch (Throwable t) {
            CrashReport crash = CrashReport.func_85055_a((Throwable)t, (String)"Exception in world tick");
            this.mc.field_71441_e.func_72914_a(crash);
            throw (Throwable)new ReportedException(crash);
        }
        this.mc.field_71424_I.func_76318_c("animateTick");
        this.mc.field_71441_e.func_73029_E(MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70165_t), MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70163_u), MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70161_v));
        this.mc.field_71424_I.func_76318_c("particles");
        this.mc.field_71452_i.func_78868_a();
        this.mc.field_71424_I.func_76319_b();
        this.mc.field_71424_I.func_76319_b();
    }

    private final void preRender() {
        Framebuffer framebuffer = this.mc.func_147110_a();
        Intrinsics.checkExpressionValueIsNotNull((Object)framebuffer, (String)"mc.framebuffer");
        if (!framebuffer.isStencilEnabled()) {
            this.mc.func_147110_a().enableStencil();
        }
    }

    public ClientWorldsManagerImpl() {
        Minecraft minecraft = Minecraft.func_71410_x();
        Intrinsics.checkExpressionValueIsNotNull((Object)minecraft, (String)"Minecraft.getMinecraft()");
        this.mc = minecraft;
        ClientState clientState = new ClientState(this, null, null, null, null);
        ClientWorldsManagerImpl clientWorldsManagerImpl = this;
        boolean bl = false;
        boolean bl2 = false;
        ClientState $this$apply = clientState;
        boolean bl3 = false;
        $this$apply.captureState$bp_master_view(this.mc);
        Object object = clientState;
        clientWorldsManagerImpl.mainView = object;
        clientWorldsManagerImpl = this;
        boolean bl4 = false;
        clientWorldsManagerImpl.unusedViews = object = (List)new ArrayList();
        this.views = CollectionsKt.mutableListOf((Object[])new ClientState[]{this.mainView});
        this.activeView = this.mainView;
        clientWorldsManagerImpl = this;
        bl4 = false;
        clientWorldsManagerImpl.unconfirmedChanges = object = (List)new ArrayList();
    }

    public static final /* synthetic */ void access$reset(ClientWorldsManagerImpl $this) {
        $this.reset();
    }

    public static final /* synthetic */ void access$tickView(ClientWorldsManagerImpl $this) {
        $this.tickView();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Lde/johni0702/minecraft/view/impl/client/ClientWorldsManagerImpl$EventHandler;", "", "(Lde/johni0702/minecraft/view/impl/client/ClientWorldsManagerImpl;)V", "addWorldsDebugInfo", "", "event", "Lnet/minecraftforge/client/event/RenderGameOverlayEvent$Text;", "onDisconnect", "Lnet/minecraftforge/fml/common/network/FMLNetworkEvent$ClientDisconnectionFromServerEvent;", "postClientTick", "Lnet/minecraftforge/fml/common/gameevent/TickEvent$ClientTickEvent;", "preClientRender", "Lnet/minecraftforge/fml/common/gameevent/TickEvent$RenderTickEvent;", "bp-master_view"})
    private final class EventHandler {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public final void postClientTick(@NotNull TickEvent.ClientTickEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            ClientWorldsManagerImpl.this.tickViews();
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public final void preClientRender(@NotNull TickEvent.RenderTickEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            if (event.phase != TickEvent.Phase.START) {
                return;
            }
            ClientWorldsManagerImpl.this.preRender();
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        public final void onDisconnect(@NotNull FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            ExtensionsKt.clientSyncIgnoringView((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ EventHandler this$0;

                public final void invoke() {
                    ClientWorldsManagerImpl.access$reset(this.this$0.ClientWorldsManagerImpl.this);
                }
                {
                    this.this$0 = eventHandler;
                    super(0);
                }
            }));
        }

        @SubscribeEvent
        public final void addWorldsDebugInfo(@NotNull RenderGameOverlayEvent.Text event) {
            int n;
            ClientState it;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            ArrayList list;
            block9: {
                int n2;
                String it2;
                int index$iv;
                boolean $i$f$indexOfFirst;
                block8: {
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    ArrayList arrayList = list = event.getLeft();
                    Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"list");
                    List $this$indexOfFirst$iv = arrayList;
                    $i$f$indexOfFirst = false;
                    index$iv = 0;
                    for (Object item$iv : $this$indexOfFirst$iv) {
                        it2 = (String)item$iv;
                        boolean bl = false;
                        String string = it2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                        if (StringsKt.startsWith$default((String)string, (String)"E: ", (boolean)false, (int)2, null)) {
                            n2 = index$iv;
                            break block8;
                        }
                        ++index$iv;
                    }
                    n2 = -1;
                }
                int $this$indexOfFirst$iv = n2;
                $i$f$indexOfFirst = false;
                index$iv = 0;
                int idx = $this$indexOfFirst$iv;
                boolean bl = false;
                if (idx != -1) {
                    list.remove(idx);
                    $this$forEach$iv = ClientWorldsManagerImpl.this.getViews();
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (ClientState)element$iv;
                        boolean bl2 = false;
                        StringBuilder stringBuilder = new StringBuilder().append("Dim: ");
                        WorldProvider worldProvider = it.getWorld().field_73011_w;
                        Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"it.world.provider");
                        RenderGlobal renderGlobal = it.getRenderGlobal();
                        list.add(idx, stringBuilder.append(worldProvider.getDimension()).append(", ").append(renderGlobal != null ? renderGlobal.func_72723_d() : null).toString());
                    }
                }
                List $this$indexOfFirst$iv2 = list;
                $i$f$indexOfFirst = false;
                index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv2) {
                    it2 = (String)item$iv;
                    boolean bl3 = false;
                    String string = it2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                    if (StringsKt.startsWith$default((String)string, (String)"MultiplayerChunkCache: ", (boolean)false, (int)2, null)) {
                        n = index$iv;
                        break block9;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int n3 = n;
            boolean bl = false;
            boolean bl4 = false;
            int idx = n3;
            boolean bl5 = false;
            if (idx != -1) {
                list.remove(idx);
                $this$forEach$iv = ClientWorldsManagerImpl.this.getWorlds();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (WorldClient)element$iv;
                    boolean bl6 = false;
                    StringBuilder stringBuilder = new StringBuilder().append("Dim: ");
                    WorldProvider worldProvider = ((WorldClient)it).field_73011_w;
                    Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"it.provider");
                    list.add(idx, stringBuilder.append(worldProvider.getDimension()).append(", ").append(it.func_72827_u()).toString());
                }
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lde/johni0702/minecraft/view/impl/client/ClientWorldsManagerImpl$IIntegratedServer;", "", "updateClientState", "", "mc", "Lnet/minecraft/client/Minecraft;", "bp-master_view"})
    public static interface IIntegratedServer {
        public void updateClientState(@NotNull Minecraft var1);
    }
}

