/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.view.client.render;

import de.johni0702.minecraft.betterportals.common.ExtensionsKt;
import de.johni0702.minecraft.view.client.render.Camera;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.util.math.Vec3d;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.util.vector.Quaternion;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u0017"}, d2={"Lde/johni0702/minecraft/view/client/render/Camera;", "", "frustum", "Lnet/minecraft/client/renderer/culling/Frustum;", "feetPosition", "Lnet/minecraft/util/math/Vec3d;", "eyePosition", "viewPosition", "eyeRotation", "viewRotation", "(Lnet/minecraft/client/renderer/culling/Frustum;Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Vec3d;)V", "getEyePosition", "()Lnet/minecraft/util/math/Vec3d;", "getEyeRotation", "getFeetPosition", "getFrustum", "()Lnet/minecraft/client/renderer/culling/Frustum;", "getViewPosition", "getViewRotation", "transformed", "matrix", "Ljavax/vecmath/Matrix4d;", "withFrustum", "bp-master_api"})
public final class Camera {
    @NotNull
    private final Frustum frustum;
    @NotNull
    private final Vec3d feetPosition;
    @NotNull
    private final Vec3d eyePosition;
    @NotNull
    private final Vec3d viewPosition;
    @NotNull
    private final Vec3d eyeRotation;
    @NotNull
    private final Vec3d viewRotation;

    @NotNull
    public final Camera transformed(@NotNull Matrix4d matrix) {
        Intrinsics.checkParameterIsNotNull((Object)matrix, (String)"matrix");
        Quaternion rotation = ExtensionsKt.extractRotation(ExtensionsKt.toLwjgl3f(ExtensionsKt.toJX4f(matrix)));
        return new Camera(new Frustum(this, matrix, new ClippingHelper()){
            private final Matrix4d inverseMatrix;
            final /* synthetic */ Camera this$0;
            final /* synthetic */ Matrix4d $matrix;

            public void func_78547_a(double xIn, double yIn, double zIn) {
                Point3d point3d = ExtensionsKt.times(this.inverseMatrix, new Point3d(xIn, yIn, zIn));
                boolean bl = false;
                boolean bl2 = false;
                Point3d $this$with = point3d;
                boolean bl3 = false;
                this.this$0.getFrustum().func_78547_a($this$with.x, $this$with.y, $this$with.z);
            }

            public boolean func_78548_b(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
                Point3d min = ExtensionsKt.times(this.inverseMatrix, new Point3d(minX, minY, minZ));
                Point3d max = ExtensionsKt.times(this.inverseMatrix, new Point3d(maxX, maxY, maxZ));
                transformed.isBoxInFrustum.1 $fun$min$1 = transformed.isBoxInFrustum.1.INSTANCE;
                transformed.isBoxInFrustum.2 $fun$max$2 = transformed.isBoxInFrustum.2.INSTANCE;
                return this.this$0.getFrustum().func_78548_b($fun$min$1.invoke(min.x, max.x), $fun$min$1.invoke(min.y, max.y), $fun$min$1.invoke(min.z, max.z), $fun$max$2.invoke(min.x, max.x), $fun$max$2.invoke(min.y, max.y), $fun$max$2.invoke(min.z, max.z));
            }
            {
                this.this$0 = $outer;
                this.$matrix = $captured_local_variable$1;
                super($super_call_param$2);
                this.inverseMatrix = ExtensionsKt.inverse($captured_local_variable$1);
            }
        }, ExtensionsKt.toMC(ExtensionsKt.times(matrix, ExtensionsKt.toPoint(this.feetPosition))), ExtensionsKt.toMC(ExtensionsKt.times(matrix, ExtensionsKt.toPoint(this.eyePosition))), ExtensionsKt.toMC(ExtensionsKt.times(matrix, ExtensionsKt.toPoint(this.viewPosition))), ExtensionsKt.toPitchYawRoll(ExtensionsKt.times(rotation, ExtensionsKt.toQuaternion(this.eyeRotation))), ExtensionsKt.toPitchYawRoll(ExtensionsKt.times(rotation, ExtensionsKt.toQuaternion(this.viewRotation))));
    }

    @NotNull
    public final Camera withFrustum(@NotNull Frustum frustum) {
        Intrinsics.checkParameterIsNotNull((Object)frustum, (String)"frustum");
        return new Camera(frustum, this.feetPosition, this.eyePosition, this.viewPosition, this.eyeRotation, this.viewRotation);
    }

    @NotNull
    public final Frustum getFrustum() {
        return this.frustum;
    }

    @NotNull
    public final Vec3d getFeetPosition() {
        return this.feetPosition;
    }

    @NotNull
    public final Vec3d getEyePosition() {
        return this.eyePosition;
    }

    @NotNull
    public final Vec3d getViewPosition() {
        return this.viewPosition;
    }

    @NotNull
    public final Vec3d getEyeRotation() {
        return this.eyeRotation;
    }

    @NotNull
    public final Vec3d getViewRotation() {
        return this.viewRotation;
    }

    public Camera(@NotNull Frustum frustum, @NotNull Vec3d feetPosition, @NotNull Vec3d eyePosition, @NotNull Vec3d viewPosition, @NotNull Vec3d eyeRotation, @NotNull Vec3d viewRotation) {
        Intrinsics.checkParameterIsNotNull((Object)frustum, (String)"frustum");
        Intrinsics.checkParameterIsNotNull((Object)feetPosition, (String)"feetPosition");
        Intrinsics.checkParameterIsNotNull((Object)eyePosition, (String)"eyePosition");
        Intrinsics.checkParameterIsNotNull((Object)viewPosition, (String)"viewPosition");
        Intrinsics.checkParameterIsNotNull((Object)eyeRotation, (String)"eyeRotation");
        Intrinsics.checkParameterIsNotNull((Object)viewRotation, (String)"viewRotation");
        this.frustum = frustum;
        this.feetPosition = feetPosition;
        this.eyePosition = eyePosition;
        this.viewPosition = viewPosition;
        this.eyeRotation = eyeRotation;
        this.viewRotation = viewRotation;
    }
}

