/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.betterportals.impl.transition.server;

import de.johni0702.minecraft.betterportals.common.ExtensionsKt;
import de.johni0702.minecraft.betterportals.impl.transition.net.NetKt;
import de.johni0702.minecraft.betterportals.impl.transition.net.TransferToDimension;
import de.johni0702.minecraft.view.common.WorldsManager;
import de.johni0702.minecraft.view.server.ServerWorldsManager;
import de.johni0702.minecraft.view.server.ServerWorldsManagerKt;
import de.johni0702.minecraft.view.server.View;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R)\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00110\u000f0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lde/johni0702/minecraft/betterportals/impl/transition/server/DimensionTransitionHandler;", "", "()V", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "knownBadTeleporterClasses", "", "", "nextId", "", "views", "", "Lde/johni0702/minecraft/view/common/WorldsManager;", "Lde/johni0702/minecraft/view/server/View;", "getViews", "()Ljava/util/Map;", "transferPlayerToDimension", "player", "Lnet/minecraft/entity/player/EntityPlayerMP;", "dimension", "teleporter", "Lnet/minecraftforge/common/util/ITeleporter;", "bp-master_transition"})
public final class DimensionTransitionHandler {
    @NotNull
    private static final Map<WorldsManager, Map<Integer, View>> views;
    private static boolean enabled;
    private static int nextId;
    private static final List<String> knownBadTeleporterClasses;
    public static final DimensionTransitionHandler INSTANCE;

    @NotNull
    public final Map<WorldsManager, Map<Integer, View>> getViews() {
        return views;
    }

    public final boolean getEnabled() {
        return enabled;
    }

    public final void setEnabled(boolean bl) {
        enabled = bl;
    }

    public final boolean transferPlayerToDimension(@NotNull EntityPlayerMP player, int dimension, @NotNull ITeleporter teleporter) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)teleporter, (String)"teleporter");
        if (!enabled) {
            return false;
        }
        ServerWorldsManager worldsManager = ServerWorldsManagerKt.getWorldsManager(player);
        if (worldsManager.getPlayer() != player) {
            return false;
        }
        if (knownBadTeleporterClasses.contains(teleporter.getClass().getName())) {
            de.johni0702.minecraft.betterportals.impl.transition.common.ExtensionsKt.getLOGGER().debug("Skipping fancy dimension transition because of bad teleporter class: {}", teleporter.getClass());
            return false;
        }
        WorldServer oldWorld = player.func_71121_q();
        MinecraftServer minecraftServer = player.func_184102_h();
        if (minecraftServer == null) {
            Intrinsics.throwNpe();
        }
        WorldServer newWorld = minecraftServer.func_71218_a(dimension);
        int n = nextId;
        nextId = n + 1;
        int id = n;
        Map<WorldsManager, Map<Integer, View>> $this$getOrPut$iv = views;
        boolean $i$f$getOrPut = false;
        Map value$iv = $this$getOrPut$iv.get(worldsManager);
        if (value$iv == null) {
            boolean bl = false;
            boolean bl2 = false;
            Map answer$iv = new LinkedHashMap();
            $this$getOrPut$iv.put(worldsManager, answer$iv);
            map = answer$iv;
        } else {
            map = value$iv;
        }
        Integer n2 = id;
        WorldServer worldServer = oldWorld;
        Intrinsics.checkExpressionValueIsNotNull((Object)worldServer, (String)"oldWorld");
        map.put(n2, worldsManager.createView(worldServer, ExtensionsKt.getPos((Entity)player), null));
        worldsManager.beginTransaction();
        NetKt.sendTo((IMessage)new TransferToDimension(id), player);
        WorldServer worldServer2 = newWorld;
        Intrinsics.checkExpressionValueIsNotNull((Object)worldServer2, (String)"newWorld");
        worldsManager.changeDimension(worldServer2, (Function1<? super EntityPlayerMP, Unit>)((Function1)new Function1<EntityPlayerMP, Unit>(newWorld, oldWorld, teleporter){
            final /* synthetic */ WorldServer $newWorld;
            final /* synthetic */ WorldServer $oldWorld;
            final /* synthetic */ ITeleporter $teleporter;

            public final void invoke(@NotNull EntityPlayerMP $this$changeDimension) {
                Intrinsics.checkParameterIsNotNull((Object)$this$changeDimension, (String)"$receiver");
                WorldProvider worldProvider = this.$newWorld.field_73011_w;
                Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"newWorld.provider");
                int newDim = worldProvider.getDimension();
                WorldProvider worldProvider2 = this.$oldWorld.field_73011_w;
                Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider2, (String)"oldWorld.provider");
                int oldDim = worldProvider2.getDimension();
                WorldProvider worldProvider3 = this.$oldWorld.field_73011_w;
                Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider3, (String)"oldWorld.provider");
                double d = worldProvider3.getMovementFactor();
                WorldProvider worldProvider4 = this.$newWorld.field_73011_w;
                Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider4, (String)"newWorld.provider");
                double moveFactor = d / worldProvider4.getMovementFactor();
                float yaw = $this$changeDimension.field_70177_z;
                double d2 = $this$changeDimension.field_70165_t * moveFactor;
                WorldServer worldServer = this.$newWorld;
                Intrinsics.checkExpressionValueIsNotNull((Object)worldServer, (String)"newWorld");
                double d3 = worldServer.func_175723_af().func_177726_b() + 16.0;
                WorldServer worldServer2 = this.$newWorld;
                Intrinsics.checkExpressionValueIsNotNull((Object)worldServer2, (String)"newWorld");
                int posX = (int)RangesKt.coerceIn((double)d2, (double)d3, (double)(worldServer2.func_175723_af().func_177728_d() - (double)16));
                double d4 = $this$changeDimension.field_70161_v * moveFactor;
                WorldServer worldServer3 = this.$newWorld;
                Intrinsics.checkExpressionValueIsNotNull((Object)worldServer3, (String)"newWorld");
                double d5 = worldServer3.func_175723_af().func_177736_c() + 16.0;
                WorldServer worldServer4 = this.$newWorld;
                Intrinsics.checkExpressionValueIsNotNull((Object)worldServer4, (String)"newWorld");
                int posZ = (int)RangesKt.coerceIn((double)d4, (double)d5, (double)(worldServer4.func_175723_af().func_177733_e() - (double)16));
                if (newDim == 1 && this.$teleporter.isVanilla()) {
                    BlockPos blockPos;
                    if (oldDim == 1) {
                        WorldServer worldServer5 = this.$newWorld;
                        Intrinsics.checkExpressionValueIsNotNull((Object)worldServer5, (String)"newWorld");
                        blockPos = worldServer5.func_175694_M();
                    } else {
                        WorldServer worldServer6 = this.$newWorld;
                        Intrinsics.checkExpressionValueIsNotNull((Object)worldServer6, (String)"newWorld");
                        blockPos = worldServer6.func_180504_m();
                    }
                    if (blockPos == null) {
                        Intrinsics.throwNpe();
                    }
                    BlockPos spawn = blockPos;
                    posX = spawn.func_177958_n();
                    posZ = spawn.func_177952_p();
                    Vec3d vec3d = ExtensionsKt.to3d((Vec3i)spawn);
                    boolean bl = false;
                    boolean bl2 = false;
                    Vec3d $this$with = vec3d;
                    boolean bl3 = false;
                    $this$changeDimension.func_70012_b($this$with.field_72450_a, $this$with.field_72448_b, $this$with.field_72449_c, 90.0f, 0.0f);
                }
                if (oldDim != 1 || !this.$teleporter.isVanilla()) {
                    posX = RangesKt.coerceIn((int)posX, (int)-29999872, (int)29999872);
                    posZ = RangesKt.coerceIn((int)posZ, (int)-29999872, (int)29999872);
                    $this$changeDimension.func_70012_b((double)posX, $this$changeDimension.field_70163_u, (double)posZ, $this$changeDimension.field_70177_z, $this$changeDimension.field_70125_A);
                    this.$teleporter.placeEntity((World)this.$newWorld, (Entity)$this$changeDimension, yaw);
                }
            }
            {
                this.$newWorld = worldServer;
                this.$oldWorld = worldServer2;
                this.$teleporter = iTeleporter;
                super(1);
            }
        }));
        worldsManager.endTransaction();
        player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        worldsManager.flushPackets();
        return true;
    }

    private DimensionTransitionHandler() {
    }

    static {
        DimensionTransitionHandler dimensionTransitionHandler;
        INSTANCE = dimensionTransitionHandler = new DimensionTransitionHandler();
        boolean bl = false;
        views = new LinkedHashMap();
        enabled = true;
        knownBadTeleporterClasses = CollectionsKt.listOf((Object)"gcewing.sg.util.FakeTeleporter");
    }
}

