/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.betterportals.impl.mixin;

import de.johni0702.minecraft.betterportals.impl.client.audio.PortalAwareSoundManager;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SoundManager.class})
public abstract class MixinSoundManager {
    @Inject(method={"setListener(Lnet/minecraft/entity/Entity;F)V"}, at={@At(value="HEAD")}, remap=false)
    private void setListener(Entity entity, float partialTicks, CallbackInfo ci) {
        if (entity != null) {
            double x = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks;
            double y = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks + (double)entity.func_70047_e();
            double z = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
            PortalAwareSoundManager.INSTANCE.setListenerPos(new Vec3d(x, y, z));
        }
    }

    @Inject(method={"playDelayedSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void recordViewOnPlayDelayedSound(ISound sound, int delay, CallbackInfo ci) {
        if (!PortalAwareSoundManager.INSTANCE.recordView(sound)) {
            ci.cancel();
        }
    }

    @Inject(method={"playSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void recordViewOnPlaySound(ISound sound, CallbackInfo ci) {
        if (!PortalAwareSoundManager.INSTANCE.recordView(sound)) {
            ci.cancel();
        }
    }

    @Inject(method={"playSound"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/audio/ISound;getVolume()F")})
    private void considerPortalsBeforePlay(ISound sound, CallbackInfo ci) {
        PortalAwareSoundManager.INSTANCE.beforePlay(sound);
    }

    @Redirect(method={"playSound"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/audio/ISound;getXPosF()F"))
    private float getXPosFConsideringPortals$0(ISound sound) {
        return (float)PortalAwareSoundManager.INSTANCE.getApparentPos((ISound)sound).field_72450_a;
    }

    @Redirect(method={"playSound"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/audio/ISound;getYPosF()F"))
    private float getYPosFConsideringPortals$0(ISound sound) {
        return (float)PortalAwareSoundManager.INSTANCE.getApparentPos((ISound)sound).field_72448_b;
    }

    @Redirect(method={"playSound"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/audio/ISound;getZPosF()F"))
    private float getZPosFConsideringPortals$0(ISound sound) {
        return (float)PortalAwareSoundManager.INSTANCE.getApparentPos((ISound)sound).field_72449_c;
    }

    @Redirect(method={"updateAllSounds"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/audio/ITickableSound;getXPosF()F"))
    private float getXPosFConsideringPortals$1(ITickableSound sound) {
        return (float)PortalAwareSoundManager.INSTANCE.getApparentPos((ISound)sound).field_72450_a;
    }

    @Redirect(method={"updateAllSounds"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/audio/ITickableSound;getYPosF()F"))
    private float getYPosFConsideringPortals$1(ITickableSound sound) {
        return (float)PortalAwareSoundManager.INSTANCE.getApparentPos((ISound)sound).field_72448_b;
    }

    @Redirect(method={"updateAllSounds"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/audio/ITickableSound;getZPosF()F"))
    private float getZPosFConsideringPortals$1(ITickableSound sound) {
        return (float)PortalAwareSoundManager.INSTANCE.getApparentPos((ISound)sound).field_72449_c;
    }
}

