/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.betterportals.impl.mekanism.common.tile;

import de.johni0702.minecraft.betterportals.common.FinitePortal;
import de.johni0702.minecraft.betterportals.common.Portal;
import de.johni0702.minecraft.betterportals.common.PortalAgent;
import de.johni0702.minecraft.betterportals.common.tile.PortalTileEntity;
import de.johni0702.minecraft.betterportals.impl.mekanism.common.ExtensionsKt;
import de.johni0702.minecraft.betterportals.impl.mekanism.common.tile.TeleporterPortalAgent;
import de.johni0702.minecraft.betterportals.impl.mekanism.common.tile.TileEntityBetterTeleporterKt;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.UsageConfig;
import mekanism.common.frequency.Frequency;
import mekanism.common.network.PacketPortalFX;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0016J\u0016\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0000\u0018\u00010$H\u0002J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0014H\u0016J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0003H\u0002J\b\u0010-\u001a\u00020\u001eH\u0016J\u000e\u0010.\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020&J\u0010\u00100\u001a\u00020\u001e2\u0006\u00101\u001a\u000202H\u0016J\u0018\u00103\u001a\u00020\u001e2\u0006\u00104\u001a\u0002052\b\b\u0002\u00106\u001a\u00020\u0006J\b\u00107\u001a\u00020\u001eH\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lde/johni0702/minecraft/betterportals/impl/mekanism/common/tile/TileEntityBetterTeleporter;", "Lmekanism/common/tile/TileEntityTeleporter;", "Lde/johni0702/minecraft/betterportals/common/tile/PortalTileEntity;", "Lde/johni0702/minecraft/betterportals/common/FinitePortal;", "()V", "active", "", "getActive", "()Z", "agent", "Lde/johni0702/minecraft/betterportals/impl/mekanism/common/tile/TeleporterPortalAgent;", "getAgent", "()Lde/johni0702/minecraft/betterportals/impl/mekanism/common/tile/TeleporterPortalAgent;", "setAgent", "(Lde/johni0702/minecraft/betterportals/impl/mekanism/common/tile/TeleporterPortalAgent;)V", "portalFacing", "Lnet/minecraft/util/EnumFacing;", "getPortalFacing", "()Lnet/minecraft/util/EnumFacing;", "trackingPlayers", "", "Lnet/minecraft/entity/player/EntityPlayerMP;", "calculateEnergyCost", "", "from", "Lmekanism/api/Coord4D;", "to", "canTeleport", "", "destroyAgent", "", "getClosest", "getNetworkedData", "Lmekanism/api/TileNetworkList;", "data", "getPortal", "Lkotlin/Pair;", "getToTeleport", "Lnet/minecraft/entity/Entity;", "handlePacketData", "dataStream", "Lio/netty/buffer/ByteBuf;", "link", "remote", "portal", "onUpdate", "playTeleportEffects", "entity", "setPos", "posIn", "Lnet/minecraft/util/math/BlockPos;", "syncWatchers", "world", "Lnet/minecraft/world/WorldServer;", "updateAgent", "teleport", "bp-master_mekanism"})
public final class TileEntityBetterTeleporter
extends TileEntityTeleporter
implements PortalTileEntity<FinitePortal> {
    @Nullable
    private TeleporterPortalAgent agent;
    private final List<EntityPlayerMP> trackingPlayers;

    @Nullable
    public TeleporterPortalAgent getAgent() {
        return this.agent;
    }

    public void setAgent(@Nullable TeleporterPortalAgent teleporterPortalAgent) {
        this.agent = teleporterPortalAgent;
    }

    public final boolean getActive() {
        return this.shouldRender && MekanismUtils.canFunction((TileEntity)((TileEntity)this));
    }

    public void func_174878_a(@NotNull BlockPos posIn) {
        Intrinsics.checkParameterIsNotNull((Object)posIn, (String)"posIn");
        super.func_174878_a(posIn);
        if (this.field_145850_b.field_72995_K) {
            Coord4D localCoord = Coord4D.get((TileEntity)((TileEntity)this));
            WorldProvider worldProvider = this.field_145850_b.field_73011_w;
            Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"world.provider");
            int n = worldProvider.getDimension();
            Coord4D coord4D = localCoord;
            Intrinsics.checkExpressionValueIsNotNull((Object)coord4D, (String)"localCoord");
            BlockPos blockPos = coord4D.getPos().func_177984_a();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"localCoord.pos.up()");
            FinitePortal portal = TileEntityBetterTeleporterKt.newTeleporterPortal(n, blockPos, Rotation.NONE);
            this.setAgent(new TeleporterPortalAgent(this, portal));
        }
    }

    private final EnumFacing getPortalFacing() {
        EnumFacing enumFacing;
        EnumFacing enumFacing2;
        block2: {
            Coord4D coord4D = Coord4D.get((TileEntity)((TileEntity)this)).step(EnumFacing.UP);
            boolean bl = false;
            boolean bl2 = false;
            Coord4D bottomPortalBlock = coord4D;
            boolean bl3 = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)EnumFacing.field_176754_o, (String)"EnumFacing.HORIZONTALS");
            EnumFacing[] enumFacingArray = EnumFacing.field_176754_o;
            boolean bl4 = false;
            EnumFacing[] enumFacingArray2 = enumFacingArray;
            boolean bl5 = false;
            EnumFacing[] enumFacingArray3 = enumFacingArray2;
            int n = enumFacingArray3.length;
            for (int j = 0; j < n; ++j) {
                EnumFacing enumFacing3;
                EnumFacing it = enumFacing3 = enumFacingArray3[j];
                boolean bl6 = false;
                if (!bottomPortalBlock.step(it).isAirBlock((IBlockAccess)this.field_145850_b)) continue;
                enumFacing2 = enumFacing3;
                break block2;
            }
            enumFacing2 = enumFacing = null;
        }
        if (enumFacing2 == null) {
            enumFacing = EnumFacing.NORTH;
        }
        return enumFacing;
    }

    private final Pair<FinitePortal, TileEntityBetterTeleporter> getPortal() {
        if (!this.hasFrame()) {
            return null;
        }
        Coord4D coord4D = Coord4D.get((TileEntity)((TileEntity)this));
        if (coord4D == null) {
            Intrinsics.throwNpe();
        }
        Coord4D localCoord = coord4D;
        Coord4D coord4D2 = this.getClosest();
        if (coord4D2 == null) {
            return null;
        }
        Coord4D remoteCoord = coord4D2;
        World world2 = this.field_145850_b;
        Intrinsics.checkExpressionValueIsNotNull((Object)world2, (String)"world");
        MinecraftServer minecraftServer = world2.func_73046_m();
        if (minecraftServer == null) {
            Intrinsics.throwNpe();
        }
        WorldServer worldServer = minecraftServer.func_71218_a(remoteCoord.dimensionId);
        if (worldServer == null) {
            return null;
        }
        WorldServer remoteWorld = worldServer;
        TileEntity tileEntity = remoteWorld.func_175625_s(remoteCoord.getPos());
        if (!(tileEntity instanceof TileEntityBetterTeleporter)) {
            tileEntity = null;
        }
        TileEntityBetterTeleporter tileEntityBetterTeleporter = (TileEntityBetterTeleporter)tileEntity;
        if (tileEntityBetterTeleporter == null) {
            return null;
        }
        TileEntityBetterTeleporter remoteTileEntity = tileEntityBetterTeleporter;
        EnumFacing localFacing = this.getPortalFacing();
        EnumFacing remoteFacing = remoteTileEntity.getPortalFacing();
        if (ExtensionsKt.compareTo(localCoord, remoteCoord) < 0) {
            EnumFacing enumFacing = localFacing.func_176734_d();
            Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"localFacing.opposite");
            localFacing = enumFacing;
        } else {
            EnumFacing enumFacing = remoteFacing.func_176734_d();
            Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"remoteFacing.opposite");
            remoteFacing = enumFacing;
        }
        int n = localCoord.dimensionId;
        BlockPos blockPos = localCoord.getPos().func_177984_a();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"localCoord.pos.up()");
        Rotation rotation = de.johni0702.minecraft.betterportals.common.ExtensionsKt.toRotation(localFacing);
        Integer n2 = remoteCoord.dimensionId;
        BlockPos blockPos2 = remoteCoord.getPos().func_177984_a();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"remoteCoord.pos.up()");
        FinitePortal portal = TileEntityBetterTeleporterKt.newTeleporterPortal(n, blockPos, rotation, n2, blockPos2, de.johni0702.minecraft.betterportals.common.ExtensionsKt.toRotation(remoteFacing));
        return new Pair((Object)portal, (Object)remoteTileEntity);
    }

    @Nullable
    public Coord4D getClosest() {
        Frequency frequency = this.frequency;
        if (frequency == null) {
            return null;
        }
        Frequency frequency2 = frequency;
        Coord4D coord4D = Coord4D.get((TileEntity)((TileEntity)this));
        if (coord4D == null) {
            Intrinsics.throwNpe();
        }
        Coord4D localCoord = coord4D;
        Coord4D coord4D2 = frequency2.getClosestCoords(localCoord);
        if (coord4D2 == null) {
            return null;
        }
        Coord4D remoteCoord = coord4D2;
        if (Intrinsics.areEqual((Object)frequency2.getClosestCoords(remoteCoord), (Object)localCoord) ^ true) {
            return null;
        }
        return remoteCoord;
    }

    private final void link(TileEntityBetterTeleporter remote, FinitePortal portal) {
        EntityPlayerMP it;
        this.destroyAgent();
        remote.destroyAgent();
        this.setAgent(new TeleporterPortalAgent(this, portal));
        remote.setAgent(new TeleporterPortalAgent(remote, portal.toRemote()));
        Iterable $this$forEach$iv = this.trackingPlayers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (EntityPlayerMP)element$iv;
            boolean bl = false;
            TeleporterPortalAgent teleporterPortalAgent = this.getAgent();
            if (teleporterPortalAgent == null) continue;
            teleporterPortalAgent.addTrackingPlayer(it);
        }
        $this$forEach$iv = remote.trackingPlayers;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (EntityPlayerMP)element$iv;
            boolean bl = false;
            TeleporterPortalAgent teleporterPortalAgent = remote.getAgent();
            if (teleporterPortalAgent == null) continue;
            teleporterPortalAgent.addTrackingPlayer(it);
        }
        Mekanism.packetHandler.sendUpdatePacket((TileEntity)this);
        Mekanism.packetHandler.sendUpdatePacket((TileEntity)remote);
    }

    private final void destroyAgent() {
        block3: {
            TeleporterPortalAgent teleporterPortalAgent = this.getAgent();
            if (teleporterPortalAgent == null) {
                return;
            }
            TeleporterPortalAgent agent = teleporterPortalAgent;
            PortalAgent portalAgent = agent.loadRemoteAgent();
            if (!(portalAgent instanceof TeleporterPortalAgent)) {
                portalAgent = null;
            }
            TeleporterPortalAgent remoteAgent = (TeleporterPortalAgent)portalAgent;
            Iterable $this$forEach$iv = this.trackingPlayers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EntityPlayerMP it = (EntityPlayerMP)element$iv;
                boolean bl = false;
                agent.removeTrackingPlayer(it);
            }
            this.setAgent(null);
            Mekanism.packetHandler.sendUpdatePacket((TileEntity)this);
            Object object = remoteAgent;
            if (object == null || (object = ((TeleporterPortalAgent)object).getTileEntity()) == null) break block3;
            super.destroyAgent();
        }
    }

    public final void syncWatchers(@NotNull WorldServer world2, boolean updateAgent) {
        Intrinsics.checkParameterIsNotNull((Object)world2, (String)"world");
        PlayerChunkMap playerChunkMap = world2.func_184164_w();
        BlockPos blockPos = this.field_174879_c;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos");
        int n = blockPos.func_177958_n() >> 4;
        BlockPos blockPos2 = this.field_174879_c;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"pos");
        Object object = playerChunkMap.func_187301_b(n, blockPos2.func_177952_p() >> 4);
        if (object == null || (object = object.getWatchingPlayers()) == null || (object = CollectionsKt.toList((Iterable)((Iterable)object))) == null) {
            boolean bl = false;
            object = CollectionsKt.emptyList();
        }
        Object actualWatchers = object;
        this.trackingPlayers.removeIf(new Predicate<EntityPlayerMP>(this, (List)actualWatchers, updateAgent){
            final /* synthetic */ TileEntityBetterTeleporter this$0;
            final /* synthetic */ List $actualWatchers;
            final /* synthetic */ boolean $updateAgent;

            public final boolean test(@NotNull EntityPlayerMP it) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (this.$actualWatchers.contains(it)) {
                    bl = false;
                } else {
                    if (this.$updateAgent) {
                        TeleporterPortalAgent teleporterPortalAgent = this.this$0.getAgent();
                        if (teleporterPortalAgent != null) {
                            teleporterPortalAgent.removeTrackingPlayer(it);
                        }
                    }
                    bl = true;
                }
                return bl;
            }
            {
                this.this$0 = tileEntityBetterTeleporter;
                this.$actualWatchers = list;
                this.$updateAgent = bl;
            }
        });
        Iterable $this$forEach$iv = (Iterable)actualWatchers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityPlayerMP it = (EntityPlayerMP)element$iv;
            boolean bl = false;
            if (this.trackingPlayers.contains(it)) continue;
            EntityPlayerMP entityPlayerMP = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayerMP, (String)"it");
            this.trackingPlayers.add(entityPlayerMP);
            if (!updateAgent) continue;
            TeleporterPortalAgent teleporterPortalAgent = this.getAgent();
            if (teleporterPortalAgent == null) continue;
            teleporterPortalAgent.addTrackingPlayer(it);
        }
    }

    public static /* synthetic */ void syncWatchers$default(TileEntityBetterTeleporter tileEntityBetterTeleporter, WorldServer worldServer, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        tileEntityBetterTeleporter.syncWatchers(worldServer, bl);
    }

    public void onUpdate() {
        super.onUpdate();
        World world2 = this.field_145850_b;
        if (world2 instanceof WorldServer) {
            Pair<FinitePortal, TileEntityBetterTeleporter> portal = this.getPortal();
            TeleporterPortalAgent teleporterPortalAgent = this.getAgent();
            Pair<FinitePortal, TileEntityBetterTeleporter> pair = portal;
            if (Intrinsics.areEqual((Object)(teleporterPortalAgent != null ? (FinitePortal)teleporterPortalAgent.getPortal() : null), (Object)(pair != null ? (FinitePortal)pair.getFirst() : null)) ^ true) {
                this.destroyAgent();
            }
            if (portal != null && this.getAgent() == null) {
                this.link((TileEntityBetterTeleporter)portal.getSecond(), (FinitePortal)portal.getFirst());
            }
            TileEntityBetterTeleporter.syncWatchers$default(this, (WorldServer)world2, false, 2, null);
        }
    }

    public final void playTeleportEffects(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        for (Coord4D coord : this.frequency.activeCoords) {
            Mekanism.packetHandler.sendToAllAround((IMessage)new PacketPortalFX.PortalFXMessage(coord), coord.getTargetPoint(40.0));
        }
        this.field_145850_b.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187534_aX, entity.func_184176_by(), 1.0f, 1.0f);
    }

    public final int calculateEnergyCost(@NotNull Coord4D from, @NotNull Coord4D to) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        UsageConfig config = MekanismConfig.current().usage;
        return config.teleporterBase.val() + (from.dimensionId != to.dimensionId ? config.teleporterDimensionPenalty.val() : from.distanceTo(to) * config.teleporterDistance.val());
    }

    /*
     * WARNING - void declaration
     */
    public byte canTeleport() {
        int n;
        byte result = super.canTeleport();
        if (result == (byte)1) {
            double d = this.getEnergy();
            Coord4D coord4D = Coord4D.get((TileEntity)((TileEntity)this));
            Intrinsics.checkExpressionValueIsNotNull((Object)coord4D, (String)"Coord4D.get(this)");
            Coord4D coord4D2 = this.getClosest();
            if (coord4D2 == null) {
                Intrinsics.throwNpe();
            }
            n = d < (double)this.calculateEnergyCost(coord4D, coord4D2) ? 4 : 1;
        } else {
            void var1_1;
            n = var1_1;
        }
        return (byte)n;
    }

    public void teleport() {
    }

    @NotNull
    public List<Entity> getToTeleport() {
        boolean bl = false;
        return new ArrayList();
    }

    @NotNull
    public TileNetworkList getNetworkedData(@NotNull TileNetworkList data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        super.getNetworkedData(data);
        TeleporterPortalAgent agent = this.getAgent();
        if (agent != null) {
            data.add((Object)true);
            data.add((Object)((FinitePortal)agent.getPortal()).writePortalToNBT());
        } else {
            data.add((Object)false);
        }
        return data;
    }

    public void handlePacketData(@NotNull ByteBuf dataStream) {
        Intrinsics.checkParameterIsNotNull((Object)dataStream, (String)"dataStream");
        super.handlePacketData(dataStream);
        FMLCommonHandler fMLCommonHandler = FMLCommonHandler.instance();
        Intrinsics.checkExpressionValueIsNotNull((Object)fMLCommonHandler, (String)"FMLCommonHandler.instance()");
        Side side = fMLCommonHandler.getEffectiveSide();
        Intrinsics.checkExpressionValueIsNotNull((Object)side, (String)"FMLCommonHandler.instance().effectiveSide");
        if (side.isClient()) {
            TeleporterPortalAgent teleporterPortalAgent = this.getAgent();
            if (teleporterPortalAgent == null) {
                Intrinsics.throwNpe();
            }
            TeleporterPortalAgent agent = teleporterPortalAgent;
            if (dataStream.readBoolean()) {
                NBTTagCompound nBTTagCompound = PacketHandler.readNBT((ByteBuf)dataStream);
                Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"PacketHandler.readNBT(dataStream)");
                agent.setPortal((Portal)new FinitePortal(nBTTagCompound));
            } else {
                agent.setPortal((Portal)((FinitePortal)agent.getPortal()).withoutRemote());
            }
        }
    }

    public TileEntityBetterTeleporter() {
        List list;
        TileEntityBetterTeleporter tileEntityBetterTeleporter = this;
        boolean bl = false;
        tileEntityBetterTeleporter.trackingPlayers = list = (List)new ArrayList();
    }
}

