/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.betterportals.impl.mekanism.common.tile;

import de.johni0702.minecraft.betterportals.common.FinitePortal;
import de.johni0702.minecraft.betterportals.common.Portal;
import de.johni0702.minecraft.betterportals.common.PortalAgent;
import de.johni0702.minecraft.betterportals.common.PortalAgentKt;
import de.johni0702.minecraft.betterportals.common.tile.PortalTileEntityAccessor;
import de.johni0702.minecraft.betterportals.impl.mekanism.common.ExtensionsKt;
import de.johni0702.minecraft.betterportals.impl.mekanism.common.tile.TileEntityBetterTeleporter;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import mekanism.api.Coord4D;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006JF\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u001e\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00140\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lde/johni0702/minecraft/betterportals/impl/mekanism/common/tile/TeleporterPortalAgent;", "Lde/johni0702/minecraft/betterportals/common/PortalAgent;", "Lde/johni0702/minecraft/betterportals/common/FinitePortal;", "tileEntity", "Lde/johni0702/minecraft/betterportals/impl/mekanism/common/tile/TileEntityBetterTeleporter;", "portal", "(Lde/johni0702/minecraft/betterportals/impl/mekanism/common/tile/TileEntityBetterTeleporter;Lde/johni0702/minecraft/betterportals/common/FinitePortal;)V", "getTileEntity", "()Lde/johni0702/minecraft/betterportals/impl/mekanism/common/tile/TileEntityBetterTeleporter;", "modifyAABBs", "", "entity", "Lnet/minecraft/entity/Entity;", "queryAABB", "Lnet/minecraft/util/math/AxisAlignedBB;", "aabbList", "", "queryRemote", "Lkotlin/Function2;", "Lnet/minecraft/world/World;", "", "serverPortalUsed", "", "player", "Lnet/minecraft/entity/player/EntityPlayerMP;", "teleport", "from", "Lnet/minecraft/util/EnumFacing;", "bp-master_mekanism"})
public final class TeleporterPortalAgent
extends PortalAgent<FinitePortal> {
    @NotNull
    private final TileEntityBetterTeleporter tileEntity;

    @Override
    public void modifyAABBs(@NotNull Entity entity, @NotNull AxisAlignedBB queryAABB, @NotNull List<AxisAlignedBB> aabbList, @NotNull Function2<? super World, ? super AxisAlignedBB, ? extends List<? extends AxisAlignedBB>> queryRemote) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)queryAABB, (String)"queryAABB");
        Intrinsics.checkParameterIsNotNull(aabbList, (String)"aabbList");
        Intrinsics.checkParameterIsNotNull(queryRemote, (String)"queryRemote");
        if (this.getRemoteAgent() == null) {
            return;
        }
        super.modifyAABBs(entity, queryAABB, aabbList, queryRemote);
    }

    @Override
    protected void teleport(@NotNull Entity entity, @NotNull EnumFacing from) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        World world2 = this.getRemoteWorldIfLoaded();
        if (world2 == null) {
            return;
        }
        World remoteWorld = world2;
        if (!this.tileEntity.getActive()) {
            return;
        }
        if (!this.getWorld().field_72995_K && !(entity instanceof EntityPlayer)) {
            Coord4D coord4D = Coord4D.get((TileEntity)((TileEntity)this.tileEntity));
            Intrinsics.checkExpressionValueIsNotNull((Object)coord4D, (String)"Coord4D.get(tileEntity)");
            int energyCost = this.tileEntity.calculateEnergyCost(coord4D, new Coord4D(((FinitePortal)this.getPortal()).getRemotePosition(), remoteWorld));
            if (this.tileEntity.getEnergy() < (double)energyCost) {
                return;
            }
            TileEntityBetterTeleporter tileEntityBetterTeleporter = this.tileEntity;
            tileEntityBetterTeleporter.setEnergy(tileEntityBetterTeleporter.getEnergy() - (double)energyCost);
            this.tileEntity.playTeleportEffects(entity);
        }
        super.teleport(entity, from);
    }

    @Override
    public boolean serverPortalUsed(@NotNull EntityPlayerMP player) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        if (!MekanismUtils.canFunction((TileEntity)((TileEntity)this.tileEntity))) {
            ExtensionsKt.getLOGGER().warn("Player used teleporter " + this + " which was disabled, resetting player..");
            player.func_70634_a(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            return false;
        }
        PortalAgent portalAgent = this.getRemoteAgent();
        if (!(portalAgent instanceof TeleporterPortalAgent)) {
            portalAgent = null;
        }
        TeleporterPortalAgent teleporterPortalAgent = (TeleporterPortalAgent)portalAgent;
        if (teleporterPortalAgent == null) {
            return false;
        }
        TeleporterPortalAgent remote = teleporterPortalAgent;
        Coord4D coord4D = Coord4D.get((TileEntity)((TileEntity)this.tileEntity));
        Intrinsics.checkExpressionValueIsNotNull((Object)coord4D, (String)"Coord4D.get(tileEntity)");
        int energyCost = this.tileEntity.calculateEnergyCost(coord4D, new Coord4D(((FinitePortal)this.getPortal()).getRemotePosition(), remote.getWorld()));
        if (this.tileEntity.getEnergy() < (double)energyCost) {
            ExtensionsKt.getLOGGER().warn("Player used teleporter " + this + " which has insufficient energy, resetting player..");
            player.func_70634_a(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            return false;
        }
        TileEntityBetterTeleporter tileEntityBetterTeleporter = this.tileEntity;
        tileEntityBetterTeleporter.setEnergy(tileEntityBetterTeleporter.getEnergy() - (double)energyCost);
        this.tileEntity.playTeleportEffects((Entity)player);
        World world2 = remote.getWorld();
        if (world2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.world.WorldServer");
        }
        TileEntityBetterTeleporter.syncWatchers$default(this.tileEntity, (WorldServer)world2, false, 2, null);
        World world3 = remote.getWorld();
        if (world3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.world.WorldServer");
        }
        TileEntityBetterTeleporter.syncWatchers$default(remote.tileEntity, (WorldServer)world3, false, 2, null);
        if (super.serverPortalUsed(player)) {
            World world4 = remote.getWorld();
            if (world4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.world.WorldServer");
            }
            this.tileEntity.syncWatchers((WorldServer)world4, false);
            World world5 = remote.getWorld();
            if (world5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.world.WorldServer");
            }
            remote.tileEntity.syncWatchers((WorldServer)world5, false);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final TileEntityBetterTeleporter getTileEntity() {
        return this.tileEntity;
    }

    public TeleporterPortalAgent(@NotNull TileEntityBetterTeleporter tileEntity, @NotNull FinitePortal portal) {
        Intrinsics.checkParameterIsNotNull((Object)tileEntity, (String)"tileEntity");
        Intrinsics.checkParameterIsNotNull((Object)portal, (String)"portal");
        World world2 = tileEntity.func_145831_w();
        Intrinsics.checkExpressionValueIsNotNull((Object)world2, (String)"tileEntity.world");
        super(PortalAgentKt.getPortalManager(world2), PortalTileEntityAccessor.Companion.getId((TileEntity)tileEntity), (Portal)portal, ExtensionsKt.getCONFIG_MEKANISM_PORTALS());
        this.tileEntity = tileEntity;
    }
}

