/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.betterportals.impl;

import net.minecraftforge.common.config.Config;

public class PortalConfig {
    @Config.RequiresMcRestart
    @Config.Name(value="Enable")
    @Config.Comment(value={"Whether to replace this kind of portal with BetterPortals ones. Needs to be set on the server and the client."})
    public boolean enabled = true;
    @Config.Name(value="Opacity")
    @Config.Comment(value={"Determines the opacity of the original portal texture.\nA value of 0 will not render the original texture at all.\nA value of 1 is maximally opaque, i.e. unchanged from the original value (the remote world will nevertheless be rendered).\n\nClient-side setting.\n"})
    @Config.RangeDouble(min=0.0, max=1.0)
    public double opacity = 0.5;
    @Config.Name(value="Fully visible distance")
    @Config.Comment(value={"The distance at which portals will fully render the remote world.\nIf this value is greater than the \"Minimal render distance\", that value is used instead.\n\nA value between 0 and 1 specifies a fraction of the overall render distance.\nA value equal or greater than 1 specifies an absolute distance in chunks.\n\nClient-side setting.\n"})
    @Config.RangeDouble(min=0.0, max=64.0)
    public double renderDistMin = 1.0;
    @Config.Name(value="Minimal render distance")
    @Config.Comment(value={"The distance at which portals will begin to render the remote world.\n\nA value between 0 and 1 specifies a fraction of the overall render distance.\nA value equal or greater than 1 specifies an absolute distance in chunks.\n\nClient-side setting.\n"})
    @Config.RangeDouble(min=0.0, max=64.0)
    public double renderDistMax = 3.0;
    @Config.Name(value="Size render distance multiplier")
    @Config.Comment(value={"For portals which have a side length greater than this value, the \"Minimal render distance\" and \"Fully visible distance\" values\n will be doubled.\nIf the side length is greater than twice this value, they will be tripled.\nGreater than thrice this value, they will be quadrupled.\nEtc.\n\nRender dist values between 0 and 1 will be scaled after they've been converted into absolute ones.\n\nClient-side setting.\n"})
    public int renderDistSizeMultiplier = 10;
}

