/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.betterportals.impl;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class BetterPortalsMixinConfigPlugin
implements IMixinConfigPlugin {
    private Logger logger = LogManager.getLogger((String)"mixin/betterportals");
    private boolean hasKotlin = Launch.classLoader.getClassBytes("kotlin.Pair") != null;
    private boolean hasOF = Launch.classLoader.getClassBytes("optifine.OptiFineForgeTweaker") != null;
    private boolean hasCC = Launch.classLoader.getClassBytes("io.github.opencubicchunks.cubicchunks.core.asm.coremod.CubicChunksCoreMod") != null;
    private boolean hasSponge = Launch.classLoader.getClassBytes("org.spongepowered.common.SpongePlatform") != null;
    private boolean hasVC = Launch.classLoader.getClassBytes("org.vivecraft.asm.VivecraftASMTransformer") != null;
    private boolean vcVR = this.hasVC && Launch.classLoader.getClassBytes("org.vivecraft.provider.MCOpenVR") != null;
    private boolean vcNonVR;

    @Override
    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!this.hasKotlin) {
            return false;
        }
        if (this.vcVR) {
            if (mixinClassName.endsWith("MixinEntityRenderer_NoOF")) {
                return true;
            }
            if (mixinClassName.endsWith("MixinEntityRenderer_OF")) {
                return false;
            }
        }
        if (this.vcNonVR && mixinClassName.endsWith("AbstractClientPlayer_VC")) {
            return true;
        }
        if (mixinClassName.endsWith("_OF")) {
            return this.hasOF;
        }
        if (mixinClassName.endsWith("_NoOF")) {
            return !this.hasOF;
        }
        if (mixinClassName.endsWith("_CC")) {
            return this.hasCC;
        }
        if (mixinClassName.endsWith("_NoCC")) {
            return !this.hasCC;
        }
        if (mixinClassName.endsWith("_Sponge")) {
            return this.hasSponge;
        }
        if (mixinClassName.endsWith("_NoSponge")) {
            return !this.hasSponge;
        }
        if (mixinClassName.endsWith("_VC")) {
            return this.vcVR;
        }
        if (mixinClassName.endsWith("_NoVC")) {
            return !this.vcVR;
        }
        return true;
    }

    @Override
    public void onLoad(String mixinPackage) {
    }

    @Override
    public String getRefMapperConfig() {
        return null;
    }

    @Override
    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    @Override
    public List<String> getMixins() {
        return null;
    }

    @Override
    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    @Override
    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public BetterPortalsMixinConfigPlugin() throws IOException {
        boolean bl = this.vcNonVR = this.hasVC && !this.vcVR;
        if (!this.hasKotlin) {
            this.logger.error("Couldn't find kotlin.Pair class, Forgelin is probably missing, skipping all mixins!");
        }
        this.logger.debug("hasKotlin: " + this.hasKotlin);
        this.logger.debug("hasOF: " + this.hasOF);
        this.logger.debug("hasCC: " + this.hasCC);
        this.logger.debug("hasSponge: " + this.hasSponge);
        this.logger.debug("hasVC: " + this.hasVC + " (VR: " + this.vcVR + ")");
    }
}

