/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.betterportals.impl;

import de.johni0702.minecraft.betterportals.impl.PortalConfig;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="betterportals")
@Mod.EventBusSubscriber(modid="betterportals")
public class BPConfig {
    @Config.Name(value="Vanilla Nether Portals")
    @Config.Comment(value={"Configuration for vanilla nether portals."})
    public static PortalConfig netherPortals = new PortalConfig();
    @Config.Name(value="Vanilla End Portals")
    @Config.Comment(value={"Configuration for vanilla end portals"})
    public static PortalConfig endPortals = new PortalConfig();
    @Config.Name(value="TwilightForest Portals")
    @Config.Comment(value={"Configuration for TwilightForest portals."})
    public static PortalConfig twilightForestPortals;
    @Config.Name(value="Mekanism Teleporter")
    @Config.Comment(value={"Configuration for Mekanism Teleporter portals."})
    public static PortalConfig mekanismPortals;
    @Config.Name(value="The Aether Portals")
    @Config.Comment(value={"Configuration for The Aether portals."})
    public static PortalConfig aetherPortals;
    @Config.Name(value="AbyssalCraft Portals")
    @Config.Comment(value={"Configuration for AbyssalCraft portals (Abyssal Wastelands, Dreadlands and Omothol)."})
    public static PortalConfig abyssalcraftPortals;
    @Config.Name(value="TravelHuts Portals")
    @Config.Comment(value={"Configuration for TravelHuts portals."})
    public static PortalConfig travelHutsPortals;
    @Config.Name(value="Prevent Fall Damage")
    @Config.Comment(value={"Whether to prevent the next fall damage after a player has passed through a lying portal.\n\nServer-side setting."})
    public static boolean preventFallDamage;
    @Config.Name(value="Sound through portals")
    @Config.Comment(value={"Whether to redirect sounds in the remote world of a portal to originate from the direction of the portal.Disabling will drop all sounds not originating in the primary world.\n\nClient-side setting."})
    public static boolean soundThroughPortals;
    @Config.Name(value="See-through portals")
    @Config.Comment(value={"Whether the other side of portals will be visible. Disabling will improve performance.\n\nClient-side setting."})
    public static boolean seeThroughPortals;
    @Config.Name(value="Portals in portals limit")
    @Config.Comment(value={"How deeply nested portals are rendered.\nA value of 0 will completely disable see-through portals.\nA value of 1 will allow you to see through portals but not portals within those.\nA value of 2 (default) will allow you to see through portals in portals but no further.\nA value of 3 will allow you to see through portals in portals in portals but no further.\nEtc.\n\nThis only applies to portals which already have their remote world loaded.\nThe recursion limit for loading of portals is a fixed 1.\n\nClient-side setting."})
    @Config.RangeInt(min=0)
    public static int recursionLimit;
    @Config.Name(value="Enhance third-party transfers")
    @Config.Comment(value={"BetterPortals can replace the loading screen on transfer to a different world when triggered by athird-party mod with a custom \"blobby-transition-thing\".\n\nDisable (and report on the issue tracker) in case of compatibility issues.\n\nNeeds to be set on the server / has no effect on the client."})
    @Config.RequiresMcRestart
    public static boolean enhanceThirdPartyTransfers;
    @Config.Name(value="Enhanced third-party transfer duration")
    @Config.Comment(value={"Duration of the \"Enhance third-party transfers\" effect in seconds.\n\nNeeds to be set on the client / has no effect on the server."})
    @Config.RangeInt(min=0)
    public static int enhancedThirdPartyTransferSeconds;
    @Config.Name(value="Debug View")
    @Config.Comment(value={"Show debug view instead of composed view. Client-side setting."})
    public static boolean debugView;

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("betterportals".equals(event.getModID())) {
            ConfigManager.sync((String)"betterportals", (Config.Type)Config.Type.INSTANCE);
        }
    }

    static {
        BPConfig.endPortals.renderDistMin = 3.0;
        BPConfig.endPortals.renderDistMax = 6.0;
        twilightForestPortals = new PortalConfig();
        mekanismPortals = new PortalConfig();
        aetherPortals = new PortalConfig();
        abyssalcraftPortals = new PortalConfig();
        travelHutsPortals = new PortalConfig();
        BPConfig.travelHutsPortals.opacity = 0.7;
        preventFallDamage = true;
        soundThroughPortals = true;
        seeThroughPortals = true;
        recursionLimit = 2;
        enhanceThirdPartyTransfers = true;
        enhancedThirdPartyTransferSeconds = 10;
        debugView = false;
    }
}

