/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.betterportals.common.entity;

import de.johni0702.minecraft.betterportals.common.ExtensionsKt;
import de.johni0702.minecraft.betterportals.common.FinitePortal;
import de.johni0702.minecraft.betterportals.common.PortalAgentKt;
import de.johni0702.minecraft.betterportals.common.PortalConfiguration;
import de.johni0702.minecraft.betterportals.common.entity.AbstractPortalEntity;
import de.johni0702.minecraft.betterportals.common.entity.OneWayPortalEntityPortalAgent;
import de.johni0702.minecraft.betterportals.common.entity.PortalEntity;
import de.johni0702.minecraft.betterportals.common.util.TickTimer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 :2\u00020\u00012\u00020\u0002:\u0001:B'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010-\u001a\u00020.H\u0014J\b\u0010/\u001a\u00020\u0019H\u0016J\b\u00100\u001a\u00020\u0004H\u0016J\u0014\u00101\u001a\u00020.2\n\u00102\u001a\u0006\u0012\u0002\b\u000303H\u0016J\b\u00104\u001a\u00020.H\u0016J\u0010\u00105\u001a\u00020.2\u0006\u00106\u001a\u000207H\u0014J\b\u00108\u001a\u00020.H\u0016J\u0010\u00109\u001a\u00020.2\u0006\u00106\u001a\u000207H\u0014R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0003\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0013R$\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0012\u0010#\u001a\u00020$X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,\u00a8\u0006;"}, d2={"Lde/johni0702/minecraft/betterportals/common/entity/OneWayPortalEntity;", "Lde/johni0702/minecraft/betterportals/common/entity/AbstractPortalEntity;", "Lde/johni0702/minecraft/betterportals/common/entity/PortalEntity$OneWay;", "isTailEnd", "", "world", "Lnet/minecraft/world/World;", "portal", "Lde/johni0702/minecraft/betterportals/common/FinitePortal;", "portalConfig", "Lde/johni0702/minecraft/betterportals/common/PortalConfiguration;", "(ZLnet/minecraft/world/World;Lde/johni0702/minecraft/betterportals/common/FinitePortal;Lde/johni0702/minecraft/betterportals/common/PortalConfiguration;)V", "agent", "Lde/johni0702/minecraft/betterportals/common/entity/OneWayPortalEntityPortalAgent;", "(ZLnet/minecraft/world/World;Lde/johni0702/minecraft/betterportals/common/FinitePortal;Lde/johni0702/minecraft/betterportals/common/entity/OneWayPortalEntityPortalAgent;)V", "checkTailObstructionDelay", "Lde/johni0702/minecraft/betterportals/common/util/TickTimer;", "checkTailPreferredPosDelay", "value", "()Z", "setTailEnd", "(Z)V", "isTailEndVisible", "isTailVisible", "setTailVisible", "Lnet/minecraft/util/math/BlockPos;", "originalTailPos", "getOriginalTailPos", "()Lnet/minecraft/util/math/BlockPos;", "setOriginalTailPos", "(Lnet/minecraft/util/math/BlockPos;)V", "getPortal", "()Lde/johni0702/minecraft/betterportals/common/FinitePortal;", "setPortal", "(Lde/johni0702/minecraft/betterportals/common/FinitePortal;)V", "portalFrameBlock", "Lnet/minecraft/block/Block;", "getPortalFrameBlock", "()Lnet/minecraft/block/Block;", "travelingInProgressTimer", "", "getTravelingInProgressTimer", "()I", "setTravelingInProgressTimer", "(I)V", "entityInit", "", "findBestUnobstructedSpace", "isObstructed", "notifyDataManagerChange", "key", "Lnet/minecraft/network/datasync/DataParameter;", "onUpdate", "readEntityFromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "updatePortalPosition", "writeEntityToNBT", "Companion", "bp-master_api"})
public abstract class OneWayPortalEntity
extends AbstractPortalEntity
implements PortalEntity.OneWay {
    private int travelingInProgressTimer;
    private final TickTimer checkTailObstructionDelay;
    private final TickTimer checkTailPreferredPosDelay;
    private static final DataParameter<Boolean> IS_TAIL_END;
    private static final DataParameter<BlockPos> ORIGINAL_TAIL_POS;
    private static final DataParameter<Boolean> IS_TAIL_VISIBLE;
    public static final Companion Companion;

    @Override
    public boolean isTailEnd() {
        Object object = this.field_70180_af.func_187225_a(IS_TAIL_END);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"dataManager[IS_TAIL_END]");
        return (Boolean)object;
    }

    public void setTailEnd(boolean value) {
        this.field_70180_af.func_187227_b(IS_TAIL_END, (Object)value);
    }

    @NotNull
    public final BlockPos getOriginalTailPos() {
        Object object = this.field_70180_af.func_187225_a(ORIGINAL_TAIL_POS);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"dataManager[ORIGINAL_TAIL_POS]");
        return (BlockPos)object;
    }

    public final void setOriginalTailPos(@NotNull BlockPos value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.field_70180_af.func_187227_b(ORIGINAL_TAIL_POS, (Object)value);
    }

    public final boolean isTailVisible() {
        Object object = this.field_70180_af.func_187225_a(IS_TAIL_VISIBLE);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"dataManager[IS_TAIL_VISIBLE]");
        return (Boolean)object;
    }

    public final void setTailVisible(boolean value) {
        this.field_70180_af.func_187227_b(IS_TAIL_VISIBLE, (Object)value);
        if (value) {
            this.travelingInProgressTimer = 20;
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_TAIL_END, (Object)false);
        this.field_70180_af.func_187214_a(ORIGINAL_TAIL_POS, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(IS_TAIL_VISIBLE, (Object)false);
    }

    @Override
    protected void func_70037_a(@NotNull NBTTagCompound compound) {
        BlockPos blockPos;
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.func_70037_a(compound);
        NBTTagCompound nBTTagCompound = compound.func_74775_l("BetterPortal");
        boolean bl = false;
        boolean bl2 = false;
        NBTTagCompound $this$with = nBTTagCompound;
        boolean bl3 = false;
        this.setTailEnd($this$with.func_74767_n("IsTailEnd"));
        if ($this$with.func_74764_b("OriginalTailPos")) {
            NBTTagCompound nBTTagCompound2 = $this$with.func_74775_l("OriginalTailPos");
            Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound2, (String)"getCompoundTag(\"OriginalTailPos\")");
            blockPos = ExtensionsKt.getXYZ(nBTTagCompound2);
        } else {
            blockPos = this.isTailEnd() ? this.getPortal().getLocalPosition() : this.getPortal().getRemotePosition();
        }
        this.setOriginalTailPos(blockPos);
    }

    @Override
    protected void func_70014_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.func_70014_b(compound);
        NBTTagCompound nBTTagCompound = compound.func_74775_l("BetterPortal");
        boolean bl = false;
        boolean bl2 = false;
        NBTTagCompound $this$with = nBTTagCompound;
        boolean bl3 = false;
        $this$with.func_74757_a("IsTailEnd", this.isTailEnd());
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        String string = "OriginalTailPos";
        NBTTagCompound nBTTagCompound3 = $this$with;
        boolean bl4 = false;
        boolean bl5 = false;
        NBTTagCompound $this$apply = nBTTagCompound2;
        boolean bl6 = false;
        ExtensionsKt.setXYZ($this$apply, this.getOriginalTailPos());
        NBTTagCompound nBTTagCompound4 = nBTTagCompound2;
        nBTTagCompound3.func_74782_a(string, (NBTBase)nBTTagCompound4);
    }

    @Override
    @NotNull
    public FinitePortal getPortal() {
        return super.getPortal();
    }

    @Override
    public void setPortal(@NotNull FinitePortal value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.setTailVisible(false);
        super.setPortal(value);
    }

    @Override
    public void func_184206_a(@NotNull DataParameter<?> key) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        super.func_184206_a(key);
        if (this.field_70170_p.field_72995_K && Intrinsics.areEqual(key, IS_TAIL_VISIBLE) && this.isTailEnd()) {
            Block block = this.isTailVisible() ? this.getPortalFrameBlock() : Blocks.field_150350_a;
            Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"(if (isTailVisible) port\u2026ameBlock else Blocks.AIR)");
            IBlockState newState = block.func_176223_P();
            Block block2 = this.isTailVisible() ? Blocks.field_150350_a : this.getPortalFrameBlock();
            Intrinsics.checkExpressionValueIsNotNull((Object)block2, (String)"(if (isTailVisible) Bloc\u2026IR else portalFrameBlock)");
            IBlockState oldState = block2.func_176223_P();
            Set<BlockPos> portalBlocks = this.getPortal().getLocalBlocks();
            Iterable $this$forEach$iv = portalBlocks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BlockPos pos = (BlockPos)element$iv;
                boolean bl = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)EnumFacing.field_176754_o, (String)"EnumFacing.HORIZONTALS");
                EnumFacing[] $this$forEach$iv2 = EnumFacing.field_176754_o;
                boolean $i$f$forEach2 = false;
                EnumFacing[] enumFacingArray = $this$forEach$iv2;
                int n = enumFacingArray.length;
                for (int j = 0; j < n; ++j) {
                    EnumFacing element$iv2;
                    EnumFacing facing = element$iv2 = enumFacingArray[j];
                    boolean bl2 = false;
                    BlockPos neighbour = pos.func_177972_a(facing);
                    if (portalBlocks.contains(neighbour) || !Intrinsics.areEqual((Object)this.field_70170_p.func_180495_p(neighbour), (Object)oldState)) continue;
                    this.field_70170_p.func_175656_a(neighbour, newState);
                }
            }
        }
    }

    @Override
    public boolean isTailEndVisible() {
        return this.isTailVisible();
    }

    public final int getTravelingInProgressTimer() {
        return this.travelingInProgressTimer;
    }

    public final void setTravelingInProgressTimer(int n) {
        this.travelingInProgressTimer = n;
    }

    @NotNull
    public abstract Block getPortalFrameBlock();

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.isTailEnd()) {
            if (this.isTailEndVisible()) {
                boolean inside;
                block13: {
                    boolean bl;
                    List list = this.field_70170_p.field_72996_f;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"world.loadedEntityList");
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            boolean bl2;
                            block12: {
                                Entity entity = (Entity)element$iv;
                                boolean bl3 = false;
                                if (entity instanceof OneWayPortalEntity) {
                                    bl2 = false;
                                } else {
                                    Entity entity2 = entity;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)entity2, (String)"entity");
                                    AxisAlignedBB entityAABB2 = entity2.func_174813_aQ();
                                    Iterable<AxisAlignedBB> $this$any$iv2 = this.getPortal().getLocalDetailedBounds();
                                    boolean $i$f$any2 = false;
                                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                        bl2 = false;
                                    } else {
                                        Iterator<AxisAlignedBB> iterator = $this$any$iv2.iterator();
                                        while (iterator.hasNext()) {
                                            AxisAlignedBB element$iv2;
                                            AxisAlignedBB it = element$iv2 = iterator.next();
                                            boolean bl4 = false;
                                            if (!it.func_72326_a(entityAABB2)) continue;
                                            bl2 = true;
                                            break block12;
                                        }
                                        bl2 = false;
                                    }
                                }
                            }
                            if (!bl2) continue;
                            bl = true;
                            break block13;
                        }
                        bl = inside = false;
                    }
                }
                if (!inside) {
                    int n = this.travelingInProgressTimer;
                    this.travelingInProgressTimer = n + -1;
                    if (this.travelingInProgressTimer <= 0) {
                        this.setTailVisible(false);
                    }
                }
            }
            this.checkTailObstructionDelay.tick("checkPortalObstruction", (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ OneWayPortalEntity this$0;

                public final void invoke() {
                    if (this.this$0.isObstructed()) {
                        this.this$0.updatePortalPosition();
                    }
                }
                {
                    this.this$0 = oneWayPortalEntity;
                    super(0);
                }
            }));
            this.checkTailPreferredPosDelay.tick("findImprovedPortalPosition", (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ OneWayPortalEntity this$0;

                public final void invoke() {
                    BlockPos orgPos;
                    BlockPos currPos = this.this$0.getPortal().getLocalPosition();
                    if (Intrinsics.areEqual((Object)currPos, (Object)(orgPos = this.this$0.getOriginalTailPos())) ^ true) {
                        this.this$0.updatePortalPosition();
                    }
                }
                {
                    this.this$0 = oneWayPortalEntity;
                    super(0);
                }
            }));
        }
    }

    public boolean isObstructed() {
        boolean bl;
        block4: {
            Vec3i vec3i = this.getPortal().getLocalFacing().func_176730_m();
            Intrinsics.checkExpressionValueIsNotNull((Object)vec3i, (String)"portal.localFacing.directionVec");
            Vec3d growVec = ExtensionsKt.times(ExtensionsKt.to3d(vec3i), 2.0);
            if (this.field_70170_p.func_184144_a(null, ExtensionsKt.grow(this.getPortal().getLocalBoundingBox(), growVec)).isEmpty()) {
                return false;
            }
            Iterable<AxisAlignedBB> $this$any$iv = this.getPortal().getLocalDetailedBounds();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator<AxisAlignedBB> iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    AxisAlignedBB element$iv;
                    AxisAlignedBB it = element$iv = iterator.next();
                    boolean bl2 = false;
                    List list = this.field_70170_p.func_184144_a(null, ExtensionsKt.grow(it, growVec));
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"world.getCollisionBoxes(null, it.grow(growVec))");
                    Collection collection = list;
                    boolean bl3 = false;
                    if (!(!collection.isEmpty())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public void updatePortalPosition() {
        BlockPos newPos = this.findBestUnobstructedSpace();
        if (Intrinsics.areEqual((Object)newPos, (Object)this.getPortal().getLocalPosition())) {
            return;
        }
        AbstractPortalEntity abstractPortalEntity = this.getRemotePortal();
        if (abstractPortalEntity == null) {
            return;
        }
        AbstractPortalEntity remote = abstractPortalEntity;
        FinitePortal finitePortal = this.getPortal();
        OneWayPortalEntity oneWayPortalEntity = this;
        boolean bl = false;
        boolean bl2 = false;
        FinitePortal $this$with = finitePortal;
        boolean bl3 = false;
        FinitePortal finitePortal2 = new FinitePortal($this$with.getPlane(), $this$with.getBlocks(), $this$with.getLocalDimension(), newPos, $this$with.getLocalRotation(), $this$with.getRemoteDimension(), $this$with.getRemotePosition(), $this$with.getRemoteRotation());
        oneWayPortalEntity.setPortal(finitePortal2);
        remote.setPortal(this.getPortal().toRemote());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public BlockPos findBestUnobstructedSpace() {
        void $this$mapTo$iv$iv2;
        int n;
        World world2 = this.field_70170_p;
        Intrinsics.checkExpressionValueIsNotNull((Object)world2, (String)"world");
        if (ExtensionsKt.isCubicWorld(world2)) {
            n = Integer.MAX_VALUE;
        } else {
            WorldProvider worldProvider = this.field_70170_p.field_73011_w;
            Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"world.provider");
            n = worldProvider.getActualHeight() - 3;
        }
        int maxY = n;
        World world3 = this.field_70170_p;
        Intrinsics.checkExpressionValueIsNotNull((Object)world3, (String)"world");
        int minY = ExtensionsKt.isCubicWorld(world3) ? Integer.MIN_VALUE : 3;
        Vec3i vec3i = this.getPortal().getLocalFacing().func_176730_m();
        Intrinsics.checkExpressionValueIsNotNull((Object)vec3i, (String)"portal.localFacing.directionVec");
        Vec3d growVec = ExtensionsKt.times(ExtensionsKt.to3d(vec3i), 2.0);
        BlockPos orgPos = this.getOriginalTailPos();
        Iterable<AxisAlignedBB> $this$map$iv = this.getPortal().getLocalDetailedBounds();
        boolean $i$f$map = false;
        Iterable<AxisAlignedBB> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            AxisAlignedBB axisAlignedBB = (AxisAlignedBB)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            AxisAlignedBB axisAlignedBB2 = it.func_191194_a(ExtensionsKt.to3d(ExtensionsKt.minus((Vec3i)orgPos, (Vec3i)this.getPortal().getLocalPosition())));
            collection.add(axisAlignedBB2);
        }
        List orgBounds = (List)destination$iv$iv;
        int bestDist = Integer.MAX_VALUE;
        BlockPos bestSpot = null;
        int $this$mapTo$iv$iv2 = -10;
        int n2 = 10;
        while ($this$mapTo$iv$iv2 <= n2) {
            void yOff;
            int y = orgPos.func_177956_o() + yOff;
            if (y >= minY && y <= maxY) {
                int n3 = -10;
                int n4 = 10;
                while (n3 <= n4) {
                    void xOff;
                    int it = -10;
                    int n5 = 10;
                    while (it <= n5) {
                        void zOff;
                        boolean bl = false;
                        int n6 = Math.abs((int)xOff);
                        bl = false;
                        int n7 = Math.abs((int)yOff);
                        n6 += n7;
                        bl = false;
                        n7 = Math.abs((int)zOff);
                        int dist = n6 + n7;
                        if (dist < bestDist) {
                            boolean empty;
                            block13: {
                                boolean bl2;
                                Iterable $this$all$iv = orgBounds;
                                boolean $i$f$all = false;
                                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                    bl2 = true;
                                } else {
                                    for (Object element$iv : $this$all$iv) {
                                        AxisAlignedBB bound;
                                        AxisAlignedBB it2 = (AxisAlignedBB)element$iv;
                                        boolean bl3 = false;
                                        AxisAlignedBB axisAlignedBB = bound = it2.func_72317_d((double)xOff, (double)yOff, (double)zOff);
                                        Intrinsics.checkExpressionValueIsNotNull((Object)axisAlignedBB, (String)"bound");
                                        if (this.field_70170_p.func_184144_a(null, ExtensionsKt.grow(axisAlignedBB, growVec)).isEmpty()) continue;
                                        bl2 = false;
                                        break block13;
                                    }
                                    bl2 = empty = true;
                                }
                            }
                            if (empty) {
                                bestDist = dist;
                                bestSpot = orgPos.func_177982_a((int)xOff, (int)yOff, (int)zOff);
                            }
                        }
                        ++zOff;
                    }
                    ++xOff;
                }
            }
            ++yOff;
        }
        BlockPos blockPos = bestSpot;
        if (blockPos == null) {
            blockPos = orgPos;
        }
        return blockPos;
    }

    public OneWayPortalEntity(boolean isTailEnd, @NotNull World world2, @NotNull FinitePortal portal, @NotNull OneWayPortalEntityPortalAgent agent) {
        Intrinsics.checkParameterIsNotNull((Object)world2, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)portal, (String)"portal");
        Intrinsics.checkParameterIsNotNull((Object)agent, (String)"agent");
        super(world2, portal, agent);
        agent.setOneWayEntity$bp_master_api(this);
        this.field_70180_af.func_187227_b(IS_TAIL_END, (Object)isTailEnd);
        this.field_70180_af.func_187227_b(ORIGINAL_TAIL_POS, (Object)(isTailEnd ? portal.getLocalPosition() : portal.getRemotePosition()));
        this.checkTailObstructionDelay = new TickTimer(200, world2);
        this.checkTailPreferredPosDelay = new TickTimer(1200, world2);
    }

    public OneWayPortalEntity(boolean isTailEnd, @NotNull World world2, @NotNull FinitePortal portal, @NotNull PortalConfiguration portalConfig) {
        Intrinsics.checkParameterIsNotNull((Object)world2, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)portal, (String)"portal");
        Intrinsics.checkParameterIsNotNull((Object)portalConfig, (String)"portalConfig");
        this(isTailEnd, world2, portal, new OneWayPortalEntityPortalAgent(PortalAgentKt.getPortalManager(world2), portalConfig));
    }

    static {
        Companion = new Companion(null);
        DataParameter dataParameter = EntityDataManager.func_187226_a(OneWayPortalEntity.class, (DataSerializer)DataSerializers.field_187198_h);
        Intrinsics.checkExpressionValueIsNotNull((Object)dataParameter, (String)"EntityDataManager.create\u2026 DataSerializers.BOOLEAN)");
        IS_TAIL_END = dataParameter;
        DataParameter dataParameter2 = EntityDataManager.func_187226_a(OneWayPortalEntity.class, (DataSerializer)DataSerializers.field_187200_j);
        Intrinsics.checkExpressionValueIsNotNull((Object)dataParameter2, (String)"EntityDataManager.create\u2026ataSerializers.BLOCK_POS)");
        ORIGINAL_TAIL_POS = dataParameter2;
        DataParameter dataParameter3 = EntityDataManager.func_187226_a(OneWayPortalEntity.class, (DataSerializer)DataSerializers.field_187198_h);
        Intrinsics.checkExpressionValueIsNotNull((Object)dataParameter3, (String)"EntityDataManager.create\u2026 DataSerializers.BOOLEAN)");
        IS_TAIL_VISIBLE = dataParameter3;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lde/johni0702/minecraft/betterportals/common/entity/OneWayPortalEntity$Companion;", "", "()V", "IS_TAIL_END", "Lnet/minecraft/network/datasync/DataParameter;", "", "IS_TAIL_VISIBLE", "ORIGINAL_TAIL_POS", "Lnet/minecraft/util/math/BlockPos;", "bp-master_api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

