/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.betterportals.common.entity;

import com.google.common.base.Predicate;
import de.johni0702.minecraft.betterportals.common.ExtensionsKt;
import de.johni0702.minecraft.betterportals.common.FinitePortal;
import de.johni0702.minecraft.betterportals.common.Portal;
import de.johni0702.minecraft.betterportals.common.PortalAgent;
import de.johni0702.minecraft.betterportals.common.PortalAgentKt;
import de.johni0702.minecraft.betterportals.common.PortalConfiguration;
import de.johni0702.minecraft.betterportals.common.entity.Linkable;
import de.johni0702.minecraft.betterportals.common.entity.PortalEntity;
import de.johni0702.minecraft.betterportals.common.entity.PortalEntityPortalAgent;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 52\u00020\u00012\u00020\u00022\u00020\u0003:\u00015B\u001f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001aH\u0016J\b\u0010\u001d\u001a\u00020\u0016H\u0014J\b\u0010\u001e\u001a\u0004\u0018\u00010\u0000J\b\u0010\u001f\u001a\u00020 H\u0016J\u0012\u0010!\u001a\u00020\u001a2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0016J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%H\u0017J\u0010\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u0003H\u0016J\u0014\u0010(\u001a\u00020\u00162\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*H\u0016J\b\u0010+\u001a\u00020\u0016H\u0015J\b\u0010,\u001a\u00020\u0016H\u0016J\u0010\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020/H\u0014J\b\u00100\u001a\u00020\u0016H\u0014J\u0010\u00101\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u00102\u001a\u00020\u0016H\u0016J\b\u00103\u001a\u00020\u001aH\u0014J\u0010\u00104\u001a\u00020\u00162\u0006\u0010.\u001a\u00020/H\u0014R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u00066"}, d2={"Lde/johni0702/minecraft/betterportals/common/entity/AbstractPortalEntity;", "Lnet/minecraft/entity/Entity;", "Lde/johni0702/minecraft/betterportals/common/entity/PortalEntity;", "Lde/johni0702/minecraft/betterportals/common/entity/Linkable;", "world", "Lnet/minecraft/world/World;", "portal", "Lde/johni0702/minecraft/betterportals/common/FinitePortal;", "portalConfig", "Lde/johni0702/minecraft/betterportals/common/PortalConfiguration;", "(Lnet/minecraft/world/World;Lde/johni0702/minecraft/betterportals/common/FinitePortal;Lde/johni0702/minecraft/betterportals/common/PortalConfiguration;)V", "agent", "Lde/johni0702/minecraft/betterportals/common/entity/PortalEntityPortalAgent;", "(Lnet/minecraft/world/World;Lde/johni0702/minecraft/betterportals/common/FinitePortal;Lde/johni0702/minecraft/betterportals/common/entity/PortalEntityPortalAgent;)V", "getAgent", "()Lde/johni0702/minecraft/betterportals/common/entity/PortalEntityPortalAgent;", "value", "getPortal", "()Lde/johni0702/minecraft/betterportals/common/FinitePortal;", "setPortal", "(Lde/johni0702/minecraft/betterportals/common/FinitePortal;)V", "addTrackingPlayer", "", "player", "Lnet/minecraft/entity/player/EntityPlayerMP;", "canBeAttackedWithItem", "", "canBeCollidedWith", "canBePushed", "entityInit", "getRemotePortal", "getRenderBoundingBox", "Lnet/minecraft/util/math/AxisAlignedBB;", "hitByEntity", "entityIn", "isInRangeToRenderDist", "distance", "", "link", "other", "notifyDataManagerChange", "key", "Lnet/minecraft/network/datasync/DataParameter;", "onClientUpdate", "onUpdate", "readEntityFromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "removePortal", "removeTrackingPlayer", "setDead", "shouldSetPosAfterLoading", "writeEntityToNBT", "Companion", "bp-master_api"})
public abstract class AbstractPortalEntity
extends Entity
implements PortalEntity,
Linkable {
    @NotNull
    private FinitePortal portal;
    @NotNull
    private final PortalEntityPortalAgent agent;
    private static final DataParameter<NBTTagCompound> PORTAL;
    public static final Companion Companion;

    @Override
    @NotNull
    public FinitePortal getPortal() {
        return this.portal;
    }

    public void setPortal(@NotNull FinitePortal value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.portal = value;
        this.field_70180_af.func_187227_b(PORTAL, (Object)value.writePortalToNBT());
        this.agent.setPortal((Portal)value);
        Vec3d vec3d = ExtensionsKt.to3dMid((Vec3i)value.getLocalPosition());
        boolean bl = false;
        boolean bl2 = false;
        Vec3d $this$with = vec3d;
        boolean bl3 = false;
        this.func_70107_b($this$with.field_72450_a, $this$with.field_72448_b, $this$with.field_72449_c);
    }

    @NotNull
    public AxisAlignedBB func_184177_bl() {
        return this.getPortal().getLocalBoundingBox();
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(PORTAL, (Object)new NBTTagCompound());
    }

    public void func_184206_a(@NotNull DataParameter<?> key) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        super.func_184206_a(key);
        if (this.field_70170_p.field_72995_K && Intrinsics.areEqual(key, PORTAL)) {
            Object object = this.field_70180_af.func_187225_a(PORTAL);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"dataManager.get(PORTAL)");
            this.setPortal(new FinitePortal((NBTTagCompound)object));
        }
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            this.onClientUpdate();
        }
    }

    public boolean func_70075_an() {
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_85031_j(@Nullable Entity entityIn) {
        return true;
    }

    protected boolean func_142008_O() {
        return false;
    }

    protected void func_70037_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        NBTBase nBTBase = compound.func_74781_a("BetterPortal");
        if (nBTBase == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagCompound");
        }
        this.setPortal(new FinitePortal((NBTTagCompound)nBTBase));
    }

    protected void func_70014_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        compound.func_74782_a("BetterPortal", (NBTBase)this.getPortal().writePortalToNBT());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final AbstractPortalEntity getRemotePortal() {
        World world2;
        if (this.field_70170_p.field_72995_K) {
            WorldClient worldClient = this.agent.getRemoteClientWorld();
            if (worldClient == null) return null;
            world2 = (World)worldClient;
        } else {
            World world3 = this.field_70170_p;
            Intrinsics.checkExpressionValueIsNotNull((Object)world3, (String)"world");
            MinecraftServer minecraftServer = world3.func_73046_m();
            if (minecraftServer == null) {
                Intrinsics.throwNpe();
            }
            Integer n = this.getPortal().getRemoteDimension();
            if (n == null) {
                return null;
            }
            world2 = (World)minecraftServer.func_71218_a(n.intValue());
        }
        World remoteWorld = world2;
        Chunk chunk = remoteWorld.func_175726_f(this.getPortal().getRemotePosition());
        boolean bl = false;
        List list = new ArrayList();
        chunk.func_177430_a(this.getClass(), new AxisAlignedBB(this.getPortal().getRemotePosition()), list, (Predicate)new Predicate<AbstractPortalEntity>(this){
            final /* synthetic */ AbstractPortalEntity this$0;

            public final boolean apply(@Nullable AbstractPortalEntity it) {
                Object object = it;
                return object != null && (object = ((AbstractPortalEntity)object).getAgent()) != null && ((PortalAgent)object).isLinked(this.this$0.getAgent());
            }
            {
                this.this$0 = abstractPortalEntity;
            }
        });
        return (AbstractPortalEntity)CollectionsKt.firstOrNull((List)list);
    }

    public void func_184178_b(@NotNull EntityPlayerMP player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        super.func_184178_b(player);
        this.agent.addTrackingPlayer(player);
    }

    public void func_184203_c(@NotNull EntityPlayerMP player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        super.func_184203_c(player);
        this.agent.removeTrackingPlayer(player);
    }

    @Override
    public void link(@NotNull Linkable other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        this.setPortal(this.getPortal().withRemote(other.getPortal()));
        if (!other.getPortal().isTarget(this.getPortal())) {
            other.link(this);
        }
        this.agent.updateViews();
    }

    public void func_70106_y() {
        if (this.field_70128_L) {
            return;
        }
        super.func_70106_y();
        if (this.field_70170_p instanceof WorldServer) {
            AbstractPortalEntity abstractPortalEntity = this.getRemotePortal();
            if (abstractPortalEntity != null) {
                abstractPortalEntity.func_70106_y();
            }
            this.removePortal();
        }
    }

    protected void removePortal() {
        Iterable $this$forEach$iv = this.getPortal().getLocalBlocks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockPos it = (BlockPos)element$iv;
            boolean bl = false;
            this.field_70170_p.func_175698_g(it);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    protected void onClientUpdate() {
    }

    @NotNull
    public final PortalEntityPortalAgent getAgent() {
        return this.agent;
    }

    public AbstractPortalEntity(@NotNull World world2, @NotNull FinitePortal portal, @NotNull PortalEntityPortalAgent agent) {
        Intrinsics.checkParameterIsNotNull((Object)world2, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)portal, (String)"portal");
        Intrinsics.checkParameterIsNotNull((Object)agent, (String)"agent");
        super(world2);
        this.agent = agent;
        this.agent.setEntity$bp_master_api(this);
        this.agent.setPortal((Portal)portal);
        this.field_70180_af.func_187227_b(PORTAL, (Object)portal.writePortalToNBT());
        this.portal = portal;
        this.field_70158_ak = true;
        this.field_70130_N = 0.0f;
        this.field_70131_O = 0.0f;
        Vec3d vec3d = ExtensionsKt.to3d((Vec3i)portal.getLocalPosition());
        boolean bl = false;
        boolean bl2 = false;
        Vec3d $this$with = vec3d;
        boolean bl3 = false;
        this.func_70107_b($this$with.field_72450_a + 0.5, $this$with.field_72448_b + 0.5, $this$with.field_72449_c + 0.5);
        this.func_70101_b(ExtensionsKt.getDegrees(portal.getLocalRotation()), 0.0f);
    }

    public AbstractPortalEntity(@NotNull World world2, @NotNull FinitePortal portal, @NotNull PortalConfiguration portalConfig) {
        Intrinsics.checkParameterIsNotNull((Object)world2, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)portal, (String)"portal");
        Intrinsics.checkParameterIsNotNull((Object)portalConfig, (String)"portalConfig");
        this(world2, portal, new PortalEntityPortalAgent(PortalAgentKt.getPortalManager(world2), portalConfig));
    }

    static {
        Companion = new Companion(null);
        DataParameter dataParameter = EntityDataManager.func_187226_a(AbstractPortalEntity.class, (DataSerializer)DataSerializers.field_192734_n);
        Intrinsics.checkExpressionValueIsNotNull((Object)dataParameter, (String)"EntityDataManager.create\u2026Serializers.COMPOUND_TAG)");
        PORTAL = dataParameter;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/johni0702/minecraft/betterportals/common/entity/AbstractPortalEntity$Companion;", "", "()V", "PORTAL", "Lnet/minecraft/network/datasync/DataParameter;", "Lnet/minecraft/nbt/NBTTagCompound;", "bp-master_api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

