/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.betterportals.common.block;

import de.johni0702.minecraft.betterportals.common.ExtensionsKt;
import de.johni0702.minecraft.betterportals.common.FinitePortal;
import de.johni0702.minecraft.betterportals.common.Gettable;
import de.johni0702.minecraft.betterportals.common.block.PortalBlock;
import de.johni0702.minecraft.betterportals.common.block.PortalBlock$WhenMappings;
import de.johni0702.minecraft.betterportals.common.entity.Linkable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.ForgeChunkManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\bf\u0018\u0000*\f\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u00032\u00020\u0004J>\u0010\u0018\u001a\u00020\u00192\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\n0\u001bj\u0002`\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0019H\u0016J>\u0010#\u001a\u00020\u00192\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\n0\u001bj\u0002`\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001f2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0016J%\u0010%\u001a\u00028\u00002\u0006\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H&\u00a2\u0006\u0002\u0010+JH\u0010,\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020/0.0-2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u0002042\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001f2\u0006\u00105\u001a\u000201H\u0016JB\u00106\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001f\u0012\u0004\u0012\u00020!0.2\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\n0\u001bj\u0002`\u001d2\u0006\u00107\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u0019H\u0016J>\u00106\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001f2\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\n0\u001bj\u0002`\u001d2\u0006\u00107\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0019H\u0016J\u001a\u00108\u001a\u0004\u0018\u0001012\u0006\u00100\u001a\u0002012\u0006\u0010$\u001a\u00020\u001cH&J\u0010\u00109\u001a\u00020\u00192\u0006\u0010:\u001a\u00020\nH\u0016J\u0010\u0010;\u001a\u00020\u00192\u0006\u0010:\u001a\u00020\nH\u0016J&\u0010<\u001a\u00020=2\u0006\u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020!2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001fH\u0016J\u0018\u0010>\u001a\u00020\u00192\u0006\u00100\u001a\u00020(2\u0006\u0010$\u001a\u00020\u001cH\u0016J\u0018\u0010?\u001a\u00020=2\u0006\u0010'\u001a\u00020(2\u0006\u0010$\u001a\u00020\u001cH\u0016R\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\f\u00a8\u0006@"}, d2={"Lde/johni0702/minecraft/betterportals/common/block/PortalBlock;", "EntityType", "Lnet/minecraft/entity/Entity;", "Lde/johni0702/minecraft/betterportals/common/entity/Linkable;", "", "entityType", "Ljava/lang/Class;", "getEntityType", "()Ljava/lang/Class;", "frameBlock", "Lnet/minecraft/block/state/IBlockState;", "getFrameBlock", "()Lnet/minecraft/block/state/IBlockState;", "frameStepsBlock", "getFrameStepsBlock", "maxPortalSize", "", "getMaxPortalSize", "()I", "mod", "getMod", "()Ljava/lang/Object;", "portalBlock", "getPortalBlock", "checkPortal", "", "blockCache", "Lde/johni0702/minecraft/betterportals/common/Gettable;", "Lnet/minecraft/util/math/BlockPos;", "Lde/johni0702/minecraft/betterportals/common/BlockCache;", "portalBlocks", "", "axis", "Lnet/minecraft/util/EnumFacing$Axis;", "filled", "considerPlacingPortalAt", "pos", "createPortalEntity", "localEnd", "world", "Lnet/minecraft/world/World;", "portal", "Lde/johni0702/minecraft/betterportals/common/FinitePortal;", "(ZLnet/minecraft/world/World;Lde/johni0702/minecraft/betterportals/common/FinitePortal;)Lnet/minecraft/entity/Entity;", "findOrCreateRemotePortal", "Ljava/util/concurrent/CompletableFuture;", "Lkotlin/Pair;", "Lnet/minecraft/util/Rotation;", "localWorld", "Lnet/minecraft/world/WorldServer;", "localPos", "plane", "Lnet/minecraft/util/EnumFacing$Plane;", "remoteWorld", "findPortalFrame", "startPos", "getRemoteWorldFor", "isFrameBlock", "blockState", "isPortalBlock", "placePortalFrame", "", "tryToLinkPortals", "validatePortalOrDestroy", "bp-master_api"})
public interface PortalBlock<EntityType extends Entity> {
    @NotNull
    public IBlockState getPortalBlock();

    public boolean isPortalBlock(@NotNull IBlockState var1);

    @NotNull
    public IBlockState getFrameBlock();

    public boolean isFrameBlock(@NotNull IBlockState var1);

    @NotNull
    public IBlockState getFrameStepsBlock();

    public int getMaxPortalSize();

    @NotNull
    public Class<EntityType> getEntityType();

    @NotNull
    public Object getMod();

    @Nullable
    public WorldServer getRemoteWorldFor(@NotNull WorldServer var1, @NotNull BlockPos var2);

    @NotNull
    public EntityType createPortalEntity(boolean var1, @NotNull World var2, @NotNull FinitePortal var3);

    public boolean tryToLinkPortals(@NotNull World var1, @NotNull BlockPos var2);

    @NotNull
    public CompletableFuture<Pair<BlockPos, Rotation>> findOrCreateRemotePortal(@NotNull WorldServer var1, @NotNull BlockPos var2, @NotNull EnumFacing.Plane var3, @NotNull Set<? extends BlockPos> var4, @NotNull WorldServer var5);

    @NotNull
    public Pair<Set<BlockPos>, EnumFacing.Axis> findPortalFrame(@NotNull Gettable<? super BlockPos, ? extends IBlockState> var1, @NotNull BlockPos var2, boolean var3);

    @NotNull
    public Set<BlockPos> findPortalFrame(@NotNull Gettable<? super BlockPos, ? extends IBlockState> var1, @NotNull BlockPos var2, @NotNull EnumFacing.Axis var3, boolean var4);

    public boolean considerPlacingPortalAt(@NotNull Gettable<? super BlockPos, ? extends IBlockState> var1, @NotNull Set<? extends BlockPos> var2, @NotNull BlockPos var3, @NotNull EnumFacing.Axis var4);

    public boolean checkPortal(@NotNull Gettable<? super BlockPos, ? extends IBlockState> var1, @NotNull Set<? extends BlockPos> var2, @NotNull EnumFacing.Axis var3, boolean var4);

    public void placePortalFrame(@NotNull World var1, @NotNull EnumFacing.Axis var2, @NotNull Set<? extends BlockPos> var3);

    public void validatePortalOrDestroy(@NotNull World var1, @NotNull BlockPos var2);

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static <EntityType extends Entity> boolean isPortalBlock(PortalBlock<EntityType> $this, @NotNull IBlockState blockState) {
            Intrinsics.checkParameterIsNotNull((Object)blockState, (String)"blockState");
            return Intrinsics.areEqual((Object)blockState, (Object)$this.getPortalBlock());
        }

        public static <EntityType extends Entity> boolean isFrameBlock(PortalBlock<EntityType> $this, @NotNull IBlockState blockState) {
            Intrinsics.checkParameterIsNotNull((Object)blockState, (String)"blockState");
            return Intrinsics.areEqual((Object)blockState, (Object)$this.getFrameBlock());
        }

        /*
         * WARNING - void declaration
         */
        public static <EntityType extends Entity> boolean tryToLinkPortals(PortalBlock<EntityType> $this, @NotNull World localWorld, @NotNull BlockPos pos) {
            void $this$mapTo$iv;
            void localBlocks;
            Intrinsics.checkParameterIsNotNull((Object)localWorld, (String)"localWorld");
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            if (!(localWorld instanceof WorldServer)) {
                return false;
            }
            Pair<Set<BlockPos>, EnumFacing.Axis> pair = $this.findPortalFrame(ExtensionsKt.makeBlockCache$default(localWorld, false, 1, null), pos, false);
            Set set = (Set)pair.component1();
            EnumFacing.Axis localAxis = (EnumFacing.Axis)pair.component2();
            if (localBlocks.isEmpty()) {
                return false;
            }
            WorldProvider worldProvider = localWorld.field_73011_w;
            Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"localWorld.provider");
            int localDim = worldProvider.getDimension();
            BlockPos blockPos = ExtensionsKt.minByAnyCoord((Collection)localBlocks);
            if (blockPos == null) {
                Intrinsics.throwNpe();
            }
            BlockPos localPos = blockPos;
            Rotation localRot = ExtensionsKt.toRotation(ExtensionsKt.toFacing(localAxis, EnumFacing.AxisDirection.POSITIVE));
            Iterable iterable = (Iterable)localBlocks;
            boolean bl = false;
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                BlockPos blockPos2 = (BlockPos)item$iv;
                Collection collection = destination$iv;
                boolean bl2 = false;
                BlockPos blockPos3 = it.func_177973_b((Vec3i)localPos).func_190942_a(ExtensionsKt.getReverse(localRot));
                collection.add(blockPos3);
            }
            Set portalBlocks = (Set)destination$iv;
            WorldServer worldServer = $this.getRemoteWorldFor((WorldServer)localWorld, pos);
            if (worldServer == null) {
                return false;
            }
            WorldServer remoteWorld = worldServer;
            WorldProvider worldProvider2 = remoteWorld.field_73011_w;
            Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider2, (String)"remoteWorld.provider");
            int remoteDim = worldProvider2.getDimension();
            CompletableFuture<Pair<BlockPos, Rotation>> future2 = $this.findOrCreateRemotePortal((WorldServer)localWorld, localPos, ExtensionsKt.getPerpendicularPlane(localAxis), portalBlocks, remoteWorld);
            EntityType localPortal = $this.createPortalEntity(true, localWorld, new FinitePortal(ExtensionsKt.getPerpendicularPlane(localAxis), portalBlocks, localDim, localPos, localRot));
            Iterable $this$forEach$iv = ((Linkable)localPortal).getPortal().getLocalBlocks();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BlockPos it = (BlockPos)element$iv;
                boolean bl3 = false;
                localWorld.func_180501_a(it, $this.getPortalBlock(), 2);
            }
            ExtensionsKt.forceSpawnEntity(localWorld, localPortal);
            ((CompletableFuture)future2.thenAcceptAsync(new Consumer<Pair<? extends BlockPos, ? extends Rotation>>($this, (Entity)localPortal, remoteWorld, localAxis, portalBlocks, remoteDim){
                final /* synthetic */ PortalBlock this$0;
                final /* synthetic */ Entity $localPortal;
                final /* synthetic */ WorldServer $remoteWorld;
                final /* synthetic */ EnumFacing.Axis $localAxis;
                final /* synthetic */ Set $portalBlocks;
                final /* synthetic */ int $remoteDim;

                /*
                 * WARNING - void declaration
                 */
                public final void accept(Pair<? extends BlockPos, ? extends Rotation> result) {
                    void remotePos;
                    if (this.$localPortal.field_70128_L) {
                        return;
                    }
                    Pair<? extends BlockPos, ? extends Rotation> pair = result;
                    BlockPos blockPos = (BlockPos)pair.component1();
                    Rotation remoteRot = (Rotation)pair.component2();
                    EntityType remotePortal = this.this$0.createPortalEntity(false, (World)this.$remoteWorld, new FinitePortal(ExtensionsKt.getPerpendicularPlane(this.$localAxis), this.$portalBlocks, this.$remoteDim, (BlockPos)remotePos, remoteRot));
                    Iterable $this$forEach$iv = ((Linkable)remotePortal).getPortal().getLocalBlocks();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        BlockPos it = (BlockPos)element$iv;
                        boolean bl = false;
                        this.$remoteWorld.func_180501_a(it, this.this$0.getPortalBlock(), 2);
                    }
                    ExtensionsKt.forceSpawnEntity((World)this.$remoteWorld, remotePortal);
                    ((Linkable)this.$localPortal).link((Linkable)remotePortal);
                }
                {
                    this.this$0 = portalBlock;
                    this.$localPortal = entity;
                    this.$remoteWorld = worldServer;
                    this.$localAxis = axis;
                    this.$portalBlocks = set;
                    this.$remoteDim = n;
                }
            }, new Executor(localWorld){
                final /* synthetic */ World $localWorld;

                public final void execute(Runnable it) {
                    ExtensionsKt.getServer((WorldServer)this.$localWorld).func_152344_a(it);
                }
                {
                    this.$localWorld = world2;
                }
            })).exceptionally(new Function<Throwable, Void>((Entity)localPortal){
                final /* synthetic */ Entity $localPortal;

                @NotNull
                public final Void apply(Throwable it) {
                    this.$localPortal.func_70106_y();
                    CrashReport report = CrashReport.func_85055_a((Throwable)it, (String)"Finding remote portal");
                    throw (Throwable)new ReportedException(report);
                }
                {
                    this.$localPortal = entity;
                }
            });
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static <EntityType extends Entity> CompletableFuture<Pair<BlockPos, Rotation>> findOrCreateRemotePortal(PortalBlock<EntityType> $this, @NotNull WorldServer localWorld, @NotNull BlockPos localPos, @NotNull EnumFacing.Plane plane, @NotNull Set<? extends BlockPos> portalBlocks, @NotNull WorldServer remoteWorld) {
            Collection<Integer> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            int n;
            Intrinsics.checkParameterIsNotNull((Object)localWorld, (String)"localWorld");
            Intrinsics.checkParameterIsNotNull((Object)localPos, (String)"localPos");
            Intrinsics.checkParameterIsNotNull((Object)plane, (String)"plane");
            Intrinsics.checkParameterIsNotNull(portalBlocks, (String)"portalBlocks");
            Intrinsics.checkParameterIsNotNull((Object)remoteWorld, (String)"remoteWorld");
            WorldProvider worldProvider = localWorld.field_73011_w;
            Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"localWorld.provider");
            double d = worldProvider.getMovementFactor();
            WorldProvider worldProvider2 = remoteWorld.field_73011_w;
            Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider2, (String)"remoteWorld.provider");
            double movementFactor = d / worldProvider2.getMovementFactor();
            boolean isCubicWorld = ExtensionsKt.isCubicWorld((World)remoteWorld);
            if (isCubicWorld) {
                n = Integer.MAX_VALUE;
            } else {
                WorldProvider worldProvider3 = remoteWorld.field_73011_w;
                Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider3, (String)"remoteWorld.provider");
                n = worldProvider3.getActualHeight() - 1;
            }
            int maxY = n;
            int minY = isCubicWorld ? Integer.MIN_VALUE : 0;
            Iterable iterable = portalBlocks;
            int n2 = maxY;
            int n3 = localPos.func_177956_o();
            int n4 = RangesKt.coerceIn((int)RangesKt.coerceIn((int)MathKt.roundToInt((double)((double)localPos.func_177958_n() * movementFactor)), (int)((int)remoteWorld.func_175723_af().func_177726_b() + 16), (int)((int)remoteWorld.func_175723_af().func_177728_d() - 16)), (int)-29999872, (int)29999872);
            boolean $i$f$map = false;
            void var14_17 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                BlockPos blockPos = (BlockPos)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Integer n5 = it.func_177956_o();
                collection.add(n5);
            }
            collection = (List)destination$iv$iv;
            Integer n6 = (Integer)CollectionsKt.max((Iterable)collection);
            int n7 = RangesKt.coerceIn((int)RangesKt.coerceIn((int)MathKt.roundToInt((double)((double)localPos.func_177952_p() * movementFactor)), (int)((int)remoteWorld.func_175723_af().func_177736_c() + 16), (int)((int)remoteWorld.func_175723_af().func_177733_e() - 16)), (int)-29999872, (int)29999872);
            int n8 = RangesKt.coerceAtMost((int)n3, (int)(n2 - (n6 != null ? n6 : 0)));
            int n9 = n4;
            BlockPos remotePosition = new BlockPos(n9, n8, n7);
            int searchDist = 64;
            BlockPos remotePos0 = remotePosition.func_177982_a(0, -remotePosition.func_177956_o(), 0);
            ChunkPos remoteChunkPos = new ChunkPos(remotePos0);
            BlockPos searchMin = isCubicWorld ? remotePosition.func_177982_a(-searchDist, -searchDist, -searchDist) : remotePos0.func_177982_a(-searchDist, minY, -searchDist);
            BlockPos searchMax = isCubicWorld ? remotePosition.func_177982_a(searchDist, searchDist, searchDist) : remotePos0.func_177982_a(searchDist, maxY, searchDist);
            Gettable<BlockPos, IBlockState> asyncBlockCache = ExtensionsKt.makeBulkBlockCache((World)remoteWorld);
            BlockPos cacheMin = searchMin.func_177982_a(-$this.getMaxPortalSize() - 16, isCubicWorld ? -$this.getMaxPortalSize() : 0, -$this.getMaxPortalSize() - 16);
            BlockPos cacheMax = searchMax.func_177982_a($this.getMaxPortalSize() + 16, isCubicWorld ? $this.getMaxPortalSize() : 0, $this.getMaxPortalSize() + 16);
            BlockPos blockPos = cacheMin;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"cacheMin");
            BlockPos blockPos2 = cacheMax;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"cacheMax");
            CompletableFuture<Void> cacheFuture = ExtensionsKt.asyncLoadBulkBlockCache(remoteWorld, asyncBlockCache, blockPos, blockPos2);
            ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestTicket((Object)$this.getMod(), (World)((World)remoteWorld), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)remoteChunkPos);
            CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)cacheFuture.thenApplyAsync(new Function<T, U>($this, portalBlocks, searchMin, searchMax, asyncBlockCache, plane){
                final /* synthetic */ PortalBlock this$0;
                final /* synthetic */ Set $portalBlocks;
                final /* synthetic */ BlockPos $searchMin;
                final /* synthetic */ BlockPos $searchMax;
                final /* synthetic */ Gettable $asyncBlockCache;
                final /* synthetic */ EnumFacing.Plane $plane;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Pair<List<Pair<BlockPos, Rotation>>, List<Triple<BlockPos, Rotation, EnumFacing.Axis>>> apply(Void it) {
                    void $this$associateByTo$iv$iv;
                    boolean bl = false;
                    List existingFrames = new ArrayList<E>();
                    boolean bl2 = false;
                    Set checkedPositions = new LinkedHashSet<E>();
                    boolean bl3 = false;
                    List nicePositions = new ArrayList<E>();
                    Rotation[] $this$associateBy$iv = Rotation.values();
                    boolean $i$f$associateBy = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
                    Rotation[] rotationArray = $this$associateBy$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                    boolean $i$f$associateByTo = false;
                    for (void element$iv$iv : $this$associateByTo$iv$iv) {
                        void $this$mapTo$iv;
                        void it2;
                        Map.Entry<K, V> entry = element$iv$iv;
                        Map map = destination$iv$iv;
                        boolean bl4 = false;
                        void var33_46 = it2;
                        it2 = element$iv$iv;
                        boolean bl5 = false;
                        Rotation[] rotationArray2 = (Rotation[])this.$portalBlocks;
                        boolean bl6 = false;
                        Collection destination$iv = new LinkedHashSet<E>();
                        boolean $i$f$mapTo = false;
                        for (Object item$iv : $this$mapTo$iv) {
                            void rot;
                            void it3;
                            BlockPos blockPos = (BlockPos)item$iv;
                            Collection collection = destination$iv;
                            boolean bl7 = false;
                            BlockPos blockPos2 = it3.func_190942_a((Rotation)rot);
                            collection.add(blockPos2);
                        }
                        Set set = (Set)destination$iv;
                        map.put(var33_46, set);
                    }
                    Map rotatedPortalBlocks = destination$iv$iv;
                    Iterable iterable = BlockPos.MutableBlockPos.func_177975_b((BlockPos)this.$searchMin, (BlockPos)this.$searchMax);
                    Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"BlockPos.MutableBlockPos\u2026ble(searchMin, searchMax)");
                    Iterable $this$forEach$iv = iterable;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Object portalPos;
                        BlockPos.MutableBlockPos pos = (BlockPos.MutableBlockPos)element$iv;
                        boolean bl8 = false;
                        BlockPos.MutableBlockPos mutableBlockPos = pos;
                        Intrinsics.checkExpressionValueIsNotNull((Object)mutableBlockPos, (String)"pos");
                        IBlockState blockState = (IBlockState)this.$asyncBlockCache.get(mutableBlockPos);
                        if (this.this$0.isFrameBlock(blockState)) {
                            for (EnumFacing potentialStartDirection : this.$plane.func_179516_a()) {
                                portalPos = pos.func_177972_a(potentialStartDirection);
                                BlockPos blockPos = portalPos;
                                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"portalPos");
                                if (!checkedPositions.add(blockPos)) continue;
                                for (Rotation rotation : Rotation.values()) {
                                    void $this$mapTo$iv;
                                    Object item$iv;
                                    item$iv = this.$portalBlocks;
                                    boolean it3 = false;
                                    Collection destination$iv = new LinkedHashSet<E>();
                                    boolean $i$f$mapTo = false;
                                    for (T item$iv2 : $this$mapTo$iv) {
                                        void it4;
                                        BlockPos blockPos3 = (BlockPos)item$iv2;
                                        Collection collection = destination$iv;
                                        boolean bl9 = false;
                                        BlockPos blockPos4 = it4.func_190942_a(rotation).func_177971_a((Vec3i)portalPos);
                                        collection.add(blockPos4);
                                    }
                                    Set remoteBlocks = (Set)destination$iv;
                                    for (EnumFacing.Axis axis : ExtensionsKt.getPerpendicularAxes(this.$plane)) {
                                        if (!this.this$0.checkPortal(this.$asyncBlockCache, remoteBlocks, axis, false)) continue;
                                        existingFrames.add(new Pair(portalPos, (Object)rotation));
                                    }
                                }
                            }
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)blockState.func_177230_c(), (Object)Blocks.field_150350_a)) continue;
                        Map map = rotatedPortalBlocks;
                        int n = 0;
                        for (Map.Entry<K, V> entry : map.entrySet()) {
                            EnumFacing.Axis axis;
                            portalPos = entry;
                            boolean bl10 = false;
                            Rotation rotation = (Rotation)portalPos.getKey();
                            portalPos = entry;
                            bl10 = false;
                            Set blocks = (Set)portalPos.getValue();
                            if (!this.this$0.considerPlacingPortalAt(this.$asyncBlockCache, blocks, (BlockPos)pos, axis = ExtensionsKt.axis(rotation, ExtensionsKt.getOpposite(this.$plane)))) continue;
                            nicePositions.add(new Triple((Object)pos.func_185334_h(), (Object)rotation, (Object)axis));
                        }
                    }
                    return new Pair((Object)existingFrames, (Object)nicePositions);
                }
                {
                    this.this$0 = portalBlock;
                    this.$portalBlocks = set;
                    this.$searchMin = blockPos;
                    this.$searchMax = blockPos2;
                    this.$asyncBlockCache = gettable;
                    this.$plane = plane;
                }
            })).thenApplyAsync(new Function<T, U>($this, remoteWorld, remotePosition, portalBlocks, plane, localPos){
                final /* synthetic */ PortalBlock this$0;
                final /* synthetic */ WorldServer $remoteWorld;
                final /* synthetic */ BlockPos $remotePosition;
                final /* synthetic */ Set $portalBlocks;
                final /* synthetic */ EnumFacing.Plane $plane;
                final /* synthetic */ BlockPos $localPos;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Pair<BlockPos, Rotation> apply(Pair<? extends List<Pair<BlockPos, Rotation>>, ? extends List<Triple<BlockPos, Rotation, EnumFacing.Axis>>> $dstr$existingFrames$nicePositions) {
                    void $this$mapTo$iv;
                    EnumFacing.Axis axis;
                    Object v0;
                    BlockPos blockPos;
                    BlockPos it;
                    Collection collection;
                    Iterable $this$mapTo$iv2;
                    boolean $i$f$mapTo;
                    boolean $i$f$firstOrNull;
                    Iterable $this$firstOrNull$iv;
                    Object object;
                    boolean $i$f$sortedBy;
                    Iterable $this$sortedBy$iv;
                    List nicePositions;
                    block6: {
                        List existingFrames = (List)$dstr$existingFrames$nicePositions.component1();
                        nicePositions = (List)$dstr$existingFrames$nicePositions.component2();
                        Gettable currentBlockCache = ExtensionsKt.makeBlockCache$default((World)this.$remoteWorld, false, 1, null);
                        $this$sortedBy$iv = existingFrames;
                        $i$f$sortedBy = false;
                        object = $this$sortedBy$iv;
                        boolean bl = false;
                        Comparator comparator = new Comparator<T>(this){
                            final /* synthetic */ findOrCreateRemotePortal.2 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final int compare(T a, T b) {
                                boolean bl = false;
                                Pair it = (Pair)a;
                                boolean bl2 = false;
                                Comparable comparable = Double.valueOf(((BlockPos)it.getFirst()).func_177951_i((Vec3i)this.this$0.$remotePosition));
                                it = (Pair)b;
                                Comparable comparable2 = comparable;
                                bl2 = false;
                                Double d = ((BlockPos)it.getFirst()).func_177951_i((Vec3i)this.this$0.$remotePosition);
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
                            }
                        };
                        $this$firstOrNull$iv = CollectionsKt.sortedWith((Iterable)object, (Comparator)comparator);
                        $i$f$firstOrNull = false;
                        for (E element$iv : $this$firstOrNull$iv) {
                            Pair $dstr$portalPos$rotation = (Pair)element$iv;
                            boolean bl2 = false;
                            BlockPos portalPos = (BlockPos)$dstr$portalPos$rotation.component1();
                            Rotation rotation = (Rotation)$dstr$portalPos$rotation.component2();
                            Iterable iterable = this.$portalBlocks;
                            boolean bl3 = false;
                            Collection destination$iv = new LinkedHashSet<E>();
                            $i$f$mapTo = false;
                            for (T item$iv : $this$mapTo$iv2) {
                                BlockPos blockPos2 = (BlockPos)item$iv;
                                collection = destination$iv;
                                boolean bl4 = false;
                                blockPos = it.func_190942_a(rotation).func_177971_a((Vec3i)portalPos);
                                collection.add(blockPos);
                            }
                            Set remoteBlocks = (Set)destination$iv;
                            if (!this.this$0.checkPortal(currentBlockCache, remoteBlocks, ExtensionsKt.axis(rotation, ExtensionsKt.getOpposite(this.$plane)), false)) continue;
                            v0 = element$iv;
                            break block6;
                        }
                        v0 = null;
                    }
                    Pair pair = v0;
                    if (pair != null) {
                        $this$firstOrNull$iv = pair;
                        $i$f$firstOrNull = false;
                        boolean bl = false;
                        Iterable it2 = $this$firstOrNull$iv;
                        boolean bl5 = false;
                        return new Pair(it2.getFirst(), it2.getSecond());
                    }
                    $this$sortedBy$iv = nicePositions;
                    $i$f$sortedBy = false;
                    object = $this$sortedBy$iv;
                    boolean it2 = false;
                    Comparator bl5 = new Comparator<T>(this){
                        final /* synthetic */ findOrCreateRemotePortal.2 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final int compare(T a, T b) {
                            boolean bl = false;
                            Triple it = (Triple)a;
                            boolean bl2 = false;
                            Comparable comparable = Double.valueOf(((BlockPos)it.getFirst()).func_177951_i((Vec3i)this.this$0.$remotePosition));
                            it = (Triple)b;
                            Comparable comparable2 = comparable;
                            bl2 = false;
                            Double d = ((BlockPos)it.getFirst()).func_177951_i((Vec3i)this.this$0.$remotePosition);
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
                        }
                    };
                    Triple triple = (Triple)CollectionsKt.firstOrNull((List)CollectionsKt.sortedWith((Iterable)object, (Comparator)bl5));
                    if (triple != null) {
                        $this$sortedBy$iv = triple;
                        $i$f$sortedBy = false;
                        boolean bl = false;
                        Iterable $dstr$pos$rot$axis = $this$sortedBy$iv;
                        boolean bl6 = false;
                        BlockPos pos = (BlockPos)$dstr$pos$rot$axis.component1();
                        Rotation rot = (Rotation)$dstr$pos$rot$axis.component2();
                        axis = (EnumFacing.Axis)$dstr$pos$rot$axis.component3();
                        $this$mapTo$iv2 = this.$portalBlocks;
                        boolean destination$iv = false;
                        Collection destination$iv2 = new LinkedHashSet<E>();
                        $i$f$mapTo = false;
                        for (T item$iv : $this$mapTo$iv2) {
                            it = (BlockPos)item$iv;
                            collection = destination$iv2;
                            boolean bl7 = false;
                            blockPos = it.func_190942_a(rot).func_177971_a((Vec3i)pos);
                            collection.add(blockPos);
                        }
                        Set blocks = (Set)destination$iv2;
                        this.this$0.placePortalFrame((World)this.$remoteWorld, axis, blocks);
                        return new Pair((Object)pos, (Object)rot);
                    }
                    Rotation portalRotation = Rotation.values()[Math.floorMod(this.$localPos.func_177958_n() + this.$localPos.func_177952_p(), 4)];
                    object = this.$portalBlocks;
                    boolean $dstr$pos$rot$axis = false;
                    Collection destination$iv = new LinkedHashSet<E>();
                    boolean $i$f$mapTo2 = false;
                    for (T item$iv : $this$mapTo$iv) {
                        void it3;
                        axis = (BlockPos)item$iv;
                        Collection collection2 = destination$iv;
                        boolean bl = false;
                        BlockPos blockPos3 = it3.func_190942_a(portalRotation).func_177971_a((Vec3i)this.$remotePosition);
                        collection2.add(blockPos3);
                    }
                    Set blocks = (Set)destination$iv;
                    this.this$0.placePortalFrame((World)this.$remoteWorld, ExtensionsKt.axis(portalRotation, ExtensionsKt.getOpposite(this.$plane)), blocks);
                    return new Pair((Object)this.$remotePosition, (Object)portalRotation);
                }
                {
                    this.this$0 = portalBlock;
                    this.$remoteWorld = worldServer;
                    this.$remotePosition = blockPos;
                    this.$portalBlocks = set;
                    this.$plane = plane;
                    this.$localPos = blockPos2;
                }
            }, new Executor(remoteWorld){
                final /* synthetic */ WorldServer $remoteWorld;

                public final void execute(Runnable it) {
                    ExtensionsKt.getServer(this.$remoteWorld).func_152344_a(it);
                }
                {
                    this.$remoteWorld = worldServer;
                }
            })).whenCompleteAsync(new BiConsumer<Pair<? extends BlockPos, ? extends Rotation>, Throwable>(ticket, remoteWorld){
                final /* synthetic */ ForgeChunkManager.Ticket $ticket;
                final /* synthetic */ WorldServer $remoteWorld;

                public final void accept(Pair<? extends BlockPos, ? extends Rotation> $noName_0, Throwable $noName_1) {
                    ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.$ticket);
                    if (!ExtensionsKt.isCubicWorld((World)this.$remoteWorld)) {
                        ChunkProviderServer chunkProvider;
                        PlayerChunkMap playerChunkMap = this.$remoteWorld.func_184164_w();
                        ChunkProviderServer chunkProviderServer = chunkProvider = this.$remoteWorld.func_72863_F();
                        Intrinsics.checkExpressionValueIsNotNull((Object)chunkProviderServer, (String)"chunkProvider");
                        Collection collection = chunkProviderServer.func_189548_a();
                        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"chunkProvider.loadedChunks");
                        Iterable $this$forEach$iv = collection;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Chunk it = (Chunk)element$iv;
                            boolean bl = false;
                            if (playerChunkMap.func_152621_a(it.field_76635_g, it.field_76647_h)) continue;
                            chunkProvider.func_189549_a(it);
                        }
                    }
                }
                {
                    this.$ticket = ticket;
                    this.$remoteWorld = worldServer;
                }
            }, new Executor(remoteWorld){
                final /* synthetic */ WorldServer $remoteWorld;

                public final void execute(Runnable it) {
                    ExtensionsKt.getServer(this.$remoteWorld).func_152344_a(it);
                }
                {
                    this.$remoteWorld = worldServer;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"cacheFuture.thenApplyAsy\u2026r.addScheduledTask(it) })");
            return completionStage;
        }

        @NotNull
        public static <EntityType extends Entity> Pair<Set<BlockPos>, EnumFacing.Axis> findPortalFrame(PortalBlock<EntityType> $this, @NotNull Gettable<? super BlockPos, ? extends IBlockState> blockCache, @NotNull BlockPos startPos, boolean filled) {
            Intrinsics.checkParameterIsNotNull(blockCache, (String)"blockCache");
            Intrinsics.checkParameterIsNotNull((Object)startPos, (String)"startPos");
            for (EnumFacing.Axis axis : EnumFacing.Axis.values()) {
                Set<BlockPos> result = $this.findPortalFrame(blockCache, startPos, axis, filled);
                Collection collection = result;
                boolean bl = false;
                if (!(!collection.isEmpty())) continue;
                return new Pair(result, (Object)axis);
            }
            return new Pair((Object)SetsKt.emptySet(), (Object)EnumFacing.Axis.X);
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public static <EntityType extends Entity> Set<BlockPos> findPortalFrame(PortalBlock<EntityType> $this, @NotNull Gettable<? super BlockPos, ? extends IBlockState> blockCache, @NotNull BlockPos startPos, @NotNull EnumFacing.Axis axis, boolean filled) {
            block12: {
                Intrinsics.checkParameterIsNotNull(blockCache, (String)"blockCache");
                Intrinsics.checkParameterIsNotNull((Object)startPos, (String)"startPos");
                Intrinsics.checkParameterIsNotNull((Object)axis, (String)"axis");
                switch (PortalBlock$WhenMappings.$EnumSwitchMapping$0[axis.ordinal()]) {
                    case 1: 
                    case 2: {
                        v0 = EnumFacing.DOWN;
                        break;
                    }
                    case 3: {
                        v0 = EnumFacing.SOUTH;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                down = v0;
                up = down.func_176734_d();
                switch (PortalBlock$WhenMappings.$EnumSwitchMapping$1[axis.ordinal()]) {
                    case 1: 
                    case 2: {
                        v1 = ExtensionsKt.toFacing(axis, EnumFacing.AxisDirection.POSITIVE).func_176746_e();
                        break;
                    }
                    case 3: {
                        v1 = EnumFacing.EAST;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                v2 = right = v1;
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"right");
                left = v2.func_176734_d();
                directions = CollectionsKt.listOf((Object[])new EnumFacing[]{right, down, left, up});
                isFilling = filled != false ? (Function1)new Function1<IBlockState, Boolean>($this){

                    public final boolean invoke(@NotNull IBlockState p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        return ((PortalBlock)this.receiver).isPortalBlock(p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(PortalBlock.class);
                    }

                    public final String getName() {
                        return "isPortalBlock";
                    }

                    public final String getSignature() {
                        return "isPortalBlock(Lnet/minecraft/block/state/IBlockState;)Z";
                    }
                } : (Function1)findPortalFrame.isFilling.2.INSTANCE;
                $fun$maxDist$1 = findPortalFrame.1.INSTANCE;
                var13_12 = false;
                visitedBlocks = new LinkedHashSet<E>();
                var14_15 = false;
                portalBlocks = new LinkedHashSet<E>();
                blockQueue = CollectionsKt.mutableListOf((Object[])new BlockPos[]{startPos});
                $fun$queueIfUnknown$2 = new Function1<BlockPos, Unit>(visitedBlocks, blockQueue){
                    final /* synthetic */ Set $visitedBlocks;
                    final /* synthetic */ List $blockQueue;

                    public final void invoke(@NotNull BlockPos pos) {
                        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
                        if (!this.$visitedBlocks.contains(pos)) {
                            this.$visitedBlocks.add(pos);
                            this.$blockQueue.add(pos);
                        }
                    }
                    {
                        this.$visitedBlocks = set;
                        this.$blockQueue = list;
                        super(1);
                    }
                };
                block8: while (true) {
                    var16_18 = blockQueue;
                    var17_20 = false;
                    if (!(var16_18.isEmpty() == false)) break block12;
                    pos = (BlockPos)ExtensionsKt.takeLast(blockQueue);
                    if ($fun$maxDist$1.invoke(pos, startPos) > $this.getMaxPortalSize()) {
                        return SetsKt.emptySet();
                    }
                    blockState = blockCache.get((BlockPos)pos);
                    block = blockState.func_177230_c();
                    if ($this.isFrameBlock(blockState)) continue;
                    if (!((Boolean)isFilling.invoke((Object)blockState)).booleanValue() && !Intrinsics.areEqual((Object)block, (Object)Blocks.field_150480_ab)) break;
                    portalBlocks.add(pos);
                    $this$forEach$iv = directions;
                    $i$f$forEach = false;
                    var21_24 = $this$forEach$iv.iterator();
                    while (true) {
                        if (var21_24.hasNext()) ** break;
                        continue block8;
                        element$iv = var21_24.next();
                        it = (EnumFacing)element$iv;
                        $i$a$-forEach-PortalBlock$findPortalFrame$3 = false;
                        v3 = pos.func_177972_a(it);
                        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"pos.offset(it)");
                        $fun$queueIfUnknown$2.invoke(v3);
                    }
                    break;
                }
                return SetsKt.emptySet();
            }
            if (ExtensionsKt.getMaxSideLength(ExtensionsKt.toAxisAlignedBB(portalBlocks)) > (double)$this.getMaxPortalSize()) {
                return SetsKt.emptySet();
            }
            return portalBlocks;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static <EntityType extends Entity> boolean considerPlacingPortalAt(PortalBlock<EntityType> $this, @NotNull Gettable<? super BlockPos, ? extends IBlockState> blockCache, @NotNull Set<? extends BlockPos> portalBlocks, @NotNull BlockPos pos, @NotNull EnumFacing.Axis axis) {
            void $this$mapTo$iv$iv;
            boolean bl;
            Iterator iterator;
            Intrinsics.checkParameterIsNotNull(blockCache, (String)"blockCache");
            Intrinsics.checkParameterIsNotNull(portalBlocks, (String)"portalBlocks");
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            Intrinsics.checkParameterIsNotNull((Object)axis, (String)"axis");
            if (axis == EnumFacing.Axis.Y) {
                boolean bl2;
                int n = 1;
                Iterable $this$all$iv = (Iterable)new IntRange(n, 3);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    iterator = $this$all$iv.iterator();
                    while (iterator.hasNext()) {
                        int element$iv;
                        int it = element$iv = ((IntIterator)iterator).nextInt();
                        boolean bl3 = false;
                        BlockPos blockPos = pos.func_177979_c(it);
                        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos.down(it)");
                        if (Intrinsics.areEqual((Object)blockCache.get((BlockPos)blockPos).func_177230_c(), (Object)Blocks.field_150350_a)) continue;
                        return false;
                    }
                    bl2 = true;
                }
                if (!bl2) return false;
                BlockPos blockPos = pos.func_177979_c(4);
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos.down(4)");
                Material material = blockCache.get((BlockPos)blockPos).func_185904_a();
                Intrinsics.checkExpressionValueIsNotNull((Object)material, (String)"blockCache[pos.down(4)].material");
                if (!material.func_76220_a()) return false;
                bl = true;
            } else {
                BlockPos blockPos = pos.func_177977_b();
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos.down()");
                Material material = blockCache.get((BlockPos)blockPos).func_185904_a();
                Intrinsics.checkExpressionValueIsNotNull((Object)material, (String)"blockCache[pos.down()].material");
                bl = material.func_76220_a();
            }
            if (!bl) {
                return false;
            }
            Iterable $this$map$iv = portalBlocks;
            boolean $i$f$map = false;
            iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                BlockPos blockPos = (BlockPos)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                BlockPos blockPos2 = it.func_177971_a((Vec3i)pos);
                collection.add(blockPos2);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            block2: while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                BlockPos portalBlock = (BlockPos)element$iv;
                boolean bl5 = false;
                BlockPos blockPos = portalBlock;
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"portalBlock");
                if (Intrinsics.areEqual((Object)blockCache.get((BlockPos)blockPos).func_177230_c(), (Object)Blocks.field_150350_a) ^ true) {
                    return false;
                }
                Iterable $this$forEach$iv2 = ExtensionsKt.getParallelFaces(axis);
                boolean $i$f$forEach2 = false;
                Iterator iterator2 = $this$forEach$iv2.iterator();
                while (true) {
                    if (!iterator2.hasNext()) continue block2;
                    Object element$iv2 = iterator2.next();
                    EnumFacing it = (EnumFacing)element$iv2;
                    boolean bl6 = false;
                    BlockPos offsetPos = portalBlock.func_177972_a(it);
                    if (portalBlocks.contains(offsetPos)) continue;
                    BlockPos blockPos3 = offsetPos;
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"offsetPos");
                    if (blockPos3.func_177956_o() >= pos.func_177956_o() && Intrinsics.areEqual((Object)blockCache.get((BlockPos)offsetPos).func_177230_c(), (Object)Blocks.field_150350_a) ^ true) return false;
                }
                break;
            }
            return true;
        }

        public static <EntityType extends Entity> boolean checkPortal(PortalBlock<EntityType> $this, @NotNull Gettable<? super BlockPos, ? extends IBlockState> blockCache, @NotNull Set<? extends BlockPos> portalBlocks, @NotNull EnumFacing.Axis axis, boolean filled) {
            Intrinsics.checkParameterIsNotNull(blockCache, (String)"blockCache");
            Intrinsics.checkParameterIsNotNull(portalBlocks, (String)"portalBlocks");
            Intrinsics.checkParameterIsNotNull((Object)axis, (String)"axis");
            Function1 isFilling2 = filled ? (Function1)new Function1<IBlockState, Boolean>($this){

                public final boolean invoke(@NotNull IBlockState p1) {
                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                    return ((PortalBlock)this.receiver).isPortalBlock(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(PortalBlock.class);
                }

                public final String getName() {
                    return "isPortalBlock";
                }

                public final String getSignature() {
                    return "isPortalBlock(Lnet/minecraft/block/state/IBlockState;)Z";
                }
            } : (Function1)checkPortal.isFilling.2.INSTANCE;
            Iterable $this$forEach$iv = portalBlocks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BlockPos pos = (BlockPos)element$iv;
                boolean bl = false;
                if (!((Boolean)isFilling2.invoke((Object)blockCache.get((BlockPos)pos))).booleanValue()) {
                    return false;
                }
                Iterable $this$forEach$iv2 = ExtensionsKt.getParallelFaces(axis);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    EnumFacing it = (EnumFacing)element$iv2;
                    boolean bl2 = false;
                    BlockPos offsetPos = pos.func_177972_a(it);
                    if (portalBlocks.contains(offsetPos)) continue;
                    BlockPos blockPos = offsetPos;
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"offsetPos");
                    if ($this.isFrameBlock(blockCache.get((BlockPos)blockPos))) continue;
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public static <EntityType extends Entity> void placePortalFrame(PortalBlock<EntityType> $this, @NotNull World world2, @NotNull EnumFacing.Axis axis, @NotNull Set<? extends BlockPos> portalBlocks) {
            void $this$mapTo$iv$iv;
            BlockPos blockPos;
            Object element$iv2;
            Intrinsics.checkParameterIsNotNull((Object)world2, (String)"world");
            Intrinsics.checkParameterIsNotNull((Object)axis, (String)"axis");
            Intrinsics.checkParameterIsNotNull(portalBlocks, (String)"portalBlocks");
            boolean bl = false;
            Set frameBlocks = new LinkedHashSet();
            Iterable $this$forEach$iv = portalBlocks;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                BlockPos portalBlock = (BlockPos)element$iv2;
                boolean bl2 = false;
                Iterable $this$forEach$iv2 = ExtensionsKt.getParallelFaces(axis);
                boolean $i$f$forEach2 = false;
                blockPos = $this$forEach$iv2.iterator();
                while (blockPos.hasNext()) {
                    Object element$iv3 = blockPos.next();
                    EnumFacing facing = (EnumFacing)element$iv3;
                    boolean bl3 = false;
                    Iterator iterator = CollectionsKt.listOf((Object[])new Integer[]{0, 1}).iterator();
                    while (iterator.hasNext()) {
                        int i2 = ((Number)iterator.next()).intValue();
                        BlockPos pos = portalBlock.func_177972_a(facing).func_177967_a(facing.func_176732_a(axis), i2);
                        if (portalBlocks.contains(pos)) continue;
                        BlockPos blockPos2 = pos;
                        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"pos");
                        frameBlocks.add(blockPos2);
                    }
                }
            }
            Iterable $this$map$iv = portalBlocks;
            boolean $i$f$map = false;
            element$iv2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                blockPos = (BlockPos)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                Integer n = it.func_177956_o();
                collection.add(n);
            }
            Integer n = (Integer)CollectionsKt.min((Iterable)((List)destination$iv$iv));
            int minY = n != null ? n : 0;
            Iterable $this$forEach$iv3 = SetsKt.plus((Set)frameBlocks, (Iterable)portalBlocks);
            boolean $i$f$forEach3 = false;
            block4: for (Object element$iv4 : $this$forEach$iv3) {
                int n2;
                int it;
                IntRange intRange;
                int n3;
                BlockPos pos = (BlockPos)element$iv4;
                boolean bl5 = false;
                if (axis != EnumFacing.Axis.Y && pos.func_177956_o() < minY) continue;
                if (axis == EnumFacing.Axis.Y) {
                    n3 = -3;
                    intRange = new IntRange(n3, 2);
                } else {
                    n3 = -1;
                    intRange = new IntRange(n3, 1);
                }
                if ((it = intRange.getFirst()) > (n2 = intRange.getLast())) continue;
                while (true) {
                    void i3;
                    world2.func_175698_g(pos.func_177967_a(ExtensionsKt.toFacing(axis, EnumFacing.AxisDirection.POSITIVE), (int)i3));
                    if (i3 == n2) continue block4;
                    ++i3;
                }
            }
            $this$forEach$iv3 = frameBlocks;
            $i$f$forEach3 = false;
            for (Object element$iv4 : $this$forEach$iv3) {
                BlockPos pos = (BlockPos)element$iv4;
                boolean bl6 = false;
                world2.func_175656_a(pos, $this.getFrameBlock());
            }
            if (axis != EnumFacing.Axis.Y) {
                $this$forEach$iv3 = frameBlocks;
                $i$f$forEach3 = false;
                for (Object element$iv4 : $this$forEach$iv3) {
                    BlockPos framePos = (BlockPos)element$iv4;
                    boolean bl7 = false;
                    if (!portalBlocks.contains(framePos.func_177972_a(EnumFacing.UP))) continue;
                    for (EnumFacing.AxisDirection direction : EnumFacing.AxisDirection.values()) {
                        BlockPos stepPos = framePos.func_177972_a(ExtensionsKt.toFacing(axis, direction));
                        IBlockState iBlockState = world2.func_180495_p(stepPos);
                        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(stepPos)");
                        Material material = iBlockState.func_185904_a();
                        Intrinsics.checkExpressionValueIsNotNull((Object)material, (String)"world.getBlockState(stepPos).material");
                        if (material.func_76220_a()) continue;
                        world2.func_175656_a(stepPos, $this.getFrameStepsBlock());
                    }
                }
            }
        }

        public static <EntityType extends Entity> void validatePortalOrDestroy(PortalBlock<EntityType> $this, @NotNull World world2, @NotNull BlockPos pos) {
            Intrinsics.checkParameterIsNotNull((Object)world2, (String)"world");
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            if (world2.field_72995_K) {
                return;
            }
            Set portalBlocks = (Set)$this.findPortalFrame(ExtensionsKt.makeBlockCache$default(world2, false, 1, null), pos, true).getFirst();
            if (portalBlocks.isEmpty()) {
                List list = world2.func_72872_a($this.getEntityType(), new AxisAlignedBB(pos));
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"world.getEntitiesWithinA\u2026Type, AxisAlignedBB(pos))");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Entity it = (Entity)element$iv;
                    boolean bl = false;
                    it.func_70106_y();
                }
                world2.func_175698_g(pos);
            } else {
                List entities2 = world2.func_72872_a($this.getEntityType(), ExtensionsKt.toAxisAlignedBB(portalBlocks));
                if (entities2.isEmpty()) {
                    Iterable $this$forEach$iv = portalBlocks;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        BlockPos it = (BlockPos)element$iv;
                        boolean bl = false;
                        world2.func_175698_g(it);
                    }
                    $this.tryToLinkPortals(world2, pos);
                } else {
                    List list = entities2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"entities");
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Entity it = (Entity)element$iv;
                        boolean bl = false;
                        if (it.field_70128_L || $this.checkPortal(ExtensionsKt.makeBlockCache$default(world2, false, 1, null), ((Linkable)it).getPortal().getLocalBlocks(), ((Linkable)it).getPortal().getLocalAxis(), true)) continue;
                        it.func_70106_y();
                    }
                }
            }
        }
    }
}

