/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.betterportals.common;

import de.johni0702.minecraft.betterportals.common.ExtensionsKt;
import de.johni0702.minecraft.betterportals.common.Mat4d;
import de.johni0702.minecraft.betterportals.common.Portal$WhenMappings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Matrix4d;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u001d\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B/\b\u0012\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\fBM\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u0014\u001a\u00020\u0010\u0012\u0006\u0010\u0015\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010?\u001a\u00020@2\b\u0010A\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010B\u001a\u00020\u000eH\u0016J\u0010\u0010C\u001a\u00020@2\u0006\u0010A\u001a\u00020\u0000H\u0016J\b\u0010D\u001a\u00020\u0006H\u0016J\n\u0010E\u001a\u00020\u0010*\u00020\u0010J\n\u0010E\u001a\u00020F*\u00020FJ\n\u0010G\u001a\u00020\u0010*\u00020\u0010J\n\u0010G\u001a\u00020F*\u00020FJ\u001a\u0010H\u001a\u00020F*\u00020F2\u0006\u0010I\u001a\u00020\u00102\u0006\u0010J\u001a\u00020\u0012J\n\u0010K\u001a\u00020\u0010*\u00020\u0010J\n\u0010K\u001a\u00020F*\u00020FJ\n\u0010L\u001a\u00020\u0010*\u00020\u0010J\n\u0010L\u001a\u00020F*\u00020FJ\u001a\u0010M\u001a\u00020F*\u00020F2\u0006\u0010I\u001a\u00020\u00102\u0006\u0010J\u001a\u00020\u0012R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0018R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u00102\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u001cR\u0011\u00104\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u001fR\u0017\u00106\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u0018R\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\n\n\u0002\u0010:\u001a\u0004\b8\u00109R\u0011\u0010;\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010'R\u0011\u0010\u0014\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010)R\u0011\u0010\u0015\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010+\u00a8\u0006N"}, d2={"Lde/johni0702/minecraft/betterportals/common/Portal;", "", "detailedBounds", "", "Lnet/minecraft/util/math/AxisAlignedBB;", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "(Ljava/lang/Iterable;Lnet/minecraft/nbt/NBTTagCompound;)V", "plane", "Lnet/minecraft/util/EnumFacing$Plane;", "local", "remote", "(Ljava/lang/Iterable;Lnet/minecraft/util/EnumFacing$Plane;Lnet/minecraft/nbt/NBTTagCompound;Lnet/minecraft/nbt/NBTTagCompound;)V", "localDimension", "", "localPosition", "Lnet/minecraft/util/math/BlockPos;", "localRotation", "Lnet/minecraft/util/Rotation;", "remoteDimension", "remotePosition", "remoteRotation", "(Lnet/minecraft/util/EnumFacing$Plane;Ljava/lang/Iterable;ILnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/Rotation;Ljava/lang/Integer;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/Rotation;)V", "getDetailedBounds", "()Ljava/lang/Iterable;", "localAxis", "Lnet/minecraft/util/EnumFacing$Axis;", "getLocalAxis", "()Lnet/minecraft/util/EnumFacing$Axis;", "localBoundingBox", "getLocalBoundingBox", "()Lnet/minecraft/util/math/AxisAlignedBB;", "localDetailedBounds", "getLocalDetailedBounds", "getLocalDimension", "()I", "localFacing", "Lnet/minecraft/util/EnumFacing;", "getLocalFacing", "()Lnet/minecraft/util/EnumFacing;", "getLocalPosition", "()Lnet/minecraft/util/math/BlockPos;", "getLocalRotation", "()Lnet/minecraft/util/Rotation;", "localToRemoteMatrix", "Ljavax/vecmath/Matrix4d;", "getLocalToRemoteMatrix", "()Ljavax/vecmath/Matrix4d;", "getPlane", "()Lnet/minecraft/util/EnumFacing$Plane;", "remoteAxis", "getRemoteAxis", "remoteBoundingBox", "getRemoteBoundingBox", "remoteDetailedBounds", "getRemoteDetailedBounds", "getRemoteDimension", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "remoteFacing", "getRemoteFacing", "getRemotePosition", "getRemoteRotation", "equals", "", "other", "hashCode", "isTarget", "writePortalToNBT", "fromLocal", "Lnet/minecraft/util/math/Vec3d;", "fromRemote", "fromSpace", "pos", "rotation", "toLocal", "toRemote", "toSpace", "bp-master_api"})
public abstract class Portal {
    @NotNull
    private final BlockPos localPosition;
    @NotNull
    private final BlockPos remotePosition;
    @NotNull
    private final EnumFacing localFacing;
    @NotNull
    private final EnumFacing remoteFacing;
    @NotNull
    private final EnumFacing.Axis localAxis;
    @NotNull
    private final EnumFacing.Axis remoteAxis;
    @NotNull
    private final Matrix4d localToRemoteMatrix;
    @NotNull
    private final Iterable<AxisAlignedBB> localDetailedBounds;
    @NotNull
    private final Iterable<AxisAlignedBB> remoteDetailedBounds;
    @NotNull
    private final AxisAlignedBB localBoundingBox;
    @NotNull
    private final AxisAlignedBB remoteBoundingBox;
    @NotNull
    private final EnumFacing.Plane plane;
    @NotNull
    private final Iterable<AxisAlignedBB> detailedBounds;
    private final int localDimension;
    @NotNull
    private final Rotation localRotation;
    @Nullable
    private final Integer remoteDimension;
    @NotNull
    private final Rotation remoteRotation;

    @NotNull
    public final BlockPos getLocalPosition() {
        return this.localPosition;
    }

    @NotNull
    public final BlockPos getRemotePosition() {
        return this.remotePosition;
    }

    @NotNull
    public final EnumFacing getLocalFacing() {
        return this.localFacing;
    }

    @NotNull
    public final EnumFacing getRemoteFacing() {
        return this.remoteFacing;
    }

    @NotNull
    public final EnumFacing.Axis getLocalAxis() {
        return this.localAxis;
    }

    @NotNull
    public final EnumFacing.Axis getRemoteAxis() {
        return this.remoteAxis;
    }

    @NotNull
    public final BlockPos toRemote(@NotNull BlockPos $this$toRemote) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toRemote, (String)"$this$toRemote");
        BlockPos blockPos = $this$toRemote.func_190942_a(this.remoteRotation).func_177971_a((Vec3i)this.remotePosition);
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"rotate(remoteRotation).add(remotePosition)");
        return blockPos;
    }

    @NotNull
    public final BlockPos toLocal(@NotNull BlockPos $this$toLocal) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toLocal, (String)"$this$toLocal");
        BlockPos blockPos = $this$toLocal.func_190942_a(this.localRotation).func_177971_a((Vec3i)this.localPosition);
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"rotate(localRotation).add(localPosition)");
        return blockPos;
    }

    @NotNull
    public final BlockPos fromRemote(@NotNull BlockPos $this$fromRemote) {
        Intrinsics.checkParameterIsNotNull((Object)$this$fromRemote, (String)"$this$fromRemote");
        BlockPos blockPos = $this$fromRemote.func_177973_b((Vec3i)this.remotePosition).func_190942_a(ExtensionsKt.getReverse(this.remoteRotation));
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"subtract(remotePosition)\u2026e(remoteRotation.reverse)");
        return blockPos;
    }

    @NotNull
    public final BlockPos fromLocal(@NotNull BlockPos $this$fromLocal) {
        Intrinsics.checkParameterIsNotNull((Object)$this$fromLocal, (String)"$this$fromLocal");
        BlockPos blockPos = $this$fromLocal.func_177973_b((Vec3i)this.localPosition).func_190942_a(ExtensionsKt.getReverse(this.localRotation));
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"subtract(localPosition).\u2026te(localRotation.reverse)");
        return blockPos;
    }

    @NotNull
    public final Vec3d toSpace(@NotNull Vec3d $this$toSpace, @NotNull BlockPos pos, @NotNull Rotation rotation) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toSpace, (String)"$this$toSpace");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)rotation, (String)"rotation");
        Vec3d vec3d = $this$toSpace.func_178786_a(0.5, 0.0, 0.5);
        Intrinsics.checkExpressionValueIsNotNull((Object)vec3d, (String)"subtract(0.5, 0.0, 0.5)");
        Vec3d vec3d2 = ExtensionsKt.rotate(vec3d, rotation).func_72441_c(0.5, 0.0, 0.5).func_178787_e(ExtensionsKt.to3d((Vec3i)pos));
        Intrinsics.checkExpressionValueIsNotNull((Object)vec3d2, (String)"subtract(0.5, 0.0, 0.5).\u20260.0, 0.5).add(pos.to3d())");
        return vec3d2;
    }

    @NotNull
    public final Vec3d fromSpace(@NotNull Vec3d $this$fromSpace, @NotNull BlockPos pos, @NotNull Rotation rotation) {
        Intrinsics.checkParameterIsNotNull((Object)$this$fromSpace, (String)"$this$fromSpace");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)rotation, (String)"rotation");
        Vec3d vec3d = $this$fromSpace.func_178788_d(ExtensionsKt.to3d((Vec3i)pos)).func_178786_a(0.5, 0.0, 0.5);
        Intrinsics.checkExpressionValueIsNotNull((Object)vec3d, (String)"subtract(pos.to3d()).subtract(0.5, 0.0, 0.5)");
        Vec3d vec3d2 = ExtensionsKt.rotate(vec3d, ExtensionsKt.getReverse(rotation)).func_72441_c(0.5, 0.0, 0.5);
        Intrinsics.checkExpressionValueIsNotNull((Object)vec3d2, (String)"subtract(pos.to3d()).sub\u2026.addVector(0.5, 0.0, 0.5)");
        return vec3d2;
    }

    @NotNull
    public final Vec3d toRemote(@NotNull Vec3d $this$toRemote) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toRemote, (String)"$this$toRemote");
        return this.toSpace($this$toRemote, this.remotePosition, this.remoteRotation);
    }

    @NotNull
    public final Vec3d toLocal(@NotNull Vec3d $this$toLocal) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toLocal, (String)"$this$toLocal");
        return this.toSpace($this$toLocal, this.localPosition, this.localRotation);
    }

    @NotNull
    public final Vec3d fromRemote(@NotNull Vec3d $this$fromRemote) {
        Intrinsics.checkParameterIsNotNull((Object)$this$fromRemote, (String)"$this$fromRemote");
        return this.fromSpace($this$fromRemote, this.remotePosition, this.remoteRotation);
    }

    @NotNull
    public final Vec3d fromLocal(@NotNull Vec3d $this$fromLocal) {
        Intrinsics.checkParameterIsNotNull((Object)$this$fromLocal, (String)"$this$fromLocal");
        return this.fromSpace($this$fromLocal, this.localPosition, this.localRotation);
    }

    @NotNull
    public final Matrix4d getLocalToRemoteMatrix() {
        return this.localToRemoteMatrix;
    }

    @NotNull
    public final Iterable<AxisAlignedBB> getLocalDetailedBounds() {
        return this.localDetailedBounds;
    }

    @NotNull
    public final Iterable<AxisAlignedBB> getRemoteDetailedBounds() {
        return this.remoteDetailedBounds;
    }

    @NotNull
    public final AxisAlignedBB getLocalBoundingBox() {
        return this.localBoundingBox;
    }

    @NotNull
    public final AxisAlignedBB getRemoteBoundingBox() {
        return this.remoteBoundingBox;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTarget(@NotNull Portal other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        if (!Intrinsics.areEqual((Object)this.remotePosition, (Object)other.localPosition)) return false;
        Integer n = this.remoteDimension;
        int n2 = other.localDimension;
        if (n == null) return false;
        if (n != n2) return false;
        if (this.remoteRotation != other.localRotation) return false;
        return true;
    }

    @NotNull
    public NBTTagCompound writePortalToNBT() {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        boolean bl = false;
        boolean bl2 = false;
        NBTTagCompound $this$apply = nBTTagCompound;
        boolean bl3 = false;
        $this$apply.func_74768_a("Plane", this.plane.ordinal());
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        String string = "Local";
        NBTTagCompound nBTTagCompound3 = $this$apply;
        boolean bl4 = false;
        boolean bl5 = false;
        NBTTagCompound $this$apply2 = nBTTagCompound2;
        boolean bl6 = false;
        ExtensionsKt.setXYZ($this$apply2, this.localPosition);
        $this$apply2.func_74768_a("Rotation", this.localRotation.ordinal());
        $this$apply2.func_74768_a("Dim", this.localDimension);
        NBTTagCompound nBTTagCompound4 = nBTTagCompound2;
        nBTTagCompound3.func_74782_a(string, (NBTBase)nBTTagCompound4);
        Integer remoteDimension = this.remoteDimension;
        if (remoteDimension != null) {
            NBTTagCompound nBTTagCompound5 = new NBTTagCompound();
            string = "Remote";
            nBTTagCompound3 = $this$apply;
            bl5 = false;
            boolean bl7 = false;
            NBTTagCompound $this$apply3 = nBTTagCompound5;
            boolean bl8 = false;
            ExtensionsKt.setXYZ($this$apply3, this.remotePosition);
            $this$apply3.func_74768_a("Rotation", this.remoteRotation.ordinal());
            $this$apply3.func_74768_a("Dim", remoteDimension.intValue());
            nBTTagCompound4 = nBTTagCompound5;
            nBTTagCompound3.func_74782_a(string, (NBTBase)nBTTagCompound4);
        }
        return nBTTagCompound;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type de.johni0702.minecraft.betterportals.common.Portal");
        }
        Portal cfr_ignored_0 = (Portal)object2;
        if (this.plane != ((Portal)other).plane) {
            return false;
        }
        if (this.localDimension != ((Portal)other).localDimension) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.localPosition, (Object)((Portal)other).localPosition) ^ true) {
            return false;
        }
        if (this.localRotation != ((Portal)other).localRotation) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.remoteDimension, (Object)((Portal)other).remoteDimension) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.remotePosition, (Object)((Portal)other).remotePosition) ^ true) {
            return false;
        }
        if (this.remoteRotation != ((Portal)other).remoteRotation) {
            return false;
        }
        return !(Intrinsics.areEqual(this.detailedBounds, ((Portal)other).detailedBounds) ^ true);
    }

    public int hashCode() {
        int result = this.plane.hashCode();
        result = 31 * result + this.localDimension;
        result = 31 * result + this.localPosition.hashCode();
        result = 31 * result + this.localRotation.hashCode();
        Integer n = this.remoteDimension;
        result = 31 * result + (n != null ? n : 0);
        result = 31 * result + this.remotePosition.hashCode();
        result = 31 * result + this.remoteRotation.hashCode();
        result = 31 * result + this.detailedBounds.hashCode();
        return result;
    }

    @NotNull
    public final EnumFacing.Plane getPlane() {
        return this.plane;
    }

    @NotNull
    public final Iterable<AxisAlignedBB> getDetailedBounds() {
        return this.detailedBounds;
    }

    public final int getLocalDimension() {
        return this.localDimension;
    }

    @NotNull
    public final Rotation getLocalRotation() {
        return this.localRotation;
    }

    @Nullable
    public final Integer getRemoteDimension() {
        return this.remoteDimension;
    }

    @NotNull
    public final Rotation getRemoteRotation() {
        return this.remoteRotation;
    }

    /*
     * WARNING - void declaration
     */
    public Portal(@NotNull EnumFacing.Plane plane, @NotNull Iterable<? extends AxisAlignedBB> detailedBounds, int localDimension, @NotNull BlockPos localPosition, @NotNull Rotation localRotation, @Nullable Integer remoteDimension, @NotNull BlockPos remotePosition, @NotNull Rotation remoteRotation) {
        AxisAlignedBB p1;
        Iterable<AxisAlignedBB> $this$reduce$iv;
        AxisAlignedBB axisAlignedBB;
        AxisAlignedBB it;
        boolean bl;
        Object object;
        Iterable<AxisAlignedBB> $this$mapTo$iv$iv;
        Iterable<AxisAlignedBB> $this$map$iv;
        EnumFacing enumFacing;
        EnumFacing enumFacing2;
        Intrinsics.checkParameterIsNotNull((Object)plane, (String)"plane");
        Intrinsics.checkParameterIsNotNull(detailedBounds, (String)"detailedBounds");
        Intrinsics.checkParameterIsNotNull((Object)localPosition, (String)"localPosition");
        Intrinsics.checkParameterIsNotNull((Object)localRotation, (String)"localRotation");
        Intrinsics.checkParameterIsNotNull((Object)remotePosition, (String)"remotePosition");
        Intrinsics.checkParameterIsNotNull((Object)remoteRotation, (String)"remoteRotation");
        this.plane = plane;
        this.detailedBounds = detailedBounds;
        this.localDimension = localDimension;
        this.localRotation = localRotation;
        this.remoteDimension = remoteDimension;
        this.remoteRotation = remoteRotation;
        BlockPos blockPos = localPosition.func_185334_h();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"localPosition.toImmutable()");
        this.localPosition = blockPos;
        BlockPos blockPos2 = remotePosition.func_185334_h();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"remotePosition.toImmutable()");
        this.remotePosition = blockPos2;
        switch (Portal$WhenMappings.$EnumSwitchMapping$0[this.plane.ordinal()]) {
            case 1: {
                enumFacing2 = ExtensionsKt.getFacing(this.localRotation);
                break;
            }
            case 2: {
                enumFacing2 = EnumFacing.UP;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.localFacing = enumFacing2;
        switch (Portal$WhenMappings.$EnumSwitchMapping$1[this.plane.ordinal()]) {
            case 1: {
                enumFacing = ExtensionsKt.getFacing(this.remoteRotation);
                break;
            }
            case 2: {
                enumFacing = EnumFacing.UP;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.remoteFacing = enumFacing;
        EnumFacing.Axis axis = this.localFacing.func_176740_k();
        Intrinsics.checkExpressionValueIsNotNull((Object)axis, (String)"localFacing.axis");
        this.localAxis = axis;
        EnumFacing.Axis axis2 = this.remoteFacing.func_176740_k();
        Intrinsics.checkExpressionValueIsNotNull((Object)axis2, (String)"remoteFacing.axis");
        this.remoteAxis = axis2;
        this.localToRemoteMatrix = ExtensionsKt.times(ExtensionsKt.times(Mat4d.add(ExtensionsKt.toJavaX(ExtensionsKt.plus(ExtensionsKt.to3d((Vec3i)remotePosition), new Vec3d(0.5, 0.0, 0.5)))), Mat4d.rotYaw(ExtensionsKt.getDegrees(ExtensionsKt.minus(this.remoteRotation, this.localRotation)))), Mat4d.sub(ExtensionsKt.toJavaX(ExtensionsKt.plus(ExtensionsKt.to3d((Vec3i)localPosition), new Vec3d(0.5, 0.0, 0.5)))));
        Iterable<AxisAlignedBB> iterable = this.detailedBounds;
        Portal portal = this;
        boolean $i$f$map = false;
        void var11_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            AxisAlignedBB axisAlignedBB2 = (AxisAlignedBB)t;
            object = destination$iv$iv;
            bl = false;
            axisAlignedBB = ExtensionsKt.toAxisAlignedBB(this.toLocal(ExtensionsKt.getMin(it)), this.toLocal(ExtensionsKt.getMax(it)));
            object.add(axisAlignedBB);
        }
        object = (List)destination$iv$iv;
        portal.localDetailedBounds = (Iterable)object;
        $this$map$iv = this.detailedBounds;
        portal = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object object2 : $this$mapTo$iv$iv) {
            it = (AxisAlignedBB)object2;
            object = destination$iv$iv;
            bl = false;
            axisAlignedBB = ExtensionsKt.toAxisAlignedBB(this.toRemote(ExtensionsKt.getMin(it)), this.toRemote(ExtensionsKt.getMax(it)));
            object.add(axisAlignedBB);
        }
        object = (List)destination$iv$iv;
        portal.remoteDetailedBounds = (Iterable)object;
        $this$map$iv = this.localDetailedBounds;
        portal = this;
        boolean $i$f$reduce = false;
        Iterator<Object> iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void p2;
            AxisAlignedBB $i$f$mapTo22 = (AxisAlignedBB)iterator$iv.next();
            p1 = (AxisAlignedBB)accumulator$iv;
            boolean bl2 = false;
            accumulator$iv = p1.func_111270_a((AxisAlignedBB)p2);
        }
        object = accumulator$iv;
        Collection<Object> collection = object;
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"localDetailedBounds.reduce(AxisAlignedBB::union)");
        portal.localBoundingBox = (AxisAlignedBB)collection;
        $this$reduce$iv = this.remoteDetailedBounds;
        portal = this;
        $i$f$reduce = false;
        iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            AxisAlignedBB p2 = (AxisAlignedBB)iterator$iv.next();
            p1 = (AxisAlignedBB)accumulator$iv;
            boolean bl3 = false;
            accumulator$iv = p1.func_111270_a(p2);
        }
        Object object3 = object = accumulator$iv;
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"remoteDetailedBounds.reduce(AxisAlignedBB::union)");
        portal.remoteBoundingBox = (AxisAlignedBB)object3;
    }

    public Portal(@NotNull Iterable<? extends AxisAlignedBB> detailedBounds, @NotNull NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull(detailedBounds, (String)"detailedBounds");
        Intrinsics.checkParameterIsNotNull((Object)nbt, (String)"nbt");
        EnumFacing.Plane plane = EnumFacing.Plane.values()[nbt.func_74762_e("Plane")];
        NBTTagCompound nBTTagCompound = nbt.func_74775_l("Local");
        Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"nbt.getCompoundTag(\"Local\")");
        this(detailedBounds, plane, nBTTagCompound, nbt.func_74764_b("Remote") ? nbt.func_74775_l("Remote") : null);
    }

    private Portal(Iterable<? extends AxisAlignedBB> detailedBounds, EnumFacing.Plane plane, NBTTagCompound local, NBTTagCompound remote) {
        NBTTagCompound nBTTagCompound;
        NBTTagCompound nBTTagCompound2;
        int n;
        Rotation rotation;
        BlockPos blockPos;
        Iterable<? extends AxisAlignedBB> iterable;
        EnumFacing.Plane plane2;
        Portal portal;
        block5: {
            block4: {
                portal = this;
                plane2 = plane;
                iterable = detailedBounds;
                blockPos = ExtensionsKt.getXYZ(local);
                rotation = Rotation.values()[local.func_74762_e("Rotation")];
                n = local.func_74762_e("Dim");
                nBTTagCompound2 = remote;
                if (nBTTagCompound2 == null || (nBTTagCompound2 = ExtensionsKt.getXYZ(nBTTagCompound2)) == null) {
                    BlockPos blockPos2 = BlockPos.field_177992_a;
                    nBTTagCompound2 = blockPos2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"BlockPos.ORIGIN");
                }
                if ((nBTTagCompound = remote) == null) break block4;
                int n2 = nBTTagCompound.func_74762_e("Rotation");
                NBTTagCompound nBTTagCompound3 = nBTTagCompound2;
                int n3 = n;
                Rotation rotation2 = rotation;
                BlockPos blockPos3 = blockPos;
                Iterable<? extends AxisAlignedBB> iterable2 = iterable;
                EnumFacing.Plane plane3 = plane2;
                Portal portal2 = portal;
                boolean bl = false;
                boolean bl2 = false;
                int it = n2;
                boolean bl3 = false;
                Rotation rotation3 = Rotation.values()[it];
                portal = portal2;
                plane2 = plane3;
                iterable = iterable2;
                blockPos = blockPos3;
                rotation = rotation2;
                n = n3;
                nBTTagCompound2 = nBTTagCompound3;
                nBTTagCompound = rotation3;
                if (nBTTagCompound != null) break block5;
            }
            nBTTagCompound = Rotation.NONE;
        }
        NBTTagCompound nBTTagCompound4 = remote;
        Integer n4 = nBTTagCompound4 != null ? Integer.valueOf(nBTTagCompound4.func_74762_e("Dim")) : null;
        NBTTagCompound nBTTagCompound5 = nBTTagCompound;
        NBTTagCompound nBTTagCompound6 = nBTTagCompound2;
        int n5 = n;
        Rotation rotation4 = rotation;
        BlockPos blockPos4 = blockPos;
        portal(plane2, iterable, n5, blockPos4, rotation4, n4, (BlockPos)nBTTagCompound6, (Rotation)nBTTagCompound5);
    }
}

