/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.client.gui;

import java.awt.Rectangle;
import net.blay09.mods.trashslot.TrashSlot;
import net.blay09.mods.trashslot.api.IGuiContainerLayout;
import net.blay09.mods.trashslot.api.SlotRenderStyle;
import net.blay09.mods.trashslot.api.Snap;
import net.blay09.mods.trashslot.client.SlotTrash;
import net.blay09.mods.trashslot.client.TrashContainerSettings;
import net.blay09.mods.trashslot.client.deletion.DeletionProvider;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiTrashSlot
extends Gui {
    private static final ResourceLocation texture = new ResourceLocation("trashslot", "textures/gui/slot.png");
    private static final int SNAP_SIZE = 7;
    private final GuiContainer gui;
    private final IGuiContainerLayout layout;
    private final TrashContainerSettings settings;
    private final SlotTrash trashSlot;
    private SlotRenderStyle renderStyle = SlotRenderStyle.LONE;
    private boolean isDragging;
    private int dragStartX;
    private int dragStartY;

    public GuiTrashSlot(GuiContainer gui, IGuiContainerLayout layout, TrashContainerSettings settings, SlotTrash trashSlot) {
        this.gui = gui;
        this.layout = layout;
        this.settings = settings;
        this.trashSlot = trashSlot;
    }

    public boolean isInside(int mouseX, int mouseY) {
        int anchoredX = this.getAnchoredX();
        int anchoredY = this.getAnchoredY();
        int renderX = anchoredX + this.renderStyle.getRenderOffsetX() + this.layout.getSlotOffsetX(this.gui, this.renderStyle);
        int renderY = anchoredY + this.renderStyle.getRenderOffsetY() + this.layout.getSlotOffsetY(this.gui, this.renderStyle);
        return mouseX >= renderX && mouseY >= renderY && mouseX < renderX + this.renderStyle.getRenderWidth() && mouseY < renderY + this.renderStyle.getRenderHeight();
    }

    public void update(int mouseX, int mouseY) {
        boolean isMouseOver;
        int anchoredX = this.getAnchoredX();
        int anchoredY = this.getAnchoredY();
        int renderX = anchoredX + this.renderStyle.getRenderOffsetX() + this.layout.getSlotOffsetX(this.gui, this.renderStyle);
        int renderY = anchoredY + this.renderStyle.getRenderOffsetY() + this.layout.getSlotOffsetY(this.gui, this.renderStyle);
        boolean bl = isMouseOver = mouseX >= renderX && mouseY >= renderY && mouseX < renderX + this.renderStyle.getRenderWidth() && mouseY < renderY + this.renderStyle.getRenderHeight();
        if (Mouse.isButtonDown((int)0)) {
            if (!(this.isDragging || !isMouseOver || !this.gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b() || this.trashSlot.func_75216_d() && this.gui.func_146981_a((Slot)this.trashSlot, mouseX, mouseY))) {
                this.dragStartX = renderX - mouseX;
                this.dragStartY = renderY - mouseY;
                this.isDragging = true;
            }
        } else if (this.isDragging) {
            this.settings.save(TrashSlot.config);
            this.isDragging = false;
        }
        if (this.isDragging) {
            int targetX = mouseX + this.dragStartX;
            int targetY = mouseY + this.dragStartY;
            for (Rectangle collisionArea : this.layout.getCollisionAreas(this.gui)) {
                int targetRight = targetX + this.renderStyle.getWidth();
                int targetBottom = targetY + this.renderStyle.getHeight();
                int rectRight = collisionArea.x + collisionArea.width;
                int rectBottom = collisionArea.y + collisionArea.height;
                if (targetRight < collisionArea.x || targetX >= rectRight || targetBottom < collisionArea.y || targetY >= rectBottom) continue;
                int distLeft = targetRight - collisionArea.x;
                int distRight = rectRight - targetX;
                int distTop = targetBottom - collisionArea.y;
                int distBottom = rectBottom - targetY;
                if (anchoredX >= collisionArea.x && anchoredX < collisionArea.x + collisionArea.width) {
                    targetY = distTop < distBottom ? collisionArea.y - this.renderStyle.getHeight() : collisionArea.y + collisionArea.height;
                    continue;
                }
                targetX = distLeft < distRight ? collisionArea.x - this.renderStyle.getWidth() : collisionArea.x + collisionArea.width;
            }
            if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
                int bestSnapDist = Integer.MAX_VALUE;
                Snap bestSnap = null;
                for (Snap snap : this.layout.getSnaps(this.gui, this.renderStyle)) {
                    int dist = Integer.MAX_VALUE;
                    switch (snap.getType()) {
                        case HORIZONTAL: {
                            dist = Math.abs(snap.getY() - targetY);
                            break;
                        }
                        case VERTICAL: {
                            dist = Math.abs(snap.getX() - targetX);
                            break;
                        }
                        case FIXED: {
                            int distX = snap.getX() - targetX;
                            int distY = snap.getY() - targetY;
                            dist = (int)Math.sqrt(distX * distX + distY * distY);
                        }
                    }
                    if (dist >= 7 || dist >= bestSnapDist) continue;
                    bestSnap = snap;
                }
                if (bestSnap != null) {
                    if (bestSnap.getType() == Snap.Type.VERTICAL || bestSnap.getType() == Snap.Type.FIXED) {
                        targetX = bestSnap.getX();
                    }
                    if (bestSnap.getType() == Snap.Type.HORIZONTAL || bestSnap.getType() == Snap.Type.FIXED) {
                        targetY = bestSnap.getY();
                    }
                }
            }
            targetX = MathHelper.func_76125_a((int)targetX, (int)0, (int)(this.gui.field_146294_l - this.renderStyle.getRenderWidth()));
            targetY = MathHelper.func_76125_a((int)targetY, (int)0, (int)(this.gui.field_146295_m - this.renderStyle.getRenderHeight()));
            this.settings.slotX = this.getUnanchoredX(targetX);
            this.settings.slotY = this.getUnanchoredY(targetY);
        }
    }

    public void drawBackground(int mouseX, int mouseY) {
        int renderX = this.getAnchoredX();
        int renderY = this.getAnchoredY();
        this.renderStyle = this.layout.getSlotRenderStyle(this.gui, renderX, renderY);
        this.trashSlot.field_75223_e = renderX - this.gui.getGuiLeft() + this.renderStyle.getSlotOffsetX() + this.layout.getSlotOffsetX(this.gui, this.renderStyle);
        this.trashSlot.field_75221_f = renderY - this.gui.getGuiTop() + this.renderStyle.getSlotOffsetY() + this.layout.getSlotOffsetY(this.gui, this.renderStyle);
        this.field_73735_i = 1.0f;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.field_146297_k.func_110434_K().func_110577_a(texture);
        renderX += this.renderStyle.getRenderOffsetX() + this.layout.getSlotOffsetX(this.gui, this.renderStyle);
        renderY += this.renderStyle.getRenderOffsetY() + this.layout.getSlotOffsetY(this.gui, this.renderStyle);
        DeletionProvider deletionProvider = TrashSlot.proxy.getDeletionProvider();
        int texOffsetX = 0;
        if (deletionProvider == null || !deletionProvider.canUndeleteLast()) {
            texOffsetX = 64;
        }
        switch (this.renderStyle) {
            case LONE: {
                this.func_73729_b(renderX, renderY, texOffsetX, 56, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                break;
            }
            case ATTACH_BOTTOM_CENTER: {
                this.func_73729_b(renderX, renderY, texOffsetX, 0, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.func_73729_b(renderX, renderY, texOffsetX + 50, 29, 4, 4);
                this.func_73729_b(renderX + this.renderStyle.getRenderWidth() - 4, renderY, texOffsetX + 54, 29, 4, 4);
                break;
            }
            case ATTACH_BOTTOM_LEFT: {
                this.func_73729_b(renderX, renderY, texOffsetX, 0, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.func_73729_b(renderX + this.renderStyle.getRenderWidth() - 4, renderY, texOffsetX + 54, 29, 4, 4);
                break;
            }
            case ATTACH_BOTTOM_RIGHT: {
                this.func_73729_b(renderX, renderY, texOffsetX, 0, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.func_73729_b(renderX, renderY, texOffsetX + 50, 29, 4, 4);
                break;
            }
            case ATTACH_TOP_CENTER: {
                this.func_73729_b(renderX, renderY, texOffsetX + 32, 0, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.func_73729_b(renderX, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 50, 25, 4, 4);
                this.func_73729_b(renderX + this.renderStyle.getRenderWidth() - 4, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 54, 25, 4, 4);
                break;
            }
            case ATTACH_TOP_LEFT: {
                this.func_73729_b(renderX, renderY, texOffsetX + 32, 0, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.func_73729_b(renderX + this.renderStyle.getRenderWidth() - 4, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 54, 25, 4, 4);
                break;
            }
            case ATTACH_TOP_RIGHT: {
                this.func_73729_b(renderX, renderY, texOffsetX + 32, 0, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.func_73729_b(renderX, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 50, 25, 4, 4);
                break;
            }
            case ATTACH_LEFT_CENTER: {
                this.func_73729_b(renderX, renderY, texOffsetX + 25, 25, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.func_73729_b(renderX + this.renderStyle.getRenderWidth() - 4, renderY, texOffsetX + 50, 33, 4, 4);
                this.func_73729_b(renderX + this.renderStyle.getRenderWidth() - 4, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 50, 37, 4, 4);
                break;
            }
            case ATTACH_LEFT_TOP: {
                this.func_73729_b(renderX, renderY, texOffsetX + 25, 25, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.func_73729_b(renderX + this.renderStyle.getRenderWidth() - 4, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 50, 37, 4, 4);
                break;
            }
            case ATTACH_LEFT_BOTTOM: {
                this.func_73729_b(renderX, renderY, texOffsetX + 25, 25, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.func_73729_b(renderX + this.renderStyle.getRenderWidth() - 4, renderY, texOffsetX + 50, 33, 4, 4);
                break;
            }
            case ATTACH_RIGHT_CENTER: {
                this.func_73729_b(renderX, renderY, texOffsetX, 25, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.func_73729_b(renderX, renderY, texOffsetX + 54, 33, 4, 4);
                this.func_73729_b(renderX, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 54, 37, 4, 4);
                break;
            }
            case ATTACH_RIGHT_TOP: {
                this.func_73729_b(renderX, renderY, texOffsetX, 25, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.func_73729_b(renderX, renderY + this.renderStyle.getRenderHeight() - 4, texOffsetX + 54, 37, 4, 4);
                break;
            }
            case ATTACH_RIGHT_BOTTOM: {
                this.func_73729_b(renderX, renderY, texOffsetX, 25, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
                this.func_73729_b(renderX, renderY, texOffsetX + 54, 33, 4, 4);
            }
        }
        this.field_73735_i = 0.0f;
    }

    private int getAnchoredX() {
        return MathHelper.func_76125_a((int)(this.settings.slotX + this.gui.getGuiLeft() + (int)((float)this.gui.getXSize() * this.settings.anchorX)), (int)0, (int)(this.gui.field_146294_l - this.renderStyle.getRenderWidth()));
    }

    private int getUnanchoredX(int x) {
        return x - this.gui.getGuiLeft() - (int)((float)this.gui.getXSize() * this.settings.anchorX);
    }

    private int getAnchoredY() {
        return MathHelper.func_76125_a((int)(this.settings.slotY + this.gui.getGuiTop() + (int)((float)this.gui.getYSize() * this.settings.anchorY)), (int)0, (int)(this.gui.field_146294_l - this.renderStyle.getRenderWidth()));
    }

    private int getUnanchoredY(int y) {
        return y - this.gui.getGuiTop() - (int)((float)this.gui.getYSize() * this.settings.anchorY);
    }

    public boolean isVisible() {
        return this.settings.isEnabled();
    }

    public Rectangle getRectangle() {
        int anchoredX = this.getAnchoredX();
        int anchoredY = this.getAnchoredY();
        int renderX = anchoredX + this.renderStyle.getRenderOffsetX() + this.layout.getSlotOffsetX(this.gui, this.renderStyle);
        int renderY = anchoredY + this.renderStyle.getRenderOffsetY() + this.layout.getSlotOffsetY(this.gui, this.renderStyle);
        return new Rectangle(renderX, renderY, this.renderStyle.getRenderWidth(), this.renderStyle.getRenderHeight());
    }
}

