/*
 * Decompiled with CFR 0.152.
 */
package com.pixelextras.util;

import com.pixelextras.commands.Breed;
import com.pixelextras.config.PixelExtrasConfig;
import com.pixelextras.util.Cooldown;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class CooldownNotifier {
    private static List<UUID> toNotify = new ArrayList<UUID>();
    private long timer = PixelExtrasConfig.breedCooldown / 5000L * 20L;
    private long ticked = 0L;
    private final TextComponentTranslation CHAT = new TextComponentTranslation("chat.type.announcement", new Object[]{TextFormatting.GREEN + "Pixelmon Extras" + TextFormatting.RESET, TextFormatting.LIGHT_PURPLE + "Your /breed cooldown is up!"});

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (this.ticked < this.timer) {
                ++this.ticked;
                return;
            }
            this.ticked = 0L;
            ArrayList<UUID> toNotifyCopy = new ArrayList<UUID>(toNotify);
            for (UUID playerUUID : toNotifyCopy) {
                Cooldown cd = Breed.breedCooldowns.get(playerUUID.toString());
                if (System.currentTimeMillis() - cd.getTimeUsed() < PixelExtrasConfig.breedCooldown) continue;
                EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(playerUUID);
                if (player != null) {
                    player.func_145747_a((ITextComponent)this.CHAT);
                }
                toNotify.remove(playerUUID);
            }
        }
    }

    public static void addNotifier(UUID playerUUID) {
        if (!toNotify.contains(playerUUID)) {
            toNotify.add(playerUUID);
        }
    }

    public static void removeNotifier(UUID playerUUID) {
        toNotify.remove(playerUUID);
    }

    public static List<UUID> getNotifiers() {
        return toNotify;
    }
}

