/*
 * Decompiled with CFR 0.152.
 */
package com.pixelextras.commands;

import com.google.common.collect.Lists;
import com.pixelextras.api.event.UnknownEvolutionConditionEvent;
import com.pixelextras.api.event.UnknownEvolutionTypeEvent;
import com.pixelextras.util.TextUtil;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnSet;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnInfoPokemon;
import com.pixelmonmod.pixelmon.api.spawning.util.SetLoader;
import com.pixelmonmod.pixelmon.api.world.WorldTime;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.BiomeCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.ChanceCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.EvoCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.EvoRockCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.FriendshipCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.GenderCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.HeldItemCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.HighAltitudeCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.LevelCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.MoveCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.MoveTypeCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.PartyCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.StatRatioCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.TimeCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.WeatherCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.types.InteractEvolution;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.types.LevelingEvolution;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.types.TradeEvolution;
import com.pixelmonmod.pixelmon.enums.EnumEggGroup;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.technicalmoves.ITechnicalMove;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class Wiki
extends CommandBase {
    private static final List<String> info = Lists.newArrayList((Object[])new String[]{"moves", "biome", "time", "egggroup", "genderratio", "evo", "rarity", "catch", "ha", "fishing", "abilities", "basestats", "eggmoves", "tutormoves", "tmmoves", "grass", "caverock", "headbutt", "rocksmash", "sweetscent"});

    public String func_71517_b() {
        return "wiki";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/wiki <pokemon> [form] <info> - displays the <info> of <pokemon>";
    }

    public int func_82362_a() {
        return 2;
    }

    public List<String> func_71514_a() {
        return Lists.newArrayList((Object[])new String[]{"pinfo", "pokeinfo"});
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)this.func_71518_a(sender), (Object[])new Object[0]);
            return;
        }
        String name = args[0];
        if (args.length == 2) {
            String infoType = args[1];
            if (EnumSpecies.hasPokemonAnyCase((String)name)) {
                Pokemon pokemon = Pixelmon.pokemonFactory.create(EnumSpecies.getFromNameAnyCase((String)name));
                this.sendInfo(pokemon, sender, infoType);
            } else {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"%s is not a valid Pixelmon name", (Object[])new Object[]{name});
            }
        } else if (args.length == 3) {
            String infoType = args[2];
            Pokemon pokemon = Pixelmon.pokemonFactory.create(EnumSpecies.getFromNameAnyCase((String)name));
            if (args[1].contains("type")) {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)this.func_71518_a(sender), (Object[])new Object[0]);
                return;
            }
            PokemonSpec.from((String[])new String[]{args[1]}).apply(pokemon);
            this.sendInfo(pokemon, sender, infoType);
        } else {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)this.func_71518_a(sender), (Object[])new Object[0]);
        }
    }

    private void sendInfo(Pokemon pokemon, ICommandSender sender, String infoType) {
        if (info.contains(infoType)) {
            if (infoType.equalsIgnoreCase("moves")) {
                Map moves = pokemon.getBaseStats().getLevelupMoves();
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.YELLOW, (String)("%s " + TextFormatting.GOLD + "can learn the following moves through level-up:"), (Object[])new Object[]{pokemon.getDisplayName()});
                ArrayList orderedEntries = new ArrayList();
                for (Map.Entry entry : moves.entrySet()) {
                    int index;
                    for (index = 0; index < orderedEntries.size() && (Integer)((Map.Entry)orderedEntries.get(index)).getKey() <= (Integer)entry.getKey(); ++index) {
                    }
                    orderedEntries.add(index, entry);
                }
                for (Map.Entry entry : orderedEntries) {
                    StringBuilder msg = new StringBuilder(TextFormatting.GOLD + "Level " + TextFormatting.DARK_AQUA + entry.getKey() + TextFormatting.GOLD + ": ");
                    Object[] translations = new TextComponentTranslation[((List)entry.getValue()).size()];
                    int i = 0;
                    for (AttackBase attack : (List)entry.getValue()) {
                        msg.append(TextFormatting.DARK_AQUA).append("%s").append(TextFormatting.GOLD).append(", ");
                        translations[i++] = TextUtil.applyColour((ITextComponent)attack.getTranslatedName(), TextFormatting.DARK_AQUA);
                    }
                    msg = new StringBuilder(msg.substring(0, msg.length() - 2));
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(msg.toString(), translations));
                }
            } else if (infoType.equalsIgnoreCase("eggmoves")) {
                ArrayList moves = pokemon.getBaseStats().getEggMoves();
                if (moves == null) {
                    moves = Lists.newArrayList();
                }
                if (moves.size() == 0) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"That Pok\u00e9mon does have any of these moves.", (Object[])new Object[0]);
                    return;
                }
                this.sortAttacks(moves);
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.YELLOW, (String)("%s " + TextFormatting.GOLD + "can learn the following egg moves:"), (Object[])new Object[]{pokemon.getDisplayName()});
                StringBuilder msg = new StringBuilder();
                Object[] translations = new TextComponentTranslation[moves.size()];
                int i = 0;
                for (Attack attack : moves) {
                    msg.append(TextFormatting.DARK_AQUA).append("%s").append(TextFormatting.GOLD).append(", ");
                    translations[i++] = TextUtil.applyColour((ITextComponent)attack.getMove().getTranslatedName(), TextFormatting.DARK_AQUA);
                }
                msg = new StringBuilder(msg.substring(0, msg.length() - 2));
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(msg.toString(), translations));
            } else if (infoType.equalsIgnoreCase("tmmoves")) {
                List movesc = pokemon.getBaseStats().getTMMoves();
                ArrayList<ITechnicalMove> moves = new ArrayList<ITechnicalMove>(movesc);
                if (moves.size() == 0) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"That Pok\u00e9mon does have any of these moves.", (Object[])new Object[0]);
                    return;
                }
                this.sortITechnicalMove(moves);
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.YELLOW, (String)("%s " + TextFormatting.GOLD + "can learn the following TM moves:"), (Object[])new Object[]{pokemon.getDisplayName()});
                StringBuilder msg = new StringBuilder();
                Object[] translations = new TextComponentTranslation[moves.size()];
                int i = 0;
                for (ITechnicalMove attack : moves) {
                    msg.append(TextFormatting.DARK_AQUA).append("%s").append(TextFormatting.GOLD).append(", ");
                    translations[i++] = TextUtil.applyColour((ITextComponent)attack.getAttack().getTranslatedName(), TextFormatting.DARK_AQUA);
                }
                msg = new StringBuilder(msg.substring(0, msg.length() - 2));
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(msg.toString(), translations));
            } else if (infoType.equalsIgnoreCase("tutormoves")) {
                ArrayList moves = pokemon.getBaseStats().getTutorMoves();
                if (moves == null) {
                    moves = Lists.newArrayList();
                }
                if (moves.size() == 0) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"That Pok\u00e9mon does have any of these moves.", (Object[])new Object[0]);
                    return;
                }
                this.sortAttacks(moves);
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.YELLOW, (String)("%s " + TextFormatting.GOLD + "can learn the following tutor moves:"), (Object[])new Object[]{pokemon.getDisplayName()});
                StringBuilder msg = new StringBuilder();
                Object[] translations = new TextComponentTranslation[moves.size()];
                int i = 0;
                for (Attack attack : moves) {
                    msg.append(TextFormatting.DARK_AQUA).append("%s").append(TextFormatting.GOLD).append(", ");
                    translations[i++] = TextUtil.applyColour((ITextComponent)attack.getMove().getTranslatedName(), TextFormatting.DARK_AQUA);
                }
                msg = new StringBuilder(msg.substring(0, msg.length() - 2));
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(msg.toString(), translations));
            } else if (infoType.equalsIgnoreCase("biome")) {
                ArrayList<Biome> allBiomes = new ArrayList<Biome>();
                HashSet<Biome> avail = new HashSet<Biome>();
                for (Object biome2 : GameRegistry.findRegistry(Biome.class)) {
                    allBiomes.add((Biome)biome2);
                }
                ArrayList setinfos = PixelmonSpawning.standard;
                setinfos.addAll(PixelmonSpawning.legendaries);
                for (Object set : setinfos) {
                    if (allBiomes.isEmpty()) break;
                    for (SpawnInfo info : ((SpawnSet)set).spawnInfos) {
                        if (!(info instanceof SpawnInfoPokemon) || ((SpawnInfoPokemon)info).getSpecies() != pokemon.getSpecies()) continue;
                        if (((SpawnInfoPokemon)info).getPokemonSpec().form != null) {
                            if (pokemon.getFormEnum().getForm() != ((SpawnInfoPokemon)info).getPokemonSpec().form.byteValue()) continue;
                            if (info.condition != null && info.condition.biomes != null && !info.condition.biomes.isEmpty()) {
                                allBiomes.removeIf(biome -> !info.condition.biomes.contains(biome));
                            }
                            if (info.anticondition != null && info.anticondition.biomes != null && !info.anticondition.biomes.isEmpty()) {
                                allBiomes.removeIf(biome -> info.anticondition.biomes.contains(biome));
                            }
                            if (info.compositeCondition != null) {
                                if (info.compositeCondition.conditions != null) {
                                    info.compositeCondition.conditions.forEach(condition -> {
                                        if (condition.biomes != null && !condition.biomes.isEmpty()) {
                                            allBiomes.removeIf(biome -> !condition.biomes.contains(biome));
                                        }
                                    });
                                }
                                if (info.compositeCondition.anticonditions != null) {
                                    info.compositeCondition.anticonditions.forEach(anticondition -> {
                                        if (anticondition.biomes != null && anticondition.biomes.isEmpty()) {
                                            allBiomes.removeIf(biome -> anticondition.biomes.contains(biome));
                                        }
                                    });
                                }
                            }
                            avail.addAll(allBiomes);
                            continue;
                        }
                        if (info.condition != null && info.condition.biomes != null && !info.condition.biomes.isEmpty()) {
                            allBiomes.removeIf(biome -> !info.condition.biomes.contains(biome));
                        }
                        if (info.anticondition != null && info.anticondition.biomes != null && !info.anticondition.biomes.isEmpty()) {
                            allBiomes.removeIf(biome -> info.anticondition.biomes.contains(biome));
                        }
                        if (info.compositeCondition != null) {
                            if (info.compositeCondition.conditions != null) {
                                info.compositeCondition.conditions.forEach(condition -> {
                                    if (condition.biomes != null && !condition.biomes.isEmpty()) {
                                        allBiomes.removeIf(biome -> !condition.biomes.contains(biome));
                                    }
                                });
                            }
                            if (info.compositeCondition.anticonditions != null) {
                                info.compositeCondition.anticonditions.forEach(anticondition -> {
                                    if (anticondition.biomes != null && anticondition.biomes.isEmpty()) {
                                        allBiomes.removeIf(biome -> anticondition.biomes.contains(biome));
                                    }
                                });
                            }
                        }
                        avail.addAll(allBiomes);
                    }
                }
                ArrayList<String> biomeNames = new ArrayList<String>();
                for (Biome biome3 : avail) {
                    biomeNames.add(biome3.field_76791_y);
                }
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.YELLOW, (String)("%s " + TextFormatting.GOLD + "spawns in these biomes:"), (Object[])new Object[]{pokemon.getDisplayName()});
                StringBuilder message = new StringBuilder(TextFormatting.RED + "None.");
                if (!biomeNames.isEmpty()) {
                    Collections.sort(biomeNames);
                    message = new StringBuilder(TextFormatting.DARK_AQUA + (String)biomeNames.get(0));
                    for (int i = 1; i < biomeNames.size(); ++i) {
                        message.append(TextFormatting.GOLD + ", " + TextFormatting.DARK_AQUA).append((String)biomeNames.get(i));
                    }
                }
                CommandChatHandler.sendChat((ICommandSender)sender, (String)message.toString(), (Object[])new Object[0]);
            } else if (infoType.equalsIgnoreCase("fishing")) {
                ArrayList<Biome> biomes = new ArrayList<Biome>();
                for (Object spawnSet : PixelmonSpawning.fishingSpawner.spawnSets) {
                    for (SpawnInfo info : ((SpawnSet)spawnSet).spawnInfos) {
                        if (!(info instanceof SpawnInfoPokemon) || !((SpawnInfoPokemon)info).getPokemonSpec().name.equalsIgnoreCase(pokemon.getSpecies().name)) continue;
                        for (Biome biome4 : info.condition.biomes) {
                            if (biomes.contains(biome4)) continue;
                            biomes.add(biome4);
                        }
                    }
                }
                ArrayList<String> biomeNames = new ArrayList<String>();
                for (Biome biome5 : biomes) {
                    biomeNames.add(biome5.field_76791_y);
                }
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.YELLOW, (String)("%s " + TextFormatting.GOLD + "can be fished in these biomes:"), (Object[])new Object[]{pokemon.getDisplayName()});
                StringBuilder message = new StringBuilder(TextFormatting.RED + "None.");
                if (!biomeNames.isEmpty()) {
                    Collections.sort(biomeNames);
                    message = new StringBuilder(TextFormatting.DARK_AQUA + (String)biomeNames.get(0));
                    for (int i = 1; i < biomeNames.size(); ++i) {
                        message.append(TextFormatting.GOLD + ", " + TextFormatting.DARK_AQUA).append((String)biomeNames.get(i));
                    }
                }
                CommandChatHandler.sendChat((ICommandSender)sender, (String)message.toString(), (Object[])new Object[0]);
            } else if (infoType.equalsIgnoreCase("grass")) {
                ArrayList<Biome> biomes = new ArrayList<Biome>();
                for (Object spawnSet : PixelmonSpawning.grassSpawner.spawnSets) {
                    for (SpawnInfo info : ((SpawnSet)spawnSet).spawnInfos) {
                        if (!(info instanceof SpawnInfoPokemon) || !((SpawnInfoPokemon)info).getPokemonSpec().name.equalsIgnoreCase(pokemon.getSpecies().name)) continue;
                        for (Biome biome6 : info.condition.biomes) {
                            if (biomes.contains(biome6)) continue;
                            biomes.add(biome6);
                        }
                    }
                }
                ArrayList biomeNames = new ArrayList();
                for (Biome biome7 : biomes) {
                    biomeNames.add(biome7.field_76791_y);
                }
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.YELLOW, (String)("%s " + TextFormatting.GOLD + "can be found in Grass block in theses biomes:"), (Object[])new Object[]{pokemon.getDisplayName()});
                StringBuilder message = new StringBuilder(TextFormatting.RED + "None.");
                if (!biomeNames.isEmpty()) {
                    Collections.sort(biomeNames);
                    message = new StringBuilder(TextFormatting.DARK_AQUA + (String)biomeNames.get(0));
                    for (int i = 1; i < biomeNames.size(); ++i) {
                        message.append(TextFormatting.GOLD + ", " + TextFormatting.DARK_AQUA).append((String)biomeNames.get(i));
                    }
                }
                CommandChatHandler.sendChat((ICommandSender)sender, (String)message.toString(), (Object[])new Object[0]);
            } else if (infoType.equalsIgnoreCase("caverock")) {
                ArrayList<Biome> biomes = new ArrayList<Biome>();
                for (Object spawnSet : PixelmonSpawning.caveRockSpawner.spawnSets) {
                    for (SpawnInfo info : ((SpawnSet)spawnSet).spawnInfos) {
                        if (!(info instanceof SpawnInfoPokemon) || !((SpawnInfoPokemon)info).getPokemonSpec().name.equalsIgnoreCase(pokemon.getSpecies().name)) continue;
                        for (Biome biome8 : info.condition.biomes) {
                            if (biomes.contains(biome8)) continue;
                            biomes.add(biome8);
                        }
                    }
                }
                ArrayList biomeNames = new ArrayList();
                for (Biome biome9 : biomes) {
                    biomeNames.add(biome9.field_76791_y);
                }
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.YELLOW, (String)("%s " + TextFormatting.GOLD + "can be found in Cave Rock block in theses biomes:"), (Object[])new Object[]{pokemon.getDisplayName()});
                StringBuilder message = new StringBuilder(TextFormatting.RED + "None.");
                if (!biomeNames.isEmpty()) {
                    Collections.sort(biomeNames);
                    message = new StringBuilder(TextFormatting.DARK_AQUA + (String)biomeNames.get(0));
                    for (int i = 1; i < biomeNames.size(); ++i) {
                        message.append(TextFormatting.GOLD + ", " + TextFormatting.DARK_AQUA).append((String)biomeNames.get(i));
                    }
                }
                CommandChatHandler.sendChat((ICommandSender)sender, (String)message.toString(), (Object[])new Object[0]);
            } else if (infoType.equalsIgnoreCase("headbutt")) {
                ArrayList<Biome> biomes = new ArrayList<Biome>();
                for (Object spawnSet : PixelmonSpawning.headbuttSpawner.spawnSets) {
                    for (SpawnInfo info : ((SpawnSet)spawnSet).spawnInfos) {
                        if (!(info instanceof SpawnInfoPokemon) || !((SpawnInfoPokemon)info).getPokemonSpec().name.equalsIgnoreCase(pokemon.getSpecies().name)) continue;
                        for (Biome biome10 : info.condition.biomes) {
                            if (biomes.contains(biome10)) continue;
                            biomes.add(biome10);
                        }
                    }
                }
                ArrayList biomeNames = new ArrayList();
                for (Biome biome11 : biomes) {
                    biomeNames.add(biome11.field_76791_y);
                }
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.YELLOW, (String)("%s " + TextFormatting.GOLD + "spawns using the (Headbutt) external move in theses biomes:"), (Object[])new Object[]{pokemon.getDisplayName()});
                StringBuilder message = new StringBuilder(TextFormatting.RED + "None.");
                if (!biomeNames.isEmpty()) {
                    Collections.sort(biomeNames);
                    message = new StringBuilder(TextFormatting.DARK_AQUA + (String)biomeNames.get(0));
                    for (int i = 1; i < biomeNames.size(); ++i) {
                        message.append(TextFormatting.GOLD + ", " + TextFormatting.DARK_AQUA).append((String)biomeNames.get(i));
                    }
                }
                CommandChatHandler.sendChat((ICommandSender)sender, (String)message.toString(), (Object[])new Object[0]);
            } else if (infoType.equalsIgnoreCase("rocksmash")) {
                ArrayList<Biome> biomes = new ArrayList<Biome>();
                for (Object spawnSet : PixelmonSpawning.rocksmashSpawner.spawnSets) {
                    for (SpawnInfo info : ((SpawnSet)spawnSet).spawnInfos) {
                        if (!(info instanceof SpawnInfoPokemon) || !((SpawnInfoPokemon)info).getPokemonSpec().name.equalsIgnoreCase(pokemon.getSpecies().name)) continue;
                        for (Biome biome12 : info.condition.biomes) {
                            if (biomes.contains(biome12)) continue;
                            biomes.add(biome12);
                        }
                    }
                }
                ArrayList biomeNames = new ArrayList();
                for (Biome biome13 : biomes) {
                    biomeNames.add(biome13.field_76791_y);
                }
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.YELLOW, (String)("%s " + TextFormatting.GOLD + "spawns using the (Rocksmash) external move in theses biomes:"), (Object[])new Object[]{pokemon.getDisplayName()});
                StringBuilder message = new StringBuilder(TextFormatting.RED + "None.");
                if (!biomeNames.isEmpty()) {
                    Collections.sort(biomeNames);
                    message = new StringBuilder(TextFormatting.DARK_AQUA + (String)biomeNames.get(0));
                    for (int i = 1; i < biomeNames.size(); ++i) {
                        message.append(TextFormatting.GOLD + ", " + TextFormatting.DARK_AQUA).append((String)biomeNames.get(i));
                    }
                }
                CommandChatHandler.sendChat((ICommandSender)sender, (String)message.toString(), (Object[])new Object[0]);
            } else if (infoType.equalsIgnoreCase("sweetscent")) {
                ArrayList<Biome> biomes = new ArrayList<Biome>();
                for (Object spawnSet : PixelmonSpawning.sweetscentSpawner.spawnSets) {
                    for (SpawnInfo info : ((SpawnSet)spawnSet).spawnInfos) {
                        if (!(info instanceof SpawnInfoPokemon) || !((SpawnInfoPokemon)info).getPokemonSpec().name.equalsIgnoreCase(pokemon.getSpecies().name)) continue;
                        for (Biome biome14 : info.condition.biomes) {
                            if (biomes.contains(biome14)) continue;
                            biomes.add(biome14);
                        }
                    }
                }
                ArrayList biomeNames = new ArrayList();
                for (Biome biome15 : biomes) {
                    biomeNames.add(biome15.field_76791_y);
                }
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.YELLOW, (String)("%s " + TextFormatting.GOLD + "spawns using the (Sweetscent) external move in theses biomes:"), (Object[])new Object[]{pokemon.getDisplayName()});
                StringBuilder message = new StringBuilder(TextFormatting.RED + "None.");
                if (!biomeNames.isEmpty()) {
                    Collections.sort(biomeNames);
                    message = new StringBuilder(TextFormatting.DARK_AQUA + (String)biomeNames.get(0));
                    for (int i = 1; i < biomeNames.size(); ++i) {
                        message.append(TextFormatting.GOLD + ", " + TextFormatting.DARK_AQUA).append((String)biomeNames.get(i));
                    }
                }
                CommandChatHandler.sendChat((ICommandSender)sender, (String)message.toString(), (Object[])new Object[0]);
            } else if (infoType.equalsIgnoreCase("time")) {
                ArrayList times = new ArrayList();
                for (SpawnSet set : SetLoader.getAllSets()) {
                    for (SpawnInfo info : set.spawnInfos) {
                        if (!(info instanceof SpawnInfoPokemon) || !((SpawnInfoPokemon)info).getPokemonSpec().name.equalsIgnoreCase(pokemon.getSpecies().name)) continue;
                        times = info.condition.times;
                    }
                }
                if (times == null || times.isEmpty()) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.YELLOW, (String)("%s " + TextFormatting.GOLD + "spawns at any time."), (Object[])new Object[]{pokemon.getDisplayName()});
                    return;
                }
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.YELLOW, (String)("%s " + TextFormatting.GOLD + "spawns at these times:"), (Object[])new Object[]{pokemon.getDisplayName()});
                for (WorldTime time : times) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.DARK_AQUA, (String)time.name(), (Object[])new Object[0]);
                }
            } else if (infoType.equalsIgnoreCase("egggroup")) {
                EnumEggGroup[] eggGroups = pokemon.getBaseStats().eggGroups;
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.YELLOW, (String)("%s" + TextFormatting.GOLD + "'s egg groups are:"), (Object[])new Object[]{pokemon.getDisplayName()});
                StringBuilder msg = new StringBuilder();
                for (EnumEggGroup egg : eggGroups) {
                    msg.append(TextFormatting.DARK_AQUA).append(egg.name()).append(TextFormatting.GOLD).append(", ");
                }
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RESET, (String)msg.substring(0, msg.length() - 2), (Object[])new Object[0]);
            } else if (infoType.equalsIgnoreCase("genderratio")) {
                double male = pokemon.getBaseStats().getMalePercent();
                if (male == -1.0) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.YELLOW, (String)("%s " + TextFormatting.GOLD + "is genderless."), (Object[])new Object[]{pokemon.getDisplayName()});
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + pokemon.getDisplayName() + TextFormatting.GOLD + " is male " + TextFormatting.DARK_AQUA + male + "%" + TextFormatting.GOLD + " of the time"));
                }
            } else if (infoType.equalsIgnoreCase("evo")) {
                ArrayList evolutions = pokemon.getBaseStats().evolutions;
                if (evolutions == null || evolutions.size() == 0) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.YELLOW, (String)("%s " + TextFormatting.GOLD + "does not evolve."), (Object[])new Object[]{pokemon.getDisplayName()});
                    return;
                }
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.YELLOW, (String)("%s " + TextFormatting.GOLD + "evolutions: "), (Object[])new Object[]{pokemon.getDisplayName()});
                for (Evolution evolution : evolutions) {
                    if (evolution == null) continue;
                    StringBuilder baseMsg = new StringBuilder(TextFormatting.YELLOW + "  " + evolution.to.name + ": " + TextFormatting.GREEN + "Levelling up ");
                    if (evolution instanceof LevelingEvolution) {
                        LevelingEvolution levelingEvolution = (LevelingEvolution)evolution;
                        if (levelingEvolution.level != null && levelingEvolution.level > 1) {
                            baseMsg.append("to level ").append(levelingEvolution.level);
                        }
                    } else if (evolution instanceof InteractEvolution) {
                        baseMsg = new StringBuilder(TextFormatting.YELLOW + "  " + evolution.to.name + ": " + TextFormatting.AQUA + "When exposed to " + ((InteractEvolution)evolution).item.getItemStack().func_82833_r());
                    } else if (evolution instanceof TradeEvolution) {
                        TradeEvolution tradeEvo = (TradeEvolution)evolution;
                        baseMsg = tradeEvo.with != null ? new StringBuilder(TextFormatting.YELLOW + "  " + evolution.to.name + ": " + TextFormatting.LIGHT_PURPLE + "Trading with " + tradeEvo.with.name) : new StringBuilder(TextFormatting.YELLOW + "  " + evolution.to.name + ": " + TextFormatting.LIGHT_PURPLE + "Trading");
                    } else {
                        Pixelmon.EVENT_BUS.post((Event)new UnknownEvolutionTypeEvent(sender, evolution));
                    }
                    CommandChatHandler.sendChat((ICommandSender)sender, (String)baseMsg.toString(), (Object[])new Object[0]);
                    if (evolution.conditions == null || evolution.conditions.isEmpty()) continue;
                    TextFormatting headingColour = TextFormatting.GOLD;
                    TextFormatting valueColour = TextFormatting.DARK_AQUA;
                    CommandChatHandler.sendChat((ICommandSender)sender, (String)(TextFormatting.GOLD + "    " + TextFormatting.UNDERLINE + "Conditions:"), (Object[])new Object[0]);
                    for (EvoCondition condition2 : evolution.conditions) {
                        if (condition2 instanceof BiomeCondition) {
                            BiomeCondition biomeCondition = (BiomeCondition)condition2;
                            StringBuilder biomes = new StringBuilder(headingColour + "Biomes: " + valueColour);
                            for (int i = 0; i < biomeCondition.biomes.size(); ++i) {
                                String biomeName;
                                Biome b = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation((String)biomeCondition.biomes.get(i)));
                                String string = biomeName = b == null ? (String)biomeCondition.biomes.get(i) : b.field_76791_y;
                                if (i == 0) {
                                    biomes.append(biomeName);
                                    continue;
                                }
                                biomes.append(headingColour).append(", ").append(valueColour).append(biomeName);
                            }
                            CommandChatHandler.sendChat((ICommandSender)sender, (String)("      " + biomes), (Object[])new Object[0]);
                            continue;
                        }
                        if (condition2 instanceof ChanceCondition) {
                            ChanceCondition chanceCondition = (ChanceCondition)condition2;
                            CommandChatHandler.sendChat((ICommandSender)sender, (String)("      " + valueColour + chanceCondition.chance * 100.0f + " percent chance"), (Object[])new Object[0]);
                            continue;
                        }
                        if (condition2 instanceof EvoRockCondition) {
                            EvoRockCondition evoRockCond = (EvoRockCondition)condition2;
                            CommandChatHandler.sendChat((ICommandSender)sender, (String)("      " + headingColour + "Within " + valueColour + Math.sqrt(evoRockCond.maxRangeSquared) + " " + headingColour + "blocks of a " + valueColour + evoRockCond.evolutionRock.name()), (Object[])new Object[0]);
                            continue;
                        }
                        if (condition2 instanceof FriendshipCondition) {
                            CommandChatHandler.sendChat((ICommandSender)sender, (String)("      " + headingColour + "Friendship: " + valueColour + ((FriendshipCondition)condition2).friendship), (Object[])new Object[0]);
                            continue;
                        }
                        if (condition2 instanceof GenderCondition) {
                            GenderCondition genderCondition = (GenderCondition)condition2;
                            StringBuilder genders = new StringBuilder(headingColour + "Genders: " + valueColour + ((Gender)genderCondition.genders.get(0)).name());
                            for (int i = 1; i < genderCondition.genders.size(); ++i) {
                                genders.append(headingColour).append(", ").append(valueColour).append(((Gender)genderCondition.genders.get(i)).name());
                            }
                            CommandChatHandler.sendChat((ICommandSender)sender, (String)("      " + genders), (Object[])new Object[0]);
                            continue;
                        }
                        if (condition2 instanceof HeldItemCondition) {
                            HeldItemCondition heldItemCondition = (HeldItemCondition)condition2;
                            ItemStack stack = heldItemCondition.item.getItemStack();
                            CommandChatHandler.sendChat((ICommandSender)sender, (String)("      " + headingColour + "Held item: " + valueColour + (stack == null ? heldItemCondition.item.itemID : stack.func_82833_r())), (Object[])new Object[0]);
                            continue;
                        }
                        if (condition2 instanceof HighAltitudeCondition) {
                            HighAltitudeCondition altitudeCondition = (HighAltitudeCondition)condition2;
                            CommandChatHandler.sendChat((ICommandSender)sender, (String)("      " + headingColour + "Above altitude: " + valueColour + (int)altitudeCondition.minAltitude), (Object[])new Object[0]);
                            continue;
                        }
                        if (condition2 instanceof LevelCondition) {
                            CommandChatHandler.sendChat((ICommandSender)sender, (String)("    " + headingColour + "Starting at level: " + ((LevelCondition)condition2).level), (Object[])new Object[0]);
                            continue;
                        }
                        if (condition2 instanceof MoveCondition) {
                            CommandChatHandler.sendChat((ICommandSender)sender, (String)("      " + headingColour + "Knowing move: " + valueColour + ((AttackBase)AttackBase.getAttackBase((int)((MoveCondition)condition2).attackIndex).get()).getTranslatedName().func_150254_d()), (Object[])new Object[0]);
                            continue;
                        }
                        if (condition2 instanceof MoveTypeCondition) {
                            CommandChatHandler.sendChat((ICommandSender)sender, (String)("      " + headingColour + "With a move of type: " + valueColour + ((MoveTypeCondition)condition2).type.getLocalizedName()), (Object[])new Object[0]);
                            continue;
                        }
                        if (condition2 instanceof PartyCondition) {
                            int i;
                            ArrayList withPokemon = new ArrayList();
                            ArrayList withTypes = new ArrayList();
                            PartyCondition partyCond = (PartyCondition)condition2;
                            if (partyCond.withPokemon != null) {
                                withPokemon = partyCond.withPokemon;
                            }
                            if (partyCond.withTypes != null) {
                                withTypes = partyCond.withTypes;
                            }
                            if (!withPokemon.isEmpty()) {
                                StringBuilder pokemonWith = new StringBuilder(headingColour + "      With these Pok\u00e9mon in party: " + valueColour + ((EnumSpecies)withPokemon.get((int)0)).name);
                                for (i = 1; i < withPokemon.size(); ++i) {
                                    pokemonWith.append(headingColour).append(", ").append(valueColour).append(((EnumSpecies)withPokemon.get((int)i)).name);
                                }
                                CommandChatHandler.sendChat((ICommandSender)sender, (String)pokemonWith.toString(), (Object[])new Object[0]);
                            }
                            if (withTypes.isEmpty()) continue;
                            StringBuilder typesWith = new StringBuilder(headingColour + "      With Pok\u00e9mon of these types in party: " + valueColour + ((EnumType)withTypes.get(0)).getLocalizedName());
                            for (i = 1; i < withTypes.size(); ++i) {
                                typesWith.append(headingColour).append(", ").append(valueColour).append(((EnumType)withTypes.get(i)).getLocalizedName());
                            }
                            CommandChatHandler.sendChat((ICommandSender)sender, (String)typesWith.toString(), (Object[])new Object[0]);
                            continue;
                        }
                        if (condition2 instanceof StatRatioCondition) {
                            StatRatioCondition statCond = (StatRatioCondition)condition2;
                            CommandChatHandler.sendChat((ICommandSender)sender, (String)(headingColour + "      With a stat ratio of " + valueColour + statCond.ratio + headingColour + " between " + valueColour + statCond.stat1.getLocalizedName() + headingColour + " and " + valueColour + statCond.stat2.getLocalizedName()), (Object[])new Object[0]);
                            continue;
                        }
                        if (condition2 instanceof TimeCondition) {
                            CommandChatHandler.sendChat((ICommandSender)sender, (String)(headingColour + "      During: " + valueColour + ((TimeCondition)condition2).time.name()), (Object[])new Object[0]);
                            continue;
                        }
                        if (condition2 instanceof WeatherCondition) {
                            CommandChatHandler.sendChat((ICommandSender)sender, (String)(headingColour + "      With weather: " + valueColour + "Rain"), (Object[])new Object[0]);
                            continue;
                        }
                        Pixelmon.EVENT_BUS.post((Event)new UnknownEvolutionConditionEvent(sender, condition2));
                    }
                }
            } else if (infoType.equalsIgnoreCase("rarity")) {
                float rarity = -1.0f;
                for (SpawnSet set : SetLoader.getAllSets()) {
                    for (SpawnInfo info : set.spawnInfos) {
                        if (!(info instanceof SpawnInfoPokemon) || !((SpawnInfoPokemon)info).getPokemonSpec().name.equalsIgnoreCase(pokemon.getSpecies().name)) continue;
                        rarity = info.rarity;
                    }
                }
                if (EnumSpecies.legendaries.contains(pokemon.getDisplayName())) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.YELLOW, (String)("%s " + TextFormatting.GOLD + "is a legendary"), (Object[])new Object[]{pokemon.getDisplayName()});
                } else if (rarity > 0.0f) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "The rarity of " + TextFormatting.YELLOW + pokemon.getDisplayName() + TextFormatting.GOLD + " is " + TextFormatting.DARK_AQUA + rarity));
                } else if (rarity <= 0.0f) {
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.YELLOW, (String)("%s " + TextFormatting.GOLD + "does not spawn"), (Object[])new Object[]{pokemon.getDisplayName()});
                }
            } else if (infoType.equalsIgnoreCase("catch")) {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "The catch rate of " + TextFormatting.YELLOW + pokemon.getDisplayName() + TextFormatting.GOLD + " is " + TextFormatting.DARK_AQUA + pokemon.getBaseStats().catchRate));
            } else if (infoType.equalsIgnoreCase("ha")) {
                String ability = pokemon.getBaseStats().abilities[2];
                if (ability == null || ability.isEmpty()) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + pokemon.getDisplayName() + TextFormatting.GOLD + " doesn't have a hidden ability"));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "The hidden ability of " + TextFormatting.YELLOW + pokemon.getDisplayName() + TextFormatting.GOLD + " is " + TextFormatting.DARK_AQUA + ability));
                }
            } else if (infoType.equalsIgnoreCase("abilities")) {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.YELLOW, (String)("%s" + TextFormatting.GOLD + "'s abilities are:"), (Object[])new Object[]{pokemon.getDisplayName()});
                for (String ability : pokemon.getBaseStats().abilities) {
                    if (ability == null || ability.isEmpty()) continue;
                    CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.DARK_AQUA, (String)ability, (Object[])new Object[0]);
                }
            } else if (infoType.equalsIgnoreCase("basestats")) {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.YELLOW, (String)("%s" + TextFormatting.GOLD + "'s base stats are:"), (Object[])new Object[]{pokemon.getDisplayName()});
                BaseStats bs = pokemon.getBaseStats();
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.DARK_AQUA, (String)(bs.get(StatsType.HP) + "/" + bs.get(StatsType.Attack) + "/" + bs.get(StatsType.Defence) + "/" + bs.get(StatsType.SpecialAttack) + "/" + bs.get(StatsType.SpecialDefence) + "/" + bs.get(StatsType.Speed)), (Object[])new Object[0]);
            }
        } else {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Invalid option", (Object[])new Object[0]);
        }
    }

    private void sortITechnicalMove(List<ITechnicalMove> attacks) {
        if (attacks == null) {
            return;
        }
        attacks.sort(Comparator.comparing(o -> {
            if (o.getAttack() != null) {
                return o.getAttackName();
            }
            return null;
        }));
    }

    private void sortAttacks(List<Attack> attacks) {
        if (attacks == null) {
            return;
        }
        attacks.sort(Comparator.comparing(o -> {
            if (o.getMove() != null) {
                return o.getMove().getAttackName();
            }
            return null;
        }));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return Wiki.func_175762_a((String[])args, (Collection)EnumSpecies.getNameList());
        }
        if (args.length == 2) {
            return Wiki.func_175762_a((String[])args, info);
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

