/*
 * Decompiled with CFR 0.152.
 */
package com.pixelextras.commands;

import com.google.common.collect.Lists;
import com.pixelextras.config.PixelExtrasConfig;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class SpawnCoords
extends CommandBase {
    public String func_71517_b() {
        return "pspawn";
    }

    public int func_82362_a() {
        return 2;
    }

    public List<String> func_71514_a() {
        return Lists.newArrayList((Object[])new String[]{"pokespawncoords", "pspawnc", "pspawncoords"});
    }

    public String func_71518_a(ICommandSender sender) {
        return "/pspawn <pokemon> [player/<x>] <y> <z>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        World world = null;
        Double posX = null;
        Double posY = null;
        Double posZ = null;
        ArrayList argument = Lists.newArrayList((Object[])args);
        if (argument.size() > 1 && server.func_184103_al().func_152612_a(args[1]) != null) {
            try {
                EntityPlayerMP player = SpawnCoords.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
                world = player.field_70170_p;
                posX = player.func_174791_d().field_72450_a;
                posY = player.func_174791_d().field_72448_b;
                posZ = player.func_174791_d().field_72449_c;
                argument.remove(1);
            }
            catch (PlayerNotFoundException playerNotFoundException) {
                // empty catch block
            }
        }
        for (String arg : argument) {
            if (world == null) {
                for (WorldServer worldServer : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
                    if (!worldServer.func_72912_H().func_76065_j().equalsIgnoreCase(arg)) continue;
                    world = worldServer;
                }
            }
            try {
                Double d = Double.parseDouble(arg);
                if (posX == null) {
                    posX = d;
                    continue;
                }
                if (posY == null) {
                    posY = d;
                    continue;
                }
                if (posZ != null) continue;
                posZ = d;
            }
            catch (NumberFormatException d) {}
        }
        PokemonSpec spec = PokemonSpec.from((String[])args);
        spec.name = PokemonSpec.from((String[])new String[]{args[0]}).name;
        if (spec.name == null) {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Missing argument: Pokemon name", (Object[])new Object[0]);
            return;
        }
        if (posX == null || posY == null || posZ == null) {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Missing at least one of the x y z arguments (or player).", (Object[])new Object[0]);
            return;
        }
        if (world == null) {
            world = sender.func_130014_f_();
        }
        Pokemon pokemon = Pixelmon.pokemonFactory.create(spec);
        EntityPixelmon pixelmon = pokemon.getOrSpawnPixelmon(world, posX.doubleValue(), posY.doubleValue(), posZ.doubleValue());
        spec.apply(pixelmon);
        pixelmon.canDespawn = false;
        CommandChatHandler.sendChat((ICommandSender)sender, (String)"pixelmon.command.spawn.spawned", (Object[])new Object[]{new TextComponentTranslation("pixelmon." + pokemon.getSpecies().name + ".name", new Object[0])});
        if (PixelExtrasConfig.notifyOPs) {
            SpawnCoords.func_152374_a((ICommandSender)sender, (ICommand)this, (int)0, (String)"pixelmon.command.spawn.spawnednotify", (Object[])new Object[]{sender.func_70005_c_(), spec.name});
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 2) {
            return SpawnCoords.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 1) {
            for (EnumSpecies p : EnumSpecies.values()) {
                list.add(p.name);
            }
            return SpawnCoords.func_175762_a((String[])args, list);
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

