/*
 * Decompiled with CFR 0.152.
 */
package com.pixelextras.commands;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.TickHandler;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStats;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextFormatting;

public class PokeRestart
extends CommandBase {
    public String func_71517_b() {
        return "pokerestart";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/pokerestart <confirm | player> <confirm>- allows <player> to reselect their starter";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player = null;
        boolean confirming = false;
        if (args.length == 0) {
            if (sender instanceof EntityPlayerMP) {
                player = (EntityPlayerMP)sender;
            } else {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Missing argument: player", (Object[])new Object[0]);
            }
        } else {
            for (String arg : args) {
                if (arg.toLowerCase().equals("confirm")) {
                    confirming = true;
                    continue;
                }
                if (player != null) continue;
                player = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)arg);
            }
        }
        if (confirming && args.length == 1) {
            if (sender instanceof EntityPlayerMP) {
                player = (EntityPlayerMP)sender;
            } else {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Missing argument: player", (Object[])new Object[0]);
            }
        }
        if (player == null) {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"Player not found", (Object[])new Object[0]);
        } else if (!confirming) {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.GRAY, (String)("Are you sure? Add 'confirm' to the command to restart " + player.func_70005_c_() + "'s Pokemon"), (Object[])new Object[0]);
        } else if (player != sender && !sender.func_70003_b(4, "pixelextras.command.admin.pokerestart")) {
            CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.RED, (String)"You don't have permission to restart others", (Object[])new Object[0]);
        } else {
            this.resetPlayerFiles(player);
            if (sender != player) {
                CommandChatHandler.sendFormattedChat((ICommandSender)sender, (TextFormatting)TextFormatting.DARK_GREEN, (String)("Successfully restarted " + player.func_70005_c_() + "'s Pokemon"), (Object[])new Object[0]);
            }
        }
    }

    private void resetPlayerFiles(EntityPlayerMP player) {
        PlayerPartyStorage storage = Pixelmon.storageManager.getParty(player);
        if (storage == null) {
            return;
        }
        storage.starterPicked = false;
        storage.pokedex.wipe();
        storage.stats = new PlayerStats();
        PCStorage pcStorage = Pixelmon.storageManager.getPCForPlayer(player);
        for (int i = 0; i < 6; ++i) {
            Pokemon pokemon = storage.get(i);
            if (pokemon == null) continue;
            storage.set(i, null);
        }
        for (int box = 0; box < PixelmonConfig.computerBoxes; ++box) {
            for (int boxPos = 0; boxPos < 30; ++boxPos) {
                pcStorage.set(box, boxPos, null);
            }
        }
        TickHandler.registerStarterList((EntityPlayerMP)player);
    }
}

